/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.converter;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class MultiplicityConverter
extends AbstractLexerBasedConverter<Integer> {
    protected String toEscapedString(Integer value) {
        if (value == -1) {
            return "[*]";
        }
        return "[" + value.toString() + "]";
    }

    protected void assertValidValue(Integer value) {
        super.assertValidValue((Object)value);
    }

    public Integer toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to integer.", node, null);
        }
        if (string.indexOf("*") >= 0) {
            return -1;
        }
        try {
            int intValue = Integer.parseInt(string.substring(1, string.length() - 1));
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to integer.", node, (Exception)e);
        }
    }
}

