/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.naming;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.RoomDefaultValues;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomSwitch;
import org.eclipse.xtext.resource.IFragmentProvider;

public class RoomFragmentProvider
implements IFragmentProvider {
    private static final char SEP = '$';
    private static final char BIND_SEP = '-';
    private static final char CONN_SEP = '-';
    private static final String INIT_TRANS = "initial";
    private static final String STATE_GRAPH = "sg";
    private static final char EP_SEP = '!';
    private static final String LOCAL = ".";
    private static final char TYPE_SEP = ':';
    private PathProvider pathProvider = new PathProvider();

    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        String path = (String)this.pathProvider.doSwitch(obj);
        if (path != null) {
            return String.valueOf(obj.eClass().getName()) + ':' + path;
        }
        return fallback.getFragment(obj);
    }

    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        RoomModel model;
        EObject result;
        if (!resource.getContents().isEmpty() && (result = this.getEObject(model = (RoomModel)resource.getContents().get(0), fragment)) != null) {
            return result;
        }
        return fallback.getEObject(fragment);
    }

    public static boolean isActorClass(String fragment) {
        return fragment.startsWith(RoomPackage.eINSTANCE.getActorClass().getName());
    }

    public static boolean isStructureClass(String fragment) {
        if (fragment.startsWith(RoomPackage.eINSTANCE.getActorClass().getName())) {
            return true;
        }
        if (fragment.startsWith(RoomPackage.eINSTANCE.getSubSystemClass().getName())) {
            return true;
        }
        return fragment.startsWith(RoomPackage.eINSTANCE.getLogicalSystem().getName());
    }

    public static boolean isStructureClass(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            return RoomFragmentProvider.isStructureClass(uri.fragment());
        }
        return false;
    }

    public static boolean isPort(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getPort().getName());
    }

    public static boolean isSPP(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getSPPRef().getName());
    }

    public static boolean isBinding(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getBinding().getName());
    }

    public static boolean isLayerConnection(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getLayerConnection().getName());
    }

    public static boolean isRef(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getActorContainerRef().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getActorRef().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isState(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getBaseState().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getRefinedState().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTrPoint(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getTransitionPoint().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getEntryPoint().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getExitPoint().getName())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isChoicePoint(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getChoicePoint().getName());
    }

    public static boolean isStateGraph(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        return uri != null && uri.fragment() != null && uri.fragment().startsWith(RoomPackage.eINSTANCE.getStateGraph().getName());
    }

    public static boolean isTransition(EObject obj) {
        URI uri = EcoreUtil.getURI((EObject)obj);
        if (uri != null && uri.fragment() != null) {
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getInitialTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getContinuationTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getCPBranchTransition().getName())) {
                return true;
            }
            if (uri.fragment().startsWith(RoomPackage.eINSTANCE.getTriggeredTransition().getName())) {
                return true;
            }
        }
        return false;
    }

    private EObject getEObject(RoomModel model, String fragment) {
        int begin = 0;
        int end = fragment.indexOf(58);
        if (end < 0) {
            return null;
        }
        String type = fragment.substring(begin, end);
        begin = end + 1;
        if ((end = fragment.indexOf(36, begin)) < 0) {
            end = fragment.length();
        }
        String className = fragment.substring(begin, end);
        RoomClass rc = this.getRoomClass(model, className);
        if (type.equals(RoomPackage.eINSTANCE.getDataClass().getName())) {
            return rc;
        }
        if (type.equals(RoomPackage.eINSTANCE.getProtocolClass().getName())) {
            return rc;
        }
        if (type.equals(RoomPackage.eINSTANCE.getActorClass().getName())) {
            return rc;
        }
        if (type.equals(RoomPackage.eINSTANCE.getSubSystemClass().getName())) {
            return rc;
        }
        if (type.equals(RoomPackage.eINSTANCE.getLogicalSystem().getName())) {
            return rc;
        }
        if (end < fragment.length()) {
            String remainder = fragment.substring(end + 1, fragment.length());
            if (type.equals(RoomPackage.eINSTANCE.getPort().getName())) {
                return this.getPort(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getSPPRef().getName())) {
                return this.getSPP(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getSubSystemRef().getName()) || type.equals(RoomPackage.eINSTANCE.getActorRef().getName())) {
                return this.getActorContainerRef(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getBinding().getName())) {
                return this.getBinding(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getLayerConnection().getName())) {
                return this.getLayerConnection(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getBaseState().getName()) || type.equals(RoomPackage.eINSTANCE.getRefinedState().getName())) {
                return this.getState(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getTransitionPoint().getName()) || type.equals(RoomPackage.eINSTANCE.getEntryPoint().getName()) || type.equals(RoomPackage.eINSTANCE.getExitPoint().getName())) {
                return this.getTrPoint(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getChoicePoint().getName())) {
                return this.getChoicePoint(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getInitialTransition().getName())) {
                return this.getInitialTransition(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getContinuationTransition().getName()) || type.equals(RoomPackage.eINSTANCE.getCPBranchTransition().getName()) || type.equals(RoomPackage.eINSTANCE.getTriggeredTransition().getName()) || type.equals(RoomPackage.eINSTANCE.getGuardedTransition().getName())) {
                return this.getTransition(rc, remainder);
            }
            if (type.equals(RoomPackage.eINSTANCE.getStateGraph().getName()) || type.equals(RoomPackage.eINSTANCE.getStateMachine().getName()) || type.equals(RoomPackage.eINSTANCE.getPlainStateGraph().getName())) {
                return this.getStateGraph(rc, remainder);
            }
        }
        return null;
    }

    private Transition getTransition(RoomClass rc, String remainder) {
        StateGraph sg = this.getStateGraph(rc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (Transition t : sg.getTransitions()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    private InitialTransition getInitialTransition(RoomClass rc, String remainder) {
        StateGraph sg = this.getStateGraph(rc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        if (name.equals(INIT_TRANS)) {
            for (Transition t : sg.getTransitions()) {
                if (!(t instanceof InitialTransition)) continue;
                return (InitialTransition)t;
            }
        }
        return null;
    }

    private ChoicePoint getChoicePoint(RoomClass rc, String remainder) {
        StateGraph sg = this.getStateGraph(rc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (ChoicePoint cp : sg.getChPoints()) {
            if (!cp.getName().equals(name)) continue;
            return cp;
        }
        return null;
    }

    private TrPoint getTrPoint(RoomClass rc, String remainder) {
        StateGraph sg = this.getStateGraph(rc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (TrPoint tp : sg.getTrPoints()) {
            if (!tp.getName().equals(name)) continue;
            return tp;
        }
        return null;
    }

    private State getState(RoomClass rc, String remainder) {
        StateGraph sg = this.getStateGraph(rc, remainder);
        int begin = remainder.lastIndexOf(36);
        begin = begin < 0 ? 0 : ++begin;
        String name = remainder.substring(begin, remainder.length());
        for (State s : sg.getStates()) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    private StateGraph getStateGraph(RoomClass rc, String remainder) {
        if (rc instanceof ActorClass) {
            StateGraph sg = ((ActorClass)rc).getStateMachine();
            if (sg == null) {
                ((ActorClass)rc).setStateMachine(RoomFactory.eINSTANCE.createStateMachine());
                ((ActorClass)rc).getStateMachine().setDataDriven(RoomDefaultValues.isUseDataDrivenStateMachine());
                sg = ((ActorClass)rc).getStateMachine();
            }
            int begin = 0;
            int end = remainder.indexOf(36);
            while (end >= 0) {
                String name = remainder.substring(begin, end);
                boolean found = false;
                for (State s : sg.getStates()) {
                    if (!s.getName().equals(name)) continue;
                    sg = s.getSubgraph();
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                begin = end + 1;
                end = remainder.indexOf(36, begin);
            }
            return sg;
        }
        return null;
    }

    private EObject getBinding(RoomClass rc, String name) {
        int pos = name.indexOf(45);
        if (pos < 0) {
            return null;
        }
        if (rc instanceof StructureClass) {
            String ep1name = name.substring(0, pos);
            String ep2name = name.substring(pos + 1, name.length());
            StructureClass sc = (StructureClass)rc;
            BindingEndPoint ep1 = this.getEndpoint(sc, ep1name);
            BindingEndPoint ep2 = this.getEndpoint(sc, ep2name);
            for (Binding bi : sc.getBindings()) {
                if (this.isEP(bi.getEndpoint1(), ep1) && this.isEP(bi.getEndpoint2(), ep2)) {
                    return bi;
                }
                if (!this.isEP(bi.getEndpoint1(), ep2) || !this.isEP(bi.getEndpoint2(), ep1)) continue;
                return bi;
            }
        }
        return null;
    }

    private boolean isEP(BindingEndPoint a, BindingEndPoint b) {
        if (a.getPort().getName().equals(b.getPort().getName())) {
            if (a.getActorRef() == null && b.getActorRef() == null) {
                return true;
            }
            if (a.getActorRef() != null && b.getActorRef() != null && a.getActorRef().getName().equals(b.getActorRef().getName())) {
                return true;
            }
        }
        return false;
    }

    private BindingEndPoint getEndpoint(StructureClass sc, String name) {
        int pos = name.indexOf(33);
        if (pos < 0) {
            return null;
        }
        String portName = name.substring(0, pos);
        String refName = name.substring(pos + 1, name.length());
        ActorContainerRef ar = null;
        if (!refName.equals(LOCAL)) {
            ar = this.getActorContainerRef(sc, refName);
        }
        if (ar != null) {
            if (ar instanceof ActorRef) {
                sc = ((ActorRef)ar).getType();
            } else if (ar instanceof SubSystemRef) {
                sc = ((SubSystemRef)ar).getType();
            }
        }
        Port port = this.getPort(sc, portName);
        BindingEndPoint ep = RoomFactory.eINSTANCE.createBindingEndPoint();
        ep.setPort(port);
        ep.setActorRef(ar);
        return ep;
    }

    private EObject getLayerConnection(RoomClass rc, String name) {
        int pos = name.indexOf(45);
        if (pos < 0) {
            return null;
        }
        if (rc instanceof StructureClass) {
            String saptname = name.substring(0, pos);
            String spptname = name.substring(pos + 1, name.length());
            StructureClass sc = (StructureClass)rc;
            SAPoint sapt = this.getSAPoint(sc, saptname);
            SPPoint sppt = this.getSPPoint(sc, spptname);
            for (LayerConnection bi : sc.getConnections()) {
                if (!this.isSAPoint(bi.getFrom(), sapt) || !this.isSPPoint(bi.getTo(), sppt)) continue;
                return bi;
            }
        }
        return null;
    }

    private SPPoint getSPPoint(StructureClass sc, String name) {
        block6: {
            String sppName;
            String refName;
            block5: {
                int pos = name.indexOf(33);
                if (pos < 0) {
                    return null;
                }
                refName = name.substring(0, pos);
                sppName = name.substring(pos + 1, name.length());
                if (!(sc instanceof ActorContainerClass)) break block5;
                for (ActorRef ar : ((ActorContainerClass)sc).getActorRefs()) {
                    if (!ar.getName().equals(refName)) continue;
                    for (SPPRef spp : ar.getType().getIfSPPs()) {
                        if (!spp.getName().equals(sppName)) continue;
                        SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                        sppt.setRef(ar);
                        sppt.setService(spp);
                        return sppt;
                    }
                }
                break block6;
            }
            if (!(sc instanceof LogicalSystem)) break block6;
            for (SubSystemRef ssr : ((LogicalSystem)sc).getSubSystems()) {
                if (!ssr.getName().equals(refName)) continue;
                for (SPPRef spp : ssr.getType().getIfSPPs()) {
                    if (!spp.getName().equals(sppName)) continue;
                    SPPoint sppt = RoomFactory.eINSTANCE.createSPPoint();
                    sppt.setRef(ssr);
                    sppt.setService(spp);
                    return sppt;
                }
            }
        }
        return null;
    }

    private SAPoint getSAPoint(StructureClass sc, String name) {
        SAPoint sapt = this.getRelaySAPoint(sc, name);
        if (sapt != null) {
            return sapt;
        }
        return this.getRefSAPoint(sc, name);
    }

    private SAPoint getRefSAPoint(StructureClass sc, String name) {
        if (sc instanceof ActorContainerClass) {
            for (ActorRef ar : ((ActorContainerClass)sc).getActorRefs()) {
                if (!ar.getName().equals(name)) continue;
                RefSAPoint sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                sapt.setRef(ar);
                return sapt;
            }
        }
        if (sc instanceof LogicalSystem) {
            for (SubSystemRef ssr : ((LogicalSystem)sc).getSubSystems()) {
                if (!ssr.getName().equals(name)) continue;
                RefSAPoint sapt = RoomFactory.eINSTANCE.createRefSAPoint();
                sapt.setRef(ssr);
                return sapt;
            }
        }
        return null;
    }

    private SAPoint getRelaySAPoint(StructureClass sc, String name) {
        if (sc instanceof ActorContainerClass) {
            for (SPPRef spp : ((ActorContainerClass)sc).getIfSPPs()) {
                if (!spp.getName().equals(name)) continue;
                RelaySAPoint sapt = RoomFactory.eINSTANCE.createRelaySAPoint();
                sapt.setRelay(spp);
                return sapt;
            }
        }
        return null;
    }

    private boolean isSAPoint(SAPoint a, SAPoint b) {
        if (a instanceof RefSAPoint && b instanceof RefSAPoint) {
            return ((RefSAPoint)a).getRef().getName().equals(((RefSAPoint)b).getRef().getName());
        }
        if (a instanceof RelaySAPoint && b instanceof RelaySAPoint) {
            return ((RelaySAPoint)a).getRelay().getName().equals(((RelaySAPoint)b).getRelay().getName());
        }
        return false;
    }

    private boolean isSPPoint(SPPoint a, SPPoint b) {
        if (!a.getRef().getName().equals(b.getRef().getName())) {
            return false;
        }
        return a.getService().getName().equals(b.getService().getName());
    }

    private ActorContainerRef getActorContainerRef(RoomClass rc, String name) {
        if (rc instanceof ActorContainerClass) {
            for (ActorRef ar : ((ActorContainerClass)rc).getActorRefs()) {
                if (!ar.getName().equals(name)) continue;
                return ar;
            }
            if (rc instanceof ActorClass && ((ActorClass)rc).getBase() != null) {
                return this.getActorContainerRef(((ActorClass)rc).getBase(), name);
            }
        } else if (rc instanceof LogicalSystem) {
            for (SubSystemRef ssr : ((LogicalSystem)rc).getSubSystems()) {
                if (!ssr.getName().equals(name)) continue;
                return ssr;
            }
        }
        return null;
    }

    protected Port getPort(RoomClass rc, String name) {
        if (rc instanceof ActorClass) {
            for (Port p : ((ActorClass)rc).getIfPorts()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            for (Port p : ((ActorClass)rc).getIntPorts()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            if (((ActorClass)rc).getBase() != null) {
                return this.getPort(((ActorClass)rc).getBase(), name);
            }
        } else if (rc instanceof SubSystemClass) {
            for (Port p : ((SubSystemClass)rc).getRelayPorts()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    protected SPPRef getSPP(RoomClass rc, String name) {
        if (rc instanceof ActorContainerClass) {
            for (SPPRef spp : ((ActorContainerClass)rc).getIfSPPs()) {
                if (!spp.getName().equals(name)) continue;
                return spp;
            }
            if (rc instanceof ActorClass && ((ActorClass)rc).getBase() != null) {
                return this.getSPP(((ActorClass)rc).getBase(), name);
            }
        }
        return null;
    }

    private RoomClass getRoomClass(RoomModel model, String className) {
        for (DataClass dc : model.getDataClasses()) {
            if (!dc.getName().equals(className)) continue;
            return dc;
        }
        for (ProtocolClass pc : model.getProtocolClasses()) {
            if (!pc.getName().equals(className)) continue;
            return pc;
        }
        for (ActorClass ac : model.getActorClasses()) {
            if (!ac.getName().equals(className)) continue;
            return ac;
        }
        for (SubSystemClass ssc : model.getSubSystemClasses()) {
            if (!ssc.getName().equals(className)) continue;
            return ssc;
        }
        for (LogicalSystem ls : model.getSystems()) {
            if (!ls.getName().equals(className)) continue;
            return ls;
        }
        return null;
    }

    private class PathProvider
    extends RoomSwitch<String> {
        private PathProvider() {
        }

        @Override
        public String caseRoomClass(RoomClass rc) {
            return rc.getName();
        }

        @Override
        public String casePort(Port port) {
            return String.valueOf((String)this.doSwitch(port.eContainer())) + '$' + port.getName();
        }

        @Override
        public String caseSPPRef(SPPRef spp) {
            return String.valueOf((String)this.doSwitch(spp.eContainer())) + '$' + spp.getName();
        }

        @Override
        public String caseActorContainerRef(ActorContainerRef acr) {
            return String.valueOf((String)this.doSwitch(acr.eContainer())) + '$' + acr.getName();
        }

        @Override
        public String caseBinding(Binding bi) {
            return String.valueOf((String)this.doSwitch(bi.eContainer())) + '$' + this.caseBindingEndPointShort(bi.getEndpoint1()) + '-' + this.caseBindingEndPointShort(bi.getEndpoint2());
        }

        private String caseBindingEndPointShort(BindingEndPoint ep) {
            String loc = ep.getActorRef() == null ? RoomFragmentProvider.LOCAL : ep.getActorRef().getName();
            return String.valueOf(ep.getPort().getName()) + '!' + loc;
        }

        @Override
        public String caseLayerConnection(LayerConnection bi) {
            return String.valueOf((String)this.doSwitch(bi.eContainer())) + '$' + this.caseSAPointShort(bi.getFrom()) + '-' + this.caseSPPointShort(bi.getTo());
        }

        private String caseSAPointShort(SAPoint sapt) {
            if (sapt instanceof RefSAPoint) {
                return ((RefSAPoint)sapt).getRef().getName();
            }
            if (sapt instanceof RelaySAPoint) {
                return ((RelaySAPoint)sapt).getRelay().getName();
            }
            assert (false) : "unexpectd sub type";
            return null;
        }

        private String caseSPPointShort(SPPoint sppt) {
            return String.valueOf(sppt.getRef().getName()) + '!' + sppt.getService().getName();
        }

        @Override
        public String caseState(State s) {
            return String.valueOf((String)this.doSwitch(s.eContainer().eContainer())) + '$' + s.getName();
        }

        @Override
        public String caseTrPoint(TrPoint trp) {
            return String.valueOf((String)this.doSwitch(trp.eContainer().eContainer())) + '$' + trp.getName();
        }

        @Override
        public String caseChoicePoint(ChoicePoint cp) {
            return String.valueOf((String)this.doSwitch(cp.eContainer().eContainer())) + '$' + cp.getName();
        }

        @Override
        public String caseInitialTransition(InitialTransition t) {
            return String.valueOf((String)this.doSwitch(t.eContainer().eContainer())) + '$' + RoomFragmentProvider.INIT_TRANS;
        }

        @Override
        public String caseNonInitialTransition(NonInitialTransition t) {
            return String.valueOf((String)this.doSwitch(t.eContainer().eContainer())) + '$' + t.getName();
        }

        @Override
        public String caseStateGraph(StateGraph sg) {
            return String.valueOf((String)this.doSwitch(sg.eContainer())) + '$' + RoomFragmentProvider.STATE_GRAPH;
        }
    }
}

