/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveType implements Enumerator
{
    VOID(0, "void", "void"),
    INT8(1, "int8", "int8"),
    INT16(2, "int16", "int16"),
    INT32(3, "int32", "int32"),
    UINT8(4, "uint8", "uint8"),
    UINT16(5, "uint16", "uint16"),
    UINT32(6, "uint32", "uint32"),
    FLOAT32(7, "float32", "float32"),
    FLOAT64(8, "float64", "float64"),
    BOOLEAN(9, "boolean", "boolean"),
    STRING(10, "string", "string"),
    CHAR(11, "char", "char");

    public static final int VOID_VALUE = 0;
    public static final int INT8_VALUE = 1;
    public static final int INT16_VALUE = 2;
    public static final int INT32_VALUE = 3;
    public static final int UINT8_VALUE = 4;
    public static final int UINT16_VALUE = 5;
    public static final int UINT32_VALUE = 6;
    public static final int FLOAT32_VALUE = 7;
    public static final int FLOAT64_VALUE = 8;
    public static final int BOOLEAN_VALUE = 9;
    public static final int STRING_VALUE = 10;
    public static final int CHAR_VALUE = 11;
    private static final PrimitiveType[] VALUES_ARRAY;
    public static final List<PrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveType[]{VOID, INT8, INT16, INT32, UINT8, UINT16, UINT32, FLOAT32, FLOAT64, BOOLEAN, STRING, CHAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType get(int value) {
        switch (value) {
            case 0: {
                return VOID;
            }
            case 1: {
                return INT8;
            }
            case 2: {
                return INT16;
            }
            case 3: {
                return INT32;
            }
            case 4: {
                return UINT8;
            }
            case 5: {
                return UINT16;
            }
            case 6: {
                return UINT32;
            }
            case 7: {
                return FLOAT32;
            }
            case 8: {
                return FLOAT64;
            }
            case 9: {
                return BOOLEAN;
            }
            case 10: {
                return STRING;
            }
            case 11: {
                return CHAR;
            }
        }
        return null;
    }

    private PrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

