/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Annotation;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.FreeType;
import org.eclipse.etrice.core.room.FreeTypedID;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.KeyValue;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.Type;

public class RoomHelpers {
    public static List<InterfaceItem> getInterfaceItems(StructureClass sc, boolean includeInherited) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<InterfaceItem>)ac.getIfSPPs());
                result.addAll((Collection<InterfaceItem>)ac.getIfPorts());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getIfSPPs());
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getRelayPorts());
        } else if (!(sc instanceof LogicalSystem)) assert (false) : "unexpected sub type";
        return result;
    }

    public static List<ActorContainerRef> getRefs(StructureClass sc, boolean includeInherited) {
        ArrayList<ActorContainerRef> result = new ArrayList<ActorContainerRef>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<ActorContainerRef>)ac.getActorRefs());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<ActorContainerRef>)((SubSystemClass)sc).getActorRefs());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<ActorContainerRef>)((LogicalSystem)sc).getSubSystems());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static List<Binding> getBindings(StructureClass sc, boolean includeInherited) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<Binding>)ac.getBindings());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<Binding>)((SubSystemClass)sc).getBindings());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<Binding>)((LogicalSystem)sc).getBindings());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static List<LayerConnection> getConnections(StructureClass sc, boolean includeInherited) {
        ArrayList<LayerConnection> result = new ArrayList<LayerConnection>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<LayerConnection>)ac.getConnections());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<LayerConnection>)((SubSystemClass)sc).getConnections());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<LayerConnection>)((LogicalSystem)sc).getConnections());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static List<EObject> getContainedObjects(StructureClass sc) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.addAll(RoomHelpers.getInterfaceItems(sc, true));
        result.addAll(RoomHelpers.getRefs(sc, true));
        result.addAll(RoomHelpers.getBindings(sc, true));
        result.addAll(RoomHelpers.getConnections(sc, true));
        return result;
    }

    public static boolean hasSubStructure(State state, ActorClass ac) {
        if (RoomHelpers.hasDirectSubStructure(state)) {
            return true;
        }
        if (ac.getStateMachine() != null) {
            Iterator iterator = ac.getStateMachine().getStates().iterator();
            block0: while (iterator.hasNext()) {
                State s;
                State predecessor = s = (State)iterator.next();
                while (predecessor instanceof RefinedState) {
                    predecessor = ((RefinedState)s).getBase();
                    if (predecessor != state) continue;
                    predecessor = s;
                    while (predecessor instanceof RefinedState) {
                        if (RoomHelpers.hasDirectSubStructure(predecessor)) {
                            return true;
                        }
                        predecessor = ((RefinedState)s).getBase();
                        if (predecessor == state) continue block0;
                    }
                    continue block0;
                }
            }
        }
        return false;
    }

    public static boolean hasDirectSubStructure(State s) {
        if (s.getSubgraph() == null) {
            return false;
        }
        StateGraph sg = s.getSubgraph();
        if (!sg.getStates().isEmpty()) {
            return true;
        }
        if (!sg.getTransitions().isEmpty()) {
            return true;
        }
        if (!sg.getTrPoints().isEmpty()) {
            return true;
        }
        return !sg.getChPoints().isEmpty();
    }

    public static State getTargettingState(State state, ActorClass ac) {
        State targetting = state;
        Iterator iterator = ac.getStateMachine().getStates().iterator();
        while (iterator.hasNext()) {
            State s;
            State predecessor = s = (State)iterator.next();
            while (predecessor instanceof RefinedState) {
                predecessor = ((RefinedState)s).getBase();
                if (predecessor != state) continue;
                targetting = s;
            }
        }
        return targetting;
    }

    public static boolean hasDetailCode(DetailCode dc) {
        if (dc == null) {
            return false;
        }
        return !dc.getCommands().isEmpty();
    }

    public static String getDetailCode(DetailCode dc) {
        if (dc == null) {
            return "";
        }
        if (dc.getCommands().isEmpty()) {
            return "";
        }
        Iterator it = dc.getCommands().iterator();
        StringBuilder result = new StringBuilder((String)it.next());
        while (it.hasNext()) {
            result.append("\n").append((String)it.next());
        }
        return result.toString();
    }

    public static boolean isGuarded(Trigger trig) {
        return trig.getGuard() != null && RoomHelpers.hasDetailCode(trig.getGuard().getGuard());
    }

    public static List<State> getAllStates(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_States());
    }

    public static List<TrPoint> getAllTrPoints(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public static List<ChoicePoint> getAllChoicePoints(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public static List<Transition> getAllTransitions(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_Transitions());
    }

    private static <T extends StateGraphItem> List<T> getAllStateGraphItems(StateGraph sg, EReference feature) {
        ArrayList result = new ArrayList();
        do {
            Object items;
            if ((items = sg.eGet((EStructuralFeature)feature)) instanceof List) {
                result.addAll((List)items);
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getBase().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ActorClass)) break;
            ActorClass base = ((ActorClass)sg.eContainer()).getBase();
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        } while (sg != null);
        return result;
    }

    public static Set<String> getAllNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null);
    }

    public static Set<String> getAllNames(StateGraph sg, StateGraphItem skip) {
        HashSet<String> result = new HashSet<String>();
        do {
            for (State st : sg.getStates()) {
                if (st == skip) continue;
                result.add(st.getName());
            }
            for (TrPoint tp : sg.getTrPoints()) {
                if (tp == skip) continue;
                result.add(tp.getName());
            }
            for (ChoicePoint cp : sg.getChPoints()) {
                if (cp == skip) continue;
                result.add(cp.getName());
            }
            for (Transition tr : sg.getTransitions()) {
                if (tr == skip) continue;
                result.add(tr.getName());
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getBase().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ActorClass)) break;
            ActorClass base = ((ActorClass)sg.eContainer()).getBase();
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        } while (sg != null);
        return result;
    }

    public static Set<String> getAllStateNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_States());
    }

    public static Set<String> getAllStateNames(StateGraph sg, State skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_States());
    }

    public static Set<String> getAllTrPointNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public static Set<String> getAllTrPointNames(StateGraph sg, TrPoint skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public static Set<String> getAllChoicePointNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public static Set<String> getAllChoicePointNames(StateGraph sg, ChoicePoint skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public static Set<String> getAllTransitionNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_Transitions());
    }

    public static Set<String> getAllTransitionNames(StateGraph sg, Transition skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_Transitions());
    }

    private static <T extends StateGraphItem> Set<String> getAllNames(StateGraph sg, T skip, EReference feature) {
        List<StateGraphItem> states = RoomHelpers.getAllStateGraphItems(sg, feature);
        HashSet<String> names = new HashSet<String>();
        for (StateGraphItem s : states) {
            if (s == skip) continue;
            names.add(s.getName());
        }
        return names;
    }

    public static List<Attribute> getAllAttributes(ActorClass ac) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (ac != null) {
            result.addAll((Collection<Attribute>)ac.getAttributes());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Operation> getAllOperations(ActorClass ac) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        while (ac != null) {
            result.addAll((Collection<Operation>)ac.getOperations());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Port> getAllEndPorts(ActorClass ac) {
        ArrayList<Port> result = new ArrayList<Port>();
        while (ac != null) {
            result.addAll((Collection<Port>)ac.getIntPorts());
            for (ExternalPort p : ac.getExtPorts()) {
                result.add(p.getIfport());
            }
            ac = ac.getBase();
        }
        return result;
    }

    public static List<InterfaceItem> getAllInterfaceItems(ActorClass ac) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        while (ac != null) {
            result.addAll((Collection<InterfaceItem>)ac.getIntPorts());
            for (ExternalPort p : ac.getExtPorts()) {
                result.add(p.getIfport());
            }
            result.addAll((Collection<InterfaceItem>)ac.getStrSAPs());
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                result.add(svc.getSpp());
            }
            ac = ac.getBase();
        }
        return result;
    }

    public static ActorClass getActorClass(StateGraphItem item) {
        StateGraphItem parent = item;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ActorClass)) continue;
            return (ActorClass)((Object)parent);
        }
        assert (false) : "data structure broken";
        return null;
    }

    public static boolean isAnnotationPresent(ActorClass ac, String name) {
        return RoomHelpers.isAnnotationPresent(ac.getAnnotations(), name);
    }

    public static boolean isAnnotationPresent(List<Annotation> annotations, String name) {
        for (Annotation annotation : annotations) {
            if (!annotation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static List<KeyValue> getAttributes(ActorClass ac, String name) {
        return RoomHelpers.getAttributes(ac.getAnnotations(), name);
    }

    public static List<KeyValue> getAttributes(List<Annotation> annotations, String name) {
        for (Annotation annotation : annotations) {
            if (!annotation.getName().equals(name)) continue;
            return annotation.getAttributes();
        }
        return Collections.emptyList();
    }

    public static boolean isAttributePresent(ActorClass ac, String name, String key) {
        return RoomHelpers.isAttributePresent(ac.getAnnotations(), name, key);
    }

    public static boolean isAttributePresent(List<Annotation> annotations, String name, String key) {
        List<KeyValue> attributes = RoomHelpers.getAttributes(annotations, name);
        for (KeyValue attrib : attributes) {
            if (!attrib.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String getAttribute(ActorClass ac, String name, String key) {
        return RoomHelpers.getAttribute(ac.getAnnotations(), name, key);
    }

    public static String getAttribute(List<Annotation> annotations, String name, String key) {
        List<KeyValue> attributes = RoomHelpers.getAttributes(annotations, name);
        for (KeyValue attrib : attributes) {
            if (!attrib.getKey().equals(key)) continue;
            return attrib.getValue();
        }
        return "";
    }

    public static boolean isAttributePresent(Annotation annotation, String key) {
        for (KeyValue attrib : annotation.getAttributes()) {
            if (!attrib.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String getAttribute(Annotation annotation, String key) {
        for (KeyValue attrib : annotation.getAttributes()) {
            if (!attrib.getKey().equals(key)) continue;
            return attrib.getValue();
        }
        return "";
    }

    public static boolean hasFlatStateMachine(ActorClass ac) {
        if (ac.getStateMachine() == null) {
            return false;
        }
        if (!ac.getStateMachine().getTrPoints().isEmpty()) {
            return false;
        }
        for (State st : ac.getStateMachine().getStates()) {
            if (!RoomHelpers.hasDirectSubStructure(st)) continue;
            return false;
        }
        return true;
    }

    public static List<Message> getMessageList(InterfaceItem item, boolean outgoing) {
        ProtocolClass protocol = null;
        if (item instanceof Port) {
            protocol = ((Port)item).getProtocol();
            if (((Port)item).isConjugated()) {
                outgoing = !outgoing;
            }
        } else if (item instanceof SAPRef) {
            outgoing = !outgoing;
            protocol = ((SAPRef)item).getProtocol();
        } else if (item instanceof SPPRef) {
            protocol = ((SPPRef)item).getProtocol();
        } else {
            assert (false) : "unexpected sub type";
            return null;
        }
        return outgoing ? protocol.getOutgoingMessages() : protocol.getIncomingMessages();
    }

    public static String getName(Type tp) {
        if (tp.getType() != null) {
            return tp.getType().getName();
        }
        if (tp.getPrim() != null) {
            return tp.getPrim().getName();
        }
        return "?";
    }

    public static String getName(FreeType tp) {
        if (tp.getType() != null) {
            return tp.getType();
        }
        if (tp.getPrim() != null) {
            return tp.getPrim().getName();
        }
        return "?";
    }

    public static String getSignature(Operation op) {
        String signature = "";
        for (FreeTypedID arg : op.getArguments()) {
            signature = signature.isEmpty() ? String.valueOf(arg.getName()) + ": " + RoomHelpers.getName(arg.getType()) : String.valueOf(signature) + ", " + arg.getName() + ": " + RoomHelpers.getName(arg.getType());
        }
        signature = "(" + signature + ")";
        return signature;
    }
}

