/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.SemanticsInRule;
import org.eclipse.etrice.core.room.SemanticsOutRule;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class RoomScopeProvider
extends AbstractDeclarativeScopeProvider {
    public static final String STATE_PATH_DELIMITER = ".";

    private StateGraph getStateGraph(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof StateGraph) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof StateGraph) {
            return (StateGraph)ctx;
        }
        return null;
    }

    private ActorClass getActorClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorClass) {
            return (ActorClass)ctx;
        }
        return null;
    }

    private ActorContainerClass getActorContainerClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ActorContainerClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ActorContainerClass) {
            return (ActorContainerClass)ctx;
        }
        return null;
    }

    private ProtocolClass getProtocolClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ProtocolClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ProtocolClass) {
            return (ProtocolClass)ctx;
        }
        return null;
    }

    private boolean isContained(Port p, EList<ExternalPort> ports) {
        for (ExternalPort port : ports) {
            if (port.getIfport() != p) continue;
            return true;
        }
        return false;
    }

    private void collectAllStates(ActorClass ac, LinkedList<BaseState> states) {
        while (ac != null) {
            this.collectStates(ac.getStateMachine(), states);
            ac = ac.getBase();
        }
    }

    private void collectStates(StateGraph sg, LinkedList<BaseState> states) {
        if (sg == null) {
            return;
        }
        for (State s : sg.getStates()) {
            if (!(s instanceof BaseState)) continue;
            states.add((BaseState)s);
        }
        for (State s : sg.getStates()) {
            this.collectStates(s.getSubgraph(), states);
        }
    }

    private QualifiedName getStatePath(BaseState bs) {
        BaseState base;
        EObject parent = bs.eContainer().eContainer();
        if (parent instanceof BaseState) {
            return this.getStatePath((BaseState)parent).append(bs.getName());
        }
        if (parent instanceof RefinedState && (base = ((RefinedState)parent).getBase()) != null) {
            return this.getStatePath(base).append(bs.getName());
        }
        return QualifiedName.create((String[])new String[]{bs.getName()});
    }

    private LinkedList<ActorClass> getBaseClasses(ActorClass ac) {
        LinkedList<ActorClass> classes = new LinkedList<ActorClass>();
        if (ac != null) {
            classes.addFirst(ac);
            while (ac.getBase() != null) {
                ac = ac.getBase();
                classes.addFirst(ac);
            }
        }
        return classes;
    }

    private LinkedList<ProtocolClass> getBaseClasses(ProtocolClass pc) {
        LinkedList<ProtocolClass> classes = new LinkedList<ProtocolClass>();
        classes.addFirst(pc);
        while (pc.getBase() != null) {
            pc = pc.getBase();
            classes.addFirst(pc);
        }
        return classes;
    }

    private BaseState getBaseState(State s) {
        if (s instanceof BaseState) {
            return (BaseState)s;
        }
        if (s instanceof RefinedState) {
            return ((RefinedState)s).getBase();
        }
        return null;
    }

    private IScope getStateScopes(EObject obj) {
        ArrayList<IEObjectDescription> scopes;
        block4: {
            ActorClass ac;
            StateGraph parent;
            block5: {
                BaseState bs;
                scopes = new ArrayList<IEObjectDescription>();
                parent = this.getStateGraph(obj);
                if (parent == null) break block4;
                for (State s : parent.getStates()) {
                    bs = this.getBaseState(s);
                    scopes.add(EObjectDescription.create((String)bs.getName(), (EObject)bs));
                }
                if (!(parent.eContainer() instanceof RefinedState)) break block5;
                if ((parent = ((RefinedState)parent.eContainer()).getBase().getSubgraph()) == null) break block4;
                for (State s : parent.getStates()) {
                    bs = this.getBaseState(s);
                    scopes.add(EObjectDescription.create((String)bs.getName(), (EObject)bs));
                }
                break block4;
            }
            if (parent.eContainer() instanceof ActorClass && (ac = (ActorClass)parent.eContainer()).getBase() != null) {
                for (State s : ac.getBase().getStateMachine().getStates()) {
                    BaseState bs = this.getBaseState(s);
                    scopes.add(EObjectDescription.create((String)bs.getName(), (EObject)bs));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_StateTerminal_state(StateTerminal st, EReference ref) {
        return this.getStateScopes(st);
    }

    public IScope scope_TrPointTerminal_trPoint(TrPointTerminal ep, EReference ref) {
        StateGraph parent;
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph targetStateGraph = parent = this.getStateGraph(ep);
        this.getTrPointScopes(scopes, targetStateGraph);
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SubStateTrPointTerminal_trPoint(SubStateTrPointTerminal ep, EReference ref) {
        StateGraph parent;
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        StateGraph targetStateGraph = parent = this.getStateGraph(ep);
        if (ep.getState() != null) {
            targetStateGraph = ep.getState().getSubgraph();
            for (State sibling : parent.getStates()) {
                if (!(sibling instanceof RefinedState) || ((RefinedState)sibling).getBase() != ep.getState()) continue;
                targetStateGraph = sibling.getSubgraph();
            }
        }
        if (targetStateGraph != null) {
            this.getTrPointScopes(scopes, targetStateGraph);
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    private void getTrPointScopes(List<IEObjectDescription> scopes, StateGraph sg) {
        for (TrPoint tp : sg.getTrPoints()) {
            scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
        }
        if (sg.eContainer() instanceof RefinedState && (sg = ((RefinedState)sg.eContainer()).getBase().getSubgraph()) != null) {
            for (TrPoint tp : sg.getTrPoints()) {
                scopes.add(EObjectDescription.create((String)tp.getName(), (EObject)tp));
            }
        }
    }

    public IScope scope_SubStateTrPointTerminal_state(SubStateTrPointTerminal st, EReference ref) {
        return this.getStateScopes(st);
    }

    public IScope scope_ChoicepointTerminal_cp(ChoicepointTerminal ct, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block6: {
            ActorClass ac;
            StateGraph parent;
            block5: {
                scopes = new ArrayList<IEObjectDescription>();
                parent = this.getStateGraph(ct);
                if (parent != null) {
                    for (ChoicePoint cp : parent.getChPoints()) {
                        scopes.add(EObjectDescription.create((String)cp.getName(), (EObject)cp));
                    }
                }
                if (!(parent.eContainer() instanceof RefinedState)) break block5;
                if ((parent = ((RefinedState)parent.eContainer()).getBase().getSubgraph()) == null) break block6;
                for (ChoicePoint cp : parent.getChPoints()) {
                    scopes.add(EObjectDescription.create((String)cp.getName(), (EObject)cp));
                }
                break block6;
            }
            if (parent.eContainer() instanceof ActorClass && (ac = (ActorClass)parent.eContainer()).getBase() != null) {
                for (ChoicePoint cp : ac.getBase().getStateMachine().getChPoints()) {
                    scopes.add(EObjectDescription.create((String)cp.getName(), (EObject)cp));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_message(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        InterfaceItem item = mfi.getFrom();
        if (item != null) {
            ProtocolClass protocol = item.getProtocol();
            boolean conjugated = false;
            if (item instanceof Port) {
                conjugated = ((Port)item).isConjugated();
            } else if (item instanceof SAPRef) {
                conjugated = true;
            }
            for (Message msg : conjugated ? protocol.getOutgoingMessages() : protocol.getIncomingMessages()) {
                scopes.add(EObjectDescription.create((String)msg.getName(), (EObject)msg));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_port(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(mfi);
        for (Object p : ac.getIntPorts()) {
            scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
        }
        for (Object p : ac.getExtPorts()) {
            scopes.add(EObjectDescription.create((String)p.getIfport().getName(), (EObject)p.getIfport()));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageFromIf_from(MessageFromIf mfi, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(mfi);
        List<InterfaceItem> items = RoomHelpers.getAllInterfaceItems(ac);
        for (InterfaceItem item : items) {
            scopes.add(EObjectDescription.create((String)item.getName(), (EObject)item));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_actorRef(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass sc = this.getActorContainerClass(ep);
        if (sc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)sc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : sc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_BindingEndPoint_port(BindingEndPoint ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block9: {
            block8: {
                scopes = new ArrayList<IEObjectDescription>();
                ActorContainerClass acc = this.getActorContainerClass(ep);
                if (ep.getActorRef() != null) break block8;
                if (!(acc instanceof ActorClass)) break block9;
                ActorClass ac = (ActorClass)acc;
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (Port p : a.getIntPorts()) {
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                    for (Port p : a.getIfPorts()) {
                        if (this.isContained(p, a.getExtPorts())) continue;
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                }
                break block9;
            }
            if (ep.getActorRef() instanceof ActorRef) {
                ActorClass ac = ((ActorRef)ep.getActorRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (Port p : a.getIfPorts()) {
                        scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                    }
                }
            } else {
                SubSystemClass ssc = ((SubSystemRef)ep.getActorRef()).getType();
                for (Port p : ssc.getRelayPorts()) {
                    scopes.add(EObjectDescription.create((String)p.getName(), (EObject)p));
                }
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefinedState_base(RefinedState rs, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(rs);
        LinkedList<BaseState> states = new LinkedList<BaseState>();
        this.collectAllStates(ac.getBase(), states);
        for (BaseState bs : states) {
            scopes.add(EObjectDescription.create((QualifiedName)this.getStatePath(bs), (EObject)bs));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SemanticsInRule_msg(SemanticsInRule sr, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = this.getProtocolClass(sr);
        LinkedList<ProtocolClass> classes = this.getBaseClasses(pc);
        for (ProtocolClass bpc : classes) {
            for (Message m : bpc.getIncomingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SemanticsOutRule_msg(SemanticsOutRule sr, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = this.getProtocolClass(sr);
        LinkedList<ProtocolClass> classes = this.getBaseClasses(pc);
        for (ProtocolClass bpc : classes) {
            for (Message m : bpc.getOutgoingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RefSAPoint_ref(RefSAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_RelaySAPoint_relay(RelaySAPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(pt);
        LinkedList<ActorClass> classes = this.getBaseClasses(ac);
        for (ActorClass a : classes) {
            for (SPPRef spp : a.getIfSPPs()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_actorRef(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorContainerClass acc = this.getActorContainerClass(pt);
        if (acc instanceof ActorClass) {
            LinkedList<ActorClass> classes = this.getBaseClasses((ActorClass)acc);
            for (ActorClass a : classes) {
                for (ActorRef ar : a.getActorRefs()) {
                    scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
                }
            }
        } else {
            for (ActorRef ar : acc.getActorRefs()) {
                scopes.add(EObjectDescription.create((String)ar.getName(), (EObject)ar));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_SPPoint_service(SPPoint pt, EReference ref) {
        ArrayList<IEObjectDescription> scopes;
        block3: {
            block4: {
                scopes = new ArrayList<IEObjectDescription>();
                if (pt.getRef() == null) break block3;
                if (!(pt.getRef() instanceof ActorRef)) break block4;
                ActorClass ac = ((ActorRef)pt.getRef()).getType();
                LinkedList<ActorClass> classes = this.getBaseClasses(ac);
                for (ActorClass a : classes) {
                    for (SPPRef spp : a.getIfSPPs()) {
                        scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
                    }
                }
                break block3;
            }
            if (!(pt.getRef() instanceof SubSystemRef)) break block3;
            SubSystemClass ssc = ((SubSystemRef)pt.getRef()).getType();
            for (SPPRef spp : ssc.getIfSPPs()) {
                scopes.add(EObjectDescription.create((String)spp.getName(), (EObject)spp));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_MessageHandler_msg(MessageHandler handler, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ProtocolClass pc = this.getProtocolClass(handler);
        if (pc != null) {
            for (Message m : pc.getIncomingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
            for (Message m : pc.getOutgoingMessages()) {
                scopes.add(EObjectDescription.create((String)m.getName(), (EObject)m));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_ExternalPort_ifport(ExternalPort ep, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorClass ac = this.getActorClass(ep);
        for (Port ip : ac.getIfPorts()) {
            scopes.add(EObjectDescription.create((String)ip.getName(), (EObject)ip));
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }
}

