/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorInstancePath;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateMachine;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.validation.AbstractRoomJavaValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.validation.Check;

public class RoomJavaValidator
extends AbstractRoomJavaValidator {
    @Check
    public void checkTypeNameStartsWithCapital(RoomClass type) {
        if (!Character.isUpperCase(type.getName().charAt(0))) {
            this.warning("Name should start with a capital", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
        }
    }

    @Check
    public void checkActorRefIsNotCircular(ActorRef ar) {
        if (ar.eContainer() instanceof ActorClass) {
            ActorClass ac = (ActorClass)ar.eContainer();
            if (ValidationUtil.isReferencing(ar.getType(), ac)) {
                this.error("Actor reference is circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_Type());
            }
        }
    }

    @Check
    public void checkBaseClassesNotCircular(DataClass dc) {
        if (dc == null) {
            return;
        }
        DataClass base = dc.getBase();
        if (base != null && ValidationUtil.isBaseOf(dc, base)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ProtocolClass pc) {
        if (pc == null) {
            return;
        }
        ProtocolClass base = pc.getBase();
        if (base != null && ValidationUtil.isBaseOf(pc, base)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_Base());
        }
    }

    @Check
    public void checkBaseClassesNotCircular(ActorClass ac) {
        if (ac == null) {
            return;
        }
        ActorClass base = ac.getBase();
        if (base != null && ValidationUtil.isBaseOf(ac, base)) {
            this.error("Base classes are circular", (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_Base());
        }
    }

    @Check
    public void checkStateMachineTypeConsistent(StateMachine sm) {
        ActorClass ac = (ActorClass)sm.eContainer();
        boolean first = true;
        boolean dataDriven = false;
        do {
            if (ac.getStateMachine() == null) continue;
            if (first) {
                first = false;
                dataDriven = ac.getStateMachine().isDataDriven();
                continue;
            }
            if (dataDriven == ac.getStateMachine().isDataDriven()) continue;
            this.error("data_driven attribute not consistent in inheritance hierarchy", (EStructuralFeature)RoomPackage.eINSTANCE.getStateMachine_DataDriven());
        } while ((ac = ac.getBase()) != null);
    }

    private SubSystemClass getSubSystemClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof SubSystemClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof SubSystemClass) {
            return (SubSystemClass)ctx;
        }
        return null;
    }

    @Check
    public void checkSubSystem(SubSystemClass ssc) {
        if (ssc.getActorRefs().isEmpty()) {
            this.warning("SubSystemClass must contain at least one ActorRef", (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_ActorRefs());
        }
    }

    @Check
    public void checkLogicalSystem(LogicalSystem ls) {
        if (ls.getSubSystems().isEmpty()) {
            this.error("LogicalSystem must contain at least one SubSystemRef", (EStructuralFeature)RoomPackage.eINSTANCE.getLogicalSystem_SubSystems());
        }
    }

    @Check
    public void checkInstancePath(ActorInstancePath ai) {
        ActorContainerClass acc = this.getSubSystemClass(ai);
        for (String seg : ai.getSegments()) {
            boolean found = false;
            for (ActorRef ar : acc.getActorRefs()) {
                if (!ar.getName().equals(seg)) continue;
                acc = ar.getType();
                found = true;
                break;
            }
            if (found) continue;
            this.error("wrong actor instance path (segment number " + ai.getSegments().indexOf((Object)seg) + ")", (EStructuralFeature)RoomPackage.eINSTANCE.getActorInstancePath_Segments());
        }
    }

    @Check
    public void checkPortCompatibility(Binding bind) {
        ValidationUtil.Result result = ValidationUtil.isValid(bind);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getBinding_Endpoint1());
        }
    }

    @Check
    public void checkServiceCompatibility(LayerConnection conn) {
        ValidationUtil.Result result = ValidationUtil.isValid(conn);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        }
    }

    @Check
    public void checkTrPoint(TrPoint tp) {
        ValidationUtil.Result result = ValidationUtil.isValid(tp);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkInterfaceItemUniqueName(InterfaceItem item) {
        ValidationUtil.Result result = ValidationUtil.isUniqueName(item);
        if (!result.isOk()) {
            this.error(result.getMsg(), (EStructuralFeature)RoomPackage.eINSTANCE.getInterfaceItem_Name());
        }
    }

    @Check
    public void checkTransition(Transition trans) {
        ValidationUtil.Result result = ValidationUtil.checkTransition(trans);
        if (!result.isOk()) {
            this.error(result);
        }
        if (!(result = trans instanceof InitialTransition ? ValidationUtil.isConnectable(null, trans.getTo(), trans, (StateGraph)trans.eContainer()) : ValidationUtil.isConnectable(((NonInitialTransition)trans).getFrom(), trans.getTo(), trans, (StateGraph)trans.eContainer())).isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkState(State state) {
        ValidationUtil.Result result = ValidationUtil.checkState(state);
        if (!result.isOk()) {
            this.error(result);
        }
    }

    @Check
    public void checkPort(Port port) {
        if (port.getMultiplicity() == 0) {
            this.error("multiplicity must not be 0", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
        if (port.getMultiplicity() < -1) {
            this.error("multiplicity must be -1 or positive", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    private void error(ValidationUtil.Result result) {
        this.error(result.getMsg(), result.getSource(), result.getFeature(), result.getIndex());
    }
}

