/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ValidationUtil {
    /*
     * Unable to fully structure code
     */
    public static boolean isKindOf(DataClass dc1, DataClass dc2) {
        if (dc2 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (dc2 == dc1) {
                return true;
            }
            dc1 = dc1.getBase();
lbl6:
            // 2 sources

            ** while (dc1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static boolean isBaseOf(DataClass dc1, DataClass dc2) {
        return ValidationUtil.isKindOf(dc2.getBase(), dc1);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isKindOf(ProtocolClass pc1, ProtocolClass pc2) {
        if (pc2 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (pc2 == pc1) {
                return true;
            }
            pc1 = pc1.getBase();
lbl6:
            // 2 sources

            ** while (pc1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static boolean isBaseOf(ProtocolClass pc1, ProtocolClass pc2) {
        return ValidationUtil.isKindOf(pc2.getBase(), pc1);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isKindOf(ActorClass ac1, ActorClass ac2) {
        if (ac2 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (ac2 == ac1) {
                return true;
            }
            ac1 = ac1.getBase();
lbl6:
            // 2 sources

            ** while (ac1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static boolean isBaseOf(ActorClass ac1, ActorClass ac2) {
        return ValidationUtil.isKindOf(ac2.getBase(), ac1);
    }

    public static boolean isReferencing(ActorClass ref, ActorClass ac) {
        if (ValidationUtil.isKindOf(ref, ac)) {
            return true;
        }
        for (ActorRef ar : ref.getActorRefs()) {
            if (ValidationUtil.isKindOf(ar.getType(), ac)) {
                return true;
            }
            if (!ValidationUtil.isReferencing(ar.getType(), ac)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRelay(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            if (((ActorClass)acc).getIfPorts().contains((Object)port)) {
                for (ExternalPort xp : ((ActorClass)acc).getExtPorts()) {
                    if (xp.getIfport() != port) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc) {
        return ValidationUtil.isConnectable(port, ref, acc, null);
    }

    public static Result isConnectable(Port port, ActorContainerRef ref, StructureClass acc, Binding exclude) {
        if (!port.isReplicated() && ValidationUtil.isConnected(port, ref, acc, exclude)) {
            return Result.error("port with multiplicity 1 is already connected");
        }
        if (acc instanceof ActorClass) {
            for (ExternalPort xp : ((ActorClass)acc).getExtPorts()) {
                if (xp.getIfport() != port) continue;
                return Result.error("external end ports must not be connected");
            }
            return Result.ok();
        }
        return Result.ok();
    }

    public static Result isValid(Binding bind) {
        return ValidationUtil.isConnectable(bind.getEndpoint1().getPort(), bind.getEndpoint1().getActorRef(), bind.getEndpoint2().getPort(), bind.getEndpoint2().getActorRef(), (StructureClass)bind.eContainer(), bind);
    }

    public static Result isConnectable(BindingEndPoint ep1, BindingEndPoint ep2, StructureClass sc) {
        return ValidationUtil.isConnectable(ep1.getPort(), ep1.getActorRef(), ep2.getPort(), ep2.getActorRef(), sc);
    }

    public static Result isConnectable(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc) {
        return ValidationUtil.isConnectable(p1, ref1, p2, ref2, sc, null);
    }

    public static Result isConnectable(Port p1, ActorContainerRef ref1, Port p2, ActorContainerRef ref2, StructureClass sc, Binding exclude) {
        if (p1 == p2) {
            return Result.error("no self connection allowed, ports are indentical");
        }
        if (p1.getProtocol() != p2.getProtocol()) {
            return Result.error("protocols don't match");
        }
        if (ref1 == null && ref2 == null) {
            return Result.error("cannot connect two local ports");
        }
        if (ref1 != null && ref2 != null) {
            if (ref1 == ref2) {
                return Result.error("ports of one ref must not be connected");
            }
            if (p1.isConjugated() == p2.isConjugated()) {
                return Result.error("connected sub component ports must be conjugated to each other");
            }
            Result result = ValidationUtil.isConnectable(p1, ref1, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
            result = ValidationUtil.isConnectable(p2, ref2, sc, exclude);
            if (!result.isOk()) {
                return result;
            }
        } else {
            Port local = ref1 == null ? p1 : p2;
            Port sub = ref1 != null ? p1 : p2;
            ActorContainerRef ref = ref1 != null ? ref1 : ref2;
            ActorContainerClass acc = (ActorContainerClass)ref.eContainer();
            if (ValidationUtil.isRelay(local)) {
                if (local.isConjugated() != sub.isConjugated()) {
                    return Result.error("connected relay port must have same direction");
                }
                if (local.isReplicated() && !sub.isReplicated()) {
                    return Result.error("connected relay port must match replication type of peer");
                }
                if (!local.isReplicated() && sub.isReplicated()) {
                    return Result.error("connected relay port must match replication type of peer");
                }
                Result result = ValidationUtil.isConnectable(local, null, acc, exclude);
                if (!result.isOk()) {
                    return result;
                }
                result = ValidationUtil.isConnectable(sub, ref, acc, exclude);
                if (!result.isOk()) {
                    return result;
                }
            } else {
                if (local.isConjugated() == sub.isConjugated()) {
                    return Result.error("internal end port must have opposite direction");
                }
                if (local.isReplicated() && sub.isReplicated()) {
                    return Result.error("not both ports can be replicated");
                }
            }
        }
        return Result.ok();
    }

    public static boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnected(port, ref, sc, null);
    }

    public static boolean isConnected(Port port, ActorContainerRef ref, StructureClass sc, Binding exclude) {
        for (Binding bind : sc.getBindings()) {
            if (bind == exclude) continue;
            if (ValidationUtil.isEndpoint(bind.getEndpoint1(), port, ref)) {
                return true;
            }
            if (!ValidationUtil.isEndpoint(bind.getEndpoint2(), port, ref)) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
            return ValidationUtil.isConnected(port, ref, ((ActorClass)sc).getBase(), exclude);
        }
        return false;
    }

    private static boolean isEndpoint(BindingEndPoint ep, Port port, ActorContainerRef ref) {
        return ep.getActorRef() == ref && ep.getPort() == port;
    }

    public static boolean isRelay(SPPRef spp) {
        ActorContainerClass acc = (ActorContainerClass)spp.eContainer();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != spp) continue;
                return false;
            }
        }
        return true;
    }

    public static Result isValid(LayerConnection lc) {
        if (lc.getFrom() instanceof RelaySAPoint) {
            return ValidationUtil.isConnectable(((RelaySAPoint)lc.getFrom()).getRelay(), null, lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        if (lc.getFrom() instanceof RefSAPoint) {
            return ValidationUtil.isConnectable(null, ((RefSAPoint)lc.getFrom()).getRef(), lc.getTo().getService(), lc.getTo().getRef(), (StructureClass)lc.eContainer(), lc);
        }
        assert (false) : "unexpected sub type";
        return Result.error("internal error");
    }

    public static Result isConnectable(SPPRef src, ActorContainerRef srcRef, SPPRef tgt, ActorContainerRef tgtRef, StructureClass ac) {
        return ValidationUtil.isConnectable(src, srcRef, tgt, tgtRef, ac, null);
    }

    public static Result isConnectable(SPPRef src, ActorContainerRef srcRef, SPPRef dst, ActorContainerRef dstRef, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return Result.error("internal error");
        }
        if (src == null && srcRef == null || src != null && srcRef != null) {
            return Result.error("source can be an own SPP _or_ a ref");
        }
        if (dst == null || dstRef == null) {
            return Result.error("destination must be an SPP on a ref");
        }
        if (src != null && ValidationUtil.isConnectedSrc(src, sc, exclude)) {
            return Result.error("source SPP is already connected");
        }
        return Result.ok();
    }

    public static boolean isConnectableSrc(SPPRef src, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnectableSrc(src, ref, sc, null);
    }

    public static boolean isConnectableSrc(SPPRef src, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (src == null && ref == null || src != null && ref != null) {
            return false;
        }
        return src == null || !ValidationUtil.isConnectedSrc(src, sc, exclude);
    }

    public static boolean isConnectedSrc(SPPRef src, StructureClass sc) {
        return ValidationUtil.isConnectedSrc(src, sc, null);
    }

    public static boolean isConnectedSrc(SPPRef src, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || !(lc.getFrom() instanceof RelaySAPoint) || ((RelaySAPoint)lc.getFrom()).getRelay() != src) continue;
            return true;
        }
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            for (ServiceImplementation svc : ac.getServiceImplementations()) {
                if (svc.getSpp() != src) continue;
                return true;
            }
            if (ac.getBase() != null) {
                return ValidationUtil.isConnectedSrc(src, ac.getBase(), exclude);
            }
        }
        return false;
    }

    public static boolean isConnectableDst(SPPRef src, ActorContainerRef ref, StructureClass sc) {
        return ValidationUtil.isConnectableDst(src, ref, sc, null);
    }

    public static boolean isConnectableDst(SPPRef dst, ActorContainerRef ref, StructureClass sc, LayerConnection exclude) {
        if (sc == null) {
            return false;
        }
        if (dst == null || ref == null) {
            return false;
        }
        return dst == null || !ValidationUtil.isConnectedDst(dst, ref, sc, exclude);
    }

    public static boolean isConnectedDst(SPPRef src, ActorContainerRef acr, StructureClass sc) {
        return ValidationUtil.isConnectedDst(src, acr, sc, null);
    }

    public static boolean isConnectedDst(SPPRef src, ActorContainerRef acr, StructureClass sc, LayerConnection exclude) {
        for (LayerConnection lc : sc.getConnections()) {
            if (lc == exclude || lc.getTo().getService() != src || lc.getTo().getRef() != acr) continue;
            return true;
        }
        if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
            return ValidationUtil.isConnectedDst(src, acr, ((ActorClass)sc).getBase(), exclude);
        }
        return false;
    }

    public static Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, StateGraph sg) {
        return ValidationUtil.isConnectable(src, tgt, null, sg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Result isConnectable(TransitionTerminal src, TransitionTerminal tgt, Transition trans, StateGraph sg) {
        Result result = ValidationUtil.isConnectableSrc(src, trans, sg);
        if (!result.isOk()) {
            return result;
        }
        if (tgt instanceof TrPointTerminal) {
            TrPoint tgtTP;
            if (((TrPointTerminal)tgt).getTrPoint() instanceof EntryPoint) {
                return Result.error("entry point can not be transition target", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            }
            if (!(((TrPointTerminal)tgt).getTrPoint() instanceof TransitionPoint)) return Result.ok();
            if (!(src instanceof TrPointTerminal)) return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
            TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
            if (srcTP == (tgtTP = ((TrPointTerminal)tgt).getTrPoint())) return Result.ok();
            return Result.error("transition point can only be target of self transition", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
        }
        if (!(tgt instanceof SubStateTrPointTerminal)) return Result.ok();
        if (((SubStateTrPointTerminal)tgt).getTrPoint() instanceof ExitPoint) {
            return Result.error("sub state exit point can not be transition target", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
        }
        for (Transition t : sg.getTransitions()) {
            SubStateTrPointTerminal tpt;
            if (t == trans || !(t.getTo() instanceof SubStateTrPointTerminal) || (tpt = (SubStateTrPointTerminal)t.getTo()).getTrPoint() != ((SubStateTrPointTerminal)tgt).getTrPoint()) continue;
            return Result.error("target transition point already is connected", tgt, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
        }
        return Result.ok();
    }

    public static Result isConnectable(TransitionTerminal src, StateGraph sg) {
        return ValidationUtil.isConnectableSrc(src, null, sg);
    }

    public static Result isConnectableSrc(TransitionTerminal src, Transition trans, StateGraph sg) {
        block7: {
            block8: {
                block6: {
                    if (src != null) break block6;
                    for (Transition t : sg.getTransitions()) {
                        if (t == trans || !(t instanceof InitialTransition)) continue;
                        return Result.error("there already is an InitialTransition", sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), sg.getTransitions().indexOf((Object)trans));
                    }
                    break block7;
                }
                if (!(src instanceof TrPointTerminal)) break block8;
                TrPoint srcTP = ((TrPointTerminal)src).getTrPoint();
                if (srcTP instanceof ExitPoint) {
                    return Result.error("exit point can not be transition source", trans, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
                if (!(srcTP instanceof EntryPoint)) break block7;
                for (Transition t : sg.getTransitions()) {
                    TrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof TrPointTerminal) || (tpt = (TrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != srcTP) continue;
                    return Result.error("source transition point already is connected", src, (EStructuralFeature)RoomPackage.eINSTANCE.getTrPointTerminal_TrPoint(), 0);
                }
                break block7;
            }
            if (src instanceof SubStateTrPointTerminal) {
                if (((SubStateTrPointTerminal)src).getTrPoint() instanceof EntryPoint) {
                    return Result.error("sub state entry point can not be transition source", src, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
                }
                for (Transition t : sg.getTransitions()) {
                    SubStateTrPointTerminal tpt;
                    if (t == trans || !(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (tpt = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != ((SubStateTrPointTerminal)src).getTrPoint()) continue;
                    return Result.error("source transition point already is connected", src, (EStructuralFeature)RoomPackage.eINSTANCE.getSubStateTrPointTerminal_TrPoint(), 0);
                }
            }
        }
        return Result.ok();
    }

    public static Result isValid(TrPoint tp) {
        if (tp instanceof TransitionPoint) {
            return Result.ok();
        }
        if (tp.eContainer().eContainer() instanceof State) {
            return Result.ok();
        }
        StateGraph sg = (StateGraph)tp.eContainer();
        int idx = sg.getTrPoints().indexOf((Object)tp);
        return Result.error("entry and exit points forbidden on top level state graph", tp.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
    }

    public static Result isUniqueName(InterfaceItem item) {
        return ValidationUtil.isUniqueName(item, item.getName());
    }

    public static boolean isConnectedOutside(TrPoint tp) {
        if (tp instanceof TransitionPoint) {
            return false;
        }
        StateGraph parentSG = (StateGraph)tp.eContainer().eContainer().eContainer();
        for (Transition t : parentSG.getTransitions()) {
            SubStateTrPointTerminal term;
            if (t.getTo() instanceof SubStateTrPointTerminal && (term = (SubStateTrPointTerminal)t.getTo()).getTrPoint() == tp) {
                return true;
            }
            if (!(t instanceof NonInitialTransition) || !(((NonInitialTransition)t).getFrom() instanceof SubStateTrPointTerminal) || (term = (SubStateTrPointTerminal)((NonInitialTransition)t).getFrom()).getTrPoint() != tp) continue;
            return true;
        }
        return false;
    }

    public static Result isUniqueName(InterfaceItem item, String name) {
        block6: {
            block5: {
                if (name.isEmpty()) {
                    return Result.error("name must not be empty");
                }
                if (!(item.eContainer() instanceof ActorClass)) break block5;
                ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
                ActorClass ac = (ActorClass)item.eContainer();
                do {
                    all.addAll((Collection<InterfaceItem>)ac.getIfPorts());
                    all.addAll((Collection<InterfaceItem>)ac.getIntPorts());
                    all.addAll((Collection<InterfaceItem>)ac.getIfSPPs());
                    all.addAll((Collection<InterfaceItem>)ac.getStrSAPs());
                } while ((ac = ac.getBase()) != null);
                for (InterfaceItem ii : all) {
                    if (ii == item || !ii.getName().equals(name)) continue;
                    if (ii.eContainer() != item.eContainer()) {
                        return Result.error("name already used in base class " + ((ActorClass)ii.eContainer()).getName());
                    }
                    return Result.error("name already used");
                }
                break block6;
            }
            if (!(item.eContainer() instanceof SubSystemClass)) break block6;
            SubSystemClass ssc = (SubSystemClass)item.eContainer();
            ArrayList<InterfaceItem> all = new ArrayList<InterfaceItem>();
            all.addAll((Collection<InterfaceItem>)ssc.getIfSPPs());
            all.addAll((Collection<InterfaceItem>)ssc.getRelayPorts());
            for (InterfaceItem ii : all) {
                if (ii == item || !ii.getName().equals(name)) continue;
                return Result.error("name already used");
            }
        }
        return Result.ok();
    }

    public static Result isUniqueName(StateGraphItem s, String name) {
        if (name.isEmpty()) {
            return Result.error("name must not be empty");
        }
        StateGraph sg = (StateGraph)s.eContainer();
        Set<String> names = RoomHelpers.getAllNames(sg, s);
        if (names.contains(name)) {
            return Result.error("name already used");
        }
        return Result.ok();
    }

    public static Result checkTransition(Transition tr) {
        ActorClass ac = RoomHelpers.getActorClass(tr);
        if (ac.getStateMachine().isDataDriven()) {
            TransitionTerminal term;
            if (tr instanceof TriggeredTransition) {
                return Result.error("data driven state machine must not contain triggered transition", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition && ((term = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term instanceof TrPointTerminal && ((TrPointTerminal)term).getTrPoint() instanceof TransitionPoint)) {
                return Result.error("guard must not be empty", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof GuardedTransition && !RoomHelpers.hasDetailCode(((GuardedTransition)tr).getGuard())) {
                return Result.error("guard must not be empty", tr, (EStructuralFeature)RoomPackage.eINSTANCE.getGuardedTransition_Guard());
            }
        } else {
            TransitionTerminal term;
            if (tr instanceof GuardedTransition) {
                return Result.error("event driven state machine must not contain guarded transition", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
            if (tr instanceof ContinuationTransition && ((term = ((ContinuationTransition)tr).getFrom()) instanceof StateTerminal || term instanceof TrPointTerminal && ((TrPointTerminal)term).getTrPoint() instanceof TransitionPoint)) {
                return Result.error("trigger must not be empty", tr.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), ((StateGraph)tr.eContainer()).getTransitions().indexOf((Object)tr));
            }
        }
        return Result.ok();
    }

    public static Result checkState(State state) {
        ActorClass ac;
        if (state.getDoCode() != null && !(ac = RoomHelpers.getActorClass(state)).getStateMachine().isDataDriven()) {
            return Result.error("only data driven state machines may have 'do' action code", state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_DoCode());
        }
        return Result.ok();
    }

    public static class Result {
        private boolean ok;
        private String msg;
        private EObject source;
        private EStructuralFeature feature;
        private int index;

        static Result ok() {
            return new Result(true, "", null, null, 0);
        }

        static Result error(String msg) {
            return new Result(false, msg, null, null, -1);
        }

        static Result error(String msg, EObject source, EStructuralFeature feature) {
            return new Result(false, msg, source, feature, -1);
        }

        static Result error(String msg, EObject source, EStructuralFeature feature, int index) {
            return new Result(false, msg, source, feature, index);
        }

        private Result(boolean ok, String msg, EObject source, EStructuralFeature feature, int index) {
            this.ok = ok;
            this.msg = msg;
            this.source = source;
            this.feature = feature;
            this.index = index;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMsg() {
            return this.msg;
        }

        public EObject getSource() {
            return this.source;
        }

        public EStructuralFeature getFeature() {
            return this.feature;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

