package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.etricegen.SubSystemInstance;
import org.eclipse.etrice.generator.java.gen.StdExtensions;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class SubSystemRunnerGen {
  
  @Inject
  private JavaIoFileSystemAccess fileAccess;
  
  @Inject
  private StdExtensions stdExt;
  
  public void doGenerate(final Root root) {
    EList<SubSystemInstance> _subSystemInstances = root.getSubSystemInstances();
    for (SubSystemInstance sc : _subSystemInstances) {
      {
        SubSystemClass _subSystemClass = sc.getSubSystemClass();
        String _generationTargetPath = this.stdExt.getGenerationTargetPath(_subSystemClass);
        SubSystemClass _subSystemClass_1 = sc.getSubSystemClass();
        String _path = this.stdExt.getPath(_subSystemClass_1);
        String _operator_plus = StringExtensions.operator_plus(_generationTargetPath, _path);
        this.fileAccess.setOutputPath(_operator_plus);
        String _name = sc.getName();
        String _operator_plus_1 = StringExtensions.operator_plus(_name, "Runner.java");
        SubSystemClass _subSystemClass_2 = sc.getSubSystemClass();
        StringConcatenation _generate = this.generate(root, sc, _subSystemClass_2);
        this.fileAccess.generateFile(_operator_plus_1, _generate);
      }
    }
  }
  
  public StringConcatenation generate(final Root root, final SubSystemInstance ssc, final SubSystemClass cc) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @author generated by eTrice");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* this class contains the main function running component ");
    String _name = ssc.getName();
    _builder.append(_name, " ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* it instantiates ");
    String _name_1 = ssc.getName();
    _builder.append(_name_1, " ");
    _builder.append(" and starts and ends the lifecycle");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("package ");
    String _package = this.stdExt.getPackage(cc);
    _builder.append(_package, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    String _name_2 = ssc.getName();
    String _operator_plus = StringExtensions.operator_plus(_name_2, "Runner");
    _builder.append(_operator_plus, "");
    _builder.append(" extends SubSystemRunnerBase {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static ");
    String _name_3 = ssc.getName();
    _builder.append(_name_3, "	");
    _builder.append(" main_component = new ");
    String _name_4 = ssc.getName();
    _builder.append(_name_4, "	");
    _builder.append("(null, \"");
    String _name_5 = ssc.getName();
    _builder.append(_name_5, "	");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* main function");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("* creates component and starts and stops the lifecycle");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static void main(String[] args) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("System.out.println(\"***   T H E   B E G I N   ***\");");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("main_component.init(); // lifecycle init");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("main_component.start(); // lifecycle start");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// application runs until quit ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("waitForQuit();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// end the lifecycle");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("main_component.stop(); // lifecycle stop");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("main_component.destroy(); // lifecycle destroy");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("System.out.println(\"***   T H E   E N D   ***\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
}