/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.Import;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.Type;
import org.eclipse.etrice.generator.base.ILogger;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.java.gen.ProcedureHelpers;
import org.eclipse.etrice.generator.java.gen.StdExtensions;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.ComparableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtend2.lib.StringConcatenation;

public class DataClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private StdExtensions stdExt;
    @Inject
    private ProcedureHelpers helpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedDataClasses = root.getUsedDataClasses();
        for (DataClass dc : _usedDataClasses) {
            String _fileName;
            String _operator_plus;
            String _generationTargetPath = this.stdExt.getGenerationTargetPath((EObject)dc);
            String _path = this.stdExt.getPath((RoomClass)dc);
            String path = _operator_plus = StringExtensions.operator_plus((String)_generationTargetPath, (Object)_path);
            String file = _fileName = this.stdExt.getFileName((RoomClass)dc);
            String _operator_plus_1 = StringExtensions.operator_plus((String)"generating DataClass implementation '", (Object)file);
            String _operator_plus_2 = StringExtensions.operator_plus((String)_operator_plus_1, (Object)"' in '");
            String _operator_plus_3 = StringExtensions.operator_plus((String)_operator_plus_2, (Object)path);
            String _operator_plus_4 = StringExtensions.operator_plus((String)_operator_plus_3, (Object)"'");
            this.logger.logInfo(_operator_plus_4);
            this.fileAccess.setOutputPath(path);
            StringConcatenation _generate = this.generate(root, dc);
            this.fileAccess.generateFile(file, (CharSequence)_generate);
        }
    }

    public StringConcatenation generate(Root root, DataClass dc) {
        EList _referencedModels;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this.stdExt.getPackage((RoomClass)dc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList models = _referencedModels = root.getReferencedModels((RoomClass)dc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList _imports = dc.getImports();
        int _size = _imports.size();
        boolean _operator_greaterThan = ComparableExtensions.operator_greaterThan((Comparable)Integer.valueOf(_size), (Object)0);
        if (_operator_greaterThan) {
            _builder.append((Object)"// user imports");
            _builder.newLine();
            EList _imports_1 = dc.getImports();
            for (Import imp : _imports_1) {
                _builder.append((Object)"import ");
                String _importedNamespace = imp.getImportedNamespace();
                _builder.append((Object)_importedNamespace, "");
                _builder.append((Object)".*;");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = dc.getName();
        _builder.append((Object)_name_1, "");
        DataClass _base = dc.getBase();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_base, null);
        if (_operator_notEquals) {
            _builder.append((Object)" extends ");
            DataClass _base_1 = dc.getBase();
            String _name_2 = _base_1.getName();
            _builder.append((Object)_name_2, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        EList _attributes = dc.getAttributes();
        StringConcatenation _Attributes = this.helpers.Attributes((List<Attribute>)_attributes);
        _builder.append((Object)_Attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        EList _attributes_1 = dc.getAttributes();
        StringConcatenation _AttributeSettersGetters = this.helpers.AttributeSettersGetters((List<Attribute>)_attributes_1);
        _builder.append((Object)_AttributeSettersGetters, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        EList _operations = dc.getOperations();
        StringConcatenation _Operations = this.helpers.Operations((List<Operation>)_operations);
        _builder.append((Object)_Operations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// default constructor");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_3 = dc.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        EList _attributes_2 = dc.getAttributes();
        for (Attribute a : _attributes_2) {
            String _defaultValueLiteral = a.getDefaultValueLiteral();
            boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)_defaultValueLiteral, null);
            if (_operator_notEquals_1) {
                _builder.append((Object)"\t\t");
                int _size_1 = a.getSize();
                boolean _operator_equals = ObjectExtensions.operator_equals((Object)_size_1, (Object)0);
                if (_operator_equals) {
                    String _name_4 = a.getName();
                    _builder.append((Object)_name_4, "\t\t");
                    _builder.append((Object)" = ");
                    String _defaultValueLiteral_1 = a.getDefaultValueLiteral();
                    _builder.append((Object)_defaultValueLiteral_1, "\t\t");
                    _builder.append((Object)";");
                }
                _builder.newLineIfNotEmpty();
                continue;
            }
            Type _type = a.getType();
            DataClass _type_1 = _type.getType();
            boolean _operator_notEquals_2 = ObjectExtensions.operator_notEquals((Object)_type_1, null);
            if (!_operator_notEquals_2) continue;
            _builder.append((Object)"\t\t");
            String _name_5 = a.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = new ");
            Type _type_2 = a.getType();
            DataClass _type_3 = _type_2.getType();
            String _name_6 = _type_3.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// deep copy");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_7 = dc.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)" deepCopy() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _name_8 = dc.getName();
        _builder.append((Object)_name_8, "\t\t");
        _builder.append((Object)" copy = new ");
        String _name_9 = dc.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        EList _attributes_3 = dc.getAttributes();
        for (Attribute a_1 : _attributes_3) {
            Type _type_4 = a_1.getType();
            DataClass _type_5 = _type_4.getType();
            boolean _operator_notEquals_3 = ObjectExtensions.operator_notEquals((Object)_type_5, null);
            if (_operator_notEquals_3) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"copy.");
                String _name_10 = a_1.getName();
                _builder.append((Object)_name_10, "\t\t");
                _builder.append((Object)" = ");
                String _name_11 = a_1.getName();
                _builder.append((Object)_name_11, "\t\t");
                _builder.append((Object)".deepCopy();");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            int _size_2 = a_1.getSize();
            boolean _operator_equals_1 = ObjectExtensions.operator_equals((Object)_size_2, (Object)0);
            if (_operator_equals_1) {
                _builder.append((Object)"copy.");
                String _name_12 = a_1.getName();
                _builder.append((Object)_name_12, "\t\t");
                _builder.append((Object)" = ");
                String _name_13 = a_1.getName();
                _builder.append((Object)_name_13, "\t\t");
                _builder.append((Object)";");
            } else {
                _builder.append((Object)"for (int i=0;i<");
                int _size_3 = a_1.getSize();
                _builder.append((Object)_size_3, "\t\t");
                _builder.append((Object)";i++){copy.");
                String _name_14 = a_1.getName();
                _builder.append((Object)_name_14, "\t\t");
                _builder.append((Object)"[i]=");
                String _name_15 = a_1.getName();
                _builder.append((Object)_name_15, "\t\t");
                _builder.append((Object)"[i];}");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return copy;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }
}

