/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.Type;
import org.eclipse.etrice.core.room.TypedID;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.ITransitionChainVisitor;
import org.eclipse.etrice.generator.etricegen.TransitionChain;
import org.eclipse.etrice.generator.java.gen.JavaTransitionChainVisitor;

public class JavaGenerator {
    public String getExecuteChain(ExpandedActorClass ac, TransitionChain tc) {
        JavaTransitionChainVisitor tcv = new JavaTransitionChainVisitor(ac, tc);
        return tc.genExecuteChain((ITransitionChainVisitor)tcv);
    }

    public String getArgumentList(ExpandedActorClass xpac, Transition t) {
        if (t instanceof InitialTransition) {
            return "";
        }
        TransitionChain chain = xpac.getChain(t);
        if (!(chain.getTransition() instanceof TriggeredTransition)) {
            return "";
        }
        Trigger trigger = (Trigger)((TriggeredTransition)chain.getTransition()).getTriggers().get(0);
        MessageFromIf mif = (MessageFromIf)trigger.getMsgFromIfPairs().get(0);
        return this.getTypedArgumentList(mif.getMessage());
    }

    public String getArgumentList(Message m) {
        return this.getArglistAndTypedData(m.getData())[0];
    }

    public String getTypedData(Message m) {
        return this.getArglistAndTypedData(m.getData())[1];
    }

    public String getTypedArgumentList(Message m) {
        return this.getArglistAndTypedData(m.getData())[2];
    }

    public String[] getArglistAndTypedData(TypedID data) {
        String ct;
        String t;
        block13: {
            Type type;
            block12: {
                if (data == null) {
                    return new String[]{"", "", ""};
                }
                type = data.getType();
                if (type.getType() != null) break block12;
                switch (type.getPrim()) {
                    case BOOLEAN: {
                        t = "boolean";
                        ct = "Boolean";
                        break block13;
                    }
                    case CHAR: {
                        t = "char";
                        ct = "Char";
                        break block13;
                    }
                    case FLOAT32: {
                        t = "float";
                        ct = "Float";
                        break block13;
                    }
                    case FLOAT64: {
                        t = "double";
                        ct = "Double";
                        break block13;
                    }
                    case INT32: {
                        t = "int";
                        ct = "Integer";
                        break block13;
                    }
                    case STRING: {
                        t = "String";
                        ct = "String";
                        break block13;
                    }
                    case INT8: {
                        t = "byte";
                        ct = "Byte";
                        break block13;
                    }
                    case INT16: {
                        t = "short";
                        ct = "Short";
                        break block13;
                    }
                    default: {
                        t = "invalid Java data type";
                        ct = "";
                        assert (false) : "Java doesn't support type " + type.getPrim().name() + "!";
                        break block13;
                    }
                }
            }
            ct = t = type.getType().getName();
        }
        String typedData = String.valueOf(t) + " " + data.getName() + " = (" + ct + ") generic_data;\n";
        String dataArg = ", " + data.getName();
        String typedArgList = ", " + t + " " + data.getName();
        return new String[]{dataArg, typedData, typedArgList};
    }
}

