/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.TypedID;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.ITransitionChainVisitor;
import org.eclipse.etrice.generator.etricegen.TransitionChain;
import org.eclipse.etrice.generator.extensions.Extensions;
import org.eclipse.etrice.generator.java.gen.JavaGenerator;

public class JavaTransitionChainVisitor
implements ITransitionChainVisitor {
    private ExpandedActorClass ac;
    private JavaGenerator javaGen = new JavaGenerator();
    private String typedData = "";
    private String dataArg = "";

    JavaTransitionChainVisitor(ExpandedActorClass ac, TransitionChain tc) {
        this.ac = ac;
        if (tc.getTransition() instanceof TriggeredTransition) {
            TypedID data = ((MessageFromIf)((Trigger)((TriggeredTransition)tc.getTransition()).getTriggers().get(0)).getMsgFromIfPairs().get(0)).getMessage().getData();
            String[] result = this.javaGen.getArglistAndTypedData(data);
            this.dataArg = result[0];
            this.typedData = result[1];
        }
    }

    public String genActionOperationCall(Transition tr) {
        if (tr.getAction() != null && !tr.getAction().getCommands().isEmpty()) {
            if (tr instanceof InitialTransition) {
                return String.valueOf(Extensions.getActionCodeOperationName((Transition)tr)) + "();\n";
            }
            return String.valueOf(Extensions.getActionCodeOperationName((Transition)tr)) + "(ifitem" + this.dataArg + ");\n";
        }
        return "";
    }

    public String genEntryOperationCall(State state) {
        return String.valueOf(Extensions.getEntryCodeOperationName((State)state)) + "();\n";
    }

    public String genExitOperationCall(State state) {
        return String.valueOf(Extensions.getExitCodeOperationName((State)state)) + "();\n";
    }

    public String genElseIfBranch(CPBranchTransition tr, boolean isFirst) {
        String result = "";
        if (!isFirst) {
            result = "}\nelse ";
        }
        result = String.valueOf(result) + "if (" + this.ac.getCode(tr.getCondition()) + ") {\n";
        return result;
    }

    public String genElseBranch(ContinuationTransition tr) {
        String result = "}\nelse {\n";
        return result;
    }

    public String genEndIf() {
        return "}\n";
    }

    public String genReturnState(State state) {
        return "return " + Extensions.getStateId((State)state) + ";";
    }

    public String genTypedData() {
        return this.typedData;
    }
}

