/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.Type;
import org.eclipse.etrice.core.room.TypedID;
import org.eclipse.etrice.generator.base.ILogger;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.java.gen.ProcedureHelpers;
import org.eclipse.etrice.generator.java.gen.StdExtensions;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtend2.lib.StringConcatenation;

public class ProtocolClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private StdExtensions stdExt;
    @Inject
    private ProcedureHelpers helpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        for (ProtocolClass pc : _usedProtocolClasses) {
            String _fileName;
            String _operator_plus;
            String _generationTargetPath = this.stdExt.getGenerationTargetPath((EObject)pc);
            String _path = this.stdExt.getPath((RoomClass)pc);
            String path = _operator_plus = StringExtensions.operator_plus((String)_generationTargetPath, (Object)_path);
            String file = _fileName = this.stdExt.getFileName((RoomClass)pc);
            String _operator_plus_1 = StringExtensions.operator_plus((String)"generating ProtocolClass implementation '", (Object)file);
            String _operator_plus_2 = StringExtensions.operator_plus((String)_operator_plus_1, (Object)"' in '");
            String _operator_plus_3 = StringExtensions.operator_plus((String)_operator_plus_2, (Object)path);
            String _operator_plus_4 = StringExtensions.operator_plus((String)_operator_plus_3, (Object)"'");
            this.logger.logInfo(_operator_plus_4);
            this.fileAccess.setOutputPath(path);
            StringConcatenation _generate = this.generate(root, pc);
            this.fileAccess.generateFile(file, (CharSequence)_generate);
        }
    }

    public StringConcatenation generate(Root root, ProtocolClass pc) {
        EList _referencedModels;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this.stdExt.getPackage((RoomClass)pc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.ArrayList;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Address;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.messaging.Message;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.*;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode1 = pc.getUserCode1();
        StringConcatenation _UserCode = this.helpers.UserCode(_userCode1);
        _builder.append((Object)_UserCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList models = _referencedModels = root.getReferencedModels((RoomClass)pc);
        _builder.newLineIfNotEmpty();
        for (RoomModel model : models) {
            _builder.append((Object)"import ");
            String _name = model.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// message IDs");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// TODO: separate class for message IDs: class MSG{public static volatile int MSG_MIN = 0; ...} -> better structure");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// error if msgID <= MSG_MIN");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MSG_MIN = 0;   ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//IDs for outgoing messages");
        _builder.newLine();
        List _allOutgoingMessages = this.stdExt.getAllOutgoingMessages(pc);
        for (Message message : _allOutgoingMessages) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int OUT_");
            String _name_2 = message.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" = ");
            List _allOutgoingMessages_1 = this.stdExt.getAllOutgoingMessages(pc);
            int _indexOf = _allOutgoingMessages_1.indexOf(message);
            int _operator_plus = IntegerExtensions.operator_plus((Integer)_indexOf, (Number)1);
            _builder.append((Object)_operator_plus, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"//IDs for incoming messages");
        _builder.newLine();
        List _allIncomingMessages = this.stdExt.getAllIncomingMessages(pc);
        for (Message message_1 : _allIncomingMessages) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public static final int IN_");
            String _name_3 = message_1.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)" = ");
            List _allIncomingMessages_1 = this.stdExt.getAllIncomingMessages(pc);
            int _indexOf_1 = _allIncomingMessages_1.indexOf(message_1);
            List _allOutgoingMessages_2 = this.stdExt.getAllOutgoingMessages(pc);
            int _size = _allOutgoingMessages_2.size();
            int _operator_plus_1 = IntegerExtensions.operator_plus((Integer)_indexOf_1, (Number)_size);
            int _operator_plus_2 = IntegerExtensions.operator_plus((Integer)_operator_plus_1, (Number)1);
            _builder.append((Object)_operator_plus_2, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"//error if msgID >= MSG_MAX");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static final int MSG_MAX = ");
        List _allOutgoingMessages_3 = this.stdExt.getAllOutgoingMessages(pc);
        int _size_1 = _allOutgoingMessages_3.size();
        List _allIncomingMessages_2 = this.stdExt.getAllIncomingMessages(pc);
        int _size_2 = _allIncomingMessages_2.size();
        int _operator_plus_3 = IntegerExtensions.operator_plus((Integer)_size_1, (Number)_size_2);
        int _operator_plus_4 = IntegerExtensions.operator_plus((Integer)_operator_plus_3, (Number)1);
        _builder.append((Object)_operator_plus_4, "\t");
        _builder.append((Object)";  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode2 = pc.getUserCode2();
        StringConcatenation _UserCode_1 = this.helpers.UserCode(_userCode2);
        _builder.append((Object)_UserCode_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static String messageStrings[] = {\"MIN\", ");
        List _allOutgoingMessages_4 = this.stdExt.getAllOutgoingMessages(pc);
        for (Message m : _allOutgoingMessages_4) {
            _builder.append((Object)"\"");
            String _name_4 = m.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)" ");
        List _allIncomingMessages_3 = this.stdExt.getAllIncomingMessages(pc);
        for (Message m_1 : _allIncomingMessages_3) {
            _builder.append((Object)"\"");
            String _name_5 = m_1.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"\",");
        }
        _builder.append((Object)"\"MAX\"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getMessageString(int msg_id) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (msg_id<0 || msg_id>MSG_MAX+1){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"// id out of range");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"else{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return messageStrings[msg_id];");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        StringConcatenation _portClass = this.portClass(pc, false);
        _builder.append((Object)_portClass, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        StringConcatenation _portClass_1 = this.portClass(pc, true);
        _builder.append((Object)_portClass_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public StringConcatenation portClass(ProtocolClass pc, Boolean conj) {
        PortClass _portClass;
        String _portClassName;
        StringConcatenation _builder = new StringConcatenation();
        String name = _portClassName = this.stdExt.getPortClassName(pc, conj);
        _builder.newLineIfNotEmpty();
        PortClass pclass = _portClass = this.stdExt.getPortClass(pc, conj);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"// port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)name, "");
        _builder.append((Object)" extends PortBase {");
        _builder.newLineIfNotEmpty();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)pclass, null);
        if (_operator_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _userCode = pclass.getUserCode();
            StringConcatenation _UserCode = this.helpers.UserCode(_userCode);
            _builder.append((Object)_UserCode, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructors");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(IEventReceiver actor, String name, int localId, Address addr, Address peerAddress) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(actor, name, localId, 0, addr, peerAddress);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addPortInstance(this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"(IEventReceiver actor, String name, int localId, int idx, Address addr, Address peerAddress) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(actor, name, localId, idx, addr, peerAddress);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addPortInstance(this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void receive(Message m) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (!(m instanceof EventMessage))");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"EventMessage msg = (EventMessage) m;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (msg.getEvtId() <= 0 || msg.getEvtId() >= MSG_MAX)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"System.out.println(\"unknown\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (messageStrings[msg.getEvtId()] != \"timerTick\"){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"// TODOTS: model switch for activation");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), messageStrings[msg.getEvtId()]);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        boolean _handlesReceive = this.stdExt.handlesReceive(pc, conj);
        if (_handlesReceive) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"switch (msg.getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this.stdExt.getReceiveHandlers(pc, conj);
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                Message _msg = hdlr.getMsg();
                String _codeName = this.stdExt.getCodeName(_msg);
                _builder.append((Object)_codeName, "\t\t\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _commands = _detailCode.getCommands();
                for (String command : _commands) {
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)command, "\t\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (msg instanceof EventWithDataMessage)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), ((EventWithDataMessage)msg).getData());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"else");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"getActor().receiveEvent(this, msg.getEvtId(), null);");
        _builder.newLine();
        boolean _handlesReceive_1 = this.stdExt.handlesReceive(pc, conj);
        if (_handlesReceive_1) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)pclass, null);
        if (_operator_notEquals_1) {
            _builder.append((Object)"\t");
            EList _attributes = pclass.getAttributes();
            StringConcatenation _Attributes = this.helpers.Attributes((List<Attribute>)_attributes);
            _builder.append((Object)_Attributes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _operations = pclass.getOperations();
            StringConcatenation _Operations = this.helpers.Operations((List<Operation>)_operations);
            _builder.append((Object)_Operations, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _outgoing = this.stdExt.getOutgoing(pc, conj);
        for (Message m : _outgoing) {
            _builder.append((Object)"\t");
            StringConcatenation _sendMessage = this.sendMessage(m, conj);
            _builder.append((Object)_sendMessage, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// replicated port class");
        _builder.newLine();
        _builder.append((Object)"static public class ");
        _builder.append((Object)name, "");
        _builder.append((Object)"Repl {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ArrayList<");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"> ports;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private int replication;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Repl(IEventReceiver actor, String name, int localId, Address[] addr,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"Address[] peerAddress) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"replication = addr.length;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ports = new ArrayList<");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t\t");
        _builder.append((Object)".");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)">(replication);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (int i=0; i<replication; ++i) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"ports.add(new ");
        _builder.append((Object)name, "\t\t\t");
        _builder.append((Object)"(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"actor, name+i, localId, i, addr[i], peerAddress[i]));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getReplication() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return replication;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public int getIndexOf(InterfaceItemBase ifitem){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return ifitem.getIdx();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)" get(int i) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ports.get(i);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (conj.booleanValue()) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            List _allIncomingMessages = this.stdExt.getAllIncomingMessages(pc);
            for (Message m_1 : _allIncomingMessages) {
                _builder.append((Object)"\t");
                StringConcatenation _messageSignature = this.messageSignature(m_1);
                _builder.append((Object)_messageSignature, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (int i=0; i<replication; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"ports.get(i).");
                StringConcatenation _messageCall = this.messageCall(m_1);
                _builder.append((Object)_messageCall, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allOutgoingMessages = this.stdExt.getAllOutgoingMessages(pc);
            for (Message m_2 : _allOutgoingMessages) {
                _builder.append((Object)"\t");
                StringConcatenation _messageSignature_1 = this.messageSignature(m_2);
                _builder.append((Object)_messageSignature_1, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"for (int i=0; i<replication; ++i) {");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"ports.get(i).");
                StringConcatenation _messageCall_1 = this.messageCall(m_2);
                _builder.append((Object)_messageCall_1, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// interface for port class");
        _builder.newLine();
        _builder.append((Object)"public interface I");
        _builder.append((Object)name, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        if (conj.booleanValue()) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            _builder.append((Object)"\t");
            List _allOutgoingMessages_1 = this.stdExt.getAllOutgoingMessages(pc);
            for (Message m_3 : _allOutgoingMessages_1) {
                _builder.append((Object)" ");
                StringConcatenation _messageSignature_2 = this.messageSignature(m_3);
                _builder.append((Object)_messageSignature_2, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"// incoming messages");
            _builder.newLine();
            _builder.append((Object)"\t");
            List _allIncomingMessages_1 = this.stdExt.getAllIncomingMessages(pc);
            for (Message m_4 : _allIncomingMessages_1) {
                _builder.append((Object)" ");
                StringConcatenation _messageSignature_3 = this.messageSignature(m_4);
                _builder.append((Object)_messageSignature_3, "\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public StringConcatenation messageSignature(Message m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" (");
        TypedID _data = m.getData();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_data, null);
        if (_operator_notEquals) {
            TypedID _data_1 = m.getData();
            Type _type = _data_1.getType();
            String _typeName = this.stdExt.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            TypedID _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public StringConcatenation messageCall(Message m) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        TypedID _data = m.getData();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_data, null);
        if (_operator_notEquals) {
            _builder.append((Object)" ");
            TypedID _data_1 = m.getData();
            String _name_1 = _data_1.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public StringConcatenation sendMessage(Message m, boolean conj) {
        MessageHandler _sendHandler;
        StringConcatenation _builder = new StringConcatenation();
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        _builder.newLineIfNotEmpty();
        MessageHandler hdlr = _sendHandler = this.stdExt.getSendHandler(m, conj);
        _builder.newLineIfNotEmpty();
        StringConcatenation _messageSignature = this.messageSignature(m);
        _builder.append((Object)_messageSignature, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)hdlr, null);
        if (_operator_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _detailCode = hdlr.getDetailCode();
            EList _commands = _detailCode.getCommands();
            for (String command : _commands) {
                _builder.append((Object)"\t");
                _builder.append((Object)command, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"if (messageStrings[ ");
            _builder.append((Object)dir, "\t");
            _builder.append((Object)"_");
            String _name = m.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)"] != \"timerTick\"){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// TODOTS: model switch for activation");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(), messageStrings[");
            _builder.append((Object)dir, "\t");
            _builder.append((Object)"_");
            String _name_1 = m.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)"]);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (getPeerAddress()!=null)");
            _builder.newLine();
            _builder.append((Object)"\t");
            TypedID _data = m.getData();
            boolean _operator_equals = ObjectExtensions.operator_equals((Object)_data, null);
            if (_operator_equals) {
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t");
                _builder.append((Object)"_");
                String _name_2 = m.getName();
                _builder.append((Object)_name_2, "\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
            } else {
                _builder.append((Object)"getPeerMsgReceiver().receive(new EventWithDataMessage(getPeerAddress(), ");
                _builder.append((Object)dir, "\t");
                _builder.append((Object)"_");
                String _name_3 = m.getName();
                _builder.append((Object)_name_3, "\t");
                _builder.append((Object)", ");
                TypedID _data_1 = m.getData();
                String _name_4 = _data_1.getName();
                _builder.append((Object)_name_4, "\t");
                boolean _operator_and = false;
                TypedID _data_2 = m.getData();
                Type _type = _data_2.getType();
                boolean _isRef = _type.isRef();
                boolean _operator_not = BooleanExtensions.operator_not((boolean)_isRef);
                if (!_operator_not) {
                    _operator_and = false;
                } else {
                    TypedID _data_3 = m.getData();
                    Type _type_1 = _data_3.getType();
                    DataClass _type_2 = _type_1.getType();
                    boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)_type_2, null);
                    _operator_and = BooleanExtensions.operator_and((boolean)_operator_not, (boolean)_operator_notEquals_1);
                }
                if (_operator_and) {
                    _builder.append((Object)".deepCopy()");
                }
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }
}

