/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Guard;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateMachine;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.generator.etricegen.ActiveTrigger;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.TransitionChain;
import org.eclipse.etrice.generator.extensions.RoomNameProv;
import org.eclipse.etrice.generator.java.gen.JavaGenerator;
import org.eclipse.etrice.generator.java.gen.StdExtensions;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtend2.lib.StringConcatenation;

public class StateMachineGen {
    @Inject
    private StdExtensions stdExt;
    @Inject
    private RoomNameProv nameProvider;
    @Inject
    private JavaGenerator javaGen;

    public StringConcatenation genStateMachine(ExpandedActorClass xpac, ActorClass ac) {
        EList _transitionChains_1;
        Transition _initTransition;
        EList _ownTriggers;
        int _operator_minus;
        EList _ownTransitionChains;
        List _baseStateList;
        int _numberOfInheritedBaseStates;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//******************************************");
        _builder.newLine();
        _builder.append((Object)"// START of generated code for FSM");
        _builder.newLine();
        _builder.append((Object)"//******************************************");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// State IDs for FSM");
        _builder.newLine();
        int offset = _numberOfInheritedBaseStates = this.stdExt.getNumberOfInheritedBaseStates(ac);
        _builder.newLineIfNotEmpty();
        StateMachine _stateMachine = ac.getStateMachine();
        List baseStates = _baseStateList = this.stdExt.getBaseStateList((StateGraph)_stateMachine);
        _builder.newLineIfNotEmpty();
        for (State state : baseStates) {
            _builder.append((Object)"protected static final int ");
            String _stateId = this.nameProvider.getStateId(state);
            _builder.append((Object)_stateId, "");
            _builder.append((Object)" = ");
            int _indexOf = baseStates.indexOf(state);
            int _operator_plus = IntegerExtensions.operator_plus((Integer)_indexOf, (Number)2);
            int _operator_plus_1 = IntegerExtensions.operator_plus((Integer)_operator_plus, (Number)offset);
            _builder.append((Object)_operator_plus_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"protected static final String stateStrings[] = {\"<no state>\",\"<top>\",");
        List _allBaseStates = this.stdExt.getAllBaseStates(ac);
        boolean hasAnyElements = false;
        for (Object state_1 : _allBaseStates) {
            if (!hasAnyElements) {
                hasAnyElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\"");
            String _statePathName = this.nameProvider.getStatePathName((State)state_1);
            _builder.append((Object)_statePathName, "\t");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
        }
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"// history");
        _builder.newLine();
        _builder.append((Object)"// TODOHRR: history defined in ActorClassBase, init in constructor");
        _builder.newLine();
        _builder.append((Object)"//\t\thistory = new int[5];");
        _builder.newLine();
        _builder.append((Object)"//\t\tfor (int i = 0; i < history.length; i++) {");
        _builder.newLine();
        _builder.append((Object)"//\t\t\thistory[i] = NO_STATE;");
        _builder.newLine();
        _builder.append((Object)"//\t\t}");
        _builder.newLine();
        _builder.append((Object)"protected int history[] = {NO_STATE,NO_STATE");
        List _allBaseStates_1 = this.stdExt.getAllBaseStates(ac);
        for (State state_2 : _allBaseStates_1) {
            _builder.append((Object)",NO_STATE");
        }
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList chains = _ownTransitionChains = xpac.getOwnTransitionChains();
        _builder.newLineIfNotEmpty();
        EList _transitionChains = xpac.getTransitionChains();
        int _size = _transitionChains.size();
        int _size_1 = chains.size();
        int offset_tc = _operator_minus = IntegerExtensions.operator_minus((Integer)_size, (Number)_size_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"// transition chains");
        _builder.newLine();
        for (TransitionChain tc : chains) {
            _builder.append((Object)"protected static final int ");
            String _chainId = this.nameProvider.getChainId(tc);
            _builder.append((Object)_chainId, "");
            _builder.append((Object)" = ");
            int _indexOf_1 = chains.indexOf(tc);
            int _operator_plus_2 = IntegerExtensions.operator_plus((Integer)_indexOf_1, (Number)1);
            int _operator_plus_3 = IntegerExtensions.operator_plus((Integer)_operator_plus_2, (Number)offset_tc);
            _builder.append((Object)_operator_plus_3, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        EList triggers = _ownTriggers = xpac.getOwnTriggers();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"// triggers for FSM");
        _builder.newLine();
        for (MessageFromIf mif : triggers) {
            _builder.append((Object)"protected static final int ");
            String _triggerCodeName = xpac.getTriggerCodeName(mif);
            _builder.append((Object)_triggerCodeName, "");
            _builder.append((Object)" = IFITEM_");
            InterfaceItem _from = mif.getFrom();
            String _name = _from.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" + EVT_SHIFT*");
            String _messageID = xpac.getMessageID(mif);
            _builder.append((Object)_messageID, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"// receiveEvent contains the main implementation of the FSM");
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public void receiveEvent(InterfaceItemBase ifitem, int evt, Object generic_data) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int trigger = ifitem.getLocalId() + EVT_SHIFT*evt;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int chain = NOT_CAUGHT;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int catching_state = NO_STATE;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"boolean is_handler = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"boolean skip_entry = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!handleSystemEvent(ifitem, evt, generic_data)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"switch (state) {");
        _builder.newLine();
        StateMachine _stateMachine_1 = xpac.getStateMachine();
        List _leafStateList = this.stdExt.getLeafStateList((StateGraph)_stateMachine_1);
        for (State state_3 : _leafStateList) {
            EList _activeTriggers;
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case ");
            String _stateId_1 = this.nameProvider.getStateId(state_3);
            _builder.append((Object)_stateId_1, "\t\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            EList atlist = _activeTriggers = xpac.getActiveTriggers(state_3);
            _builder.newLineIfNotEmpty();
            boolean _isEmpty = atlist.isEmpty();
            boolean _operator_not = BooleanExtensions.operator_not((boolean)_isEmpty);
            if (_operator_not) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"switch(trigger) {");
                _builder.newLine();
                for (ActiveTrigger at : atlist) {
                    boolean _hasGuard;
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"case ");
                    String _trigger = at.getTrigger();
                    String _triggerCodeName_1 = xpac.getTriggerCodeName(_trigger);
                    _builder.append((Object)_triggerCodeName_1, "\t\t\t\t");
                    _builder.append((Object)":");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    boolean needData = _hasGuard = this.stdExt.hasGuard(xpac, at);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    if (needData) {
                        _builder.append((Object)"{ ");
                        Message _msg = at.getMsg();
                        String _typedDataDefinition = this.stdExt.getTypedDataDefinition(_msg);
                        _builder.append((Object)_typedDataDefinition, "\t\t\t\t\t");
                    }
                    _builder.newLineIfNotEmpty();
                    EList _transitions = at.getTransitions();
                    boolean hasAnyElements_1 = false;
                    for (TriggeredTransition tt : _transitions) {
                        TransitionChain _chain;
                        if (!hasAnyElements_1) {
                            hasAnyElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t\t\t\t\t");
                        }
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        TransitionChain chain = _chain = xpac.getChain((Transition)tt);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        Transition _transition = chain.getTransition();
                        String _trigger_1 = at.getTrigger();
                        StringConcatenation _guard = this.guard(_transition, _trigger_1, xpac);
                        _builder.append((Object)_guard, "\t\t\t\t\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"chain = ");
                        String _chainId_1 = this.nameProvider.getChainId(chain);
                        _builder.append((Object)_chainId_1, "\t\t\t\t\t\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"catching_state = ");
                        String _contextId = this.stdExt.getContextId(chain);
                        _builder.append((Object)_contextId, "\t\t\t\t\t\t");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        boolean _isHandler = chain.isHandler();
                        if (_isHandler) {
                            _builder.append((Object)"is_handler = true;");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        boolean _isSkipEntry = chain.isSkipEntry();
                        if (_isSkipEntry) {
                            _builder.append((Object)"skip_entry = true;");
                        }
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    if (needData) {
                        _builder.append((Object)"}");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (chain != NOT_CAUGHT) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"exitTo(state, catching_state, is_handler);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int next = executeTransitionChain(chain, ifitem, generic_data);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"next = enterHistory(next, is_handler, skip_entry);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setState(next);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"private void setState(int new_state) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"DebuggingService.getInstance().addActorState(this,stateStrings[new_state]);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (stateStrings[new_state]!=\"Idle\") {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// TODOTS: model switch for activation");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(getInstancePath() + \" -> \" + stateStrings[new_state]);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.state = new_state;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"public void executeInitTransition() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        StateMachine _stateMachine_2 = xpac.getStateMachine();
        Transition initt = _initTransition = this.stdExt.getInitTransition((StateGraph)_stateMachine_2);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"int chain = ");
        TransitionChain _chain_1 = xpac.getChain(initt);
        String _chainId_2 = this.nameProvider.getChainId(_chain_1);
        _builder.append((Object)_chainId_2, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"int next = executeTransitionChain(chain, null, null);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"next = enterHistory(next, false, false);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"setState(next);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls exit codes while exiting from the current state to one of its");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* parent states while remembering the history");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param current - the current state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param to - the final parent state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param handler - entry and exit codes are called only if not handler (for handler TransitionPoints)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private void exitTo(int current, int to, boolean handler) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (current!=to) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"switch (current) {");
        _builder.newLine();
        StateMachine _stateMachine_3 = xpac.getStateMachine();
        List _baseStateList_1 = this.stdExt.getBaseStateList((StateGraph)_stateMachine_3);
        for (State state_4 : _baseStateList_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case ");
            String _stateId_2 = this.nameProvider.getStateId(state_4);
            _builder.append((Object)_stateId_2, "\t\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            boolean _hasExitCode = this.stdExt.hasExitCode(state_4);
            if (_hasExitCode) {
                _builder.append((Object)"if (!handler) ");
                String _exitCodeOperationName = this.nameProvider.getExitCodeOperationName(state_4);
                _builder.append((Object)_exitCodeOperationName, "\t\t\t\t");
                _builder.append((Object)"();");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"history[");
            String _parentStateId = this.nameProvider.getParentStateId(state_4);
            _builder.append((Object)_parentStateId, "\t\t\t\t");
            _builder.append((Object)"] = ");
            String _stateId_3 = this.nameProvider.getStateId(state_4);
            _builder.append((Object)_stateId_3, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"current = ");
            String _parentStateId_1 = this.nameProvider.getParentStateId(state_4);
            _builder.append((Object)_parentStateId_1, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* matching the trigger of this chain. The ID of the final state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param chain - the chain ID");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param generic_data - the generic data pointer");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the ID of the final state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private int executeTransitionChain(int chain, InterfaceItemBase ifitem, Object generic_data) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch (chain) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList allchains = _transitionChains_1 = xpac.getTransitionChains();
        _builder.newLineIfNotEmpty();
        for (TransitionChain tc_1 : allchains) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"case ");
            String _chainId_3 = this.nameProvider.getChainId(tc_1);
            _builder.append((Object)_chainId_3, "\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _executeChainCode = this.stdExt.getExecuteChainCode(xpac, tc_1);
            _builder.append((Object)_executeChainCode, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return NO_STATE;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param state - the state which is entered");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param handler - entry code is executed if not handler");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return - the ID of the final leaf state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"private int enterHistory(int state, boolean handler, boolean skip_entry) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (true) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"switch (state) {");
        _builder.newLine();
        StateMachine _stateMachine_4 = xpac.getStateMachine();
        List _baseStateList_2 = this.stdExt.getBaseStateList((StateGraph)_stateMachine_4);
        for (State state_5 : _baseStateList_2) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case ");
            String _stateId_4 = this.nameProvider.getStateId(state_5);
            _builder.append((Object)_stateId_4, "\t\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            boolean _hasEntryCode = this.stdExt.hasEntryCode(state_5);
            if (_hasEntryCode) {
                _builder.append((Object)"if (!(skip_entry || handler)) ");
                String _entryCodeOperationName = this.nameProvider.getEntryCodeOperationName(state_5);
                _builder.append((Object)_entryCodeOperationName, "\t\t\t\t");
                _builder.append((Object)"();");
            }
            _builder.newLineIfNotEmpty();
            boolean _isLeaf = this.stdExt.isLeaf(state_5);
            if (_isLeaf) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"// in leaf state: return state id");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                String _stateId_5 = this.nameProvider.getStateId(state_5);
                _builder.append((Object)_stateId_5, "\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"// state has a sub graph");
            _builder.newLine();
            StateGraph _subgraph = state_5.getSubgraph();
            boolean _hasInitTransition = this.stdExt.hasInitTransition(_subgraph);
            if (_hasInitTransition) {
                Transition _initTransition_1;
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"// with init transition");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"if (history[");
                String _stateId_6 = this.nameProvider.getStateId(state_5);
                _builder.append((Object)_stateId_6, "\t\t\t\t");
                _builder.append((Object)"]==NO_STATE) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                StateGraph _subgraph_1 = state_5.getSubgraph();
                Transition sub_initt = _initTransition_1 = this.stdExt.getInitTransition(_subgraph_1);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = executeTransitionChain(");
                TransitionChain _chain_2 = xpac.getChain(sub_initt);
                String _chainId_4 = this.nameProvider.getChainId(_chain_2);
                _builder.append((Object)_chainId_4, "\t\t\t\t\t");
                _builder.append((Object)", null, null);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"else {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = history[");
                String _stateId_7 = this.nameProvider.getStateId(state_5);
                _builder.append((Object)_stateId_7, "\t\t\t\t\t");
                _builder.append((Object)"];");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"// without init transition");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = history[");
                String _stateId_8 = this.nameProvider.getStateId(state_5);
                _builder.append((Object)_stateId_8, "\t\t\t\t");
                _builder.append((Object)"];");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"case STATE_TOP:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"state = history[STATE_TOP];");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"skip_entry = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true)");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"//*** Entry and Exit Codes");
        _builder.newLine();
        StateMachine _stateMachine_5 = xpac.getStateMachine();
        List _stateList = this.stdExt.getStateList((StateGraph)_stateMachine_5);
        for (State state_6 : _stateList) {
            boolean _hasExitCode_1;
            boolean _isOwnObject = xpac.isOwnObject((StateGraphItem)state_6);
            if (!_isOwnObject) continue;
            boolean _hasEntryCode_1 = this.stdExt.hasEntryCode(state_6);
            if (_hasEntryCode_1) {
                _builder.append((Object)"protected void ");
                String _entryCodeOperationName_1 = this.nameProvider.getEntryCodeOperationName(state_6);
                _builder.append((Object)_entryCodeOperationName_1, "");
                _builder.append((Object)"() {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String _entryCode = this.stdExt.getEntryCode(xpac, state_6);
                _builder.append((Object)_entryCode, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            }
            if (!(_hasExitCode_1 = this.stdExt.hasExitCode(state_6))) continue;
            _builder.append((Object)"protected void ");
            String _exitCodeOperationName_1 = this.nameProvider.getExitCodeOperationName(state_6);
            _builder.append((Object)_exitCodeOperationName_1, "");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _exitCode = this.stdExt.getExitCode(xpac, state_6);
            _builder.append((Object)_exitCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"//*** Action Codes");
        _builder.newLine();
        StateMachine _stateMachine_6 = xpac.getStateMachine();
        List _transitionList = this.stdExt.getTransitionList((StateGraph)_stateMachine_6);
        for (Transition tr : _transitionList) {
            boolean _operator_and = false;
            boolean _isOwnObject_1 = xpac.isOwnObject((StateGraphItem)tr);
            if (!_isOwnObject_1) {
                _operator_and = false;
            } else {
                boolean _hasActionCode = this.stdExt.hasActionCode(tr);
                _operator_and = BooleanExtensions.operator_and((boolean)_isOwnObject_1, (boolean)_hasActionCode);
            }
            if (!_operator_and) continue;
            _builder.append((Object)"protected void ");
            String _actionCodeOperationName = this.nameProvider.getActionCodeOperationName(tr);
            _builder.append((Object)_actionCodeOperationName, "");
            _builder.append((Object)"(");
            if (tr instanceof NonInitialTransition) {
                _builder.append((Object)"InterfaceItemBase ifitem");
                String _argumentList = this.javaGen.getArgumentList(xpac, tr);
                _builder.append((Object)_argumentList, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _actionCode = this.stdExt.getActionCode(xpac, tr);
            _builder.append((Object)_actionCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t ");
        _builder.newLine();
        _builder.append((Object)"//******************************************");
        _builder.newLine();
        _builder.append((Object)"// END of generated code for FSM");
        _builder.newLine();
        _builder.append((Object)"//******************************************");
        _builder.newLine();
        return _builder;
    }

    protected StringConcatenation _guard(TriggeredTransition tt, final String trigger, final ExpandedActorClass ac) {
        Trigger _findFirst;
        StringConcatenation _builder = new StringConcatenation();
        EList _triggers = tt.getTriggers();
        Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(Trigger e) {
                boolean _isMatching = ac.isMatching(e, trigger);
                return _isMatching;
            }
        };
        Trigger tr = _findFirst = (Trigger)IterableExtensions.findFirst((Iterable)_triggers, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        boolean _hasGuard = this.stdExt.hasGuard(tr);
        if (_hasGuard) {
            _builder.append((Object)"if (");
            Guard _guard = tr.getGuard();
            DetailCode _guard_1 = _guard.getGuard();
            String _code = ac.getCode(_guard_1);
            _builder.append((Object)_code, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected StringConcatenation _guard(Transition t, String trigger, ExpandedActorClass ac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* error */");
        _builder.newLine();
        return _builder;
    }

    public StringConcatenation guard(Transition tt, String trigger, ExpandedActorClass ac) {
        if (tt instanceof TriggeredTransition && trigger instanceof String && ac instanceof ExpandedActorClass) {
            return this._guard((TriggeredTransition)tt, trigger, ac);
        }
        if (tt instanceof Transition && trigger instanceof String && ac instanceof ExpandedActorClass) {
            return this._guard(tt, trigger, ac);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tt, trigger, ac).toString());
    }
}

