/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.etricegen.SubSystemInstance;
import org.eclipse.etrice.generator.java.gen.StdExtensions;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtend2.lib.StringConcatenation;

public class SubSystemRunnerGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    private StdExtensions stdExt;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance sc : _subSystemInstances) {
            SubSystemClass _subSystemClass = sc.getSubSystemClass();
            String _generationTargetPath = this.stdExt.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = sc.getSubSystemClass();
            String _path = this.stdExt.getPath((RoomClass)_subSystemClass_1);
            String _operator_plus = StringExtensions.operator_plus((String)_generationTargetPath, (Object)_path);
            this.fileAccess.setOutputPath(_operator_plus);
            String _name = sc.getName();
            String _operator_plus_1 = StringExtensions.operator_plus((String)_name, (Object)"Runner.java");
            SubSystemClass _subSystemClass_2 = sc.getSubSystemClass();
            StringConcatenation _generate = this.generate(root, sc, _subSystemClass_2);
            this.fileAccess.generateFile(_operator_plus_1, (CharSequence)_generate);
        }
    }

    public StringConcatenation generate(Root root, SubSystemInstance ssc, SubSystemClass cc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* this class contains the main function running component ");
        String _name = ssc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* it instantiates ");
        String _name_1 = ssc.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" and starts and ends the lifecycle");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        String _package = this.stdExt.getPackage((RoomClass)cc);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_2 = ssc.getName();
        String _operator_plus = StringExtensions.operator_plus((String)_name_2, (Object)"Runner");
        _builder.append((Object)_operator_plus, "");
        _builder.append((Object)" extends SubSystemRunnerBase {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static ");
        String _name_3 = ssc.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" main_component = new ");
        String _name_4 = ssc.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"(null, \"");
        String _name_5 = ssc.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* main function");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"* creates component and starts and stops the lifecycle");
        _builder.newLine();
        _builder.append((Object)"     ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void main(String[] args) {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"***   T H E   B E G I N   ***\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"main_component.init(); // lifecycle init");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"main_component.start(); // lifecycle start");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// application runs until quit ");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"waitForQuit();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// end the lifecycle");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"main_component.stop(); // lifecycle stop");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"main_component.destroy(); // lifecycle destroy");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"System.out.println(\"***   T H E   E N D   ***\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }
}

