/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.newwizard;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.core.ui.newwizard.ProjectCreator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EmptyProjectWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IPath projectLocation;
    protected IPath sourcePath;
    protected IPath sourceGenPath;
    protected IProject project;
    protected IProject runtimeProject;
    protected String initialProjectName;
    private String[] additionalLaunchConfigLines = new String[]{"<stringAttribute key=\"org.eclipse.debug.core.ATTR_REFRESH_SCOPE\" value=\"${workspace}\"/>"};

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setDefaultPageImageDescriptor(ProjectCreator.getImageDescriptor((String)"icons/NewETriceProjectWizban.gif"));
        this.setWindowTitle("New Empty eTrice Project");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.runtimeProject = workspace.getRoot().getProject("org.eclipse.etrice.runtime.java");
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    if (EmptyProjectWizard.this.runtimeProject == null || !EmptyProjectWizard.this.runtimeProject.exists()) {
                        this.setErrorMessage("the project 'org.eclipse.etrice.runtime.java' must be in the workspace");
                        return false;
                    }
                    IPath locationPath = this.getLocationPath();
                    EmptyProjectWizard.this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    IPath projectPath = this.getProjectHandle().getFullPath();
                    EmptyProjectWizard.this.sourcePath = projectPath.append("src");
                    EmptyProjectWizard.this.sourceGenPath = projectPath.append("src-gen");
                    return true;
                }
                return false;
            }
        };
        newProjectCreationPage.setInitialProjectName(this.initialProjectName);
        newProjectCreationPage.setTitle("Empty eTrice Project");
        newProjectCreationPage.setDescription("Create an empty Java project with eTrice dependencies");
        this.addPage((IWizardPage)newProjectCreationPage);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        URI modelProjectURI = EmptyProjectWizard.this.projectLocation == null ? null : URI.createFileURI((String)EmptyProjectWizard.this.projectLocation.toOSString());
                        EmptyProjectWizard.this.project = ProjectCreator.createETriceProject((IPath)new Path(EmptyProjectWizard.this.sourcePath.toString()), (IPath)new Path(EmptyProjectWizard.this.sourceGenPath.toString()), (URI)modelProjectURI, (IProject)EmptyProjectWizard.this.runtimeProject, (List)ProjectCreator.getCommonNatureIDs(), (List)ProjectCreator.getCommonBuilderIDs(), (Monitor)BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
                        String baseName = EmptyProjectWizard.this.sourcePath.segment(0);
                        ProjectCreator.findOrCreateContainer((IPath)new Path("/" + baseName + "/model"), (boolean)true, (IPath)EmptyProjectWizard.this.projectLocation, (IProgressMonitor)progressMonitor);
                        ProjectCreator.createModel((URI)URI.createPlatformResourceURI((String)("/" + baseName + "/model/" + baseName + ".room"), (boolean)true), (String)baseName);
                        ProjectCreator.createBuildProperties((URI)URI.createPlatformResourceURI((String)("/" + baseName + "/build.properties"), (boolean)true), (String)baseName);
                        ProjectCreator.createLaunchConfig((URI)URI.createPlatformResourceURI((String)("/" + baseName + "/gen_" + baseName + ".launch"), (boolean)true), (String)baseName, (String[])EmptyProjectWizard.this.additionalLaunchConfigLines);
                        ProjectCreator.findOrCreateContainer((IPath)new Path("/" + baseName + "/tmp/log"), (boolean)true, (IPath)EmptyProjectWizard.this.projectLocation, (IProgressMonitor)progressMonitor);
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (this.project != null && (activePart = (page = this.workbench.getActiveWorkbenchWindow().getActivePage()).getActivePart()) instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)this.project);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return true;
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }
}

