/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.java.gen

import java.util.List

import org.eclipse.xtext.generator.IFileSystemAccess
import org.eclipse.xtext.generator.JavaIoFileSystemAccess
import com.google.inject.Inject

import static extension org.eclipse.xtext.xtend2.lib.ResourceExtensions.*
import static extension org.eclipse.xtext.xtend2.lib.*

import org.eclipse.etrice.core.room.*
import org.eclipse.etrice.generator.etricegen.*

class ProcedureHelpers {

	@Inject extension StdExtensions stdExt

	def ActorClassPortIF(ActorClass ac) {'''
		IF ac.extPorts.size > 0implementsENDIF
		FOR ep : ac.extPortspublic ep.ifport.protocol.nameIF ep.ifport.conjugated==trueConjENDIFPort ep.ifport.name = null; 
		ENDFOR
	'''
	}
	
	def UserCode(DetailCode dc) {'''
		IF dc!=null
		//--------------------- begin user code
			FOR command : dc.commands	command
			ENDFOR//--------------------- end user code
		ENDIF
	'''
	}
	
	def Attributes(List<Attribute> attribs) {'''
		//--------------------- attributes
		FOR attribute : attribsIF attribute.size==0protected IF attribute.type.ext != nullattribute.type.extELSEattribute.type.typeName()ENDIF attribute.name;ELSEprotected attribute.type.typeName()[] attribute.nameIF attribute.defaultValueLiteral==null =new attribute.type.typeName()[attribute.size];ELSE = attribute.defaultValueLiteral;ENDIF
		ENDIF 
		ENDFOR
	'''
	}

	def AttributeSettersGetters(List<Attribute> attribs) {'''
		//--------------------- attribute setters and getters
		FOR attribute : attribspublic void setattribute.name.toFirstUpper() (IF attribute.type.ext != null attribute.type.extELSEattribute.type.typeName()ENDIFIF attribute.size!=0[]ENDIF attribute.name) {
			 this.attribute.name = attribute.name;
		}
		public IF attribute.type.ext != null attribute.type.extELSEattribute.type.typeName()ENDIFIF attribute.size!=0[]ENDIF getattribute.name.toFirstUpper() () {
			return attribute.name;
		}ENDFOR
	'''
	}

	def Operations(List<Operation> operations) {'''
		//--------------------- operations
		FOR operation : operationspublic IF operation.returntype==nullvoidELSEoperation.returntype.freeTypeName()ENDIF operation.name (FOR argument : operation.arguments SEPARATOR ", "argument.type.freeTypeName() argument.nameENDFOR){
			FOR command : operation.detailCode.commands	command
			ENDFOR
		}ENDFOR
		'''
	}
	
}