/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch.java;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class JavaGeneratorConfigTab
extends AbstractLaunchConfigurationTab {
    public static final String GEN_INSTANCE_DIAGRAM = "GenInstanceDiagram";
    public static final String GEN_MODEL_PATH = "GenModelPath";
    public static final String SAVE_GEN_MODEL = "SaveGenModel";
    public static final String LIB = "Lib";
    private Button libButton;
    private Button instanceDiagramButton;
    private Button saveGenModel;
    private Text genModelPath;
    private Button browsePath;

    public String getName() {
        return "Java Generator";
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        this.libButton = this.createCheckButton(mainComposite, "generate all classes as library");
        this.libButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.libButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaGeneratorConfigTab.this.setDirty(true);
                JavaGeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.saveGenModel = this.createCheckButton(mainComposite, "save generator model");
        this.saveGenModel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.saveGenModel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaGeneratorConfigTab.this.handleSaveGenModelSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JavaGeneratorConfigTab.this.handleSaveGenModelSelected();
            }
        });
        this.genModelPath = new Text(mainComposite, 2052);
        this.genModelPath.setLayoutData((Object)new GridData(768));
        this.genModelPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaGeneratorConfigTab.this.validate();
                JavaGeneratorConfigTab.this.setDirty(true);
                JavaGeneratorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browsePath = this.createPushButton(mainComposite, "Browse...", null);
        this.browsePath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaGeneratorConfigTab.this.handlePathButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JavaGeneratorConfigTab.this.handlePathButtonSelected();
            }
        });
        this.instanceDiagramButton = this.createCheckButton(mainComposite, "generate instance diagram");
        this.instanceDiagramButton.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
    }

    protected void handleSaveGenModelSelected() {
        boolean save = this.saveGenModel.getSelection();
        this.genModelPath.setEnabled(save);
        this.browsePath.setEnabled(save);
        this.validate();
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private void validate() {
        if (this.saveGenModel.getSelection() && this.genModelPath.getText().trim().isEmpty()) {
            this.setErrorMessage("generator model path must not be empty");
            return;
        }
        this.setErrorMessage(null);
    }

    protected void handlePathButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "select a container for the generator model");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String fname = path.toString();
            fname = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", fname);
            this.genModelPath.setText(fname);
            this.setErrorMessage(null);
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.libButton.setSelection(configuration.getAttribute(LIB, false));
            boolean save = configuration.getAttribute(SAVE_GEN_MODEL, false);
            this.saveGenModel.setSelection(save);
            this.genModelPath.setEnabled(save);
            this.browsePath.setEnabled(save);
            this.genModelPath.setText(configuration.getAttribute(GEN_MODEL_PATH, ""));
            this.instanceDiagramButton.setSelection(configuration.getAttribute(GEN_INSTANCE_DIAGRAM, false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(LIB, this.libButton.getSelection());
        configuration.setAttribute(SAVE_GEN_MODEL, this.saveGenModel.getSelection());
        configuration.setAttribute(GEN_MODEL_PATH, this.genModelPath.getText());
        configuration.setAttribute(GEN_INSTANCE_DIAGRAM, this.instanceDiagramButton.getSelection());
    }

    public boolean canSave() {
        if (this.saveGenModel.getSelection()) {
            return !this.genModelPath.getText().trim().isEmpty();
        }
        return true;
    }
}

