/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.RoomStandaloneSetup;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.SetupGenerator;
import org.eclipse.etrice.generator.base.ILineOutput;
import org.eclipse.etrice.generator.base.ILineOutputLogger;
import org.eclipse.etrice.generator.base.StdLineOutput;
import org.eclipse.etrice.generator.builder.GeneratorModelBuilder;
import org.eclipse.etrice.generator.etricegen.IDiagnostician;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractGenerator {
    protected static ILineOutput output = new StdLineOutput();
    @Inject
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected ILineOutputLogger logger;
    @Inject
    protected IDiagnostician diagnostician;
    @Inject
    protected JavaIoFileSystemAccess fileAccess;
    protected IResourceValidator validator;

    public static void setOutput(ILineOutput out) {
        if (out != null) {
            output = out;
        }
    }

    protected static void createAndRunGenerator(Module generatorModule, String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{generatorModule});
        AbstractGenerator generator = (AbstractGenerator)injector.getInstance(AbstractGenerator.class);
        generator.logger.setOutput(output);
        generator.runGenerator(args);
    }

    protected static String convertToURI(String uri) {
        if (uri.startsWith("file:")) {
            return uri.replace('\\', '/');
        }
        return "file://" + uri.replace('\\', '/');
    }

    protected void setupRoomModel() {
        Injector roomInjector = new RoomStandaloneSetup().createInjectorAndDoEMFRegistration();
        this.validator = (IResourceValidator)roomInjector.getInstance(IResourceValidator.class);
        SetupGenerator.doSetup();
    }

    protected Root createGeneratorModel(ResourceSet rs, boolean asLibrary, String genModelPath) {
        ArrayList<RoomModel> rml = new ArrayList<RoomModel>();
        for (Resource resource : rs.getResources()) {
            EList contents = resource.getContents();
            if (contents.isEmpty() || !(contents.get(0) instanceof RoomModel)) continue;
            rml.add((RoomModel)contents.get(0));
        }
        if (rml.isEmpty()) {
            this.logger.logError("no ROOM models found", null);
            this.logger.logError("-- terminating", null);
            return null;
        }
        this.logger.logInfo("-- creating generator model");
        GeneratorModelBuilder gmb = new GeneratorModelBuilder(this.logger, this.diagnostician);
        Root gmRoot = gmb.createGeneratorModel(rml, asLibrary);
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("validation failed during build of generator model");
            this.logger.logError("-- terminating", null);
            return null;
        }
        URI genModelURI = genModelPath != null ? URI.createURI((String)genModelPath) : URI.createFileURI((String)"tmp.rim");
        Resource genResource = rs.createResource(genModelURI);
        genResource.getContents().add((Object)gmRoot);
        if (genModelPath != null) {
            try {
                this.logger.logInfo("saving genmodel to " + genModelPath);
                genResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                this.logger.logError(e.getMessage(), null);
                this.logger.logError("-- terminating", null);
                return null;
            }
        }
        return gmRoot;
    }

    protected boolean validateModels(ResourceSet rs) {
        this.logger.logInfo("-- validating models");
        int errors = 0;
        int warnings = 0;
        for (Resource resource : rs.getResources()) {
            List list = this.validator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            if (list.isEmpty()) continue;
            for (Issue issue : list) {
                if (issue.getSeverity() == Severity.ERROR) {
                    ++errors;
                    this.logger.logError(issue.toString(), null);
                    continue;
                }
                ++warnings;
                this.logger.logInfo(issue.toString());
            }
        }
        this.logger.logInfo("validation finished with " + errors + " errors and " + warnings + " warnings");
        if (errors > 0) {
            this.logger.logError("-- terminating", null);
            return false;
        }
        return true;
    }

    protected boolean loadModels(List<String> uriList, ResourceSet rs) {
        this.logger.logInfo("-- reading models");
        boolean ok = true;
        for (String uriString : uriList) {
            this.logger.logInfo("Loading " + uriString);
            try {
                rs.getResource(URI.createURI((String)uriString), true);
            }
            catch (RuntimeException e) {
                ok = false;
                this.logger.logError("couldn't load '" + uriString + "'", null);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)rs);
        return ok;
    }

    protected abstract void runGenerator(String[] var1);
}

