/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class DetailCodeTranslator {
    private ActorClass ac;
    private ITranslationProvider provider;
    private HashMap<String, InterfaceItem> name2item;
    private HashMap<String, Attribute> name2attr;
    private HashMap<String, Operation> name2op;

    public DetailCodeTranslator(ActorClass ac, ITranslationProvider provider) {
        this.ac = ac;
        this.provider = provider;
        this.prepare();
    }

    public String translateDetailCode(DetailCode code) {
        if (code == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (String line : code.getCommands()) {
            text.append(String.valueOf(line) + "\n");
        }
        StringBuilder result = new StringBuilder();
        this.translateText(text.substring(0, text.length() - 1), result);
        return result.toString();
    }

    private void translateText(String text, StringBuilder result) {
        Position curr = new Position();
        int last = 0;
        while (curr.pos < text.length()) {
            this.proceedToToken(text, curr);
            last = this.appendParsed(text, curr, last, result);
            String token = this.getToken(text, curr);
            if (token.isEmpty()) {
                if (curr.pos < text.length() && !this.isTokenChar(text.charAt(curr.pos))) {
                    ++curr.pos;
                }
                last = this.appendParsed(text, curr, last, result);
                continue;
            }
            String translated = null;
            Attribute attribute = this.name2attr.get(token);
            if (attribute != null) {
                String orig = text.substring(last, curr.pos);
                translated = this.provider.getAttributeText(attribute, orig);
            } else {
                Operation operation = this.name2op.get(token);
                if (operation != null) {
                    ArrayList<String> args = this.getArgs(text, curr);
                    if (args != null && operation.getArguments().size() == args.size()) {
                        int i = 0;
                        while (i < args.size()) {
                            StringBuilder transArg = new StringBuilder();
                            this.translateText(args.remove(i), transArg);
                            args.add(i, transArg.toString());
                            ++i;
                        }
                        String orig = text.substring(last, curr.pos);
                        translated = this.provider.getOperationText(operation, args, orig);
                    }
                } else {
                    InterfaceItem item = this.name2item.get(token);
                    if (item != null) {
                        int start = curr.pos;
                        Message msg = this.getMessage(text, curr, item, true);
                        if (msg != null) {
                            ArrayList<String> args = this.getArgs(text, curr);
                            if (args != null && this.argsMatching(msg, args)) {
                                String orig = text.substring(last, curr.pos);
                                translated = this.provider.getInterfaceItemMessageText(item, msg, args, orig);
                            }
                        } else {
                            curr.pos = start;
                            msg = this.getMessage(text, curr, item, false);
                            if (msg != null && (curr.pos >= text.length() || text.charAt(curr.pos) != '(')) {
                                String orig = text.substring(last, curr.pos);
                                translated = this.provider.getInterfaceItemMessageValue(item, msg, orig);
                            }
                        }
                    }
                }
            }
            if (translated != null) {
                last = curr.pos;
                result.append(translated);
                continue;
            }
            last = this.appendParsed(text, curr, last, result);
        }
    }

    private int appendParsed(String text, Position curr, int last, StringBuilder result) {
        String str = text.substring(last, curr.pos);
        result.append(str);
        return curr.pos;
    }

    private boolean argsMatching(Message msg, ArrayList<String> args) {
        if (msg.getData() == null && args.isEmpty()) {
            return true;
        }
        return msg.getData() != null && args.size() == 1;
    }

    private void proceedToToken(String text, Position curr) {
        boolean stop = false;
        while (curr.pos < text.length() && !stop) {
            if (text.charAt(curr.pos) == '\"') {
                this.skipString(text, curr);
                continue;
            }
            if (text.charAt(curr.pos) == '/') {
                if (curr.pos + 1 < text.length()) {
                    if (text.charAt(curr.pos + 1) == '/') {
                        this.skipSingleComment(text, curr);
                        continue;
                    }
                    if (text.charAt(curr.pos + 1) == '*') {
                        this.skipMultiComment(text, curr);
                        continue;
                    }
                    stop = true;
                    continue;
                }
                stop = true;
                continue;
            }
            if (Character.isWhitespace(text.charAt(curr.pos))) {
                this.skipWhiteSpace(text, curr);
                continue;
            }
            stop = true;
        }
    }

    private Message getMessage(String text, Position curr, InterfaceItem item, boolean outgoing) {
        this.proceedToToken(text, curr);
        if (text.charAt(curr.pos) != '.') {
            return null;
        }
        ++curr.pos;
        this.proceedToToken(text, curr);
        String token = this.getToken(text, curr);
        List messages = RoomHelpers.getMessageList((InterfaceItem)item, (boolean)outgoing);
        for (Message message : messages) {
            if (!message.getName().equals(token)) continue;
            return message;
        }
        return null;
    }

    private ArrayList<String> getArgs(String text, Position curr) {
        this.proceedToToken(text, curr);
        if (text.charAt(curr.pos) != '(') {
            return null;
        }
        ++curr.pos;
        ArrayList<String> result = new ArrayList<String>();
        boolean stop = false;
        do {
            this.proceedToToken(text, curr);
            if (text.charAt(curr.pos) != ')') {
                String arg = this.getParam(text, curr);
                result.add(arg);
                this.proceedToToken(text, curr);
            }
            if (text.charAt(curr.pos) == ',') {
                ++curr.pos;
                continue;
            }
            stop = true;
        } while (!stop);
        if (text.charAt(curr.pos) != ')') {
            return null;
        }
        ++curr.pos;
        return result;
    }

    private String getToken(String text, Position curr) {
        int begin = curr.pos;
        while (curr.pos < text.length() && this.isTokenChar(text.charAt(curr.pos))) {
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos);
        return token;
    }

    private String getParam(String text, Position curr) {
        int begin = curr.pos;
        int parenthesisLevel = 0;
        while (curr.pos < text.length()) {
            if (text.charAt(curr.pos) == '(') {
                ++parenthesisLevel;
            } else if (text.charAt(curr.pos) == ')') {
                if (parenthesisLevel == 0) break;
                --parenthesisLevel;
            } else if (parenthesisLevel == 0 && text.charAt(curr.pos) == ',') break;
            ++curr.pos;
        }
        String token = text.substring(begin, curr.pos).trim();
        return token;
    }

    private void skipWhiteSpace(String text, Position curr) {
        while (curr.pos < text.length() && Character.isWhitespace(text.charAt(curr.pos))) {
            ++curr.pos;
        }
    }

    private void skipMultiComment(String text, Position curr) {
        curr.pos += 2;
        while (curr.pos < text.length() - 1 && text.charAt(curr.pos++) != '*') {
            if (text.charAt(curr.pos) == '/') break;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private void skipSingleComment(String text, Position curr) {
        while (curr.pos < text.length() && text.charAt(curr.pos) != '\n') {
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private void skipString(String text, Position curr) {
        while (++curr.pos < text.length() && text.charAt(curr.pos) != '\"') {
            if (text.charAt(curr.pos) != '\\') continue;
            ++curr.pos;
        }
        if (curr.pos < text.length()) {
            ++curr.pos;
        }
    }

    private boolean isTokenChar(char c) {
        return Character.isDigit(c) || Character.isLetter(c) || c == '_';
    }

    private void prepare() {
        this.name2item = new HashMap();
        List items = RoomHelpers.getAllInterfaceItems((ActorClass)this.ac);
        for (InterfaceItem item : items) {
            this.name2item.put(item.getName(), item);
        }
        this.name2attr = new HashMap();
        List attributes = RoomHelpers.getAllAttributes((ActorClass)this.ac);
        for (Attribute attribute : attributes) {
            this.name2attr.put(attribute.getName(), attribute);
        }
        this.name2op = new HashMap();
        List operations = RoomHelpers.getAllOperations((ActorClass)this.ac);
        for (Operation operation : operations) {
            this.name2op.put(operation.getName(), operation);
        }
    }

    public static interface ITranslationProvider {
        public String getAttributeText(Attribute var1, String var2);

        public String getOperationText(Operation var1, ArrayList<String> var2, String var3);

        public String getInterfaceItemMessageText(InterfaceItem var1, Message var2, ArrayList<String> var3, String var4);

        public String getInterfaceItemMessageValue(InterfaceItem var1, Message var2, String var3);
    }

    private static class Position {
        int pos = 0;

        private Position() {
        }
    }
}

