/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.generator.base.ILineOutputLogger;
import org.eclipse.etrice.generator.etricegen.IDiagnostician;

public class Diagnostician
implements IDiagnostician {
    private boolean validationFailed = false;
    @Inject
    private ILineOutputLogger logger;

    @Override
    public void warning(String msg, EObject source, EStructuralFeature feature) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature));
    }

    @Override
    public void warning(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.logger.logInfo("Validation warning: " + this.getMsgTxt(msg, source, feature) + " at index " + idx);
    }

    @Override
    public void error(String msg, EObject source, EStructuralFeature feature) {
        this.validationFailed = true;
        this.logger.logInfo("Validation error: " + this.getMsgTxt(msg, source, feature));
    }

    @Override
    public void error(String msg, EObject source, EStructuralFeature feature, int idx) {
        this.validationFailed = true;
        this.logger.logInfo("Validation error: " + this.getMsgTxt(msg, source, feature) + " at index " + idx);
    }

    @Override
    public boolean isFailed() {
        return this.validationFailed;
    }

    private String getMsgTxt(String msg, EObject source, EStructuralFeature feature) {
        return String.valueOf(msg) + " " + (source == null ? "" : source.toString()) + " " + (feature == null ? "" : feature.toString());
    }
}

