/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class FileSystemHelpers {
    public static URI getProjectURI(EObject obj) {
        return FileSystemHelpers.getMarkerFileURI(obj, ".project");
    }

    public static URI getMarkerFileURI(EObject obj, String markerFileName) {
        URI mainPath = null;
        if (obj != null && obj.eResource() != null) {
            mainPath = obj.eResource().getURI().trimSegments(1);
            File parent = null;
            if (mainPath.isPlatform()) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFolder file = workspaceRoot.getFolder((IPath)new Path(mainPath.toPlatformString(true)));
                String osString = file.getLocation().toOSString();
                parent = new File(osString);
            } else {
                parent = new File(mainPath.toFileString());
            }
            boolean isProject = false;
            int nUp = 0;
            while (!isProject && parent != null) {
                String[] contents = parent.list();
                int i = 0;
                while (i < contents.length) {
                    if (contents[i].equals(markerFileName)) {
                        isProject = true;
                        break;
                    }
                    ++i;
                }
                if (isProject) break;
                parent = parent.getParentFile();
                ++nUp;
            }
            if (isProject && nUp > 0) {
                mainPath = mainPath.trimSegments(nUp);
            }
        }
        return mainPath;
    }

    private static boolean bothNullOrEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String getRelativePath(String base, String path) {
        return FileSystemHelpers.getRelativePath(URI.createFileURI((String)base), URI.createFileURI((String)path), false);
    }

    public static String getRelativePath(String base, String path, boolean goUpIfNeeded) {
        return FileSystemHelpers.getRelativePath(URI.createFileURI((String)base), URI.createFileURI((String)path), goUpIfNeeded);
    }

    public static String getRelativePath(URI base, URI path) {
        return FileSystemHelpers.getRelativePath(base, path, false);
    }

    public static String getRelativePath(URI base, URI path, boolean goUpIfNeeded) {
        if (base == null || path == null) {
            return null;
        }
        if (!FileSystemHelpers.bothNullOrEqual(base.scheme(), path.scheme())) {
            return null;
        }
        if (!base.hasAbsolutePath()) {
            return null;
        }
        if (!path.hasAbsolutePath()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (goUpIfNeeded) {
            int max = base.segmentCount() < path.segmentCount() ? base.segmentCount() : path.segmentCount();
            int common = 0;
            while (common < max) {
                if (!base.segment(common).equals(path.segment(common))) break;
                ++common;
            }
            int i = common;
            while (i < base.segmentCount()) {
                result.append("../");
                ++i;
            }
            i = common;
            while (i < path.segmentCount()) {
                result.append(String.valueOf(path.segment(i)) + "/");
                ++i;
            }
            return result.substring(0, result.length() - 1);
        }
        if (path.segmentCount() < base.segmentCount()) {
            return null;
        }
        int i = 0;
        while (i < base.segmentCount()) {
            if (!base.segment(i).equals(path.segment(i))) {
                return null;
            }
            ++i;
        }
        i = base.segmentCount();
        while (i < path.segmentCount()) {
            result.append(String.valueOf(path.segment(i)) + "/");
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }
}

