/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.builder;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.generator.base.ILogger;
import org.eclipse.etrice.generator.etricegen.ActorInstance;
import org.eclipse.etrice.generator.etricegen.BindingInstance;
import org.eclipse.etrice.generator.etricegen.ConnectionInstance;
import org.eclipse.etrice.generator.etricegen.ETriceGenFactory;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.IDiagnostician;
import org.eclipse.etrice.generator.etricegen.InstanceBase;
import org.eclipse.etrice.generator.etricegen.PortInstance;
import org.eclipse.etrice.generator.etricegen.PortKind;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.etricegen.SAPInstance;
import org.eclipse.etrice.generator.etricegen.SPPInstance;
import org.eclipse.etrice.generator.etricegen.ServiceImplInstance;
import org.eclipse.etrice.generator.etricegen.StructureInstance;
import org.eclipse.etrice.generator.etricegen.SubSystemInstance;
import org.eclipse.etrice.generator.etricegen.impl.StructureInstanceImpl;

public class GeneratorModelBuilder {
    private static final int OBJ_ID_OFFSET = 100;
    private HashSet<Port> relayPorts = new HashSet();
    private LinkedList<InstanceBase> allObjects = new LinkedList();
    private ILogger logger;
    private IDiagnostician diagnostician;

    public GeneratorModelBuilder(ILogger logger, IDiagnostician diagnostician) {
        this.logger = logger;
        this.diagnostician = diagnostician;
    }

    public Root createGeneratorModel(List<RoomModel> models, boolean asLibrary) {
        Root root = ETriceGenFactory.eINSTANCE.createRoot();
        root.getModels().addAll(models);
        root.setLibrary(asLibrary);
        if (!root.isLibrary()) {
            this.determineRelayPorts(root);
            for (RoomModel mdl : models) {
                for (SubSystemClass comp : mdl.getSubSystemClasses()) {
                    root.getSubSystemInstances().add((Object)this.createSubSystemInstance(comp));
                }
            }
            this.connectPorts(root);
            this.checkPortMultiplicity(root);
            this.connectServices(root);
            this.setObjectIDs();
        }
        this.createExpandedActorClasses(root);
        return root;
    }

    private void connectServices(Root root) {
        this.createServiceMappings(root);
        this.bindSAPs(root);
    }

    private void createServiceMappings(Root root) {
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.createServiceMappings(comp);
        }
    }

    private void createServiceMappings(StructureInstance si) {
        for (ConnectionInstance ci : si.getConnections()) {
            if (ci.getFromSPP() == null) {
                this.addService(ci.getFromAI(), ci);
                continue;
            }
            if (!ci.getFromSPP().getIncoming().isEmpty()) continue;
            this.addService(si, ci);
        }
        for (ActorInstance child : si.getInstances()) {
            this.createServiceMappings(child);
        }
    }

    private void addService(StructureInstance si, ConnectionInstance ci) {
        assert (si instanceof StructureInstanceImpl) : "unknown implementation " + si.eClass().getName();
        StructureInstanceImpl sii = (StructureInstanceImpl)si;
        ProtocolClass pc = ci.getToSPP().getSpp().getProtocol();
        if (sii.protocol2service.get(pc) != null) {
            Object obj = null;
            obj = si instanceof ActorInstance ? ((ActorInstance)si).getActorClass() : (si instanceof SubSystemInstance ? ((SubSystemInstance)si).getSubSystemClass() : si);
            this.diagnostician.error("A service can only be offered once per actor instance, consider pushing one down to a contained actor!", (EObject)obj, (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs());
        } else if (ci.getFromSPP() != null && ci.getFromSPP().getSpp().getProtocol() != pc) {
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        } else {
            SPPInstance sppi;
            do {
                if ((sppi = ci.getToSPP()).getOutgoing() != null) continue;
                boolean found = false;
                if (sppi.eContainer() instanceof ActorInstance) {
                    ActorInstance implementor = (ActorInstance)sppi.eContainer();
                    for (ServiceImplInstance svc : implementor.getServices()) {
                        if (svc.getSvcImpl().getSpp() != sppi.getSpp()) continue;
                        found = true;
                        sii.protocol2service.put(pc, svc);
                    }
                } else assert (false);
                if (!found) {
                    ActorContainerClass acr = (ActorContainerClass)sppi.getSpp().eContainer();
                    int idx = acr.getIfSPPs().indexOf((Object)sppi.getSpp());
                    this.diagnostician.error("An SPP mus be connected by a layer connection or implemented by a ServiceImplementation!", (EObject)sppi.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs(), idx);
                }
                return;
            } while ((ci = sppi.getOutgoing()).getToSPP().getSpp().getProtocol() == pc);
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
            return;
        }
    }

    private void bindSAPs(Root root) {
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.bindSAPs(comp);
        }
    }

    private void bindSAPs(StructureInstance si) {
        for (SAPInstance sap : si.getSaps()) {
            this.bindSAP(si, sap);
        }
        for (ActorInstance child : si.getInstances()) {
            this.bindSAPs(child);
        }
    }

    private void bindSAP(StructureInstance si, SAPInstance sap) {
        assert (si instanceof StructureInstanceImpl);
        StructureInstanceImpl sii = (StructureInstanceImpl)si;
        do {
            ServiceImplInstance svc;
            if ((svc = sii.protocol2service.get(sap.getSap().getProtocol())) == null) continue;
            sap.getPeers().add((Object)svc);
            svc.getPeers().add((Object)sap);
            return;
        } while ((sii = sii.eContainer() instanceof StructureInstanceImpl ? (StructureInstanceImpl)sii.eContainer() : null) != null);
        ActorClass ac = (ActorClass)sap.getSap().eContainer();
        int idx = ac.getStrSAPs().indexOf((Object)sap.getSap());
        this.diagnostician.error("SAP not satisfied!", (EObject)ac, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_StrSAPs(), idx);
    }

    private void determineRelayPorts(Root root) {
        for (RoomModel model : root.getModels()) {
            for (ActorClass ac : model.getActorClasses()) {
                for (Port port : ac.getIfPorts()) {
                    boolean external = false;
                    for (ExternalPort ep : ac.getExtPorts()) {
                        if (ep.getIfport() != port) continue;
                        external = true;
                        break;
                    }
                    if (external) continue;
                    this.relayPorts.add(port);
                    int count = 0;
                    for (Binding b : ac.getBindings()) {
                        if (b.getEndpoint1().getPort() == port) {
                            ++count;
                        }
                        if (b.getEndpoint2().getPort() != port) continue;
                        ++count;
                    }
                    if (count <= true) continue;
                    int idx = ac.getIfPorts().indexOf((Object)port);
                    this.diagnostician.error("relay port is multiply connected inside its actor class", (EObject)port, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_IfPorts(), idx);
                }
            }
        }
    }

    private void setObjectIDs() {
        int counter = 0;
        for (InstanceBase obj : this.allObjects) {
            if (obj instanceof SubSystemInstance) {
                counter = 100;
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof ActorInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof PortInstance) {
                PortInstance pi = (PortInstance)obj;
                if (pi.getKind() == PortKind.RELAY) continue;
                int multiplicity = pi.getPort().getMultiplicity();
                if (multiplicity == -1) {
                    multiplicity = pi.getBindings().size();
                }
                pi.setObjId(counter);
                counter += multiplicity;
                continue;
            }
            if (obj instanceof SAPInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (!(obj instanceof ServiceImplInstance)) continue;
            ServiceImplInstance svc = (ServiceImplInstance)obj;
            svc.setObjId(counter);
            counter += svc.getPeers().size();
        }
    }

    private SubSystemInstance createSubSystemInstance(SubSystemClass comp) {
        this.logger.logInfo("GeneratorModelBuilder: creating component instance from " + comp.getName());
        SubSystemInstance instance = ETriceGenFactory.eINSTANCE.createSubSystemInstance();
        this.allObjects.add(instance);
        instance.setName(comp.getName());
        instance.setSubSystemClass(comp);
        for (ActorRef ar : comp.getActorRefs()) {
            instance.getInstances().add((Object)this.recursivelyCreateActorInstances(ar));
        }
        this.createBindingInstances(instance, (EList<Binding>)comp.getBindings());
        this.createConnectionInstances(instance, (EList<LayerConnection>)comp.getConnections());
        return instance;
    }

    private ActorInstance recursivelyCreateActorInstances(ActorRef aref) {
        this.logger.logInfo("GeneratorModelBuilder: creating actor instance " + aref.getName() + " from " + aref.getType().getName());
        ActorInstance ai = ETriceGenFactory.eINSTANCE.createActorInstance();
        this.allObjects.add(ai);
        ai.setName(aref.getName());
        ActorClass ac = aref.getType();
        ai.setActorClass(ac);
        LinkedList<ActorClass> classes = new LinkedList<ActorClass>();
        classes.addFirst(ac);
        while (ac.getBase() != null) {
            ac = ac.getBase();
            classes.addFirst(ac);
        }
        for (ActorClass acl : classes) {
            this.createPortInstances(ai, acl);
            this.createServiceRelatedInstances(ai, acl);
            for (ActorRef ar : acl.getActorRefs()) {
                ai.getInstances().add((Object)this.recursivelyCreateActorInstances(ar));
            }
        }
        for (ActorClass acl : classes) {
            this.createBindingInstances(ai, (EList<Binding>)acl.getBindings());
            this.createConnectionInstances(ai, (EList<LayerConnection>)acl.getConnections());
        }
        return ai;
    }

    private void createPortInstances(ActorInstance ai, ActorClass ac) {
        PortInstance pi;
        for (ExternalPort port : ac.getExtPorts()) {
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getIfport().getName());
            pi.setPort(port.getIfport());
            pi.setKind(PortKind.EXTERNAL);
            ai.getPorts().add((Object)pi);
        }
        for (ExternalPort port : ac.getIntPorts()) {
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getName());
            pi.setPort((Port)port);
            pi.setKind(PortKind.INTERNAL);
            ai.getPorts().add((Object)pi);
        }
        for (ExternalPort port : ac.getIfPorts()) {
            if (!this.relayPorts.contains(port)) continue;
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getName());
            pi.setPort((Port)port);
            pi.setKind(PortKind.RELAY);
            ai.getPorts().add((Object)pi);
        }
    }

    private void createServiceRelatedInstances(ActorInstance ai, ActorClass ac) {
        InstanceBase si;
        for (SAPRef sap : ac.getStrSAPs()) {
            si = ETriceGenFactory.eINSTANCE.createSAPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSap(sap);
            ai.getSaps().add((Object)si);
        }
        for (SAPRef sap : ac.getIfSPPs()) {
            si = ETriceGenFactory.eINSTANCE.createSPPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSpp((SPPRef)sap);
            ai.getSpps().add((Object)si);
        }
        for (ServiceImplementation svcimpl : ac.getServiceImplementations()) {
            ServiceImplInstance sii = ETriceGenFactory.eINSTANCE.createServiceImplInstance();
            this.allObjects.add(sii);
            sii.setName(svcimpl.getSpp().getName());
            sii.setSvcImpl(svcimpl);
            ai.getServices().add((Object)sii);
        }
    }

    private void createBindingInstances(StructureInstance ai, EList<Binding> bindings) {
        for (Binding bind : bindings) {
            BindingInstance bi = ETriceGenFactory.eINSTANCE.createBindingInstance();
            if (bind.getEndpoint1().getActorRef() == null && bind.getEndpoint2().getActorRef() != null) {
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint1()));
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint2()));
            } else if (bind.getEndpoint1().getActorRef() != null && bind.getEndpoint2().getActorRef() == null) {
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint2()));
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint1()));
            } else if (bind.getEndpoint1().getActorRef() != null && bind.getEndpoint2().getActorRef() != null) {
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint1()));
                bi.getPorts().add((Object)this.getPortInstance(ai, bind.getEndpoint2()));
            } else {
                int idx = bindings.indexOf((Object)bind);
                this.diagnostician.error("binding connects two ports of the same actor", (EObject)bind, (EStructuralFeature)RoomPackage.eINSTANCE.getStructureClass_Bindings(), idx);
            }
            ai.getBindings().add((Object)bi);
        }
    }

    private void createConnectionInstances(StructureInstance si, EList<LayerConnection> connections) {
        for (LayerConnection lc : connections) {
            ConnectionInstance ci = ETriceGenFactory.eINSTANCE.createConnectionInstance();
            ci.setConnection(lc);
            SAPoint from = lc.getFrom();
            if (from instanceof RefSAPoint) {
                if (((RefSAPoint)from).getRef() instanceof ActorRef) {
                    ActorInstance fromAI = this.getActorInstance(si, (ActorRef)((RefSAPoint)from).getRef());
                    ci.setFromAI(fromAI);
                } else {
                    System.err.println("error");
                }
            } else if (from instanceof RelaySAPoint) {
                SPPInstance sppi = this.getSPPInstance(si, null, ((RelaySAPoint)from).getRelay());
                if (sppi.getOutgoing() != null) {
                    ActorContainerClass acr = (ActorContainerClass)sppi.getSpp().eContainer();
                    int idx = acr.getIfSPPs().indexOf((Object)sppi.getSpp());
                    this.diagnostician.error("SPPRef has several outgoing layer connections!", (EObject)sppi.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs(), idx);
                }
                ci.setFromSPP(sppi);
            } else assert (false) : "unknown type of " + from.eClass().getName();
            SPPoint to = lc.getTo();
            SPPInstance sppi = this.getSPPInstance(si, to.getRef(), to.getService());
            ci.setToSPP(sppi);
            si.getConnections().add((Object)ci);
        }
    }

    private SPPInstance getSPPInstance(StructureInstance si, ActorContainerRef ar, SPPRef spp) {
        if (ar == null) {
            for (SPPInstance sppi : si.getSpps()) {
                if (sppi.getSpp() != spp) continue;
                return sppi;
            }
        } else if (ar instanceof ActorRef) {
            ActorInstance subai = this.getActorInstance(si, (ActorRef)ar);
            if (subai != null) {
                return this.getSPPInstance(subai, null, spp);
            }
        } else {
            boolean cfr_ignored_0 = ar instanceof SubSystemRef;
        }
        return null;
    }

    private ActorInstance getActorInstance(StructureInstance si, ActorRef ar) {
        for (ActorInstance subai : si.getInstances()) {
            if (!subai.getName().equals(ar.getName())) continue;
            return subai;
        }
        return null;
    }

    private PortInstance getPortInstance(StructureInstance si, BindingEndPoint be) {
        if (be.getActorRef() == null) {
            for (PortInstance pi : si.getPorts()) {
                if (pi.getPort() != be.getPort()) continue;
                if (pi.getKind() == PortKind.EXTERNAL) {
                    EReference feature = ((Binding)be.eContainer()).getEndpoint1() == be ? RoomPackage.eINSTANCE.getBinding_Endpoint1() : RoomPackage.eINSTANCE.getBinding_Endpoint2();
                    this.diagnostician.error("binding connects external end port to sub-actor interface", be.eContainer(), (EStructuralFeature)feature);
                }
                return pi;
            }
        } else {
            for (ActorInstance subai : si.getInstances()) {
                if (!subai.getName().equals(be.getActorRef().getName())) continue;
                for (PortInstance pi : subai.getPorts()) {
                    if (pi.getPort() != be.getPort()) continue;
                    if (pi.getKind() == PortKind.INTERNAL) {
                        EReference feature = ((Binding)be.eContainer()).getEndpoint1() == be ? RoomPackage.eINSTANCE.getBinding_Endpoint1() : RoomPackage.eINSTANCE.getBinding_Endpoint2();
                        this.diagnostician.error("binding connects to sub-actor internal end port", be.eContainer(), (EStructuralFeature)feature);
                    }
                    return pi;
                }
            }
        }
        return null;
    }

    private void connectPorts(Root root) {
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof ActorInstance)) continue;
            for (PortInstance pi : ((ActorInstance)obj).getPorts()) {
                if (pi.getKind() == PortKind.RELAY) continue;
                List<PortInstance> peers = this.getFinalPeers(pi, null);
                pi.getPeers().addAll(peers);
            }
        }
    }

    private List<PortInstance> getFinalPeers(PortInstance pi, BindingInstance from) {
        LinkedList<PortInstance> peers = new LinkedList<PortInstance>();
        for (BindingInstance bi : pi.getBindings()) {
            PortInstance end;
            if (bi == from || from != null && from.eContainer() == bi.eContainer()) continue;
            PortInstance portInstance = end = bi.getPorts().get(0) != pi ? (PortInstance)bi.getPorts().get(0) : (PortInstance)bi.getPorts().get(1);
            if (end.getKind() == PortKind.RELAY) {
                peers.addAll(this.getFinalPeers(end, bi));
                continue;
            }
            peers.add(end);
        }
        return peers;
    }

    private void checkPortMultiplicity(Root root) {
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof ActorInstance)) continue;
            ActorInstance ai = (ActorInstance)obj;
            for (PortInstance pi : ai.getPorts()) {
                if (pi.getKind() == PortKind.RELAY || pi.getBindings().size() <= pi.getPort().getMultiplicity() || pi.getPort().getMultiplicity() == -1) continue;
                EReference feature = null;
                int idx = -1;
                if (pi.getPort().eContainer() instanceof ActorClass) {
                    ActorClass ac = (ActorClass)pi.getPort().eContainer();
                    idx = ac.getIfPorts().indexOf((Object)pi.getPort());
                    if (idx >= 0) {
                        feature = RoomPackage.eINSTANCE.getActorClass_IfPorts();
                    } else {
                        feature = RoomPackage.eINSTANCE.getActorClass_IntPorts();
                        idx = ac.getIntPorts().indexOf((Object)pi.getPort());
                    }
                } else if (pi.getPort().eContainer() instanceof SubSystemClass) {
                    SubSystemClass ssc = (SubSystemClass)pi.getPort().eContainer();
                    feature = RoomPackage.eINSTANCE.getSubSystemClass_RelayPorts();
                    idx = ssc.getRelayPorts().indexOf((Object)pi.getPort());
                }
                this.diagnostician.error("number of peers " + pi.getBindings().size() + " of port " + pi.getName() + " exceeds multiplicity " + pi.getPort().getMultiplicity() + " in instance " + ai.getPath(), pi, (EStructuralFeature)feature, idx);
            }
        }
    }

    private void createExpandedActorClasses(Root root) {
        for (ActorClass ac : root.getUsedActorClasses()) {
            root.getXpActorClasses().add((Object)this.createExpandedActorClass(ac));
        }
    }

    private ExpandedActorClass createExpandedActorClass(ActorClass ac) {
        this.logger.logInfo("GeneratorModelBuilder: creating expanded actor class from " + ac.getName() + " of " + ((RoomModel)ac.eContainer()).getName());
        ExpandedActorClass xpac = ETriceGenFactory.eINSTANCE.createExpandedActorClass();
        xpac.setName(ac.getName());
        xpac.setActorClass(ac);
        xpac.setAbstract(ac.isAbstract());
        xpac.prepare(this.diagnostician);
        return xpac;
    }
}

