/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.etricegen.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.FreeTypedID;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TypedID;
import org.eclipse.etrice.generator.etricegen.ActorInstance;
import org.eclipse.etrice.generator.etricegen.ETriceGenPackage;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.Root;
import org.eclipse.etrice.generator.etricegen.SubSystemInstance;

public class RootImpl
extends EObjectImpl
implements Root {
    protected static final boolean LIBRARY_EDEFAULT = false;
    protected boolean library = false;
    protected EList<SubSystemInstance> subSystemInstances;
    protected EList<RoomModel> models;
    protected EList<ExpandedActorClass> xpActorClasses;
    private BasicEList<SubSystemClass> subSystemClasses = null;
    private HashMap<String, DataClass> name2dc = new HashMap();
    private BasicEList<DataClass> usedDataClasses = null;
    private BasicEList<ProtocolClass> usedProtocolClasses = null;
    private BasicEList<ActorClass> usedActorClasses = null;
    private BasicEList<RoomModel> usedRoomModels = null;

    protected RootImpl() {
    }

    protected EClass eStaticClass() {
        return ETriceGenPackage.Literals.ROOT;
    }

    @Override
    public EList<SubSystemInstance> getSubSystemInstances() {
        if (this.subSystemInstances == null) {
            this.subSystemInstances = new EObjectContainmentEList(SubSystemInstance.class, (InternalEObject)this, 1);
        }
        return this.subSystemInstances;
    }

    @Override
    public EList<RoomModel> getModels() {
        if (this.models == null) {
            this.models = new EObjectResolvingEList(RoomModel.class, (InternalEObject)this, 2);
        }
        return this.models;
    }

    @Override
    public EList<ExpandedActorClass> getXpActorClasses() {
        if (this.xpActorClasses == null) {
            this.xpActorClasses = new EObjectContainmentEList(ExpandedActorClass.class, (InternalEObject)this, 3);
        }
        return this.xpActorClasses;
    }

    @Override
    public EList<DataClass> getUsedDataClasses() {
        if (this.usedDataClasses == null) {
            this.computeUsedClasses();
        }
        return this.usedDataClasses;
    }

    @Override
    public EList<ProtocolClass> getUsedProtocolClasses() {
        if (this.usedProtocolClasses == null) {
            this.computeUsedClasses();
        }
        return this.usedProtocolClasses;
    }

    @Override
    public EList<ActorClass> getUsedActorClasses() {
        if (this.usedActorClasses == null) {
            this.computeUsedClasses();
        }
        return this.usedActorClasses;
    }

    @Override
    public EList<RoomModel> getUsedRoomModels() {
        if (this.usedRoomModels == null) {
            this.computeUsedClasses();
        }
        return this.usedRoomModels;
    }

    @Override
    public EList<SubSystemClass> getSubSystemClasses() {
        if (this.subSystemClasses == null) {
            this.collectSubSystems();
        }
        return this.subSystemClasses;
    }

    private void collectSubSystems() {
        this.subSystemClasses = new BasicEList();
        if (!this.getModels().isEmpty()) {
            for (RoomModel mdl : this.getModels()) {
                this.subSystemClasses.addAll((Collection)mdl.getSubSystemClasses());
            }
        }
    }

    @Override
    public boolean isLibrary() {
        return this.library;
    }

    @Override
    public void setLibrary(boolean newLibrary) {
        boolean oldLibrary = this.library;
        this.library = newLibrary;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldLibrary, this.library));
        }
    }

    @Override
    public EList<RoomModel> getReferencedModels(RoomClass cls) {
        if (cls instanceof ExpandedActorClass) {
            cls = ((ExpandedActorClass)cls).getActorClass();
        }
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        HashSet<RoomModel> models = new HashSet<RoomModel>();
        if (cls instanceof DataClass) {
            dataClasses.add((DataClass)cls);
        } else if (cls instanceof ProtocolClass) {
            protocolClasses.add((ProtocolClass)cls);
        } else if (cls instanceof ActorClass) {
            actorClasses.add((ActorClass)cls);
        } else if (cls instanceof SubSystemClass) {
            SubSystemClass cc = (SubSystemClass)cls;
            for (ActorRef ar : cc.getActorRefs()) {
                this.recursivelyAddReferencedClasses(ar.getType(), actorClasses);
            }
        }
        this.getReferencedClassesAndModels(dataClasses, protocolClasses, actorClasses, models);
        models.remove(cls.eContainer());
        BasicEList result = new BasicEList(models);
        RoomModelComparator comp = new RoomModelComparator();
        Collections.sort(result, comp);
        return result;
    }

    private void recursivelyAddReferencedClasses(ActorClass ac, HashSet<ActorClass> actorClasses) {
        actorClasses.add(ac);
        for (ActorRef ar : ac.getActorRefs()) {
            this.recursivelyAddReferencedClasses(ar.getType(), actorClasses);
        }
    }

    @Override
    public EList<ProtocolClass> getReferencedProtocols(ActorClass cls) {
        if (cls instanceof ExpandedActorClass) {
            cls = ((ExpandedActorClass)cls).getActorClass();
        }
        HashSet<DataClass> dataClasses = new HashSet<DataClass>();
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        HashSet<RoomModel> models = new HashSet<RoomModel>();
        actorClasses.add(cls);
        this.getReferencedClassesAndModels(dataClasses, protocolClasses, actorClasses, models);
        BasicEList result = new BasicEList(protocolClasses);
        RoomClassComparator comp = new RoomClassComparator();
        Collections.sort(result, comp);
        return result;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getSubSystemInstances()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getXpActorClasses()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isLibrary();
            }
            case 1: {
                return this.getSubSystemInstances();
            }
            case 2: {
                return this.getModels();
            }
            case 3: {
                return this.getXpActorClasses();
            }
            case 4: {
                return this.getUsedDataClasses();
            }
            case 5: {
                return this.getUsedProtocolClasses();
            }
            case 6: {
                return this.getUsedActorClasses();
            }
            case 7: {
                return this.getUsedRoomModels();
            }
            case 8: {
                return this.getSubSystemClasses();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLibrary((Boolean)newValue);
                return;
            }
            case 1: {
                this.getSubSystemInstances().clear();
                this.getSubSystemInstances().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getModels().clear();
                this.getModels().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getXpActorClasses().clear();
                this.getXpActorClasses().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getUsedDataClasses().clear();
                this.getUsedDataClasses().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getUsedProtocolClasses().clear();
                this.getUsedProtocolClasses().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getUsedActorClasses().clear();
                this.getUsedActorClasses().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getUsedRoomModels().clear();
                this.getUsedRoomModels().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getSubSystemClasses().clear();
                this.getSubSystemClasses().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLibrary(false);
                return;
            }
            case 1: {
                this.getSubSystemInstances().clear();
                return;
            }
            case 2: {
                this.getModels().clear();
                return;
            }
            case 3: {
                this.getXpActorClasses().clear();
                return;
            }
            case 4: {
                this.getUsedDataClasses().clear();
                return;
            }
            case 5: {
                this.getUsedProtocolClasses().clear();
                return;
            }
            case 6: {
                this.getUsedActorClasses().clear();
                return;
            }
            case 7: {
                this.getUsedRoomModels().clear();
                return;
            }
            case 8: {
                this.getSubSystemClasses().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.library;
            }
            case 1: {
                return this.subSystemInstances != null && !this.subSystemInstances.isEmpty();
            }
            case 2: {
                return this.models != null && !this.models.isEmpty();
            }
            case 3: {
                return this.xpActorClasses != null && !this.xpActorClasses.isEmpty();
            }
            case 4: {
                return !this.getUsedDataClasses().isEmpty();
            }
            case 5: {
                return !this.getUsedProtocolClasses().isEmpty();
            }
            case 6: {
                return !this.getUsedActorClasses().isEmpty();
            }
            case 7: {
                return !this.getUsedRoomModels().isEmpty();
            }
            case 8: {
                return !this.getSubSystemClasses().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (library: ");
        result.append(this.library);
        result.append(')');
        return result.toString();
    }

    private void computeUsedClasses() {
        if (this.isLibrary()) {
            this.usedDataClasses = new BasicEList();
            this.usedProtocolClasses = new BasicEList();
            this.usedActorClasses = new BasicEList();
            this.usedRoomModels = new BasicEList();
            this.subSystemClasses = new BasicEList();
            for (RoomModel mdl : this.getModels()) {
                this.usedDataClasses.addAll((Collection)mdl.getDataClasses());
                this.usedProtocolClasses.addAll((Collection)mdl.getProtocolClasses());
                this.usedActorClasses.addAll((Collection)mdl.getActorClasses());
                this.subSystemClasses.addAll((Collection)mdl.getSubSystemClasses());
                this.usedRoomModels.add((Object)mdl);
            }
        } else {
            for (RoomModel mdl : this.getModels()) {
                for (Iterator dc : mdl.getDataClasses()) {
                    this.name2dc.put(dc.getName(), (DataClass)dc);
                }
            }
            HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
            for (SubSystemInstance ci : this.getSubSystemInstances()) {
                TreeIterator it = ci.eAllContents();
                while (it.hasNext()) {
                    EObject obj = (EObject)it.next();
                    if (!(obj instanceof ActorInstance)) continue;
                    ActorClass ac = ((ActorInstance)obj).getActorClass();
                    actorClasses.add(ac);
                }
            }
            HashSet<DataClass> dataClasses = new HashSet<DataClass>();
            HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
            HashSet<RoomModel> models = new HashSet<RoomModel>();
            this.getReferencedClassesAndModels(dataClasses, protocolClasses, actorClasses, models);
            this.usedDataClasses = new BasicEList(dataClasses);
            this.usedProtocolClasses = new BasicEList(protocolClasses);
            this.usedActorClasses = new BasicEList(actorClasses);
            this.usedRoomModels = new BasicEList(models);
        }
    }

    private void getReferencedClassesAndModels(HashSet<DataClass> dataClasses, HashSet<ProtocolClass> protocolClasses, HashSet<ActorClass> actorClasses, HashSet<RoomModel> models) {
        LinkedList<ActorClass> tmpAc = new LinkedList<ActorClass>(actorClasses);
        for (ActorClass ac : tmpAc) {
            while (ac.getBase() != null) {
                ac = ac.getBase();
                actorClasses.add(ac);
            }
        }
        for (ActorClass ac : actorClasses) {
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)ac.getIfPorts());
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)ac.getIntPorts());
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)ac.getStrSAPs());
            for (Iterator<Object> ispp : ac.getServiceImplementations()) {
                protocolClasses.add(ispp.getSpp().getProtocol());
            }
            this.getInterfaceItemProtocolClasses(protocolClasses, (EList<? extends InterfaceItem>)ac.getIfSPPs());
            this.getAttributeDataClasses(dataClasses, (EList<Attribute>)ac.getAttributes());
            this.getOperationDataClasses(dataClasses, (EList<Operation>)ac.getOperations());
        }
        LinkedList<ProtocolClass> tmpPc = new LinkedList<ProtocolClass>(protocolClasses);
        for (ProtocolClass pc : tmpPc) {
            while (pc.getBase() != null) {
                pc = pc.getBase();
                protocolClasses.add(pc);
            }
        }
        for (ProtocolClass pc : protocolClasses) {
            for (Message m : pc.getIncomingMessages()) {
                this.getTypedIdDataClasses(dataClasses, m.getData());
            }
            for (Message m : pc.getOutgoingMessages()) {
                this.getTypedIdDataClasses(dataClasses, m.getData());
            }
        }
        boolean repeat = true;
        do {
            LinkedList<DataClass> tmpDc = new LinkedList<DataClass>(dataClasses);
            for (DataClass dc : tmpDc) {
                this.getAttributeDataClasses(dataClasses, (EList<Attribute>)dc.getAttributes());
                this.getOperationDataClasses(dataClasses, (EList<Operation>)dc.getOperations());
                while (dc.getBase() != null) {
                    dc = dc.getBase();
                    dataClasses.add(dc);
                }
            }
            if (tmpDc.size() != dataClasses.size()) continue;
            repeat = false;
        } while (repeat);
        for (DataClass dc : dataClasses) {
            models.add((RoomModel)dc.eContainer());
        }
        for (ProtocolClass pc : protocolClasses) {
            models.add((RoomModel)pc.eContainer());
        }
        for (ActorClass ac : actorClasses) {
            models.add((RoomModel)ac.eContainer());
        }
    }

    private void getInterfaceItemProtocolClasses(HashSet<ProtocolClass> protocolClasses, EList<? extends InterfaceItem> items) {
        for (InterfaceItem ii : items) {
            protocolClasses.add(ii.getProtocol());
        }
    }

    private void getOperationDataClasses(HashSet<DataClass> dataClasses, EList<Operation> operations) {
        for (Operation op : operations) {
            DataClass dc;
            if (op.getReturntype() != null && (dc = this.name2dc.get(op.getReturntype())) != null) {
                dataClasses.add(dc);
            }
            this.getFreeTypedIdDataClasses(dataClasses, (EList<FreeTypedID>)op.getArguments());
        }
    }

    private void getTypedIdDataClasses(HashSet<DataClass> dataClasses, TypedID data) {
        if (data != null && data.getType().getType() != null) {
            dataClasses.add(data.getType().getType());
        }
    }

    private void getFreeTypedIdDataClasses(HashSet<DataClass> dataClasses, EList<FreeTypedID> arguments) {
        for (FreeTypedID tid : arguments) {
            DataClass dc = this.name2dc.get(tid.getType());
            if (dc == null) continue;
            dataClasses.add(dc);
        }
    }

    private void getAttributeDataClasses(HashSet<DataClass> dataClasses, EList<Attribute> attributes) {
        for (Attribute attr : attributes) {
            if (attr.getType().getType() == null) continue;
            dataClasses.add(attr.getType().getType());
        }
    }

    private class RoomClassComparator
    implements Comparator<RoomClass> {
        private RoomClassComparator() {
        }

        @Override
        public int compare(RoomClass o1, RoomClass o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class RoomModelComparator
    implements Comparator<RoomModel> {
        private RoomModelComparator() {
        }

        @Override
        public int compare(RoomModel o1, RoomModel o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

