/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.etricegen.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.generator.etricegen.ETriceGenPackage;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.ITransitionChainVisitor;
import org.eclipse.etrice.generator.etricegen.TransitionChain;

public class TransitionChainImpl
extends EObjectImpl
implements TransitionChain {
    protected Transition transition;
    protected static final boolean SKIP_ENTRY_EDEFAULT = false;
    protected boolean skipEntry = false;

    protected TransitionChainImpl() {
    }

    protected EClass eStaticClass() {
        return ETriceGenPackage.Literals.TRANSITION_CHAIN;
    }

    @Override
    public Transition getTransition() {
        if (this.transition != null && this.transition.eIsProxy()) {
            InternalEObject oldTransition = (InternalEObject)this.transition;
            this.transition = (Transition)this.eResolveProxy(oldTransition);
            if (this.transition != oldTransition && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldTransition, (Object)this.transition));
            }
        }
        return this.transition;
    }

    public Transition basicGetTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(Transition newTransition) {
        Transition oldTransition = this.transition;
        this.transition = newTransition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldTransition, (Object)this.transition));
        }
    }

    @Override
    public boolean isSkipEntry() {
        return this.skipEntry;
    }

    @Override
    public void setSkipEntry(boolean newSkipEntry) {
        boolean oldSkipEntry = this.skipEntry;
        this.skipEntry = newSkipEntry;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldSkipEntry, this.skipEntry));
        }
    }

    @Override
    public State getStateContext() {
        if (this.getTransition().eContainer().eContainer() instanceof State) {
            return (State)this.getTransition().eContainer().eContainer();
        }
        return null;
    }

    @Override
    public boolean isHandler() {
        TrPoint tp;
        if (!(this.getTransition() instanceof TriggeredTransition)) {
            return false;
        }
        TriggeredTransition trans = (TriggeredTransition)this.getTransition();
        if (trans.getFrom() instanceof TrPointTerminal) {
            TrPoint tp2 = ((TrPointTerminal)trans.getFrom()).getTrPoint();
            if (tp2 instanceof TransitionPoint) {
                return ((TransitionPoint)tp2).isHandler();
            }
        } else if (trans.getFrom() instanceof SubStateTrPointTerminal && (tp = ((SubStateTrPointTerminal)trans.getFrom()).getTrPoint()) instanceof TransitionPoint) {
            return ((TransitionPoint)tp).isHandler();
        }
        return false;
    }

    @Override
    public String genExecuteChain(ITransitionChainVisitor tcv) {
        ExpandedActorClass ac = this.getExpandedActorClass();
        StringBuilder result = new StringBuilder();
        result.append(tcv.genTypedData());
        this.genChainCode(this.getTransition(), ac, tcv, result);
        return result.toString();
    }

    private void genChainCode(Transition tr, ExpandedActorClass ac, ITransitionChainVisitor tcv, StringBuilder result) {
        result.append(tcv.genActionOperationCall(tr));
        StateGraphNode node = ac.getNode(tr.getTo());
        EList<Transition> out = ac.getOutgoingTransitions(node);
        if (node instanceof ChoicePoint) {
            ContinuationTransition dflt = ac.getDefaultBranch(out);
            assert (dflt != null) : "ChoicePoint " + RoomNameProvider.getFullPath((StateGraphItem)node) + " has no default branch!";
            boolean isFirst = true;
            for (Transition cond : out) {
                if (cond == dflt) continue;
                assert (cond instanceof CPBranchTransition) : "The non default ChoicePoint branch " + RoomNameProvider.getFullPath((StateGraphItem)cond) + " must be of type CPBranchTransition!";
                result.append(tcv.genElseIfBranch((CPBranchTransition)cond, isFirst));
                isFirst = false;
                this.genChainCode(cond, ac, tcv, result);
            }
            result.append(tcv.genElseBranch(dflt));
            this.genChainCode((Transition)dflt, ac, tcv, result);
            result.append(tcv.genEndIf());
        } else if (node instanceof TrPoint) {
            if (node instanceof TransitionPoint) {
                if (node == ac.getNode(((NonInitialTransition)tr).getFrom())) {
                    result.append(tcv.genReturnState(this.getStateContext()));
                    return;
                }
            } else {
                assert (out.size() <= 1) : "TrPoint " + RoomNameProvider.getFullPath((StateGraphItem)node) + " is expected to have at most one outgoing transition!";
                if (out.size() == 1) {
                    State state;
                    State state2 = state = node.eContainer().eContainer() instanceof State ? (State)node.eContainer().eContainer() : null;
                    if (node instanceof EntryPoint) {
                        if (state != null && ac.isOwnObject((StateGraphItem)state) && state.getEntryCode() != null && !state.getEntryCode().getCommands().isEmpty()) {
                            result.append(tcv.genEntryOperationCall(state));
                        }
                    } else if (node instanceof ExitPoint) {
                        if (state != null && ac.isOwnObject((StateGraphItem)state) && state.getExitCode() != null && !state.getExitCode().getCommands().isEmpty()) {
                            result.append(tcv.genExitOperationCall(state));
                        }
                    } else assert (false) : "unexpected sub type";
                }
            }
            this.genChainCode((Transition)out.get(0), ac, tcv, result);
        } else {
            assert (node instanceof State) : "A transition target can be a ChoicePoint, a TrPoint or a State!";
            result.append(tcv.genReturnState((State)node));
        }
    }

    private ExpandedActorClass getExpandedActorClass() {
        Transition obj = this.getTransition();
        while (obj != null) {
            if (!((obj = obj.eContainer()) instanceof ExpandedActorClass)) continue;
            return (ExpandedActorClass)obj;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getTransition();
                }
                return this.basicGetTransition();
            }
            case 1: {
                return this.isSkipEntry();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setTransition((Transition)newValue);
                return;
            }
            case 1: {
                this.setSkipEntry((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setTransition(null);
                return;
            }
            case 1: {
                this.setSkipEntry(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.transition != null;
            }
            case 1: {
                return this.skipEntry;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (skipEntry: ");
        result.append(this.skipEntry);
        result.append(')');
        return result.toString();
    }
}

