/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.extensions;

import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.generator.etricegen.TransitionChain;

public class Extensions {
    public static String getActionCodeOperationName(Transition t) {
        return "action_" + RoomNameProvider.getFullPath((StateGraphItem)t);
    }

    public static String getEntryCodeOperationName(State s) {
        return "entry_" + Extensions.getStatePathName(s);
    }

    public static String getExitCodeOperationName(State s) {
        return "exit_" + Extensions.getStatePathName(s);
    }

    public static String getDoCodeOperationName(State s) {
        return "do_" + Extensions.getStatePathName(s);
    }

    public static String getChainId(TransitionChain tc) {
        return "CHAIN_" + RoomNameProvider.getFullPath((StateGraphItem)tc.getTransition());
    }

    public static boolean isTopLevel(StateGraphNode s) {
        return !(s.eContainer().eContainer() instanceof State);
    }

    public static State getParentState(StateGraphNode s) {
        if (Extensions.isTopLevel(s)) {
            return null;
        }
        return (State)s.eContainer().eContainer();
    }

    public static String getStatePathName(State s) {
        return RoomNameProvider.getFullPath((StateGraphItem)s);
    }

    public static String getStateId(State s) {
        if (s == null) {
            return "STATE_" + RoomNameProvider.getStateName((State)s);
        }
        return "STATE_" + RoomNameProvider.getFullPath((StateGraphItem)s);
    }

    public static String getParentStateId(State s) {
        return Extensions.getStateId(Extensions.getParentState((StateGraphNode)s));
    }
}

