/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.extensions;

import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.FreeType;
import org.eclipse.etrice.core.room.Guard;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateMachine;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.generator.etricegen.ActiveTrigger;
import org.eclipse.etrice.generator.etricegen.ExpandedActorClass;
import org.eclipse.etrice.generator.etricegen.TransitionChain;
import org.eclipse.etrice.generator.extensions.RoomNameProv;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.ComparableExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RoomExtensions {
    @Inject
    private RoomNameProv nameProvider;

    public <T> List<T> union(List<T> l1, List<T> l2) {
        ArrayList<T> _arrayList;
        ArrayList<T> ret = _arrayList = new ArrayList<T>();
        ret.addAll(l1);
        ret.addAll(l2);
        return ret;
    }

    public List<Port> punion(List<Port> in1, List<ExternalPort> in2) {
        ArrayList<Port> _arrayList;
        ArrayList<Port> ret = _arrayList = new ArrayList<Port>();
        for (ExternalPort ele : in2) {
            Port _ifport = ele.getIfport();
            ret.add(_ifport);
        }
        ret.addAll(in1);
        return ret;
    }

    public String getGenerationPathSegment() {
        return "/src-gen/";
    }

    public String getModelPath(EObject e) {
        Resource _eResource = e.eResource();
        Resource res = _eResource;
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)res, null);
        if (_operator_equals) {
            return "";
        }
        URI _uRI = res.getURI();
        String _fileString = _uRI.toFileString();
        return _fileString;
    }

    public String getProjectPath(EObject e) {
        boolean _operator_and;
        Boolean _xdowhileexpression;
        File _file;
        Resource _eResource = e.eResource();
        Resource res = _eResource;
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)res, null);
        if (_operator_equals) {
            return "";
        }
        File tmpf = _file = new File("");
        URI _uRI = res.getURI();
        String _fileString = _uRI.toFileString();
        File _file_1 = new File(_fileString);
        tmpf = _file_1;
        boolean _isFile = tmpf.isFile();
        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isFile);
        if (_operator_not) {
            return "";
        }
        boolean isProject = false;
        do {
            String[] _list;
            String[] contents;
            File _parentFile;
            tmpf = _parentFile = tmpf.getParentFile();
            String[] stringArray = contents = (_list = tmpf.list());
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                boolean _equals = f.equals(".project");
                if (_equals) {
                    isProject = true;
                }
                ++n2;
            }
            _operator_and = false;
            boolean _operator_not_1 = BooleanExtensions.operator_not((boolean)isProject);
            if (!_operator_not_1) {
                _operator_and = false;
                continue;
            }
            File _parentFile_1 = tmpf.getParentFile();
            boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_parentFile_1, null);
            _operator_and = BooleanExtensions.operator_and((boolean)_operator_not_1, (boolean)_operator_notEquals);
        } while ((_xdowhileexpression = Boolean.valueOf(_operator_and)).booleanValue());
        String _absolutePath = tmpf.getAbsolutePath();
        return _absolutePath;
    }

    public String getGenerationTargetPath(EObject e) {
        String _projectPath = this.getProjectPath(e);
        String _generationPathSegment = this.getGenerationPathSegment();
        String _operator_plus = StringExtensions.operator_plus((String)_projectPath, (Object)_generationPathSegment);
        return _operator_plus;
    }

    public List<Port> getEndPorts(ActorClass ac) {
        EList _intPorts = ac.getIntPorts();
        EList _extPorts = ac.getExtPorts();
        List<Port> _punion = this.punion((List<Port>)_intPorts, (List<ExternalPort>)_extPorts);
        return _punion;
    }

    public String getPathName(String path) {
        String _replaceAll = path.replaceAll("/", "_");
        return _replaceAll;
    }

    public String getPortClassName(ProtocolClass p, boolean conj) {
        String _operator_plus_1;
        String _operator_plus;
        String _name;
        String ret = _name = p.getName();
        ret = conj ? (_operator_plus = StringExtensions.operator_plus((String)ret, (Object)"ConjPort")) : (_operator_plus_1 = StringExtensions.operator_plus((String)ret, (Object)"Port"));
        return ret;
    }

    public String getPortClassName(Port p) {
        String _portClassName;
        ProtocolClass _protocol = p.getProtocol();
        boolean _isConjugated = p.isConjugated();
        String ret = _portClassName = this.getPortClassName(_protocol, _isConjugated);
        boolean _isReplicated = p.isReplicated();
        if (_isReplicated) {
            String _operator_plus;
            ret = _operator_plus = StringExtensions.operator_plus((String)ret, (Object)"Repl");
        }
        return ret;
    }

    public String getPortClassName(ExternalPort p) {
        Port _ifport = p.getIfport();
        String _portClassName = this.getPortClassName(_ifport);
        return _portClassName;
    }

    public String getPortClassName(SAPRef sap) {
        ProtocolClass _protocol = sap.getProtocol();
        String _portClassName = this.getPortClassName(_protocol, true);
        return _portClassName;
    }

    public String getPortClassName(ServiceImplementation svc) {
        SPPRef _spp = svc.getSpp();
        ProtocolClass _protocol = _spp.getProtocol();
        String _portClassName = this.getPortClassName(_protocol, false);
        String _operator_plus = StringExtensions.operator_plus((String)_portClassName, (Object)"Repl");
        return _operator_plus;
    }

    public List<Message> getAllIncomingMessages(ProtocolClass pc) {
        ProtocolClass _base = pc.getBase();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_base, null);
        if (_operator_notEquals) {
            ProtocolClass _base_1 = pc.getBase();
            List<Message> _allIncomingMessages = this.getAllIncomingMessages(_base_1);
            EList _incomingMessages = pc.getIncomingMessages();
            List<Message> _union = this.union((List)_allIncomingMessages, (List)_incomingMessages);
            return _union;
        }
        EList _incomingMessages_1 = pc.getIncomingMessages();
        return _incomingMessages_1;
    }

    public List<Message> getAllOutgoingMessages(ProtocolClass pc) {
        EList _outgoingMessages_1;
        EList _xifexpression = null;
        ProtocolClass _base = pc.getBase();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_base, null);
        if (_operator_notEquals) {
            ProtocolClass _base_1 = pc.getBase();
            List<Message> _allOutgoingMessages = this.getAllOutgoingMessages(_base_1);
            EList _outgoingMessages = pc.getOutgoingMessages();
            List<Message> _union = this.union((List)_allOutgoingMessages, (List)_outgoingMessages);
            return _union;
        }
        _xifexpression = _outgoingMessages_1 = pc.getOutgoingMessages();
        return _xifexpression;
    }

    public List<Message> getIncoming(ProtocolClass pc, boolean conj) {
        if (conj) {
            List<Message> _allOutgoingMessages = this.getAllOutgoingMessages(pc);
            return _allOutgoingMessages;
        }
        List<Message> _allIncomingMessages = this.getAllIncomingMessages(pc);
        return _allIncomingMessages;
    }

    public List<Message> getOutgoing(ProtocolClass pc, boolean conj) {
        if (conj) {
            List<Message> _allIncomingMessages = this.getAllIncomingMessages(pc);
            return _allIncomingMessages;
        }
        List<Message> _allOutgoingMessages = this.getAllOutgoingMessages(pc);
        return _allOutgoingMessages;
    }

    public PortClass getPortClass(ProtocolClass pc, boolean conj) {
        if (conj) {
            PortClass _conjugate = pc.getConjugate();
            return _conjugate;
        }
        PortClass _regular = pc.getRegular();
        return _regular;
    }

    public boolean handlesSend(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_portClass, null);
        if (_operator_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _outgoing = this.getOutgoing(pc, conj);
            boolean _contains = _outgoing.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public boolean handlesReceive(ProtocolClass pc, boolean conj) {
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_portClass, null);
        if (_operator_equals) {
            return false;
        }
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _incoming = this.getIncoming(pc, conj);
            boolean _contains = _incoming.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            return true;
        }
        return false;
    }

    public List<MessageHandler> getReceiveHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_portClass, null);
        if (_operator_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _incoming = this.getIncoming(pc, conj);
            boolean _contains = _incoming.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public List<MessageHandler> getSendHandlers(ProtocolClass pc, boolean conj) {
        ArrayList<MessageHandler> _arrayList_1;
        PortClass _portClass = this.getPortClass(pc, conj);
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_portClass, null);
        if (_operator_equals) {
            ArrayList<MessageHandler> _arrayList = new ArrayList<MessageHandler>();
            return _arrayList;
        }
        ArrayList<MessageHandler> res = _arrayList_1 = new ArrayList<MessageHandler>();
        PortClass _portClass_1 = this.getPortClass(pc, conj);
        EList _msgHandlers = _portClass_1.getMsgHandlers();
        for (MessageHandler hdlr : _msgHandlers) {
            Message _msg;
            List<Message> _outgoing = this.getOutgoing(pc, conj);
            boolean _contains = _outgoing.contains(_msg = hdlr.getMsg());
            if (!_contains) continue;
            res.add(hdlr);
        }
        return res;
    }

    public MessageHandler getSendHandler(final Message m, boolean conj) {
        EObject _eContainer = m.eContainer();
        List<MessageHandler> _sendHandlers = this.getSendHandlers((ProtocolClass)_eContainer, conj);
        Functions.Function1<MessageHandler, Boolean> _function = new Functions.Function1<MessageHandler, Boolean>(){

            public Boolean apply(MessageHandler e) {
                Message _msg = e.getMsg();
                boolean _operator_equals = ObjectExtensions.operator_equals((Object)_msg, (Object)m);
                return _operator_equals;
            }
        };
        MessageHandler _findFirst = (MessageHandler)IterableExtensions.findFirst(_sendHandlers, (Functions.Function1)_function);
        return _findFirst;
    }

    public boolean isIncoming(Message m) {
        EObject _eContainer = m.eContainer();
        List<Message> _allIncomingMessages = this.getAllIncomingMessages((ProtocolClass)_eContainer);
        boolean _contains = _allIncomingMessages.contains(m);
        return _contains;
    }

    public String getCodeName(Message m) {
        boolean _isIncoming = this.isIncoming(m);
        if (_isIncoming) {
            String _name = m.getName();
            String _operator_plus = StringExtensions.operator_plus((String)"IN_", (Object)_name);
            return _operator_plus;
        }
        String _name_1 = m.getName();
        String _operator_plus_1 = StringExtensions.operator_plus((String)"OUT_", (Object)_name_1);
        return _operator_plus_1;
    }

    public boolean isLeaf(State s) {
        StateGraph _subgraph = s.getSubgraph();
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_subgraph, null);
        return _operator_equals;
    }

    public List<State> getLeafStateList(StateGraph sg) {
        ArrayList<State> _arrayList;
        ArrayList<State> res = _arrayList = new ArrayList<State>();
        EList _states = sg.getStates();
        for (State s : _states) {
            List<State> _leafStateList = this.getLeafStateList(s);
            res.addAll(_leafStateList);
        }
        return res;
    }

    public List<State> getLeafStateList(State s) {
        boolean _isLeaf = this.isLeaf(s);
        if (_isLeaf) {
            ArrayList<State> _arrayList;
            ArrayList<State> res = _arrayList = new ArrayList<State>();
            res.add(s);
            return res;
        }
        StateGraph _subgraph = s.getSubgraph();
        List<State> _leafStateList = this.getLeafStateList(_subgraph);
        return _leafStateList;
    }

    public List<State> getStateList(StateGraph sg) {
        ArrayList<State> _arrayList;
        ArrayList<State> ret = _arrayList = new ArrayList<State>();
        EList _states = sg.getStates();
        for (State e : _states) {
            StateGraph _subgraph;
            ret.add(e);
            StateGraph tmp = _subgraph = e.getSubgraph();
            boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)tmp, null);
            if (!_operator_notEquals) continue;
            StateGraph _subgraph_1 = e.getSubgraph();
            List<State> _stateList = this.getStateList(_subgraph_1);
            ret.addAll(_stateList);
        }
        return ret;
    }

    public List<State> getBaseStateList(StateGraph sg) {
        ArrayList<State> _arrayList;
        ArrayList<State> ret = _arrayList = new ArrayList<State>();
        List<State> _stateList = this.getStateList(sg);
        for (State e : _stateList) {
            if (!(e instanceof BaseState)) continue;
            ret.add(e);
        }
        return ret;
    }

    public List<State> getAllBaseStates(ActorClass ac) {
        List<State> _union;
        List<State> _xifexpression = null;
        ActorClass _base = ac.getBase();
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_base, null);
        if (_operator_equals) {
            StateMachine _stateMachine = ac.getStateMachine();
            List<State> _baseStateList = this.getBaseStateList((StateGraph)_stateMachine);
            return _baseStateList;
        }
        ActorClass _base_1 = ac.getBase();
        List<State> _allBaseStates = this.getAllBaseStates(_base_1);
        StateMachine _stateMachine_1 = ac.getStateMachine();
        List<State> _baseStateList_1 = this.getBaseStateList((StateGraph)_stateMachine_1);
        _xifexpression = _union = this.union(_allBaseStates, _baseStateList_1);
        return _xifexpression;
    }

    public boolean overridesStop(ActorClass ac) {
        Functions.Function1<Operation, Boolean> _function;
        boolean _operator_or = false;
        EList _operations = ac.getOperations();
        boolean _exists = IterableExtensions.exists((Iterable)_operations, (Functions.Function1)(_function = new Functions.Function1<Operation, Boolean>(){

            public Boolean apply(Operation e) {
                boolean _operator_and = false;
                boolean _operator_and_1 = false;
                String _name = e.getName();
                boolean _operator_equals = ObjectExtensions.operator_equals((Object)_name, (Object)"stop");
                if (!_operator_equals) {
                    _operator_and_1 = false;
                } else {
                    EList _arguments = e.getArguments();
                    boolean _isEmpty = _arguments.isEmpty();
                    _operator_and_1 = BooleanExtensions.operator_and((boolean)_operator_equals, (boolean)_isEmpty);
                }
                if (!_operator_and_1) {
                    _operator_and = false;
                } else {
                    FreeType _returntype = e.getReturntype();
                    boolean _operator_equals_1 = ObjectExtensions.operator_equals((Object)_returntype, null);
                    _operator_and = BooleanExtensions.operator_and((boolean)_operator_and_1, (boolean)_operator_equals_1);
                }
                return _operator_and;
            }
        }));
        if (_exists) {
            _operator_or = true;
        } else {
            boolean _operator_and_2 = false;
            ActorClass _base = ac.getBase();
            boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_base, null);
            if (!_operator_notEquals) {
                _operator_and_2 = false;
            } else {
                ActorClass _base_1 = ac.getBase();
                boolean _overridesStop = this.overridesStop(_base_1);
                _operator_and_2 = BooleanExtensions.operator_and((boolean)_operator_notEquals, (boolean)_overridesStop);
            }
            _operator_or = BooleanExtensions.operator_or((boolean)_exists, (boolean)_operator_and_2);
        }
        return _operator_or;
    }

    public int getNumberOfInheritedStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_base, null);
        if (_operator_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateMachine _stateMachine = _base_1.getStateMachine();
        List<State> _stateList = this.getStateList((StateGraph)_stateMachine);
        int _size = _stateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedStates = this.getNumberOfInheritedStates(_base_2);
        int _operator_plus = IntegerExtensions.operator_plus((Integer)_size, (Number)_numberOfInheritedStates);
        return _operator_plus;
    }

    public int getNumberOfInheritedBaseStates(ActorClass ac) {
        ActorClass _base = ac.getBase();
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_base, null);
        if (_operator_equals) {
            return 0;
        }
        ActorClass _base_1 = ac.getBase();
        StateMachine _stateMachine = _base_1.getStateMachine();
        List<State> _baseStateList = this.getBaseStateList((StateGraph)_stateMachine);
        int _size = _baseStateList.size();
        ActorClass _base_2 = ac.getBase();
        int _numberOfInheritedBaseStates = this.getNumberOfInheritedBaseStates(_base_2);
        int _operator_plus = IntegerExtensions.operator_plus((Integer)_size, (Number)_numberOfInheritedBaseStates);
        return _operator_plus;
    }

    public String getStateId(State s) {
        String _stateId = this.nameProvider.getStateId(s);
        return _stateId;
    }

    public String getStatePathName(State s) {
        String _statePathName = this.nameProvider.getStatePathName(s);
        return _statePathName;
    }

    public String getChainId(TransitionChain t) {
        String _chainId = this.nameProvider.getChainId(t);
        return _chainId;
    }

    public boolean hasGuard(Trigger tr) {
        boolean _operator_and = false;
        boolean _operator_and_1 = false;
        Guard _guard = tr.getGuard();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_guard, null);
        if (!_operator_notEquals) {
            _operator_and_1 = false;
        } else {
            Guard _guard_1 = tr.getGuard();
            DetailCode _guard_2 = _guard_1.getGuard();
            boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)_guard_2, null);
            _operator_and_1 = BooleanExtensions.operator_and((boolean)_operator_notEquals, (boolean)_operator_notEquals_1);
        }
        if (!_operator_and_1) {
            _operator_and = false;
        } else {
            Guard _guard_3 = tr.getGuard();
            DetailCode _guard_4 = _guard_3.getGuard();
            EList _commands = _guard_4.getCommands();
            int _size = _commands.size();
            boolean _operator_greaterThan = ComparableExtensions.operator_greaterThan((Comparable)Integer.valueOf(_size), (Object)0);
            _operator_and = BooleanExtensions.operator_and((boolean)_operator_and_1, (boolean)_operator_greaterThan);
        }
        return _operator_and;
    }

    public boolean hasGuard(final ExpandedActorClass ac, final ActiveTrigger at) {
        boolean hasGuard = false;
        EList<TriggeredTransition> _transitions = at.getTransitions();
        for (TriggeredTransition t : _transitions) {
            Functions.Function1<Trigger, Boolean> _function;
            EList _triggers = t.getTriggers();
            boolean _exists = IterableExtensions.exists((Iterable)_triggers, (Functions.Function1)(_function = new Functions.Function1<Trigger, Boolean>(){

                public Boolean apply(Trigger e) {
                    boolean _operator_and = false;
                    String _trigger = at.getTrigger();
                    boolean _isMatching = ac.isMatching(e, _trigger);
                    if (!_isMatching) {
                        _operator_and = false;
                    } else {
                        boolean _hasGuard = RoomExtensions.this.hasGuard(e);
                        _operator_and = BooleanExtensions.operator_and((boolean)_isMatching, (boolean)_hasGuard);
                    }
                    return _operator_and;
                }
            }));
            if (!_exists) continue;
            hasGuard = true;
        }
        return hasGuard;
    }

    public boolean hasEntryCode(State s) {
        boolean _operator_and = false;
        DetailCode _entryCode = s.getEntryCode();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_entryCode, null);
        if (!_operator_notEquals) {
            _operator_and = false;
        } else {
            DetailCode _entryCode_1 = s.getEntryCode();
            EList _commands = _entryCode_1.getCommands();
            int _size = _commands.size();
            boolean _operator_greaterThan = ComparableExtensions.operator_greaterThan((Comparable)Integer.valueOf(_size), (Object)0);
            _operator_and = BooleanExtensions.operator_and((boolean)_operator_notEquals, (boolean)_operator_greaterThan);
        }
        return _operator_and;
    }

    public boolean hasExitCode(State s) {
        boolean _operator_and = false;
        DetailCode _exitCode = s.getExitCode();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_exitCode, null);
        if (!_operator_notEquals) {
            _operator_and = false;
        } else {
            DetailCode _exitCode_1 = s.getExitCode();
            EList _commands = _exitCode_1.getCommands();
            int _size = _commands.size();
            boolean _operator_greaterThan = ComparableExtensions.operator_greaterThan((Comparable)Integer.valueOf(_size), (Object)0);
            _operator_and = BooleanExtensions.operator_and((boolean)_operator_notEquals, (boolean)_operator_greaterThan);
        }
        return _operator_and;
    }

    public String getEntryCode(ExpandedActorClass ac, State s) {
        if (s instanceof RefinedState) {
            String _entryCodeOperationName = this.nameProvider.getEntryCodeOperationName(s);
            String _operator_plus = StringExtensions.operator_plus((String)"super.", (Object)_entryCodeOperationName);
            String _operator_plus_1 = StringExtensions.operator_plus((String)_operator_plus, (Object)"();\n");
            DetailCode _entryCode = s.getEntryCode();
            String _code = ac.getCode(_entryCode);
            String _operator_plus_2 = StringExtensions.operator_plus((String)_operator_plus_1, (Object)_code);
            return _operator_plus_2;
        }
        DetailCode _entryCode_1 = s.getEntryCode();
        String _code_1 = ac.getCode(_entryCode_1);
        return _code_1;
    }

    public String getExitCode(ExpandedActorClass ac, State s) {
        String _code_1;
        String _xifexpression = null;
        if (s instanceof RefinedState) {
            DetailCode _exitCode = s.getExitCode();
            String _code = ac.getCode(_exitCode);
            String _operator_plus = StringExtensions.operator_plus((String)_code, (Object)"super.");
            String _entryCodeOperationName = this.nameProvider.getEntryCodeOperationName(s);
            String _operator_plus_1 = StringExtensions.operator_plus((String)_operator_plus, (Object)_entryCodeOperationName);
            String _operator_plus_2 = StringExtensions.operator_plus((String)_operator_plus_1, (Object)"();\n");
            return _operator_plus_2;
        }
        DetailCode _exitCode_1 = s.getExitCode();
        _xifexpression = _code_1 = ac.getCode(_exitCode_1);
        return _xifexpression;
    }

    public boolean hasActionCode(Transition t) {
        boolean _operator_and = false;
        DetailCode _action = t.getAction();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_action, null);
        if (!_operator_notEquals) {
            _operator_and = false;
        } else {
            DetailCode _action_1 = t.getAction();
            EList _commands = _action_1.getCommands();
            int _size = _commands.size();
            boolean _operator_greaterThan = ComparableExtensions.operator_greaterThan((Comparable)Integer.valueOf(_size), (Object)0);
            _operator_and = BooleanExtensions.operator_and((boolean)_operator_notEquals, (boolean)_operator_greaterThan);
        }
        return _operator_and;
    }

    public String getActionCode(ExpandedActorClass ac, Transition t) {
        DetailCode _action = t.getAction();
        String _code = ac.getCode(_action);
        return _code;
    }

    public String getContextId(TransitionChain tc) {
        State _stateContext = tc.getStateContext();
        String _stateId = this.nameProvider.getStateId(_stateContext);
        return _stateId;
    }

    public Transition getInitTransition(StateGraph sg) {
        EList _transitions = sg.getTransitions();
        for (Transition tr : _transitions) {
            if (!(tr instanceof InitialTransition)) continue;
            return tr;
        }
        return null;
    }

    public boolean hasInitTransition(StateGraph sg) {
        EList _transitions = sg.getTransitions();
        for (Transition tr : _transitions) {
            if (!(tr instanceof InitialTransition)) continue;
            return true;
        }
        return false;
    }

    public List<Transition> getTransitionList(State s) {
        boolean _isLeaf = this.isLeaf(s);
        if (_isLeaf) {
            ArrayList<Transition> _arrayList = new ArrayList<Transition>();
            return _arrayList;
        }
        StateGraph _subgraph = s.getSubgraph();
        List<Transition> _transitionList = this.getTransitionList(_subgraph);
        return _transitionList;
    }

    public List<Transition> getTransitionList(StateGraph sg) {
        ArrayList<Transition> _arrayList;
        EList _transitions = sg.getTransitions();
        ArrayList<Transition> res = _arrayList = new ArrayList<Transition>((Collection<Transition>)_transitions);
        EList _states = sg.getStates();
        for (State s : _states) {
            List<Transition> _transitionList = this.getTransitionList(s);
            res.addAll(_transitionList);
        }
        return res;
    }
}

