/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.commands;

import java.util.HashMap;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.ui.behavior.commands.StateGraphContext;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class PopulateDiagramCommand
extends RecordingCommand {
    private ActorClass ac;
    private Diagram diagram;
    private IFeatureProvider fp;

    public PopulateDiagramCommand(Diagram diag, ActorClass ac, TransactionalEditingDomain domain) {
        super(domain);
        this.diagram = diag;
        this.ac = ac;
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(this.diagram, "org.eclipse.etrice.ui.behavior.diagramTypeProvider");
        this.fp = dtp.getFeatureProvider();
    }

    protected void doExecute() {
        this.fp.link((PictogramElement)this.diagram, (Object)this.ac);
        StateGraphContext tree = StateGraphContext.createContextTree(this.ac);
        this.addStateGraph(tree, (ContainerShape)this.diagram);
        ContextSwitcher.switchTop(this.diagram);
    }

    private void addStateGraph(StateGraphContext ctx, ContainerShape parent) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)ctx.getStateGraph());
        addContext.setTargetContainer(parent);
        addContext.setX(40);
        addContext.setY(40);
        ContainerShape sgShape = (ContainerShape)this.fp.addIfPossible((IAddContext)addContext);
        if (sgShape == null) {
            return;
        }
        HashMap<String, Anchor> node2anchor = new HashMap<String, Anchor>();
        SupportUtil.addInitialPointIff(ctx.getTransitions(), sgShape, this.fp, node2anchor);
        SupportUtil.addTransitionPoints(ctx.getTrPoints(), sgShape, this.fp, node2anchor);
        SupportUtil.addStates(ctx.getStates(), sgShape, this.fp, node2anchor);
        SupportUtil.addChoicePoints(ctx.getChPoints(), sgShape, this.fp, node2anchor);
        for (StateGraphContext sub : ctx.getChildren()) {
            this.addStateGraph(sub, parent);
        }
        SupportUtil.getSubTpAnchors(sgShape, node2anchor);
        SupportUtil.addTransitions(ctx.getTransitions(), sgShape, this.fp, node2anchor);
    }
}

