/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.commands;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.util.RoomHelpers;

class StateGraphContext {
    private ArrayList<StateGraphContext> children = new ArrayList();
    private StateGraph stateGraph;
    private ArrayList<State> states = new ArrayList();
    private ArrayList<ChoicePoint> chPoints = new ArrayList();
    private ArrayList<TrPoint> trPoints = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    static HashMap<EObject, StateGraphContext> obj2ctx = new HashMap();

    static StateGraphContext createContextTree(ActorClass ac) {
        if (ac.getStateMachine() == null || ac.getStateMachine().eIsProxy()) {
            ac.setStateMachine(RoomFactory.eINSTANCE.createStateMachine());
        }
        ArrayList<ActorClass> classes = new ArrayList<ActorClass>();
        ActorClass a = ac;
        while (a != null) {
            classes.add(0, a);
            a = a.getBase();
        }
        obj2ctx.clear();
        StateGraphContext tree = null;
        for (ActorClass cls : classes) {
            if (cls.getStateMachine() == null) continue;
            if (tree == null) {
                tree = new StateGraphContext((StateGraph)cls.getStateMachine());
                continue;
            }
            super.merge((StateGraph)cls.getStateMachine());
        }
        return tree;
    }

    private StateGraphContext(StateGraph sg) {
        this.stateGraph = sg;
        this.init(sg);
    }

    private void init(StateGraph sg) {
        for (State s : sg.getStates()) {
            this.states.add(s);
            obj2ctx.put((EObject)s, this);
        }
        for (ChoicePoint cp : sg.getChPoints()) {
            this.chPoints.add(cp);
            obj2ctx.put((EObject)cp, this);
        }
        for (TrPoint tp : sg.getTrPoints()) {
            this.trPoints.add(tp);
            obj2ctx.put((EObject)tp, this);
        }
        for (Transition t : sg.getTransitions()) {
            this.transitions.add(t);
            obj2ctx.put((EObject)t, this);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.children.add(new StateGraphContext(s.getSubgraph()));
        }
    }

    private void merge(StateGraphContext derived) {
        for (State s : derived.getStates()) {
            this.states.add(s);
            obj2ctx.put((EObject)s, this);
        }
        for (ChoicePoint cp : derived.getChPoints()) {
            this.chPoints.add(cp);
            obj2ctx.put((EObject)cp, this);
        }
        for (TrPoint tp : derived.getTrPoints()) {
            this.trPoints.add(tp);
            obj2ctx.put((EObject)tp, this);
        }
        for (Transition t : derived.getTransitions()) {
            this.transitions.add(t);
            obj2ctx.put((EObject)t, this);
        }
    }

    private void merge(StateGraph derived) {
        this.stateGraph = derived;
        for (State s : derived.getStates()) {
            if (!(s instanceof BaseState)) continue;
            this.states.add(s);
            obj2ctx.put((EObject)s, this);
        }
        for (ChoicePoint cp : derived.getChPoints()) {
            this.chPoints.add(cp);
            obj2ctx.put((EObject)cp, this);
        }
        for (TrPoint tp : derived.getTrPoints()) {
            this.trPoints.add(tp);
            obj2ctx.put((EObject)tp, this);
        }
        for (Transition t : derived.getTransitions()) {
            this.transitions.add(t);
            obj2ctx.put((EObject)t, this);
        }
        for (State s : derived.getStates()) {
            if (!(s instanceof BaseState) || s.getSubgraph() == null) continue;
            this.children.add(new StateGraphContext(s.getSubgraph()));
        }
        for (State refined : derived.getStates()) {
            if (!(refined instanceof RefinedState)) continue;
            BaseState base = ((RefinedState)refined).getBase();
            StateGraphContext ctx = obj2ctx.get(base);
            assert (ctx != null) : "should have visited base state already";
            ctx.getStates().remove(base);
            ctx.getStates().add(refined);
            StateGraphContext sub = null;
            if (RoomHelpers.hasDirectSubStructure((State)refined)) {
                sub = new StateGraphContext(refined.getSubgraph());
                ctx.getChildren().add(sub);
            }
            if (!RoomHelpers.hasDirectSubStructure((State)base)) continue;
            StateGraphContext basesub = null;
            for (StateGraphContext bs : ctx.getChildren()) {
                if (bs.getParentState() != base) continue;
                basesub = bs;
                break;
            }
            if (basesub != null) {
                if (sub == null) continue;
                ctx.getChildren().remove(basesub);
                sub.merge(basesub);
                continue;
            }
            assert (false) : "context not found";
        }
    }

    public State getParentState() {
        if (this.stateGraph.eContainer() instanceof State) {
            return (State)this.stateGraph.eContainer();
        }
        return null;
    }

    public ArrayList<StateGraphContext> getChildren() {
        return this.children;
    }

    public ArrayList<State> getStates() {
        return this.states;
    }

    public ArrayList<ChoicePoint> getChPoints() {
        return this.chPoints;
    }

    public StateGraph getStateGraph() {
        return this.stateGraph;
    }

    public ArrayList<TrPoint> getTrPoints() {
        return this.trPoints;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public String toString() {
        return this.dump("");
    }

    private String dump(String indent) {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(indent) + ">>> " + this.getText(this.stateGraph) + "\n");
        indent = String.valueOf(indent) + "  ";
        for (State s : this.states) {
            result.append(String.valueOf(indent) + this.getText((StateGraphItem)s) + "\n");
        }
        for (StateGraphContext child : this.children) {
            result.append(child.dump(indent));
        }
        return result.toString();
    }

    private String getText(StateGraph sg) {
        ActorClass parent = this.getActorClass((EObject)sg);
        return "state graph of " + (parent == null ? "?" : parent.getName());
    }

    private String getText(StateGraphItem sg) {
        ActorClass parent = this.getActorClass((EObject)sg);
        String name = "?";
        if (sg instanceof State) {
            name = "st " + ((State)sg).getName();
        } else if (sg instanceof TrPoint) {
            name = "tp " + ((TrPoint)sg).getName();
        }
        return String.valueOf(name) + " of " + (parent == null ? "?" : parent.getName());
    }

    private ActorClass getActorClass(EObject obj) {
        EObject parent = obj.eContainer();
        while (parent != null) {
            if (parent instanceof ActorClass) {
                return (ActorClass)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }
}

