/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import java.util.HashSet;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.dialogs.MemberSelectionDialog;
import org.eclipse.etrice.ui.behavior.dialogs.PortMessageSelectionDialog;
import org.eclipse.etrice.ui.common.dialogs.AbstractPropertyDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractMemberAwarePropertyDialog
extends AbstractPropertyDialog {
    private Text lastTextField = null;
    private Button members;
    private Button messages;
    private ActorClass ac;
    private LastTextListener listener = new LastTextListener();
    private HashSet<Control> memberAware = new HashSet();
    private HashSet<Control> messageAware = new HashSet();
    private HashSet<Control> recvOnly = new HashSet();

    public AbstractMemberAwarePropertyDialog(Shell shell, String title, ActorClass ac) {
        super(shell, title);
        this.ac = ac;
    }

    public ActorClass getActorClass() {
        return this.ac;
    }

    protected void createMembersAndMessagesButtons(Composite body) {
        Composite buttonsArea = this.getToolkit().createComposite(body);
        buttonsArea.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        buttonsArea.setLayoutData((Object)gd);
        this.members = new Button(buttonsArea, 8);
        this.members.setText("Mem&bers");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.members.setLayoutData((Object)gd);
        this.members.setEnabled(false);
        this.members.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMembersPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMembersPressed();
            }
        });
        this.messages = new Button(buttonsArea, 8);
        this.messages.setText("Me&ssages");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.messages.setLayoutData((Object)gd);
        this.messages.setEnabled(false);
        this.messages.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMessagesPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractMemberAwarePropertyDialog.this.handleMessagesPressed();
            }
        });
    }

    protected void handleMembersPressed() {
        MemberSelectionDialog dlg = new MemberSelectionDialog(this.getShell(), this.ac);
        if (dlg.open() == 0) {
            Object selected = dlg.getSelected();
            if (selected instanceof Attribute) {
                this.insertText(((Attribute)selected).getName());
            } else if (selected instanceof Operation) {
                this.insertText(String.valueOf(((Operation)selected).getName()) + RoomHelpers.getSignature((Operation)((Operation)selected)));
            }
        }
    }

    protected void handleMessagesPressed() {
        boolean receiveOnly = this.recvOnly.contains(this.lastTextField);
        PortMessageSelectionDialog dlg = new PortMessageSelectionDialog(this.getShell(), this.ac, receiveOnly);
        if (dlg.open() == 0 && dlg.getMsgItemPair() != null) {
            PortMessageSelectionDialog.MsgItemPair pair = dlg.getMsgItemPair();
            if (pair.out) {
                String data = pair.msg.getData() != null ? pair.msg.getData().getName() : "";
                this.insertText(String.valueOf(pair.item.getName()) + "." + pair.msg.getName() + "(" + data + ")");
            } else {
                this.insertText(String.valueOf(pair.item.getName()) + "." + pair.msg.getName());
            }
        }
    }

    private void insertText(String txt) {
        if (this.lastTextField != null) {
            int begin = txt.indexOf(40);
            int end = txt.indexOf(41);
            int offset = this.lastTextField.getSelection().x;
            this.lastTextField.insert(txt);
            if (begin >= 0 && end >= 0 && end > begin + 1) {
                this.lastTextField.setSelection(offset + begin + 1, offset + end);
            }
            this.lastTextField.setFocus();
        }
    }

    public void configureMemberAware(Control ctrl) {
        this.configureMemberAware(ctrl, false, false);
    }

    public void configureMemberAware(Control ctrl, boolean useMembers, boolean useMessages) {
        this.configureMemberAware(ctrl, useMembers, useMembers, false);
    }

    public void configureMemberAware(Control ctrl, boolean useMembers, boolean useMessages, boolean useRecvMessagesOnly) {
        if (useMembers) {
            this.memberAware.add(ctrl);
        }
        if (useMessages) {
            this.messageAware.add(ctrl);
        }
        if (useRecvMessagesOnly) {
            this.recvOnly.add(ctrl);
        }
        ctrl.addFocusListener((FocusListener)this.listener);
    }

    private class LastTextListener
    implements FocusListener {
        private LastTextListener() {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof Text) {
                boolean enableMemberButton = AbstractMemberAwarePropertyDialog.this.memberAware.contains(e.getSource());
                boolean enableMessageButton = AbstractMemberAwarePropertyDialog.this.messageAware.contains(e.getSource());
                if (enableMemberButton || enableMessageButton) {
                    AbstractMemberAwarePropertyDialog.this.lastTextField = (Text)e.getSource();
                } else {
                    AbstractMemberAwarePropertyDialog.this.lastTextField = null;
                }
                AbstractMemberAwarePropertyDialog.this.members.setEnabled(enableMemberButton);
                AbstractMemberAwarePropertyDialog.this.messages.setEnabled(enableMessageButton);
            } else {
                AbstractMemberAwarePropertyDialog.this.lastTextField = null;
                AbstractMemberAwarePropertyDialog.this.members.setEnabled(false);
                AbstractMemberAwarePropertyDialog.this.messages.setEnabled(false);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

