/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Type;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortMessageSelectionDialog
extends FormDialog {
    private ActorClass ac;
    private boolean recvOnly;
    private TreeViewer viewer;
    private MsgItemPair selected = null;
    @Inject
    ILabelProvider labelProvider;

    public PortMessageSelectionDialog(Shell shell, ActorClass ac, boolean recvOnly) {
        super(shell);
        this.ac = ac;
        this.recvOnly = recvOnly;
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        Form form = mform.getForm().getForm();
        form.setText("Select a port.message Combination");
        form.setImage(Activator.getImage("icons/Behavior.gif"));
        toolkit.decorateFormHeading(form);
        Composite body = form.getBody();
        this.viewer = new TreeViewer(body, 67840);
        TreeColumn col0 = new TreeColumn(this.viewer.getTree(), 0);
        col0.setText("interface item/message");
        TreeColumn col1 = new TreeColumn(this.viewer.getTree(), 0);
        col1.setText("direction");
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0);
        col2.setText("data");
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new PortMessageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PortMessageLabelProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setInput((Object)this.ac);
        this.viewer.expandAll();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PortMessageSelectionDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button ok = PortMessageSelectionDialog.this.getButton(0);
                if (ok != null && event.getSelection() instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    ok.setEnabled(element instanceof MsgItemPair);
                }
            }
        });
        TreeColumnLayout layout = new TreeColumnLayout();
        body.setLayout((Layout)layout);
        layout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(40));
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(20));
        layout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(40));
    }

    protected void okPressed() {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof MsgItemPair) {
            this.selected = (MsgItemPair)element;
        }
        super.okPressed();
    }

    public MsgItemPair getMsgItemPair() {
        return this.selected;
    }

    public static class MsgItemPair {
        Message msg;
        InterfaceItem item;
        boolean out;

        public MsgItemPair(Message msg, InterfaceItem item, boolean out) {
            this.msg = msg;
            this.item = item;
            this.out = out;
        }
    }

    private class PortMessageContentProvider
    implements ITreeContentProvider {
        private HashMap<InterfaceItem, ArrayList<MsgItemPair>> msg2item;

        private PortMessageContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.msg2item = new HashMap();
            List items = RoomHelpers.getAllInterfaceItems((ActorClass)PortMessageSelectionDialog.this.ac);
            for (InterfaceItem item : items) {
                ArrayList<MsgItemPair> pairs = new ArrayList<MsgItemPair>();
                List out = RoomHelpers.getMessageList((InterfaceItem)item, (boolean)true);
                if (!PortMessageSelectionDialog.this.recvOnly) {
                    for (Message msg : out) {
                        pairs.add(new MsgItemPair(msg, item, true));
                    }
                }
                if (PortMessageSelectionDialog.this.ac.getStateMachine().isDataDriven()) {
                    List in = RoomHelpers.getMessageList((InterfaceItem)item, (boolean)false);
                    for (Message msg : in) {
                        pairs.add(new MsgItemPair(msg, item, false));
                    }
                }
                this.msg2item.put(item, pairs);
            }
        }

        public Object[] getElements(Object inputElement) {
            return RoomHelpers.getAllInterfaceItems((ActorClass)PortMessageSelectionDialog.this.ac).toArray();
        }

        public Object[] getChildren(Object element) {
            if (element instanceof InterfaceItem) {
                ArrayList<MsgItemPair> list = this.msg2item.get(element);
                return list.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof MsgItemPair) {
                return ((MsgItemPair)element).item;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof InterfaceItem) {
                if (!RoomHelpers.getMessageList((InterfaceItem)((InterfaceItem)element), (boolean)true).isEmpty()) {
                    return true;
                }
                if (PortMessageSelectionDialog.this.ac.getStateMachine().isDataDriven() && !RoomHelpers.getMessageList((InterfaceItem)((InterfaceItem)element), (boolean)false).isEmpty()) {
                    return true;
                }
            }
            return false;
        }
    }

    private class PortMessageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PortMessageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof MsgItemPair) {
                    element = ((MsgItemPair)element).msg;
                }
                return PortMessageSelectionDialog.this.labelProvider.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof InterfaceItem) {
                        return ((InterfaceItem)element).getName();
                    }
                    if (!(element instanceof MsgItemPair)) break;
                    return ((MsgItemPair)element).msg.getName();
                }
                case 1: {
                    if (!(element instanceof MsgItemPair)) break;
                    return ((MsgItemPair)element).out ? "send" : "recv";
                }
                case 2: {
                    Message msg;
                    if (!(element instanceof MsgItemPair) || (msg = ((MsgItemPair)element).msg).getData() == null) break;
                    return String.valueOf(msg.getData().getName()) + " : " + RoomHelpers.getName((Type)msg.getData().getType());
                }
            }
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getImage(Object element) {
            return PortMessageSelectionDialog.this.labelProvider.getImage(element);
        }
    }
}

