/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.dialogs.AbstractMemberAwarePropertyDialog;
import org.eclipse.etrice.ui.behavior.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.dialogs.StringToDetailCode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class StatePropertyDialog
extends AbstractMemberAwarePropertyDialog {
    private State state;

    public StatePropertyDialog(Shell shell, ActorClass ac, State s) {
        super(shell, "Edit State", ac);
        this.state = s;
    }

    protected Image getImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        if (this.state instanceof BaseState) {
            NameValidator nv = new NameValidator();
            Text name = this.createText(body, "&Name:", (EObject)this.state, RoomPackage.eINSTANCE.getBaseState_Name(), nv);
            this.configureMemberAware((Control)name);
            this.createDecorator((Control)name, "invalid name");
            name.setFocus();
            name.selectAll();
        } else {
            Text name = mform.getToolkit().createText(body, "Name:", 2048);
            name.setLayoutData((Object)new GridData(768));
            name.setEnabled(false);
        }
        DetailCodeToString m2s = new DetailCodeToString();
        StringToDetailCode s2m = new StringToDetailCode();
        Text entry = this.createText(body, "&Entry Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_EntryCode(), null, (IConverter)s2m, (IConverter)m2s, true);
        this.configureMemberAware((Control)entry, true, true);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        entry.setLayoutData((Object)gd);
        Text exit = this.createText(body, "E&xit Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_ExitCode(), null, (IConverter)s2m, (IConverter)m2s, true);
        this.configureMemberAware((Control)exit, true, true);
        gd = new GridData(1808);
        gd.heightHint = 100;
        exit.setLayoutData((Object)gd);
        ActorClass ac = RoomHelpers.getActorClass((StateGraphItem)this.state);
        if (ac.getStateMachine().isDataDriven()) {
            Text dotxt = this.createText(body, "&Do Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_DoCode(), null, (IConverter)s2m, (IConverter)m2s, true);
            this.configureMemberAware((Control)dotxt, true, true);
            GridData gd2 = new GridData(1808);
            gd2.heightHint = 100;
            dotxt.setLayoutData((Object)gd2);
        }
        this.createMembersAndMessagesButtons(body);
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                ValidationUtil.Result result = ValidationUtil.isUniqueName((StateGraphItem)StatePropertyDialog.this.state, (String)name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }
}

