/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.etrice.core.RoomDefaultValues;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;

public class BehaviorEditor
extends RoomDiagramEditor {
    public static final String BEHAVIOR_EDITOR_ID = "org.eclipse.etrice.ui.behavior.editor.BehaviorEditor";

    public BehaviorEditor() {
        IPreferenceStore store = org.eclipse.etrice.ui.common.Activator.getDefault().getPreferenceStore();
        boolean dataDriven = store.getBoolean("DataDrivenFSM");
        RoomDefaultValues.setUseDataDrivenStateMachine((boolean)dataDriven);
    }

    public Image getDefaultImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        RecordingCommand cmd = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ContextSwitcher.switchTop(BehaviorEditor.this.getDiagramTypeProvider().getDiagram());
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        this.getEditingDomain().getCommandStack().flush();
    }

    public ActorClass getActorClass() {
        Diagram diagram = ((DiagramEditorInput)this.getEditorInput()).getDiagram();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
        if (bo instanceof ActorClass) {
            return (ActorClass)bo;
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                BehaviorEditor.this.removeEmptySubgraphs();
                BehaviorEditor.this.removeUnusedRefinedStates();
            }
        });
        super.doSave(monitor);
    }

    protected void removeUnusedRefinedStates() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        ActorClass ac = SupportUtil.getActorClass(diagram);
        ArrayList<RefinedState> toBeRemoved = new ArrayList<RefinedState>();
        for (State s : ac.getStateMachine().getStates()) {
            if (!(s instanceof RefinedState) || !this.isUnused((RefinedState)s)) continue;
            toBeRemoved.add((RefinedState)s);
        }
        ac.getStateMachine().getStates().removeAll(toBeRemoved);
    }

    private boolean isUnused(RefinedState s) {
        if (RoomHelpers.hasDirectSubStructure((State)s)) {
            return false;
        }
        if (RoomHelpers.hasDetailCode((DetailCode)s.getEntryCode())) {
            return false;
        }
        return !RoomHelpers.hasDetailCode((DetailCode)s.getExitCode());
    }

    protected void removeEmptySubgraphs() {
        State s;
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        StateGraph current = ContextSwitcher.getCurrentStateGraph(diagram);
        if (current.eContainer() instanceof State && !RoomHelpers.hasDirectSubStructure((State)(s = (State)current.eContainer()))) {
            ContextSwitcher.goUp(diagram, current);
        }
        ArrayList<Shape> toBeRemoved = new ArrayList<Shape>();
        for (Shape ctxShape : diagram.getChildren()) {
            State s2;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            if (bo.eIsProxy()) {
                toBeRemoved.add(ctxShape);
                continue;
            }
            assert (bo instanceof StateGraph) : "expected state graph";
            StateGraph sg = (StateGraph)bo;
            if (!(sg.eContainer() instanceof State) || RoomHelpers.hasDirectSubStructure((State)(s2 = (State)sg.eContainer()))) continue;
            EcoreUtil.delete((EObject)sg);
            toBeRemoved.add(ctxShape);
        }
        for (Shape shape : toBeRemoved) {
            EcoreUtil.delete((EObject)shape, (boolean)true);
        }
    }
}

