/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.ui.behavior.support.StateSupport;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ContextSwitcher {
    public static void goUp(Diagram diagram, StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            State s = (State)sg.eContainer();
            while (s instanceof RefinedState) {
                s = ((RefinedState)s).getBase();
            }
            StateGraph superSG = (StateGraph)s.eContainer();
            if (superSG.eContainer() instanceof ActorClass) {
                ContextSwitcher.switchTop(diagram);
            } else {
                ContextSwitcher.switchTo(diagram, superSG);
            }
        }
    }

    public static void switchTop(Diagram diagram) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
        if (bo instanceof ActorClass) {
            ContextSwitcher.switchTo(diagram, (StateGraph)((ActorClass)bo).getStateMachine());
        }
    }

    public static void switchTo(Diagram diagram, StateGraph sg) {
        for (Shape ctxShape : diagram.getChildren()) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            if (bo.eIsProxy()) continue;
            assert (bo instanceof StateGraph) : "expected state graph";
            if (bo instanceof StateGraph && bo == sg) {
                ContextSwitcher.activateContext(ctxShape, true);
                continue;
            }
            ContextSwitcher.activateContext(ctxShape, false);
        }
        ContextSwitcher.activateTransitions(diagram);
    }

    public static StateGraph getCurrentStateGraph(Diagram diagram) {
        for (Shape ctxShape : diagram.getChildren()) {
            if (!(ctxShape instanceof ContainerShape) || !ctxShape.isVisible()) continue;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            assert (bo instanceof StateGraph) : "expected state graph";
            if (!(bo instanceof StateGraph)) continue;
            return (StateGraph)bo;
        }
        return null;
    }

    public static ContainerShape getContext(Diagram diagram, StateGraph sg) {
        for (Shape ctxShape : diagram.getChildren()) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            assert (bo instanceof StateGraph) : "expected state graph";
            if (!(bo instanceof StateGraph) || bo != sg) continue;
            return (ContainerShape)ctxShape;
        }
        return null;
    }

    private static void activateTransitions(Diagram diagram) {
        for (Connection conn : diagram.getConnections()) {
            if (conn.getStart() != null) {
                boolean visible = conn.getStart().getParent().isVisible();
                conn.setVisible(visible);
                for (ConnectionDecorator dec : conn.getConnectionDecorators()) {
                    dec.setVisible(visible);
                }
                continue;
            }
            assert (false) : "internal error";
        }
    }

    private static void activateContext(Shape ctxShape, boolean activate) {
        ctxShape.setVisible(activate);
        TreeIterator it = ctxShape.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof Shape)) continue;
            ((Shape)obj).setVisible(activate);
            EObject eobj = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)((Shape)obj));
            if (!(eobj instanceof State)) continue;
            GraphicsAlgorithm border = (GraphicsAlgorithm)((Shape)obj).getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            StateSupport.updateHints((State)eobj, border);
        }
    }
}

