/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.support.NoResizeFeature;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class InitialPointSupport {
    public static final int ITEM_SIZE = 20;
    protected static final int LINE_WIDTH = 2;
    protected static final IColorConstant DARK_COLOR = new ColorConstant(0, 0, 0);
    protected static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    protected static final IColorConstant BRIGHT_COLOR = new ColorConstant(255, 255, 255);
    protected static final String PROP_KIND = "item-kind";
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public InitialPointSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Transition");
            button.setIconId("org.eclipse.etrice.ui.behavior.transition");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        protected IFeatureProvider fp;

        protected FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, "Initial Point", "Create Initial Point")};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void createFigure(ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightColor) {
            IGaService gaService = Graphiti.getGaService();
            Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
            circle.setForeground(darkColor);
            circle.setBackground(brightColor);
            circle.setLineWidth(Integer.valueOf(2));
            int s2 = 10;
            gaService.setLocationAndSize((GraphicsAlgorithm)circle, s2, s2, 20, 20);
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)circle);
            }
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof StateGraph && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public PictogramElement add(IAddContext context) {
                ContainerShape sgShape = context.getTargetContainer();
                StateGraph sg = (StateGraph)context.getNewObject();
                boolean inherited = false;
                for (Transition tr : sg.getTransitions()) {
                    if (!(tr instanceof InitialTransition)) continue;
                    inherited = SupportUtil.isInherited((StateGraphItem)tr, sgShape);
                }
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(sgShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "trp");
                int x = context.getX() - 20;
                int y = context.getY() - 20;
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x, y, 40, 40);
                FeatureProvider.createFigure(containerShape, (GraphicsAlgorithm)invisibleRectangle, dark, this.manageColor(BRIGHT_COLOR));
                this.link((PictogramElement)containerShape, sg);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, "I");
                label.setForeground(dark);
                label.setBackground(dark);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, 10, 40, 20);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private static class CreateFeature
        extends AbstractCreateFeature {
            public CreateFeature(IFeatureProvider fp, String name, String description) {
                super(fp, name, description);
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.initial";
            }

            public Object[] create(ICreateContext context) {
                ContainerShape targetContainer = context.getTargetContainer();
                StateGraph sg = (StateGraph)targetContainer.getLink().getBusinessObjects().get(0);
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)sg);
                if (inherited) {
                    ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                    sg = SupportUtil.insertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                }
                this.addGraphicalRepresentation((IAreaContext)context, sg);
                return new Object[]{sg};
            }

            public boolean canCreate(ICreateContext context) {
                ContainerShape parent;
                EObject obj;
                if (context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph && !((parent = context.getTargetContainer().getContainer()) instanceof StateGraph)) {
                    StateGraph sg = (StateGraph)obj;
                    for (Transition t : sg.getTransitions()) {
                        if (!(t instanceof InitialTransition)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                return false;
            }
        }

        protected class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                boolean canMove = super.canMoveShape(context);
                if (canMove) {
                    Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                    return bo instanceof StateGraph;
                }
                return canMove;
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return bo instanceof StateGraph;
            }

            public void preRemove(IRemoveContext context) {
                super.preRemove(context);
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)this.getFeatureProvider());
            }
        }
    }
}

