/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.dialogs.StatePropertyDialog;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StateSupport {
    private static final int LINE_WIDTH = 1;
    public static final int DEFAULT_SIZE_X = 60;
    public static final int DEFAULT_SIZE_Y = 30;
    public static final int MIN_SIZE_X = 60;
    public static final int MIN_SIZE_Y = 30;
    public static final int MARGIN = 30;
    public static final int CORNER_WIDTH = 20;
    public static final int HINT_CORNER_WIDTH = 5;
    private static final int TEXT_MARGIN = 10;
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private static final IColorConstant BACKGROUND = new ColorConstant(200, 200, 200);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public StateSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private static void addHints(State s, RoundedRectangle border, Color lineColor) {
        int x = border.getWidth() - 25;
        int y = 3;
        IGaService gaService = Graphiti.getGaService();
        RoundedRectangle hint = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)border, 5, 5);
        hint.setForeground(lineColor);
        hint.setFilled(Boolean.valueOf(false));
        hint.setLineWidth(Integer.valueOf(1));
        gaService.setLocationAndSize((GraphicsAlgorithm)hint, x, y, 15, 8);
        ActorClass ac = SupportUtil.getActorClass(SupportUtil.getDiagram((GraphicsAlgorithm)border));
        if (!RoomHelpers.hasSubStructure((State)s, (ActorClass)ac)) {
            hint.setLineVisible(Boolean.valueOf(false));
        }
        x = border.getWidth() / 2;
        y = border.getHeight() - 6;
        gaService = Graphiti.getGaService();
        int[] xy1 = new int[]{-3, -3, -3, 3, -11, 3};
        Polygon entryHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy1);
        entryHint.setForeground(lineColor);
        entryHint.setFilled(Boolean.valueOf(false));
        entryHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)entryHint, x, y);
        int[] xy2 = new int[]{3, -3, 3, 3, 11, 3};
        Polygon exitHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy2);
        exitHint.setForeground(lineColor);
        exitHint.setFilled(Boolean.valueOf(false));
        exitHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)exitHint, x, y);
        int[] xy3 = new int[]{-2, -3, -2, 3, 2, 3, 2, -3};
        Polygon doHint = gaService.createPolygon((GraphicsAlgorithmContainer)border, xy3);
        doHint.setForeground(lineColor);
        doHint.setFilled(Boolean.valueOf(false));
        doHint.setLineWidth(Integer.valueOf(1));
        gaService.setLocation((GraphicsAlgorithm)doHint, x, y);
        if (!RoomHelpers.hasDetailCode((DetailCode)s.getEntryCode())) {
            entryHint.setLineVisible(Boolean.valueOf(false));
        }
        if (!RoomHelpers.hasDetailCode((DetailCode)s.getExitCode())) {
            exitHint.setLineVisible(Boolean.valueOf(false));
        }
        if (!RoomHelpers.hasDetailCode((DetailCode)s.getDoCode())) {
            doHint.setLineVisible(Boolean.valueOf(false));
        }
    }

    protected static void updateHints(State s, GraphicsAlgorithm border) {
        ActorClass ac = SupportUtil.getActorClass(SupportUtil.getDiagram(border));
        GraphicsAlgorithm hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(0);
        hint.setLineVisible(Boolean.valueOf(RoomHelpers.hasSubStructure((State)s, (ActorClass)ac)));
        hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(1);
        hint.setLineVisible(Boolean.valueOf(RoomHelpers.hasDetailCode((DetailCode)s.getEntryCode())));
        hint = (GraphicsAlgorithm)border.getGraphicsAlgorithmChildren().get(2);
        hint.setLineVisible(Boolean.valueOf(RoomHelpers.hasDetailCode((DetailCode)s.getExitCode())));
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.GoDownFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public String getToolTip(GraphicsAlgorithm ga) {
            EObject bo;
            PictogramElement pe = ga.getPictogramElement();
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            if ((bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe)) instanceof State) {
                String label = "";
                State s = (State)bo;
                if (RoomHelpers.hasDetailCode((DetailCode)s.getEntryCode())) {
                    label = "entry:\n" + RoomHelpers.getDetailCode((DetailCode)s.getEntryCode());
                }
                if (RoomHelpers.hasDetailCode((DetailCode)s.getExitCode())) {
                    if (label.length() > 0) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "exit:\n" + RoomHelpers.getDetailCode((DetailCode)s.getExitCode());
                }
                if (RoomHelpers.hasDetailCode((DetailCode)s.getDoCode())) {
                    if (label.length() > 0) {
                        label = String.valueOf(label) + "\n";
                    }
                    label = String.valueOf(label) + "do:\n" + RoomHelpers.getDetailCode((DetailCode)s.getDoCode());
                }
                if (label.length() > 0) {
                    return label;
                }
            }
            return super.getToolTip(ga);
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Transition");
            button.setIconId("org.eclipse.etrice.ui.behavior.transition");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public static RoundedRectangle createFigure(State s, GraphicsAlgorithm invisibleRect, Color darkColor, Color brightColor) {
            IGaService gaService = Graphiti.getGaService();
            RoundedRectangle rect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRect, 20, 20);
            rect.setForeground(darkColor);
            rect.setBackground(brightColor);
            rect.setLineWidth(Integer.valueOf(1));
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, 30, 30, invisibleRect.getWidth() - 60, invisibleRect.getHeight() - 60);
            StateSupport.addHints(s, rect, darkColor);
            return rect;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp), new GoDownFeature(this.fp), new CreateSubGraphFeature(this.fp)};
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof State && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public PictogramElement add(IAddContext context) {
                boolean inherited;
                IDimension sz;
                State s = (State)context.getNewObject();
                ContainerShape acShape = context.getTargetContainer();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(acShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "state");
                int width = context.getWidth();
                int height = context.getHeight();
                if (width <= 0 && (width = 60) < (sz = GraphitiUi.getUiLayoutService().calculateTextSize(s.getName(), (Font)this.getDiagram().getFonts().get(0))).getWidth() + 10) {
                    width = sz.getWidth() + 10;
                }
                if (height <= 0) {
                    height = 30;
                }
                Color lineColor = this.manageColor((inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)s)) ? INHERITED_COLOR : LINE_COLOR);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX() - (width / 2 + 30), context.getY() - (height / 2 + 30), width + 60, height + 60);
                RoundedRectangle rect = FeatureProvider.createFigure(s, (GraphicsAlgorithm)invisibleRectangle, lineColor, this.manageColor(BACKGROUND));
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
                this.link((PictogramElement)containerShape, s);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, s.getName());
                label.setForeground(lineColor);
                label.setBackground(lineColor);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 30, 30, width, height);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class CreateFeature
        extends AbstractCreateFeature {
            private boolean doneChanges;

            public CreateFeature(IFeatureProvider fp) {
                super(fp, "State", "create State");
                this.doneChanges = false;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.state";
            }

            public boolean canCreate(ICreateContext context) {
                EObject obj;
                return context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public Object[] create(ICreateContext context) {
                ContainerShape targetContainer = context.getTargetContainer();
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                StateGraph sg = (StateGraph)targetContainer.getLink().getBusinessObjects().get(0);
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)sg);
                if (inherited) {
                    sg = SupportUtil.insertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                }
                BaseState s = RoomFactory.eINSTANCE.createBaseState();
                s.setName(RoomNameProvider.getUniqueStateName((StateGraph)sg));
                sg.getStates().add((Object)s);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                StatePropertyDialog dlg = new StatePropertyDialog(shell, ac, (State)s);
                if (dlg.open() != 0) {
                    if (inherited) {
                        SupportUtil.undoInsertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                    } else {
                        sg.getStates().remove((Object)s);
                    }
                    return EMPTY;
                }
                this.addGraphicalRepresentation((IAreaContext)context, s);
                this.doneChanges = true;
                return new Object[]{s};
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private static class CreateSubGraphFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public CreateSubGraphFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Create SubGraph";
            }

            public String getDescription() {
                return "Create and Switch to New SubGraph";
            }

            public boolean canExecute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                return bo instanceof State && ((State)bo).getSubgraph() == null;
            }

            public void execute(ICustomContext context) {
                this.getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (bo instanceof State) {
                    State s = (State)bo;
                    boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)s);
                    if (inherited) {
                        ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                        RefinedState rs = null;
                        for (State st : ac.getStateMachine().getStates()) {
                            if (!(st instanceof RefinedState) || ((RefinedState)st).getBase() != s) continue;
                            rs = (RefinedState)st;
                            break;
                        }
                        if (rs == null) {
                            rs = RoomFactory.eINSTANCE.createRefinedState();
                            rs.setBase((BaseState)s);
                            ac.getStateMachine().getStates().add((Object)rs);
                        }
                        s = rs;
                    }
                    s.setSubgraph((StateGraph)RoomFactory.eINSTANCE.createPlainStateGraph());
                    AddContext addContext = new AddContext();
                    addContext.setNewObject((Object)s.getSubgraph());
                    addContext.setTargetContainer((ContainerShape)this.getDiagram());
                    addContext.setX(40);
                    addContext.setY(40);
                    PictogramElement subGraphShape = this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                    if (subGraphShape != null) {
                        RoundedRectangle borderRect = (RoundedRectangle)container.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
                        StateSupport.updateHints(s, (GraphicsAlgorithm)borderRect);
                    }
                    ContextSwitcher.switchTo(this.getDiagram(), s.getSubgraph());
                }
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof State) {
                    State state = (State)bo;
                    return !SupportUtil.isInherited(this.getDiagram(), (EObject)state);
                }
                return false;
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                if (!(context.getPictogramElement() instanceof ContainerShape)) {
                    return;
                }
                State s = (State)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                IFeatureProvider fp = this.getFeatureProvider();
                Diagram diagram = this.getDiagram();
                ActorClass ac = RoomHelpers.getActorClass((StateGraphItem)s);
                SupportUtil.deleteSubStructureRecursive(s, ac, diagram, fp);
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)fp);
            }
        }

        private static class GoDownFeature
        extends AbstractCustomFeature
        implements ICustomFeature {
            public GoDownFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Switch to SubGraph";
            }

            public String getDescription() {
                return "Switch Context to SubGraph";
            }

            public boolean canExecute(ICustomContext context) {
                State targetting;
                PictogramElement pe = context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                return bo instanceof State && (targetting = SupportUtil.getTargettingState((State)bo, this.getDiagram())).getSubgraph() != null;
            }

            public void execute(ICustomContext context) {
                State targetting;
                this.getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
                if (bo instanceof State && (targetting = SupportUtil.getTargettingState((State)bo, this.getDiagram())).getSubgraph() != null) {
                    ContextSwitcher.switchTo(this.getDiagram(), targetting.getSubgraph());
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                return bo instanceof State;
            }

            public boolean layout(ILayoutContext context) {
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() >= 1) {
                    GraphicsAlgorithm borderGA = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    int nw = w - 60;
                    int nh = h - 60;
                    borderGA.setWidth(nw);
                    borderGA.setHeight(nh);
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                    if (bo instanceof State) {
                        State s = (State)bo;
                        while (!borderGA.getGraphicsAlgorithmChildren().isEmpty()) {
                            EcoreUtil.delete((EObject)((EObject)borderGA.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
                        }
                        Color lineColor = this.manageColor(SupportUtil.isInherited(this.getDiagram(), (EObject)s) ? INHERITED_COLOR : LINE_COLOR);
                        StateSupport.addHints(s, (RoundedRectangle)borderGA, lineColor);
                    }
                    if (!containerShape.getChildren().isEmpty()) {
                        GraphicsAlgorithm childGA = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
                        assert (childGA instanceof Text) : "label expected";
                        childGA.setWidth(nw);
                        childGA.setHeight(nh);
                    }
                    anythingChanged = true;
                }
                return anythingChanged;
            }
        }

        private class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                Object bo;
                boolean canMove = super.canMoveShape(context);
                if (canMove && (bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement())) instanceof State) {
                    State s = (State)bo;
                    return !SupportUtil.isInherited(this.getDiagram(), (EObject)s);
                }
                return canMove;
            }
        }

        private static class PropertyFeature
        extends AbstractCustomFeature {
            private boolean doneChanges = false;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Edit State...";
            }

            public String getDescription() {
                return "Edit State Properties";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof State;
            }

            public void execute(ICustomContext context) {
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                State s = (State)this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                StatePropertyDialog dlg = new StatePropertyDialog(shell, ac, s);
                if (dlg.open() != 0) {
                    throw new OperationCanceledException();
                }
                this.doneChanges = true;
                this.updateFigure(s, context);
                this.adjustSubgraphLabels(s, ac);
            }

            private void adjustSubgraphLabels(State s, ActorClass ac) {
                if (RoomHelpers.hasSubStructure((State)s, (ActorClass)ac)) {
                    Shape labelShape;
                    GraphicsAlgorithm ga;
                    ContainerShape subShape = ContextSwitcher.getContext(this.getDiagram(), s.getSubgraph());
                    if (subShape != null && !subShape.getChildren().isEmpty() && (ga = (labelShape = (Shape)subShape.getChildren().get(0)).getGraphicsAlgorithm()) instanceof Text) {
                        ((Text)ga).setValue(RoomNameProvider.getStateGraphLabel((StateGraph)s.getSubgraph()));
                    }
                    for (State sub : s.getSubgraph().getStates()) {
                        this.adjustSubgraphLabels(sub, ac);
                    }
                }
            }

            private void updateFigure(State s, ICustomContext context) {
                ContainerShape container = (ContainerShape)context.getPictogramElements()[0];
                GraphicsAlgorithm invisibleRect = context.getPictogramElements()[0].getGraphicsAlgorithm();
                while (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                    EcoreUtil.delete((EObject)((EObject)invisibleRect.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
                }
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)s);
                Color lineColor = this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR);
                FeatureProvider.createFigure(s, invisibleRect, lineColor, this.manageColor(BACKGROUND));
                GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    ((Text)ga).setValue(s.getName());
                }
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                int width = context.getWidth() - 30;
                int height = context.getHeight() - 30;
                return width <= 0 || height <= 0 || width >= 90 && height >= 60;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                Shape shape = context.getShape();
                if (shape.getGraphicsAlgorithm() != null && (containerGa = shape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 1) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 60) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 60) / (double)ga.getHeight();
                    for (Shape childShape : ((ContainerShape)context.getShape()).getChildren()) {
                        Object childBo = this.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                        if (!(childBo instanceof TrPoint)) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        ga.setX((int)((double)ga.getX() * sx));
                        ga.setY((int)((double)ga.getY() * sy));
                    }
                }
                super.resizeShape(context);
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof State;
            }

            public IReason updateNeeded(IUpdateContext context) {
                GraphicsAlgorithm ga;
                int last;
                GraphicsAlgorithm borderRect;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"State deleted from model");
                }
                State s = (State)bo;
                ActorClass mainAc = SupportUtil.getActorClass(this.getDiagram());
                ActorClass ac = RoomHelpers.getActorClass((StateGraphItem)s);
                ActorClass tmp = mainAc;
                boolean found = false;
                do {
                    if (tmp == ac) {
                        found = true;
                    }
                    tmp = tmp.getBase();
                } while (!found && tmp != null);
                if (!found) {
                    return Reason.createTrueReason((String)"Ref not inherited anymore");
                }
                boolean hasSubStruct = RoomHelpers.hasSubStructure((State)s, (ActorClass)mainAc);
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty() && !(borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0)).getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm hint = (GraphicsAlgorithm)borderRect.getGraphicsAlgorithmChildren().get(0);
                    if (hasSubStruct && !hint.getLineVisible().booleanValue()) {
                        return Reason.createTrueReason((String)"state has sub structure now");
                    }
                    if (!hasSubStruct && hint.getLineVisible().booleanValue()) {
                        return Reason.createTrueReason((String)"state has no sub structure anymore");
                    }
                }
                if ((last = containerShape.getChildren().size() - 1) >= 0 && (ga = ((Shape)containerShape.getChildren().get(last)).getGraphicsAlgorithm()) instanceof Text && !((Text)ga).getValue().equals(s.getName())) {
                    return Reason.createTrueReason((String)"State name is out of date");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                GraphicsAlgorithm ga;
                int last;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                State s = (State)bo;
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                if (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                    GraphicsAlgorithm borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0);
                    StateSupport.updateHints(s, (GraphicsAlgorithm)((RoundedRectangle)borderRect));
                }
                if ((last = containerShape.getChildren().size() - 1) >= 0 && (ga = ((Shape)containerShape.getChildren().get(last)).getGraphicsAlgorithm()) instanceof Text) {
                    ((Text)ga).setValue(s.getName());
                }
                return true;
            }
        }
    }
}

