/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class SupportUtil {
    private static final String INITIAL = "init";
    private static final String STATE = "state:";
    private static final String TP = "tp:";
    private static final String CP = "cp:";
    private static final String SEP = ".";

    public static boolean isInherited(StateGraphItem item, ContainerShape cs) {
        EObject container = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)cs);
        if (container instanceof StateGraph) {
            StateGraph sg = (StateGraph)container;
            return item.eContainer() != sg;
        }
        if (container instanceof State) {
            assert (item instanceof EntryPoint || item instanceof ExitPoint) : "this MUST be an entry or exit point";
            State s = (State)container;
            ContainerShape sCont = cs.getContainer();
            EObject cls = (EObject)sCont.getLink().getBusinessObjects().get(0);
            return s.eContainer() != cls;
        }
        return false;
    }

    public static boolean isInherited(Diagram diag, EObject obj) {
        if (obj instanceof RefinedState) {
            return true;
        }
        ActorClass parent = SupportUtil.getActorClass(diag);
        while (obj != null) {
            if (obj instanceof ActorClass) {
                return obj != parent;
            }
            obj = obj.eContainer();
        }
        assert (false) : "no parent actor class found";
        return false;
    }

    public static Diagram getDiagram(GraphicsAlgorithm ga) {
        if (ga.eContainer() instanceof GraphicsAlgorithm) {
            return SupportUtil.getDiagram((GraphicsAlgorithm)ga.eContainer());
        }
        return SupportUtil.getDiagram(ga.getPictogramElement());
    }

    public static Diagram getDiagram(PictogramElement pe) {
        while (pe.eContainer() != null) {
            if (pe.eContainer() instanceof Diagram) {
                return (Diagram)pe.eContainer();
            }
            pe = (PictogramElement)pe.eContainer();
        }
        return null;
    }

    public static ActorClass getActorClass(Diagram diag) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag);
        if (bo instanceof ActorClass) {
            return (ActorClass)bo;
        }
        return null;
    }

    public static StateGraph insertRefinedState(StateGraph sg, ActorClass ac, ContainerShape targetContainer, IFeatureProvider fp) {
        BaseState base = (BaseState)sg.eContainer();
        RefinedState rs = null;
        for (State s : ac.getStateMachine().getStates()) {
            if (!(s instanceof RefinedState) || ((RefinedState)s).getBase() != base) continue;
            rs = (RefinedState)s;
            break;
        }
        if (rs == null) {
            rs = RoomFactory.eINSTANCE.createRefinedState();
            rs.setBase(base);
            ac.getStateMachine().getStates().add((Object)rs);
        }
        sg = RoomFactory.eINSTANCE.createStateGraph();
        rs.setSubgraph(sg);
        fp.link((PictogramElement)targetContainer, (Object)sg);
        return sg;
    }

    public static void undoInsertRefinedState(StateGraph sg, ActorClass ac, ContainerShape targetContainer, IFeatureProvider fp) {
        RefinedState rs = (RefinedState)sg.eContainer();
        fp.link((PictogramElement)targetContainer, (Object)rs.getBase().getSubgraph());
        if (!RoomHelpers.hasDetailCode((DetailCode)rs.getEntryCode()) && !RoomHelpers.hasDetailCode((DetailCode)rs.getExitCode())) {
            ac.getStateMachine().getStates().remove((Object)rs);
        }
    }

    public static State getTargettingState(State state, Diagram diagram) {
        ActorClass ac = SupportUtil.getActorClass(diagram);
        return RoomHelpers.getTargettingState((State)state, (ActorClass)ac);
    }

    public static ContainerShape getStateGraphContainer(ContainerShape shape) {
        while (shape != null) {
            ContainerShape parent = shape.getContainer();
            if (parent instanceof Diagram) {
                return shape;
            }
            shape = parent;
        }
        return null;
    }

    public static StateGraph getStateGraph(ContainerShape cs, IFeatureProvider fp) {
        ContainerShape shape = SupportUtil.getStateGraphContainer(cs);
        Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof StateGraph) {
            return (StateGraph)bo;
        }
        assert (false) : "state graph expected";
        return null;
    }

    public static TransitionTerminal getTransitionTerminal(Anchor anchor, IFeatureProvider fp) {
        if (anchor != null) {
            Object obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent());
            if (obj instanceof TrPoint) {
                Object parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()));
                if (parent instanceof State) {
                    BaseState state = parent instanceof RefinedState ? ((RefinedState)parent).getBase() : (BaseState)parent;
                    SubStateTrPointTerminal sstpt = RoomFactory.eINSTANCE.createSubStateTrPointTerminal();
                    sstpt.setState(state);
                    sstpt.setTrPoint((TrPoint)obj);
                    return sstpt;
                }
                TrPointTerminal tpt = RoomFactory.eINSTANCE.createTrPointTerminal();
                tpt.setTrPoint((TrPoint)obj);
                return tpt;
            }
            if (obj instanceof State) {
                BaseState state = obj instanceof RefinedState ? ((RefinedState)obj).getBase() : (BaseState)obj;
                StateTerminal st = RoomFactory.eINSTANCE.createStateTerminal();
                st.setState(state);
                return st;
            }
            if (obj instanceof ChoicePoint) {
                ChoicepointTerminal ct = RoomFactory.eINSTANCE.createChoicepointTerminal();
                ct.setCp((ChoicePoint)obj);
                return ct;
            }
        }
        return null;
    }

    public static boolean isInitialPoint(Anchor anchor, IFeatureProvider fp) {
        Object parent;
        Object obj;
        return anchor != null && (obj = fp.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof StateGraph && (parent = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)anchor.getParent().eContainer()))) instanceof StateGraph;
    }

    public static boolean canConnect(Anchor asrc, Anchor atgt, ContainerShape cs, IFeatureProvider fp) {
        return SupportUtil.canConnect(asrc, atgt, null, cs, fp);
    }

    public static boolean canConnect(Anchor asrc, Anchor atgt, Transition trans, ContainerShape cs, IFeatureProvider fp) {
        TransitionTerminal src = SupportUtil.getTransitionTerminal(asrc, fp);
        TransitionTerminal tgt = SupportUtil.getTransitionTerminal(atgt, fp);
        if (src == null && !SupportUtil.isInitialPoint(asrc, fp)) {
            return false;
        }
        if (tgt == null) {
            return false;
        }
        StateGraph sg = SupportUtil.getStateGraph(cs, fp);
        if (sg == null) {
            return false;
        }
        return ValidationUtil.isConnectable((TransitionTerminal)src, (TransitionTerminal)tgt, (Transition)trans, (StateGraph)sg).isOk();
    }

    public static void deleteSubStructureRecursive(State s, ActorClass ac, Diagram diagram, IFeatureProvider fp) {
        if (RoomHelpers.hasSubStructure((State)s, (ActorClass)ac)) {
            StateGraph subgraph = s.getSubgraph();
            for (State st : subgraph.getStates()) {
                SupportUtil.deleteSubStructureRecursive(st, ac, diagram, fp);
            }
            ContainerShape subShape = ContextSwitcher.getContext(diagram, subgraph);
            CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)subShape, (IFeatureProvider)fp);
            EcoreUtil.delete((EObject)subShape, (boolean)true);
        }
    }

    public static List<State> getStates(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getStates(shape, fp, null);
    }

    public static List<State> getStates(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor) {
        ArrayList<State> items = new ArrayList<State>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof State)) continue;
            items.add((State)bo);
            if (item2anchor == null) continue;
            item2anchor.put(SupportUtil.getKey((EObject)((State)bo), null), (Anchor)ch.getAnchors().get(0));
        }
        return items;
    }

    public static List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getChoicePoints(shape, fp, null);
    }

    public static List<ChoicePoint> getChoicePoints(ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor) {
        ArrayList<ChoicePoint> items = new ArrayList<ChoicePoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof ChoicePoint)) continue;
            items.add((ChoicePoint)bo);
            if (item2anchor == null) continue;
            item2anchor.put(SupportUtil.getKey((EObject)((ChoicePoint)bo), null), (Anchor)ch.getAnchors().get(0));
        }
        return items;
    }

    public static List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp) {
        return SupportUtil.getTrPoints(sg, shape, fp, null);
    }

    public static List<TrPoint> getTrPoints(StateGraph sg, ContainerShape shape, IFeatureProvider fp, Map<String, Anchor> item2anchor) {
        ArrayList<TrPoint> items = new ArrayList<TrPoint>();
        for (Shape ch : shape.getChildren()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)ch);
            if (!(bo instanceof TrPoint)) continue;
            items.add((TrPoint)bo);
            if (item2anchor == null) continue;
            item2anchor.put(SupportUtil.getKey((EObject)((TrPoint)bo), sg), (Anchor)ch.getAnchors().get(0));
        }
        return items;
    }

    public static List<Transition> getTransitions(Diagram diagram, IFeatureProvider fp) {
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (Connection conn : diagram.getConnections()) {
            Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
            if (!(bo instanceof Transition)) continue;
            transitions.add((Transition)bo);
        }
        return transitions;
    }

    public static void getSubTpAnchors(ContainerShape sgShape, HashMap<String, Anchor> node2anchor) {
        for (Shape childShape : sgShape.getChildren()) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)childShape);
            if (!(bo instanceof State)) continue;
            SupportUtil.getAnchors((State)bo, (PictogramElement)childShape, node2anchor);
        }
    }

    public static void addTransitions(List<Transition> transitions, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        for (Transition trans : transitions) {
            String from = trans instanceof InitialTransition ? INITIAL : SupportUtil.getKey((EObject)((NonInitialTransition)trans).getFrom(), null);
            String to = SupportUtil.getKey((EObject)trans.getTo(), null);
            Anchor src = node2anchor.get(from);
            Anchor dst = node2anchor.get(to);
            assert (src != null && dst != null) : "transition endpoints must be present";
            AddConnectionContext context = new AddConnectionContext(src, dst);
            context.setNewObject((Object)trans);
            PictogramElement pe = fp.addIfPossible((IAddContext)context);
            if (src != dst || !(pe instanceof FreeFormConnection)) continue;
            FreeFormConnection conn = (FreeFormConnection)pe;
            ILocation begin = Graphiti.getPeService().getLocationRelativeToDiagram(conn.getStart());
            Point pt = Graphiti.getGaService().createPoint(begin.getX(), begin.getY() + 120);
            conn.getBendpoints().add((Object)pt);
        }
    }

    public static void addTransitionPoints(List<TrPoint> trps, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        int delta;
        int width = ((GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
        int n = trps.size();
        int pos = delta = width / (n + 1);
        for (TrPoint tp : trps) {
            SupportUtil.addTrPoint(tp, sgShape, pos + 30, fp, node2anchor);
            pos += delta;
        }
    }

    public static void addTrPoint(TrPoint tp, ContainerShape sgShape, int pos, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)tp);
        addContext.setTargetContainer(sgShape);
        addContext.setX(pos);
        addContext.setY(0);
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (!pe.getAnchors().isEmpty()) : "transition point should have an anchor";
        node2anchor.put(SupportUtil.getKey((EObject)tp, (StateGraph)tp.eContainer()), (Anchor)pe.getAnchors().get(0));
    }

    public static void addStates(List<State> states, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        int delta;
        int width = ((GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
        int n = states.size();
        int pos = delta = width / (n + 1);
        for (State s : states) {
            SupportUtil.addState(s, sgShape, pos + 30, fp, node2anchor);
            pos += delta;
        }
    }

    public static void addState(State s, ContainerShape sgShape, int pos, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)s);
        addContext.setTargetContainer(sgShape);
        addContext.setX(pos);
        addContext.setY(125);
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "state should have been created";
        assert (!pe.getAnchors().isEmpty()) : "state should have an anchor";
        node2anchor.put(SupportUtil.getKey((EObject)s, null), (Anchor)pe.getAnchors().get(0));
    }

    public static void addChoicePoints(List<ChoicePoint> cps, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        int delta;
        int width = ((GraphicsAlgorithm)sgShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
        int n = cps.size();
        int pos = delta = width / (n + 1);
        for (ChoicePoint cp : cps) {
            SupportUtil.addChoicePoint(cp, sgShape, pos + 40, fp, node2anchor);
            pos += delta;
        }
    }

    public static void addChoicePoint(ChoicePoint cp, ContainerShape sgShape, int pos, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)cp);
        addContext.setTargetContainer(sgShape);
        addContext.setX(pos);
        addContext.setY(250);
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "choice point should have been created";
        assert (!pe.getAnchors().isEmpty()) : "choice point should have an anchor";
        node2anchor.put(SupportUtil.getKey((EObject)cp, null), (Anchor)pe.getAnchors().get(0));
    }

    public static void addInitialPointIff(List<Transition> transitions, ContainerShape sgShape, IFeatureProvider fp, HashMap<String, Anchor> node2anchor) {
        StateGraph sg = null;
        for (Transition t : transitions) {
            if (!(t instanceof InitialTransition)) continue;
            sg = (StateGraph)t.eContainer();
            break;
        }
        if (sg == null) {
            return;
        }
        AddContext addContext = new AddContext();
        addContext.setNewObject(sg);
        addContext.setTargetContainer(sgShape);
        addContext.setX(120);
        addContext.setY(120);
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "initial point should have been created";
        assert (!pe.getAnchors().isEmpty()) : "initial point should have an anchor";
        node2anchor.put(INITIAL, (Anchor)pe.getAnchors().get(0));
    }

    public static void getAnchors(State state, PictogramElement stateShape, HashMap<String, Anchor> node2anchor) {
        if (stateShape instanceof ContainerShape) {
            node2anchor.put(SupportUtil.getKey((EObject)state, null), (Anchor)((ContainerShape)stateShape).getAnchors().get(0));
            for (Shape child : ((ContainerShape)stateShape).getChildren()) {
                EObject obj;
                ContainerShape childShape;
                if (!(child instanceof ContainerShape) || (childShape = (ContainerShape)child).getAnchors().isEmpty() || childShape.getLink().getBusinessObjects().isEmpty() || !((obj = (EObject)childShape.getLink().getBusinessObjects().get(0)) instanceof EntryPoint) && !(obj instanceof ExitPoint)) continue;
                node2anchor.put(SupportUtil.getKey(obj, null), (Anchor)childShape.getAnchors().get(0));
            }
        }
    }

    public static String getKey(EObject obj, StateGraph sg) {
        if (obj instanceof TrPoint) {
            TrPoint tp = (TrPoint)obj;
            if (tp.eContainer() == sg) {
                return TP + tp.getName();
            }
            if (tp.eContainer().eContainer() instanceof State) {
                State s = (State)tp.eContainer().eContainer();
                return TP + tp.getName() + SEP + s.getName();
            }
            assert (false) : "State expected";
        } else {
            if (obj instanceof State) {
                return STATE + ((State)obj).getName();
            }
            if (obj instanceof ChoicePoint) {
                return CP + ((ChoicePoint)obj).getName();
            }
            if (obj instanceof TransitionTerminal) {
                TransitionTerminal tt = (TransitionTerminal)obj;
                if (tt instanceof ChoicepointTerminal) {
                    return CP + ((ChoicepointTerminal)tt).getCp().getName();
                }
                if (tt instanceof StateTerminal) {
                    return STATE + ((StateTerminal)tt).getState().getName();
                }
                if (tt instanceof SubStateTrPointTerminal) {
                    SubStateTrPointTerminal sstt = (SubStateTrPointTerminal)tt;
                    return TP + sstt.getTrPoint().getName() + SEP + sstt.getState().getName();
                }
                if (tt instanceof TrPointTerminal) {
                    return TP + ((TrPointTerminal)tt).getTrPoint().getName();
                }
                assert (false) : "unexpected sub type";
            }
        }
        assert (false) : "unexpected type";
        return null;
    }
}

