/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.dialogs.TrPointPropertyDialog;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.support.NoResizeFeature;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILocationContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TrPointSupport {
    public static final int ITEM_SIZE = 20;
    public static final int ITEM_SIZE_SMALL = 11;
    public static final int MARGIN = 40;
    public static final int MARGIN_SMALL = 30;
    protected static final int LINE_WIDTH = 2;
    public static final IColorConstant DARK_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    protected static final IColorConstant BRIGHT_COLOR = new ColorConstant(255, 255, 255);
    protected static final String PROP_KIND = "item-kind";
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public TrPointSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private static void addItem(EObject ownObject, int x, int y, ContainerShape stateShape, IFeatureProvider fp) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)ownObject);
        addContext.setTargetContainer(stateShape);
        addContext.setX(x);
        addContext.setY(y);
        ContainerShape pe = (ContainerShape)fp.addIfPossible((IAddContext)addContext);
        assert (pe != null) : "transition point should have been created";
        assert (!pe.getAnchors().isEmpty()) : "transition point must have an anchor";
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Transition");
            button.setIconId("org.eclipse.etrice.ui.behavior.transition");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        protected IFeatureProvider fp;

        protected FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, Type.TRANS_POINT, "Transition Point", "Create Transition Point"), new CreateFeature(this.fp, Type.ENTRY_POINT, "Entry Point", "Create Entry Point"), new CreateFeature(this.fp, Type.EXIT_POINT, "Exit Point", "Create Exit Point")};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp)};
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void createFigure(TrPoint tp, boolean subtp, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightColor) {
            int margin = subtp ? 30 : 40;
            int size = subtp ? 11 : 20;
            int line = subtp ? 1 : 2;
            IGaService gaService = Graphiti.getGaService();
            Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
            circle.setForeground(darkColor);
            circle.setBackground(brightColor);
            circle.setLineWidth(Integer.valueOf(line));
            int s2 = size / 2;
            int offset = margin - s2;
            gaService.setLocationAndSize((GraphicsAlgorithm)circle, offset, offset, size, size);
            if (tp instanceof TransitionPoint) {
                if (!((TransitionPoint)tp).isHandler()) {
                    circle.setBackground(darkColor);
                }
            } else if (tp instanceof ExitPoint) {
                int[] nArray = new int[8];
                nArray[0] = s2;
                nArray[2] = size;
                nArray[3] = s2;
                nArray[4] = s2;
                nArray[5] = size;
                nArray[7] = s2;
                int[] xy = nArray;
                Polygon diamond = gaService.createPolygon((GraphicsAlgorithmContainer)invisibleRectangle, xy);
                diamond.setForeground(darkColor);
                diamond.setBackground(brightColor);
                diamond.setLineWidth(Integer.valueOf(line));
                gaService.setLocation((GraphicsAlgorithm)diamond, offset, offset);
            } else if (tp instanceof EntryPoint) {
                int sq = (int)(0.707106 * (double)s2);
                int[] l1 = new int[]{margin - sq, margin + sq, margin + sq, margin - sq};
                Polyline line1 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRectangle, l1);
                line1.setLineWidth(Integer.valueOf(line));
                line1.setForeground(darkColor);
                int[] l2 = new int[]{margin - sq, margin - sq, margin + sq, margin + sq};
                Polyline line2 = gaService.createPolyline((GraphicsAlgorithmContainer)invisibleRectangle, l2);
                line2.setLineWidth(Integer.valueOf(line));
                line2.setForeground(darkColor);
            }
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)circle);
            }
        }

        private static void updateTrPointFigure(TrPoint tp, PictogramElement pe, Color dark, Color bright) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm invisibleRect = pe.getGraphicsAlgorithm();
            while (!invisibleRect.getGraphicsAlgorithmChildren().isEmpty()) {
                EcoreUtil.delete((EObject)((EObject)invisibleRect.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
            }
            FeatureProvider.createFigure(tp, false, container, invisibleRect, dark, bright);
            GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
            if (ga instanceof Text) {
                ((Text)ga).setValue(tp.getName());
            }
        }

        protected static boolean isSubTP(PictogramElement pe) {
            if (!(pe instanceof ContainerShape)) {
                return false;
            }
            ContainerShape parentShape = ((ContainerShape)pe).getContainer();
            EObject parent = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)parentShape);
            return parent instanceof State;
        }

        protected static boolean isValidPosition(ILocationContext loc, ITargetContext tgt, int margin) {
            if (tgt.getTargetContainer().getGraphicsAlgorithm() == null) {
                return false;
            }
            if (tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().isEmpty()) {
                return false;
            }
            int x = loc.getX();
            int y = loc.getY();
            if (loc instanceof ICreateContext) {
                x -= margin;
                y -= margin;
            }
            int width = ((GraphicsAlgorithm)tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
            int height = ((GraphicsAlgorithm)tgt.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getHeight();
            boolean inStripe = false;
            int stripe = margin / 2;
            if (x <= stripe) {
                inStripe = true;
            } else if (y <= stripe) {
                inStripe = true;
            } else if (width - stripe <= x) {
                inStripe = true;
            } else if (height - stripe <= y) {
                inStripe = true;
            }
            return inStripe;
        }

        protected static String getItemKind(TrPoint item) {
            if (item instanceof TransitionPoint) {
                return ((TransitionPoint)item).isHandler() ? "htp" : "tp";
            }
            if (item instanceof EntryPoint) {
                return "entp";
            }
            if (item instanceof ExitPoint) {
                return "extp";
            }
            return "";
        }

        protected static void adjustLabel(Text label, int x, int y, int width, int margin, int size) {
            Orientation halign = Orientation.ALIGNMENT_CENTER;
            Orientation valign = Orientation.ALIGNMENT_CENTER;
            int pos = 0;
            if (x <= margin) {
                halign = Orientation.ALIGNMENT_LEFT;
            } else if (width - margin <= x) {
                halign = Orientation.ALIGNMENT_RIGHT;
            }
            if (y <= margin) {
                pos = 0;
                valign = Orientation.ALIGNMENT_BOTTOM;
            } else {
                pos = 5 * margin / 4;
                valign = Orientation.ALIGNMENT_TOP;
            }
            label.setHorizontalAlignment(halign);
            label.setVerticalAlignment(valign);
            if (pos != label.getY()) {
                IGaService gaService = Graphiti.getGaService();
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, pos, 2 * margin, 3 * margin / 4);
            }
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                if (context.getNewObject() instanceof TrPoint && context.getTargetContainer().getLink().getBusinessObjects().size() == 1) {
                    EObject obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                    if (obj instanceof StateGraph) {
                        return true;
                    }
                    if (obj instanceof State) {
                        return true;
                    }
                }
                return false;
            }

            public PictogramElement add(IAddContext context) {
                int dy;
                TrPoint tp = (TrPoint)context.getNewObject();
                ContainerShape parentShape = context.getTargetContainer();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)parentShape);
                boolean subtp = bo instanceof State;
                boolean inherited = subtp ? SupportUtil.isInherited(this.getDiagram(), (EObject)((State)bo)) : SupportUtil.isInherited((StateGraphItem)tp, parentShape);
                int margin = subtp ? 30 : 40;
                int size = subtp ? 11 : 20;
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(parentShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "trp");
                String kind = FeatureProvider.getItemKind(tp);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, TrPointSupport.PROP_KIND, kind);
                int x = context.getX();
                int y = context.getY();
                int width = parentShape.getGraphicsAlgorithm().getWidth();
                int height = parentShape.getGraphicsAlgorithm().getHeight();
                int dx = x <= width / 2 ? x : width - x;
                int n = dy = y <= height / 2 ? y : height - y;
                if (dx > dy) {
                    y = y <= height / 2 ? margin : height - margin;
                    if (x < margin) {
                        x = margin;
                    } else if (x > width - margin) {
                        x = width - margin;
                    }
                } else {
                    x = x <= width / 2 ? margin : width - margin;
                    if (y < margin) {
                        y = margin;
                    } else if (y > height - margin) {
                        y = height - margin;
                    }
                }
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x -= margin, y -= margin, 2 * margin, 2 * margin);
                FeatureProvider.createFigure(tp, subtp, containerShape, (GraphicsAlgorithm)invisibleRectangle, dark, this.manageColor(BRIGHT_COLOR));
                this.link((PictogramElement)containerShape, tp);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, tp.getName());
                label.setForeground(dark);
                label.setBackground(dark);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, margin + size / 2, 2 * margin, margin / 2);
                FeatureProvider.adjustLabel(label, x, y, width, margin, size);
                if (!subtp) {
                    this.createParentTP(tp, containerShape, parentShape);
                }
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }

            private void createParentTP(TrPoint tp, ContainerShape tpShape, ContainerShape subGraphShape) {
                if (tp instanceof TransitionPoint) {
                    return;
                }
                if (!(tp.eContainer().eContainer() instanceof State)) {
                    return;
                }
                State s = (State)tp.eContainer().eContainer();
                List elements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)s);
                if (elements.isEmpty()) {
                    Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)subGraphShape);
                    assert (bo instanceof StateGraph) : "expected state graph";
                    assert (((StateGraph)bo).eContainer() instanceof State) : "expected state";
                    s = (State)((StateGraph)bo).eContainer();
                    elements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)s);
                }
                assert (elements.size() == 1) : "expected unique pe";
                assert (elements.get(0) instanceof ContainerShape) : "expected state shape";
                ContainerShape stateShape = (ContainerShape)elements.get(0);
                GraphicsAlgorithm invisibleRect = stateShape.getGraphicsAlgorithm();
                GraphicsAlgorithm borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0);
                GraphicsAlgorithm invisibleSubRect = subGraphShape.getGraphicsAlgorithm();
                GraphicsAlgorithm borderSubRect = (GraphicsAlgorithm)invisibleSubRect.getGraphicsAlgorithmChildren().get(0);
                double scaleX = (double)borderRect.getWidth() / (double)borderSubRect.getWidth();
                double scaleY = (double)borderRect.getHeight() / (double)borderSubRect.getHeight();
                int mp = 50;
                int x = (int)((double)(tpShape.getGraphicsAlgorithm().getX() + mp - 40) * scaleX);
                int y = (int)((double)(tpShape.getGraphicsAlgorithm().getY() + mp - 40) * scaleY);
                TrPointSupport.addItem((EObject)tp, x + 30, y + 30, stateShape, FeatureProvider.this.fp);
            }
        }

        private static class CreateFeature
        extends AbstractCreateFeature {
            private boolean doneChanges = false;
            protected Type type;

            public CreateFeature(IFeatureProvider fp, Type type, String name, String description) {
                super(fp, name, description);
                this.type = type;
            }

            public String getCreateImageId() {
                switch (this.type) {
                    case ENTRY_POINT: {
                        return "org.eclipse.etrice.ui.behavior.entrypoint";
                    }
                    case EXIT_POINT: {
                        return "org.eclipse.etrice.ui.behavior.exitpoint";
                    }
                    case TRANS_POINT: {
                        return "org.eclipse.etrice.ui.behavior.trpoint";
                    }
                }
                return null;
            }

            public Object[] create(ICreateContext context) {
                ContainerShape targetContainer = context.getTargetContainer();
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                StateGraph sg = (StateGraph)targetContainer.getLink().getBusinessObjects().get(0);
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)sg);
                if (inherited) {
                    sg = SupportUtil.insertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                }
                EntryPoint tp = null;
                switch (this.type) {
                    case ENTRY_POINT: {
                        tp = RoomFactory.eINSTANCE.createEntryPoint();
                        break;
                    }
                    case EXIT_POINT: {
                        tp = RoomFactory.eINSTANCE.createExitPoint();
                        break;
                    }
                    case TRANS_POINT: {
                        tp = RoomFactory.eINSTANCE.createTransitionPoint();
                    }
                }
                tp.setName(RoomNameProvider.getUniqueTrPointName((StateGraph)sg));
                sg.getTrPoints().add((Object)tp);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                TrPointPropertyDialog dlg = new TrPointPropertyDialog(shell, (TrPoint)tp, false);
                if (dlg.open() != 0) {
                    if (inherited) {
                        SupportUtil.undoInsertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                    } else {
                        sg.getTrPoints().remove((Object)tp);
                    }
                    return EMPTY;
                }
                this.doneChanges = true;
                this.addGraphicalRepresentation((IAreaContext)context, tp);
                return new Object[]{tp};
            }

            public boolean canCreate(ICreateContext context) {
                EObject obj;
                if (context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph) {
                    StateGraph sg = (StateGraph)obj;
                    if (sg.eContainer() instanceof ActorClass && this.type != Type.TRANS_POINT) {
                        return false;
                    }
                    return FeatureProvider.isValidPosition((ILocationContext)context, (ITargetContext)context, 40);
                }
                return false;
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                if (FeatureProvider.isSubTP(context.getPictogramElement())) {
                    return false;
                }
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                TrPoint tp = (TrPoint)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (SupportUtil.isInherited((StateGraphItem)tp, containerShape)) {
                    return false;
                }
                return !ValidationUtil.isConnectedOutside((TrPoint)tp);
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                List elements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), bo);
                for (PictogramElement pe : elements) {
                    RemoveContext rc;
                    IRemoveFeature removeFeature;
                    if (pe == context.getPictogramElement() || (removeFeature = featureProvider.getRemoveFeature((IRemoveContext)(rc = new RemoveContext(pe)))) == null) continue;
                    removeFeature.remove((IRemoveContext)rc);
                }
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)this.getFeatureProvider());
            }
        }

        protected class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                boolean canMove = super.canMoveShape(context);
                if (canMove) {
                    Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                    if (bo instanceof TrPoint) {
                        TrPoint tp = (TrPoint)bo;
                        ContainerShape containerShape = context.getTargetContainer();
                        if (SupportUtil.isInherited((StateGraphItem)tp, containerShape)) {
                            return false;
                        }
                        if (FeatureProvider.isSubTP(context.getPictogramElement())) {
                            return true;
                        }
                        return FeatureProvider.isValidPosition((ILocationContext)context, (ITargetContext)context, 40);
                    }
                    return false;
                }
                return canMove;
            }

            protected void postMoveShape(IMoveShapeContext context) {
                int dy;
                ContainerShape shapeToMove = (ContainerShape)context.getShape();
                boolean subtp = FeatureProvider.isSubTP(context.getPictogramElement());
                int margin = subtp ? 30 : 40;
                int size = subtp ? 11 : 20;
                int x = context.getX();
                int y = context.getY();
                int width = ((GraphicsAlgorithm)context.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
                int height = ((GraphicsAlgorithm)context.getTargetContainer().getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getHeight();
                int dx = x <= width / 2 ? x : width - x;
                int n = dy = y <= height / 2 ? y : height - y;
                if (dx > dy) {
                    y = y <= height / 2 ? 0 : height - 0;
                    if (x < 0) {
                        x = 0;
                    } else if (x > width - 0) {
                        x = width - 0;
                    }
                } else {
                    x = x <= width / 2 ? 0 : width - 0;
                    if (y < 0) {
                        y = 0;
                    } else if (y > height - 0) {
                        y = height - 0;
                    }
                }
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
                GraphicsAlgorithm ga = ((Shape)shapeToMove.getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    FeatureProvider.adjustLabel((Text)ga, x, y, width, margin, size);
                }
            }

            private void adjustSubTPs(ContainerShape shapeToMove) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)shapeToMove);
                if (!(bo instanceof TrPoint)) {
                    assert (false) : "expected TrPoint";
                    return;
                }
                if (bo instanceof TransitionPoint) {
                    return;
                }
                List elements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), bo);
                if (elements.size() != 2) {
                    assert (false) : "should be this TrPoint and one sub TrPoint";
                    return;
                }
                PictogramElement subTpShape = (PictogramElement)elements.get(0);
                if (subTpShape == shapeToMove) {
                    subTpShape = (PictogramElement)elements.get(1);
                }
                GraphicsAlgorithm invisibleRect = shapeToMove.getContainer().getGraphicsAlgorithm();
                GraphicsAlgorithm borderRect = (GraphicsAlgorithm)invisibleRect.getGraphicsAlgorithmChildren().get(0);
                GraphicsAlgorithm invisibleSubRect = ((ContainerShape)subTpShape.eContainer()).getGraphicsAlgorithm();
                GraphicsAlgorithm borderSubRect = (GraphicsAlgorithm)invisibleSubRect.getGraphicsAlgorithmChildren().get(0);
                double scaleX = (double)borderSubRect.getWidth() / (double)borderRect.getWidth();
                double scaleY = (double)borderSubRect.getHeight() / (double)borderRect.getHeight();
                int x = (int)((double)shapeToMove.getGraphicsAlgorithm().getX() * scaleX);
                int y = (int)((double)shapeToMove.getGraphicsAlgorithm().getY() * scaleY);
                Graphiti.getGaService().setLocation(subTpShape.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
                GraphicsAlgorithm ga = ((Shape)((ContainerShape)subTpShape).getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    FeatureProvider.adjustLabel((Text)ga, x, y, borderRect.getWidth(), 40, 11);
                }
            }
        }

        private static class PropertyFeature
        extends AbstractCustomFeature {
            private String name = "Edit Transition Point";
            private String description = "Edit Transition Point";
            private boolean doneChanges = false;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && pes[0] instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof TrPoint;
            }

            public void execute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                TrPoint tp = (TrPoint)this.getBusinessObjectForPictogramElement(pe);
                boolean subtp = FeatureProvider.isSubTP(pe);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                TrPointPropertyDialog dlg = new TrPointPropertyDialog(shell, tp, subtp);
                if (dlg.open() != 0) {
                    throw new OperationCanceledException();
                }
                this.doneChanges = true;
                String kind = FeatureProvider.getItemKind(tp);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, TrPointSupport.PROP_KIND, kind);
                FeatureProvider.updateTrPointFigure(tp, pe, this.manageColor(DARK_COLOR), this.manageColor(BRIGHT_COLOR));
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof TrPoint;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Transition Point deleted from model");
                }
                TrPoint tp = (TrPoint)bo;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                GraphicsAlgorithm ga = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
                if (ga instanceof Text) {
                    if (!tp.getName().equals(((Text)ga).getValue())) {
                        return Reason.createTrueReason((String)"Name is out of date");
                    }
                    String kind = FeatureProvider.getItemKind(tp);
                    if (!kind.equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)context.getPictogramElement(), TrPointSupport.PROP_KIND))) {
                        return Reason.createTrueReason((String)"Figure is out of date");
                    }
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                TrPoint tp = (TrPoint)bo;
                boolean inherited = SupportUtil.isInherited((StateGraphItem)tp, containerShape);
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                FeatureProvider.updateTrPointFigure(tp, (PictogramElement)containerShape, dark, this.manageColor(BRIGHT_COLOR));
                String kind = FeatureProvider.getItemKind(tp);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, TrPointSupport.PROP_KIND, kind);
                return true;
            }
        }
    }

    static enum Type {
        TRANS_POINT,
        ENTRY_POINT,
        EXIT_POINT;

    }
}

