/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.dialogs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xtext.resource.IEObjectDescription;

public abstract class AbstractPropertyDialog
extends FormDialog {
    private String title;
    private FormToolkit toolkit;
    private DataBindingContext bindingContext;
    private HashMap<Control, ControlDecoration> decoratorMap = new HashMap();
    private Label validationLabel;
    private Label validationText;
    private AggregateValidationStatus aggregateValidationStatus;

    public AbstractPropertyDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
    }

    protected abstract Image getImage();

    protected void createFormContent(IManagedForm mform) {
        this.toolkit = mform.getToolkit();
        this.bindingContext = new DataBindingContext();
        Form form = mform.getForm().getForm();
        form.setText(this.title);
        form.setImage(this.getImage());
        mform.getToolkit().decorateFormHeading(form);
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(768));
        this.validationLabel = this.toolkit.createLabel(body, "", 0);
        this.validationLabel.setText("ERROR:");
        this.validationLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.validationText = this.toolkit.createLabel(body, "", 0);
        this.validationText.setLayoutData((Object)new GridData(768));
        this.createContent(mform, body, this.bindingContext);
        this.aggregateValidationStatus = new AggregateValidationStatus((IObservableCollection)this.bindingContext.getBindings(), 2);
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.validationText), (IObservableValue)this.aggregateValidationStatus, null, null);
        this.aggregateValidationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                boolean ok = true;
                for (Object o : AbstractPropertyDialog.this.bindingContext.getBindings()) {
                    ControlDecoration decoration;
                    Binding binding = (Binding)o;
                    IStatus status = (IStatus)binding.getValidationStatus().getValue();
                    Control control = null;
                    if (binding.getTarget() instanceof ISWTObservable) {
                        ISWTObservable swtObservable = (ISWTObservable)binding.getTarget();
                        control = (Control)swtObservable.getWidget();
                    }
                    if ((decoration = (ControlDecoration)AbstractPropertyDialog.this.decoratorMap.get(control)) == null) continue;
                    if (status.isOK()) {
                        decoration.hide();
                        continue;
                    }
                    ok = false;
                    decoration.setDescriptionText(status.getMessage());
                    decoration.show();
                }
                AbstractPropertyDialog.this.updateValidationFeedback(ok);
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        Object value = this.aggregateValidationStatus.getValue();
        if (value instanceof IStatus) {
            boolean ok = ((IStatus)value).isOK();
            this.updateValidationFeedback(ok);
        }
        return bar;
    }

    protected void updateValidationFeedback(boolean ok) {
        if (this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setVisible(!ok);
        this.validationText.setVisible(!ok);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(ok);
        }
    }

    protected void setValidationText(String text) {
        this.validationText.setText(text);
    }

    protected abstract void createContent(IManagedForm var1, Composite var2, DataBindingContext var3);

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att) {
        return this.createText(parent, label, obj, att, null);
    }

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att, IValidator validator) {
        return this.createText(parent, label, obj, att, validator, false);
    }

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att, IValidator validator, boolean multiline) {
        return this.createText(parent, label, obj, (EStructuralFeature)att, validator, null, null, multiline);
    }

    protected Text createText(Composite parent, String label, EObject obj, EStructuralFeature feat, IValidator validator, IConverter s2m, IConverter m2s, boolean multiline) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        int style = 2048;
        if (multiline) {
            style |= 0x302;
        }
        Text text = this.toolkit.createText(parent, "", style);
        GridData gd = new GridData(multiline ? 1808 : 768);
        text.setLayoutData((Object)gd);
        UpdateValueStrategy t2m = null;
        UpdateValueStrategy m2t = null;
        if (validator != null || s2m != null || m2s != null) {
            t2m = new UpdateValueStrategy();
            if (s2m != null) {
                t2m.setConverter(s2m);
            }
            if (validator != null) {
                t2m.setAfterConvertValidator(validator);
                t2m.setBeforeSetValidator(validator);
            }
            m2t = new UpdateValueStrategy();
            if (m2s != null) {
                m2t.setConverter(m2s);
            }
            if (validator != null) {
                m2t.setAfterConvertValidator(validator);
                m2t.setBeforeSetValidator(validator);
            }
        }
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), PojoObservables.observeValue((Object)obj, (String)feat.getName()), t2m, m2t);
        return text;
    }

    protected Button createCheck(Composite parent, String label, EObject obj, EAttribute att) {
        return this.createCheck(parent, label, obj, att, null);
    }

    protected Button createCheck(Composite parent, String label, EObject obj, EAttribute att, IValidator validator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Button check = this.toolkit.createButton(parent, "", 32);
        check.setLayoutData((Object)new GridData(768));
        UpdateValueStrategy t2m = null;
        UpdateValueStrategy m2t = null;
        if (validator != null) {
            t2m = new UpdateValueStrategy();
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t = new UpdateValueStrategy();
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)check), PojoObservables.observeValue((Object)obj, (String)att.getName()), t2m, m2t);
        return check;
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EReference ref, List<? extends EObject> candidates, EAttribute nameAttr) {
        return this.createCombo(parent, label, obj, type, ref, candidates, nameAttr, null);
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EReference ref, List<? extends EObject> candidates, EAttribute nameAttr, IValidator validator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(256));
        combo.setVisibleItemCount(10);
        this.toolkit.adapt((Control)combo, true, true);
        Reference2StringConverter r2s = new Reference2StringConverter(type, nameAttr);
        for (EObject eObject : candidates) {
            combo.add((String)r2s.convert(eObject));
        }
        String2ReferenceConverter string2ReferenceConverter = new String2ReferenceConverter(type, candidates, nameAttr);
        UpdateValueStrategy t2m = new UpdateValueStrategy().setConverter((IConverter)string2ReferenceConverter);
        UpdateValueStrategy m2t = new UpdateValueStrategy().setConverter((IConverter)r2s);
        if (validator != null) {
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)combo), PojoObservables.observeValue((Object)obj, (String)ref.getName()), t2m, m2t);
        return combo;
    }

    protected Combo createComboUsingDesc(Composite parent, String label, EObject obj, Object type, EReference ref, List<IEObjectDescription> candidates, EAttribute nameAttr, IValidator validator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(256));
        combo.setVisibleItemCount(10);
        this.toolkit.adapt((Control)combo, true, true);
        DescriptionBased_Reference2StringConverter r2s = new DescriptionBased_Reference2StringConverter(type, nameAttr);
        for (IEObjectDescription desc : candidates) {
            combo.add(r2s.convert(desc).toString());
        }
        DescriptionBased_String2ReferenceConverter s2r = new DescriptionBased_String2ReferenceConverter(type, obj, candidates);
        UpdateValueStrategy t2m = new UpdateValueStrategy().setConverter((IConverter)s2r);
        UpdateValueStrategy m2t = new UpdateValueStrategy().setConverter((IConverter)r2s);
        if (validator != null) {
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)combo), PojoObservables.observeValue((Object)obj, (String)ref.getName()), t2m, m2t);
        return combo;
    }

    protected ControlDecoration createDecorator(Control ctrl, String message) {
        ControlDecoration controlDecoration = new ControlDecoration(ctrl, 16512);
        controlDecoration.setDescriptionText(message);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        this.decoratorMap.put(ctrl, controlDecoration);
        return controlDecoration;
    }

    protected DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    static class DescriptionBased_Reference2StringConverter
    extends Converter {
        private EAttribute nameAttr;

        DescriptionBased_Reference2StringConverter(Object type, EAttribute nameAttr) {
            super(type, String.class);
            this.nameAttr = nameAttr;
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof IEObjectDescription) {
                return ((IEObjectDescription)fromObject).getName();
            }
            if (fromObject instanceof EObject) {
                return ((EObject)fromObject).eGet((EStructuralFeature)this.nameAttr);
            }
            return null;
        }
    }

    static class DescriptionBased_String2ReferenceConverter
    extends Converter {
        private EObject obj;
        private List<IEObjectDescription> candidates;

        DescriptionBased_String2ReferenceConverter(Object type, EObject obj, List<IEObjectDescription> candidates) {
            super(String.class, type);
            this.obj = obj;
            this.candidates = candidates;
        }

        public Object convert(Object fromObject) {
            for (IEObjectDescription desc : this.candidates) {
                if (!desc.getName().toString().equals(fromObject)) continue;
                EObject refObj = desc.getEObjectOrProxy();
                if (refObj.eIsProxy()) {
                    refObj = EcoreUtil.resolve((EObject)refObj, (EObject)this.obj);
                }
                return refObj;
            }
            return null;
        }
    }

    static class Reference2StringConverter
    extends Converter {
        private EAttribute nameAttr;

        Reference2StringConverter(Object type, EAttribute nameAttr) {
            super(type, String.class);
            this.nameAttr = nameAttr;
        }

        public Object convert(Object fromObject) {
            return ((EObject)fromObject).eGet((EStructuralFeature)this.nameAttr);
        }
    }

    static class String2ReferenceConverter
    extends Converter {
        private List<? extends EObject> candidates;
        private EAttribute nameAttr;

        String2ReferenceConverter(Object type, List<? extends EObject> candidates, EAttribute nameAttr) {
            super(String.class, type);
            this.candidates = candidates;
            this.nameAttr = nameAttr;
        }

        public Object convert(Object fromObject) {
            for (EObject eObject : this.candidates) {
                if (!eObject.eGet((EStructuralFeature)this.nameAttr).equals(fromObject)) continue;
                return eObject;
            }
            return null;
        }
    }
}

