/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.editor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.ui.common.editor.ModificationTrackingEnabler;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class RoomDiagramEditor
extends DiagramEditor {
    @Inject
    protected IResourceValidator resourceValidator;
    private ModificationTrackingEnabler mte = new ModificationTrackingEnabler();

    public RoomDiagramEditor() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        Map result = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)this.getEditingDomain().getResourceSet());
        if (!result.isEmpty()) {
            System.err.println("ERROR in diagram viewer: could not resolve all proxies!");
        }
        this.mte.setTarget(this.getEditingDomain());
    }

    public void dispose() {
        this.mte.unsetTarget(this.getEditingDomain());
        super.dispose();
    }

    public void doSave(final IProgressMonitor monitor) {
        ResourceSet rs = this.getEditingDomain().getResourceSet();
        for (Resource res : rs.getResources()) {
            if (!(res instanceof XtextResource) || !res.isModified()) continue;
            XtextResource xres = (XtextResource)res;
            ISerializer serializer = xres.getSerializer();
            if (xres.getContents().isEmpty()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: part of textual model is empty, can't save");
                return;
            }
            serializer.serialize((EObject)xres.getContents().get(0));
            List result = this.resourceValidator.validate(res, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            if (result.isEmpty()) continue;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: model is invalid, can't save");
            return;
        }
        super.doSave(monitor);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.doSave(null);
    }

    public void setFocus() {
        boolean dirtyAlready = this.isDirty();
        super.setFocus();
        if (!dirtyAlready && this.isDirty()) {
            this.doSave(null);
        }
    }
}

