/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.dialogs;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.dialogs.AbstractPropertyDialog;
import org.eclipse.etrice.ui.structure.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class PortPropertyDialog
extends AbstractPropertyDialog {
    private Port port;
    private IScope scope;
    private ActorContainerClass acc;
    private boolean newPort;
    private boolean refitem;
    private boolean internal;
    private Button relayCheck = null;
    private boolean relay;

    public PortPropertyDialog(Shell shell, Port port, IScope scope, ActorContainerClass acc, boolean newPort, boolean refitem, boolean internal) {
        super(shell, "Edit Port");
        this.port = port;
        this.scope = scope;
        this.acc = acc;
        this.newPort = newPort;
        this.refitem = refitem;
        this.internal = internal;
        this.relay = this.isPortRelay();
    }

    private boolean isPortRelay() {
        if (this.internal) {
            return false;
        }
        if (this.acc instanceof SubSystemClass) {
            return true;
        }
        if (this.acc instanceof ActorClass) {
            for (ExternalPort xp : ((ActorClass)this.acc).getExtPorts()) {
                if (xp.getIfport() != this.port) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point size = this.getShell().getSize();
        this.getShell().setSize((int)((double)size.x * 1.2), size.y);
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        boolean connected = ValidationUtil.isConnected((Port)this.port, null, (StructureClass)this.acc);
        NameValidator nv = new NameValidator();
        ProtocolValidator pv = new ProtocolValidator();
        MultiplicityValidator mv = new MultiplicityValidator(this.newPort || !connected, this.port.getMultiplicity());
        ArrayList<IEObjectDescription> protocols = new ArrayList<IEObjectDescription>();
        for (IEObjectDescription desc : this.scope.getAllElements()) {
            EObject obj = desc.getEObjectOrProxy();
            if (!(obj instanceof ProtocolClass)) continue;
            protocols.add(desc);
        }
        Text name = this.createText(body, "Name:", (EObject)this.port, RoomPackage.eINSTANCE.getInterfaceItem_Name(), nv);
        Combo protocol = this.createComboUsingDesc(body, "Protocol:", (EObject)this.port, ProtocolClass.class, RoomPackage.eINSTANCE.getInterfaceItem_Protocol(), protocols, RoomPackage.eINSTANCE.getRoomClass_Name(), pv);
        Button conj = this.createCheck(body, "Conjugated:", (EObject)this.port, RoomPackage.eINSTANCE.getPort_Conjugated());
        if (!this.internal && !this.refitem && this.acc instanceof ActorClass) {
            this.createRelayCheck(body, mform.getToolkit());
        }
        Multiplicity2StringConverter m2s = new Multiplicity2StringConverter();
        String2MultiplicityConverter s2m = new String2MultiplicityConverter();
        Text multi = this.createText(body, "Multiplicity:", (EObject)this.port, (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity(), mv, (IConverter)s2m, (IConverter)m2s, false);
        if (!this.newPort) {
            if (connected) {
                protocol.setEnabled(false);
                conj.setEnabled(false);
                if (this.port.getMultiplicity() == 1) {
                    multi.setEnabled(false);
                }
            }
            if (this.refitem) {
                name.setEnabled(false);
                protocol.setEnabled(false);
                conj.setEnabled(false);
                multi.setEnabled(false);
            }
        }
        this.createDecorator((Control)name, "invalid name");
        this.createDecorator((Control)protocol, "no protocol selected");
        this.createDecorator((Control)multi, "multiplicity must be greater 1");
        name.selectAll();
        name.setFocus();
    }

    private void createRelayCheck(Composite parent, FormToolkit toolkit) {
        Label l = toolkit.createLabel(parent, "Is Relay Port:", 0);
        l.setLayoutData((Object)new GridData(0));
        this.relayCheck = toolkit.createButton(parent, "", 32);
        this.relayCheck.setLayoutData((Object)new GridData(768));
        this.relayCheck.setSelection(this.relay);
        if (ValidationUtil.isConnected((Port)this.port, null, (StructureClass)this.acc)) {
            this.relayCheck.setEnabled(false);
        }
    }

    protected void okPressed() {
        if (this.relayCheck != null && this.relay != this.relayCheck.getSelection()) {
            this.relay = this.relayCheck.getSelection();
            ActorClass ac = (ActorClass)this.acc;
            if (this.relay) {
                for (ExternalPort xp : ac.getExtPorts()) {
                    if (xp.getIfport() != this.port) continue;
                    ac.getExtPorts().remove((Object)xp);
                    break;
                }
            } else {
                ExternalPort xp = RoomFactory.eINSTANCE.createExternalPort();
                xp.setIfport(this.port);
                ac.getExtPorts().add((Object)xp);
            }
        }
        super.okPressed();
    }

    protected Image getImage() {
        return Activator.getImage("icons/Structure.gif");
    }

    static class Multiplicity2StringConverter
    extends Converter {
        public Multiplicity2StringConverter() {
            super(Integer.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof Integer) {
                int val = (Integer)fromObject;
                if (val == -1) {
                    return "*";
                }
                return fromObject.toString();
            }
            return fromObject;
        }
    }

    class MultiplicityValidator
    implements IValidator {
        private boolean mayChange;
        private int old;

        public MultiplicityValidator(boolean mayChange, int old) {
            this.mayChange = mayChange;
            this.old = old;
        }

        public IStatus validate(Object value) {
            if (value instanceof Integer) {
                int m = (Integer)value;
                if (m == 0) {
                    return ValidationStatus.error((String)"multiplicity must not be 0");
                }
                if (m < -1) {
                    return ValidationStatus.error((String)"multiplicity must be -1 or positive");
                }
                if (!this.mayChange) {
                    if (this.old == 1 && (m > 1 || m == -1)) {
                        return ValidationStatus.error((String)"cannot make connected port replicated");
                    }
                    if ((this.old > 1 || this.old == -1) && m == 1) {
                        return ValidationStatus.error((String)"cannot make connected port not replicated");
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                ValidationUtil.Result result = ValidationUtil.isUniqueName((InterfaceItem)PortPropertyDialog.this.port, (String)name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }

    class ProtocolValidator
    implements IValidator {
        ProtocolValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                return ValidationStatus.error((String)"select a protocol");
            }
            return Status.OK_STATUS;
        }
    }

    static class String2MultiplicityConverter
    extends Converter {
        String2MultiplicityConverter() {
            super(String.class, Integer.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject.equals("*")) {
                return -1;
            }
            return Integer.parseInt((String)fromObject);
        }
    }
}

