/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultReconnectionFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class BindingSupport {
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public BindingSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }
    }

    class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        private boolean isInherited(Diagram diag, Binding b) {
            ActorContainerClass ac = (ActorContainerClass)Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diag.getChildren().get(0));
            return b.eContainer() != ac;
        }

        public ICreateConnectionFeature[] getCreateConnectionFeatures() {
            return new ICreateConnectionFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IReconnectionFeature getReconnectionFeature(IReconnectionContext context) {
            return new ReconnectionFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context instanceof IAddConnectionContext && context.getNewObject() instanceof Binding;
            }

            public PictogramElement add(IAddContext context) {
                IAddConnectionContext addConContext = (IAddConnectionContext)context;
                Binding bind = (Binding)context.getNewObject();
                boolean inherited = FeatureProvider.this.isInherited(this.getDiagram(), bind);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
                connection.setStart(addConContext.getSourceAnchor());
                connection.setEnd(addConContext.getTargetAnchor());
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "obj-type", "bind");
                IGaService gaService = Graphiti.getGaService();
                Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
                polyline.setForeground(this.manageColor(inherited ? INHERITED_COLOR : LINE_COLOR));
                this.link((PictogramElement)connection, bind);
                return connection;
            }
        }

        private class CreateFeature
        extends AbstractCreateConnectionFeature {
            private boolean justStarted;

            public CreateFeature(IFeatureProvider fp) {
                super(fp, "Binding", "create Binding");
                this.justStarted = false;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.binding";
            }

            public boolean canCreate(ICreateConnectionContext context) {
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getSourceAnchor(), featureProvider);
                Port tgt = SupportUtil.getPort(context.getTargetAnchor(), featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                if (this.justStarted) {
                    this.justStarted = false;
                    this.beginHighLightMatches(src, srcRef);
                }
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getParent(context, featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                return ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, (Port)tgt, (ActorContainerRef)tgtRef, (StructureClass)ac).isOk();
            }

            public boolean canStartConnection(ICreateConnectionContext context) {
                boolean canStart;
                Port src = SupportUtil.getPort(context.getSourceAnchor(), this.getFeatureProvider());
                boolean bl = canStart = src != null;
                if (canStart) {
                    ActorContainerRef ref = SupportUtil.getRef(context.getSourceAnchor(), this.getFeatureProvider());
                    if (ref == null) {
                        ActorContainerClass acc = (ActorContainerClass)src.eContainer();
                        if (!ValidationUtil.isConnectable((Port)src, null, (StructureClass)acc).isOk()) {
                            canStart = false;
                        }
                    } else {
                        ActorContainerClass acc = (ActorContainerClass)ref.eContainer();
                        if (!ValidationUtil.isConnectable((Port)src, (ActorContainerRef)ref, (StructureClass)acc).isOk()) {
                            canStart = false;
                        }
                    }
                }
                if (canStart) {
                    this.justStarted = true;
                }
                return canStart;
            }

            public Connection create(ICreateConnectionContext context) {
                Connection newConnection = null;
                this.endHighLightMatches();
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getSourceAnchor(), featureProvider);
                Port dst = SupportUtil.getPort(context.getTargetAnchor(), featureProvider);
                StructureClass ac = SupportUtil.getParent(context, featureProvider);
                if (src != null && dst != null && ac != null) {
                    Binding bind = RoomFactory.eINSTANCE.createBinding();
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getRef(context.getSourceAnchor(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getRef(context.getTargetAnchor(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                    ac.getBindings().add((Object)bind);
                    AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                    addContext.setNewObject((Object)bind);
                    newConnection = (Connection)featureProvider.addIfPossible((IAddContext)addContext);
                }
                return newConnection;
            }

            private void beginHighLightMatches(Port port, ActorContainerRef ref) {
                if (port == null) {
                    return;
                }
                ActorContainerClass acc = (ActorContainerClass)(ref != null ? ref.eContainer() : port.eContainer());
                if (!(acc instanceof ActorClass) && !(acc instanceof SubSystemClass) && !(acc instanceof LogicalSystem)) assert (false) : "unknown kind of StructureClass";
            }

            private void endHighLightMatches() {
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(context.getPictogramElement());
                if (bo instanceof Binding) {
                    Binding b = (Binding)bo;
                    if (FeatureProvider.this.isInherited(this.getDiagram(), b)) {
                        return false;
                    }
                }
                return true;
            }
        }

        private class ReconnectionFeature
        extends DefaultReconnectionFeature {
            private boolean doneChanges;

            public ReconnectionFeature(IFeatureProvider fp) {
                super(fp);
                this.doneChanges = false;
            }

            public boolean canReconnect(IReconnectionContext context) {
                if (!super.canReconnect(context)) {
                    return false;
                }
                Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                if (FeatureProvider.this.isInherited(this.getDiagram(), bind)) {
                    return false;
                }
                Anchor asrc = context.getConnection().getStart();
                Anchor atgt = context.getConnection().getEnd();
                if (context.getReconnectType().equals(ReconnectionContext.RECONNECT_SOURCE)) {
                    asrc = context.getNewAnchor();
                } else {
                    atgt = context.getNewAnchor();
                }
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(asrc, featureProvider);
                Port tgt = SupportUtil.getPort(atgt, featureProvider);
                ActorContainerRef srcRef = SupportUtil.getRef(asrc, featureProvider);
                if (src == null || tgt == null) {
                    return false;
                }
                StructureClass ac = SupportUtil.getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (ac == null) {
                    return false;
                }
                ActorContainerRef tgtRef = SupportUtil.getRef(atgt, featureProvider);
                return ValidationUtil.isConnectable((Port)src, (ActorContainerRef)srcRef, (Port)tgt, (ActorContainerRef)tgtRef, (StructureClass)ac, (Binding)bind).isOk();
            }

            public void postReconnect(IReconnectionContext context) {
                super.postReconnect(context);
                IFeatureProvider featureProvider = this.getFeatureProvider();
                Port src = SupportUtil.getPort(context.getConnection().getStart(), featureProvider);
                Port dst = SupportUtil.getPort(context.getConnection().getEnd(), featureProvider);
                StructureClass ac = SupportUtil.getParent((ContainerShape)this.getDiagram(), featureProvider);
                if (src != null && dst != null && ac != null) {
                    this.doneChanges = true;
                    Binding bind = (Binding)this.getBusinessObjectForPictogramElement((PictogramElement)context.getConnection());
                    BindingEndPoint ep1 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar1 = SupportUtil.getRef(context.getConnection().getStart(), featureProvider);
                    ep1.setPort(src);
                    ep1.setActorRef(ar1);
                    BindingEndPoint ep2 = RoomFactory.eINSTANCE.createBindingEndPoint();
                    ActorContainerRef ar2 = SupportUtil.getRef(context.getConnection().getEnd(), featureProvider);
                    ep2.setPort(dst);
                    ep2.setActorRef(ar2);
                    bind.setEndpoint1(ep1);
                    bind.setEndpoint2(ep2);
                }
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return bo instanceof EObject && ((EObject)bo).eIsProxy();
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Binding deleted from model");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                PictogramElement pe = context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement(pe);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext(pe);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                return false;
            }
        }
    }
}

