/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.structure.DiagramTypeProvider;
import org.eclipse.etrice.ui.structure.dialogs.PortPropertyDialog;
import org.eclipse.etrice.ui.structure.support.InterfaceItemSupport;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class PortSupport
extends InterfaceItemSupport {
    private static final int REPL_OFFSET = 5;
    private static final int REPL_OFFSET_SMALL = 2;
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public PortSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private static String getPortKind(Port port) {
        String kind = "";
        if (port.isConjugated()) {
            kind = String.valueOf(kind) + "C";
        }
        if (ValidationUtil.isRelay((Port)port)) {
            kind = String.valueOf(kind) + "R";
        }
        if (port.isReplicated()) {
            kind = String.valueOf(kind) + "M";
        }
        return kind;
    }

    private class BehaviorProvider
    extends InterfaceItemSupport.BehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Binding");
            button.setIconId("org.eclipse.etrice.ui.structure.binding");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends InterfaceItemSupport.FeatureProvider {
        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp, fp);
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, true), new CreateFeature(this.fp, false)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp)};
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        @Override
        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void createPortFigure(Port port, boolean refport, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
            Rectangle rect;
            boolean relay = ValidationUtil.isRelay((Port)port);
            int size = refport ? 18 : 40;
            int margin = refport ? 30 : 40;
            int offset = refport ? 2 : 5;
            int line = refport ? 1 : 2;
            Color bg = brightDolor;
            bg = refport ? (port.isConjugated() ? brightDolor : darkColor) : (!port.isConjugated() && !relay ? darkColor : brightDolor);
            IGaService gaService = Graphiti.getGaService();
            if (port.isReplicated()) {
                rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                rect.setForeground(darkColor);
                rect.setBackground(brightDolor);
                rect.setLineWidth(Integer.valueOf(line));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, margin - size / 2 + offset, margin - size / 2 - offset, size, size);
            }
            rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
            rect.setForeground(darkColor);
            rect.setBackground(bg);
            if (!refport && relay && !port.isConjugated()) {
                rect.setLineWidth(Integer.valueOf(4 * line));
            } else {
                rect.setLineWidth(Integer.valueOf(line));
            }
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, margin - size / 2, margin - size / 2, size, size);
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
            } else {
                ((Anchor)containerShape.getAnchors().get(0)).setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
            }
            if (!(refport || !port.isConjugated() && relay)) {
                if (relay) {
                    Rectangle inset = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                    inset.setForeground(darkColor);
                    inset.setBackground(darkColor);
                    inset.setLineWidth(Integer.valueOf(2));
                    gaService.setLocationAndSize((GraphicsAlgorithm)inset, margin - size / 4, margin - size / 4, size / 2, size / 2);
                } else {
                    Color fill = port.isConjugated() ? darkColor : brightDolor;
                    Ellipse inset = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
                    inset.setForeground(fill);
                    inset.setBackground(fill);
                    inset.setLineWidth(Integer.valueOf(2));
                    gaService.setLocationAndSize((GraphicsAlgorithm)inset, margin - size / 4, margin - size / 4, size / 2, size / 2);
                }
            }
        }

        private static void updatePortFigure(Port port, PictogramElement pe, Color dark, Color bright) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm invisibleRect = pe.getGraphicsAlgorithm();
            invisibleRect.getGraphicsAlgorithmChildren().clear();
            FeatureProvider.createPortFigure(port, false, container, invisibleRect, dark, bright);
            GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
            if (ga instanceof Text) {
                ((Text)ga).setValue(port.getName());
            }
        }

        private static class AddFeature
        extends InterfaceItemSupport.FeatureProvider.AddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof Port) {
                    return PortSupport.getPortKind((Port)item);
                }
                return "";
            }

            @Override
            protected void createItemFigure(InterfaceItem item, boolean refitem, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
                if (item instanceof Port) {
                    FeatureProvider.createPortFigure((Port)item, refitem, containerShape, invisibleRectangle, darkColor, brightDolor);
                }
            }
        }

        private class CreateFeature
        extends InterfaceItemSupport.FeatureProvider.CreateFeature {
            public CreateFeature(IFeatureProvider fp, boolean internal) {
                super(fp, internal, internal ? "Internal Port" : "Interface Port", internal ? "create internal Port" : "create interface Port");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.port";
            }

            public Object[] create(ICreateContext context) {
                ActorContainerClass acc = (ActorContainerClass)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                Port port = RoomFactory.eINSTANCE.createPort();
                port.setName(RoomNameProvider.getUniqueInterfaceItemName((String)"p", (ActorContainerClass)acc));
                ExternalPort xp = null;
                if (acc instanceof ActorClass) {
                    ActorClass ac = (ActorClass)acc;
                    if (this.internal) {
                        ac.getIntPorts().add((Object)port);
                    } else {
                        ac.getIfPorts().add((Object)port);
                        xp = RoomFactory.eINSTANCE.createExternalPort();
                        xp.setIfport(port);
                        ac.getExtPorts().add((Object)xp);
                    }
                } else if (acc instanceof SubSystemClass) {
                    SubSystemClass ssc = (SubSystemClass)acc;
                    ssc.getRelayPorts().add((Object)port);
                } else assert (false) : "ActorClass or SubSystemClass expected";
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                IScope scope = scopeProvider.getScope((EObject)port, RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PortPropertyDialog dlg = new PortPropertyDialog(shell, port, scope, acc, true, false, this.internal);
                if (dlg.open() != 0) {
                    if (acc instanceof ActorClass) {
                        ActorClass ac = (ActorClass)acc;
                        if (this.internal) {
                            ac.getIntPorts().remove((Object)port);
                        } else {
                            ac.getIfPorts().remove((Object)port);
                            ac.getExtPorts().remove((Object)xp);
                        }
                    } else if (acc instanceof SubSystemClass) {
                        SubSystemClass ssc = (SubSystemClass)acc;
                        ssc.getRelayPorts().remove((Object)port);
                    }
                    return EMPTY;
                }
                this.doneChanges = true;
                this.addGraphicalRepresentation((IAreaContext)context, port);
                return new Object[]{port};
            }
        }

        private static class DeleteFeature
        extends InterfaceItemSupport.FeatureProvider.DeleteFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            protected void deleteBusinessObject(Object bo) {
                Port port;
                if (bo instanceof Port && (port = (Port)bo).eContainer() instanceof ActorClass) {
                    ExternalPort external = null;
                    ActorClass ac = (ActorClass)port.eContainer();
                    for (ExternalPort extp : ac.getExtPorts()) {
                        if (extp.getIfport() != port) continue;
                        external = extp;
                        break;
                    }
                    if (external != null) {
                        super.deleteBusinessObject(external);
                    }
                }
                super.deleteBusinessObject(bo);
            }
        }

        private static class PropertyFeature
        extends InterfaceItemSupport.FeatureProvider.PropertyFeature {
            private boolean doneChanges = false;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp, "Edit Port...", "Edit Port Properties");
            }

            @Override
            public boolean canExecute(ICustomContext context) {
                if (!super.canExecute(context)) {
                    return false;
                }
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape) {
                    Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
                    return bo instanceof Port;
                }
                return false;
            }

            public void execute(ICustomContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                if (bo instanceof Port) {
                    Port port = (Port)bo;
                    ActorContainerClass acc = (ActorContainerClass)port.eContainer();
                    boolean internal = FeatureProvider.isInternal((InterfaceItem)port);
                    boolean refport = FeatureProvider.isRefItem(context.getPictogramElements()[0]);
                    IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                    IScope scope = scopeProvider.getScope(port.eContainer().eContainer(), RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    PortPropertyDialog dlg = new PortPropertyDialog(shell, port, scope, acc, false, refport, internal);
                    if (dlg.open() != 0) {
                        throw new OperationCanceledException();
                    }
                    this.doneChanges = true;
                    FeatureProvider.updatePortFigure(port, context.getPictogramElements()[0], this.manageColor(DARK_COLOR), this.manageColor(BRIGHT_COLOR));
                    String kind = PortSupport.getPortKind(port);
                    Graphiti.getPeService().setPropertyValue((PropertyContainer)context.getPictogramElements()[0], "item-kind", kind);
                }
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class UpdateFeature
        extends InterfaceItemSupport.FeatureProvider.UpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof Port) {
                    return PortSupport.getPortKind((Port)item);
                }
                return "";
            }

            @Override
            protected void updateFigure(InterfaceItem item, PictogramElement pe, Color dark, Color bright) {
                FeatureProvider.updatePortFigure((Port)item, pe, dark, bright);
            }
        }
    }
}

