/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.common.support.NoResizeFeature;
import org.eclipse.etrice.ui.structure.DiagramTypeProvider;
import org.eclipse.etrice.ui.structure.dialogs.SPPPropertyDialog;
import org.eclipse.etrice.ui.structure.support.InterfaceItemSupport;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class SPPSupport
extends InterfaceItemSupport {
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public SPPSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    protected static String getSPPKind(SPPRef spp) {
        String kind = "";
        if (ValidationUtil.isRelay((SPPRef)spp)) {
            kind = String.valueOf(kind) + "R";
        }
        return kind;
    }

    private class BehaviorProvider
    extends InterfaceItemSupport.BehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Layer Connection");
            button.setIconId("org.eclipse.etrice.ui.structure.layer_connection");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends InterfaceItemSupport.FeatureProvider {
        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp, fp);
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        @Override
        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new InterfaceItemSupport.FeatureProvider.MoveShapeFeature(this.fp);
        }

        @Override
        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp)};
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        protected static void createSPPFigure(SPPRef spp, boolean refspp, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
            boolean relay = ValidationUtil.isRelay((SPPRef)spp);
            int size = refspp ? 18 : 40;
            int margin = refspp ? 30 : 40;
            int line = refspp ? 1 : 2;
            Color bg = brightDolor;
            bg = refspp ? darkColor : (relay ? brightDolor : darkColor);
            IGaService gaService = Graphiti.getGaService();
            Ellipse rect = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
            rect.setForeground(darkColor);
            rect.setBackground(bg);
            rect.setLineWidth(Integer.valueOf(line));
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, margin - size / 2, margin - size / 2, size, size);
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
            }
        }

        private static void updateSPPFigure(SPPRef spp, PictogramElement pe, Color dark, Color bright) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm invisibleRect = pe.getGraphicsAlgorithm();
            invisibleRect.getGraphicsAlgorithmChildren().clear();
            FeatureProvider.createSPPFigure(spp, false, container, invisibleRect, dark, bright);
            GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
            if (ga instanceof Text) {
                ((Text)ga).setValue(spp.getName());
            }
        }

        private class AddFeature
        extends InterfaceItemSupport.FeatureProvider.AddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof SPPRef) {
                    return SPPSupport.getSPPKind((SPPRef)item);
                }
                return "";
            }

            @Override
            protected void createItemFigure(InterfaceItem item, boolean refitem, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
                if (item instanceof SPPRef) {
                    FeatureProvider.createSPPFigure((SPPRef)item, refitem, containerShape, invisibleRectangle, darkColor, brightDolor);
                }
            }
        }

        private static class CreateFeature
        extends InterfaceItemSupport.FeatureProvider.CreateFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, false, "SPP", "create SPP");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.spp";
            }

            public Object[] create(ICreateContext context) {
                ActorContainerClass acc = (ActorContainerClass)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                SPPRef spp = RoomFactory.eINSTANCE.createSPPRef();
                spp.setName(RoomNameProvider.getUniqueInterfaceItemName((String)"spp", (ActorContainerClass)acc));
                acc.getIfSPPs().add((Object)spp);
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                IScope scope = scopeProvider.getScope(spp.eContainer().eContainer(), RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SPPPropertyDialog dlg = new SPPPropertyDialog(shell, spp, scope, acc, true, false);
                if (dlg.open() != 0) {
                    acc.getIfSPPs().remove((Object)spp);
                    return EMPTY;
                }
                this.doneChanges = true;
                this.addGraphicalRepresentation((IAreaContext)context, spp);
                return new Object[]{spp};
            }
        }

        private static class PropertyFeature
        extends InterfaceItemSupport.FeatureProvider.PropertyFeature {
            private boolean doneChanges = false;

            public PropertyFeature(IFeatureProvider fp) {
                super(fp, "Edit SPP...", "Edit SPP Properties");
            }

            @Override
            public boolean canExecute(ICustomContext context) {
                if (!super.canExecute(context)) {
                    return false;
                }
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape) {
                    Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
                    return bo instanceof SPPRef;
                }
                return false;
            }

            public void execute(ICustomContext context) {
                SPPRef spp = (SPPRef)this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                ActorContainerClass acc = (ActorContainerClass)spp.eContainer();
                boolean refport = FeatureProvider.isRefItem(context.getPictogramElements()[0]);
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                IScope scope = scopeProvider.getScope(spp.eContainer().eContainer(), RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SPPPropertyDialog dlg = new SPPPropertyDialog(shell, spp, scope, acc, false, refport);
                if (dlg.open() != 0) {
                    throw new OperationCanceledException();
                }
                this.doneChanges = true;
                FeatureProvider.updateSPPFigure(spp, context.getPictogramElements()[0], this.manageColor(DARK_COLOR), this.manageColor(BRIGHT_COLOR));
            }

            public boolean hasDoneChanges() {
                return this.doneChanges;
            }
        }

        private class UpdateFeature
        extends InterfaceItemSupport.FeatureProvider.UpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof SPPRef) {
                    return SPPSupport.getSPPKind((SPPRef)item);
                }
                return "";
            }

            @Override
            protected void updateFigure(InterfaceItem item, PictogramElement pe, Color dark, Color bright) {
                FeatureProvider.updateSPPFigure((SPPRef)item, pe, dark, bright);
            }
        }
    }
}

