/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class StructureClassSupport {
    public static final int MARGIN = 40;
    private static final int LINE_WIDTH = 4;
    public static final int DEFAULT_SIZE_X = 800;
    public static final int DEFAULT_SIZE_Y = 500;
    private static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    private static final IColorConstant BACKGROUND = new ColorConstant(255, 255, 255);
    private FeatureProvider afp;
    private BehaviorProvider tbp;

    public StructureClassSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.afp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.afp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    public static void addInheritedItems(ActorClass ac, ContainerShape acShape, Map<String, Anchor> ifitem2anchor, IFeatureProvider fp) {
        ContainerShape refAcShape;
        Object bo;
        Diagram diag = (Diagram)acShape.eContainer();
        ResourceSet rs = ac.eResource().getResourceSet();
        List<InterfaceItem> presentIfItems = SupportUtil.getInterfaceItems(acShape, fp, ifitem2anchor);
        List<ActorContainerRef> presentRefs = SupportUtil.getRefs(acShape, fp, ifitem2anchor);
        List<Binding> presentBindings = SupportUtil.getBindings(diag, fp);
        List<LayerConnection> presentConnections = SupportUtil.getConnections(diag, fp);
        Diagram refDiag = new DiagramAccess().getDiagram((StructureClass)ac);
        if (!refDiag.getChildren().isEmpty() && (bo = fp.getBusinessObjectForPictogramElement((PictogramElement)(refAcShape = (ContainerShape)refDiag.getChildren().get(0)))) instanceof StructureClass) {
            StructureClass extRefClass = (StructureClass)bo;
            assert (extRefClass.getName().equals(ac.getName())) : "actor class names must match";
            int scaleX = refAcShape.getGraphicsAlgorithm().getWidth() / acShape.getGraphicsAlgorithm().getWidth();
            int scaleY = refAcShape.getGraphicsAlgorithm().getHeight() / acShape.getGraphicsAlgorithm().getHeight();
            for (Shape childShape : refAcShape.getChildren()) {
                EObject ownObject;
                bo = fp.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                GraphicsAlgorithm ga = childShape.getGraphicsAlgorithm();
                if (!(bo instanceof InterfaceItem) && !(bo instanceof ActorContainerRef) || presentIfItems.contains(ownObject = SupportUtil.getOwnObject((EObject)bo, rs)) || presentRefs.contains(ownObject)) continue;
                int x = (ga.getX() + ga.getWidth() / 2) / scaleX;
                int y = (ga.getY() + ga.getHeight() / 2) / scaleY;
                SupportUtil.addItem(ownObject, x, y, acShape, ifitem2anchor, fp);
            }
            for (Connection conn : refDiag.getConnections()) {
                LayerConnection lc;
                bo = fp.getBusinessObjectForPictogramElement((PictogramElement)conn);
                if (bo instanceof Binding) {
                    Binding bind = (Binding)SupportUtil.getOwnObject((EObject)((Binding)bo), rs);
                    if (presentBindings.contains(bind)) continue;
                    SupportUtil.addBinding(bind, fp, ifitem2anchor);
                    continue;
                }
                if (!(bo instanceof LayerConnection) || presentConnections.contains(lc = (LayerConnection)SupportUtil.getOwnObject((EObject)((LayerConnection)bo), rs))) continue;
                SupportUtil.addLayerConnection(lc, fp, ifitem2anchor);
            }
        }
    }

    private static void addMissingItems(StructureClass sc, ContainerShape acShape, IFeatureProvider fp) {
        ActorClass base;
        int width = ((GraphicsAlgorithm)acShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0)).getWidth();
        HashMap<String, Anchor> ifitem2anchor = new HashMap<String, Anchor>();
        List<InterfaceItem> present = SupportUtil.getInterfaceItems(acShape, fp, ifitem2anchor);
        List expected = RoomHelpers.getInterfaceItems((StructureClass)sc, (boolean)false);
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object item : expected) {
            if (present.contains(item)) continue;
            items.add(item);
        }
        SupportUtil.addInterfaceItems(items, 0, acShape, width, fp, ifitem2anchor);
        if (sc instanceof ActorClass) {
            ArrayList<Port> ports = new ArrayList<Port>();
            for (Port port : ((ActorClass)sc).getIntPorts()) {
                if (present.contains(port)) continue;
                ports.add(port);
            }
            SupportUtil.addInterfaceItems(ports, 120, acShape, width, fp, ifitem2anchor);
        }
        present = SupportUtil.getRefs(acShape, fp, ifitem2anchor);
        expected = RoomHelpers.getRefs((StructureClass)sc, (boolean)false);
        items = new ArrayList();
        for (Object item : expected) {
            if (present.contains(item)) continue;
            items.add(item);
        }
        SupportUtil.addRefItems(items, acShape, width, fp, ifitem2anchor);
        if (sc instanceof ActorClass && (base = ((ActorClass)sc).getBase()) != null) {
            StructureClassSupport.addInheritedItems(base, acShape, ifitem2anchor, fp);
        }
        Diagram diag = (Diagram)acShape.eContainer();
        List<Binding> present2 = SupportUtil.getBindings(diag, fp);
        List expected2 = RoomHelpers.getBindings((StructureClass)sc, (boolean)false);
        for (Binding bind : expected2) {
            if (present2.contains(bind)) continue;
            SupportUtil.addBinding(bind, fp, ifitem2anchor);
        }
        present2 = SupportUtil.getConnections(diag, fp);
        expected2 = RoomHelpers.getConnections((StructureClass)sc, (boolean)false);
        for (LayerConnection lc : expected2) {
            if (present2.contains(lc)) continue;
            SupportUtil.addLayerConnection(lc, fp, ifitem2anchor);
        }
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }
    }

    private class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new OpenBehaviorDiagram(this.fp)};
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                return context.getNewObject() instanceof StructureClass && context.getTargetContainer() instanceof Diagram;
            }

            public PictogramElement add(IAddContext context) {
                StructureClass ac = (StructureClass)context.getNewObject();
                Diagram diag = (Diagram)context.getTargetContainer();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)diag, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "cls");
                int width = context.getWidth() <= 0 ? 800 : context.getWidth();
                int height = context.getHeight() <= 0 ? 500 : context.getHeight();
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + 80, height + 80);
                Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setBackground(this.manageColor(BACKGROUND));
                rect.setTransparency(Double.valueOf(0.5));
                rect.setLineWidth(Integer.valueOf(4));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                rect = gaService.createRectangle((GraphicsAlgorithmContainer)invisibleRectangle);
                rect.setForeground(this.manageColor(LINE_COLOR));
                rect.setFilled(Boolean.valueOf(false));
                rect.setLineWidth(Integer.valueOf(4));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 40, 40, width, height);
                this.link((PictogramElement)containerShape, ac);
                this.link((PictogramElement)this.getDiagram(), ac);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                return false;
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            private static final int MIN_HEIGHT = 100;
            private static final int MIN_WIDTH = 250;

            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                EList businessObjects = pe.getLink().getBusinessObjects();
                return businessObjects.size() == 1 && businessObjects.get(0) instanceof StructureClass;
            }

            public boolean layout(ILayoutContext context) {
                boolean anythingChanged = false;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                if (containerGa.getHeight() < 100) {
                    containerGa.setHeight(100);
                    anythingChanged = true;
                }
                if (containerGa.getWidth() < 250) {
                    containerGa.setWidth(250);
                    anythingChanged = true;
                }
                int w = containerGa.getWidth();
                int h = containerGa.getHeight();
                if (containerGa.getGraphicsAlgorithmChildren().size() == 2) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(1);
                    ga.setWidth(w - 80);
                    ga.setHeight(h - 80);
                    anythingChanged = true;
                }
                return anythingChanged;
            }
        }

        private class OpenBehaviorDiagram
        extends AbstractCustomFeature {
            public OpenBehaviorDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Class Behavior";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorClass;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorClass) {
                    org.eclipse.etrice.ui.behavior.DiagramAccess diagramAccess = new org.eclipse.etrice.ui.behavior.DiagramAccess();
                    diagramAccess.openDiagramEditor((StructureClass)((ActorClass)bo));
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                int width = context.getWidth() - 40;
                int height = context.getHeight() - 40;
                int xmax = 0;
                int ymax = 0;
                ContainerShape containerShape = (ContainerShape)context.getShape();
                StructureClass sc = (StructureClass)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                for (Shape childShape : containerShape.getChildren()) {
                    if (this.isOnInterface(sc, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                    GraphicsAlgorithm ga = childShape.getGraphicsAlgorithm();
                    int x = ga.getX() + ga.getWidth() - 30;
                    int y = ga.getY() + ga.getHeight() - 30;
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y <= ymax) continue;
                    ymax = y;
                }
                if (width > 0 && width < xmax) {
                    return false;
                }
                return height <= 0 || height >= ymax;
            }

            public void resizeShape(IResizeShapeContext context) {
                GraphicsAlgorithm containerGa;
                ContainerShape containerShape = (ContainerShape)context.getShape();
                StructureClass sc = (StructureClass)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (containerShape.getGraphicsAlgorithm() != null && (containerGa = containerShape.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren().size() == 2) {
                    GraphicsAlgorithm ga = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
                    double sx = (double)(context.getWidth() - 80) / (double)ga.getWidth();
                    double sy = (double)(context.getHeight() - 80) / (double)ga.getHeight();
                    for (Shape childShape : containerShape.getChildren()) {
                        if (!this.isOnInterface(sc, this.getBusinessObjectForPictogramElement((PictogramElement)childShape))) continue;
                        ga = childShape.getGraphicsAlgorithm();
                        ga.setX((int)((double)ga.getX() * sx));
                        ga.setY((int)((double)ga.getY() * sy));
                    }
                }
                super.resizeShape(context);
            }

            private boolean isOnInterface(StructureClass sc, Object childBo) {
                boolean onInterface = false;
                if (childBo instanceof InterfaceItem) {
                    onInterface = true;
                    if (childBo instanceof Port && sc instanceof ActorClass && ((ActorClass)sc).getIntPorts().contains(childBo)) {
                        onInterface = false;
                    }
                }
                return onInterface;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                if (context.getPictogramElement() instanceof Diagram) {
                    return false;
                }
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof StructureClass;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"Structure class deleted from model");
                }
                StructureClass sc = (StructureClass)bo;
                ContainerShape shape = (ContainerShape)context.getPictogramElement();
                String reason = "";
                int missing = 0;
                List expectedItems = RoomHelpers.getInterfaceItems((StructureClass)sc, (boolean)true);
                List<InterfaceItem> presentItems = SupportUtil.getInterfaceItems(shape, FeatureProvider.this.fp);
                for (InterfaceItem interfaceItem : expectedItems) {
                    if (presentItems.contains(interfaceItem)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " missing interface items\n";
                }
                missing = 0;
                List expectedRefs = RoomHelpers.getRefs((StructureClass)sc, (boolean)true);
                List<ActorContainerRef> presentRefs = SupportUtil.getRefs(shape, FeatureProvider.this.fp);
                for (ActorContainerRef actorContainerRef : expectedRefs) {
                    if (presentRefs.contains(actorContainerRef)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " missing refs\n";
                }
                missing = 0;
                List expectedBindings = RoomHelpers.getBindings((StructureClass)sc, (boolean)true);
                List<Binding> presentBindings = SupportUtil.getBindings(this.getDiagram(), FeatureProvider.this.fp);
                for (Binding binding : expectedBindings) {
                    if (presentBindings.contains(binding)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " missing bindings\n";
                }
                missing = 0;
                expectedBindings = RoomHelpers.getConnections((StructureClass)sc, (boolean)true);
                presentBindings = SupportUtil.getConnections(this.getDiagram(), FeatureProvider.this.fp);
                for (Binding binding : expectedBindings) {
                    if (presentBindings.contains(binding)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " missing layer connections\n";
                }
                if (!reason.isEmpty()) {
                    return Reason.createTrueReason((String)reason.substring(0, reason.length() - 1));
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                Object bo;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                if (containerShape instanceof Diagram) {
                    containerShape = (ContainerShape)containerShape.getChildren().get(0);
                }
                if ((bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape)) instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                StructureClass sc = (StructureClass)bo;
                StructureClassSupport.addMissingItems(sc, containerShape, FeatureProvider.this.fp);
                return true;
            }
        }
    }
}

