/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.LiteralArray;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.LiteralType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.contentassist.AbstractConfigProposalProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class ConfigProposalProvider
extends AbstractConfigProposalProvider {
    @Override
    public void completeImport_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        URI configURI = context.getRootModel().eResource().getURI();
        Path configPath = new Path(configURI.toPlatformString(false).replace(configURI.lastSegment(), ""));
        IResourceProxyVisitor visitor = new IResourceProxyVisitor((IPath)configPath, rootPath, acceptor, context){
            private final /* synthetic */ IPath val$configPath;
            private final /* synthetic */ IPath val$rootPath;
            private final /* synthetic */ ICompletionProposalAcceptor val$acceptor;
            private final /* synthetic */ ContentAssistContext val$context;
            {
                this.val$configPath = iPath;
                this.val$rootPath = iPath2;
                this.val$acceptor = iCompletionProposalAcceptor;
                this.val$context = contentAssistContext;
            }

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() != 1) {
                    return true;
                }
                String name = proxy.getName();
                if (name.regionMatches(true, name.length() - 4, "room", 0, 4)) {
                    IPath relConfigPath = proxy.requestFullPath().makeRelativeTo(this.val$configPath);
                    IPath relWorkspacePath = proxy.requestFullPath().makeRelativeTo(this.val$rootPath);
                    String proposal = "\"" + relConfigPath.toString() + "\"";
                    String displayString = String.valueOf(relConfigPath.lastSegment()) + " - " + relWorkspacePath;
                    this.val$acceptor.accept(ConfigProposalProvider.this.createCompletionProposal(proposal, new StyledString(displayString), null, this.val$context));
                }
                return false;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeActorInstanceConfig_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeActorInstanceConfig_Path(model, assignment, context, acceptor);
        List<ActorRef> instances = this.collectInstances((ActorInstanceConfig)model);
        for (ActorRef instance : instances) {
            acceptor.accept(this.createCompletionProposal(instance.getName(), context));
        }
    }

    @Override
    public void completeRefPath_Refs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRefPath_Refs(model, assignment, context, acceptor);
        if (model instanceof ActorInstanceConfig) {
            this.completeActorInstanceConfig_Path(model, assignment, context, acceptor);
            return;
        }
        RefPath path = (RefPath)model;
        if (path.eContainer() instanceof ActorInstanceConfig) {
            List<ActorRef> instances = this.collectInstances((ActorInstanceConfig)path.eContainer());
            for (ActorRef instance : instances) {
                acceptor.accept(this.createCompletionProposal(instance.getName(), context));
            }
        }
    }

    private List<ActorRef> collectInstances(ActorInstanceConfig config) {
        ArrayList<ActorRef> refs = new ArrayList<ActorRef>();
        SubSystemClass root = config.getRoot();
        if (root != null) {
            RefPath path = config.getPath();
            if (path != null && !path.getRefs().isEmpty()) {
                root = ConfigUtil.resolve((ActorContainerClass)root, (RefPath)path);
            }
            if (root != null) {
                for (ActorContainerRef ref : RoomHelpers.getRefs((StructureClass)root, (boolean)true)) {
                    ActorRef aRef;
                    if (!(ref instanceof ActorRef) || (aRef = (ActorRef)ref).getSize() != 1) continue;
                    refs.add((ActorRef)ref);
                }
            }
        }
        return refs;
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LiteralType type;
        Attribute attr = this.getAttribute(model);
        if (attr != null && (type = ConfigUtil.getLiteralType((Attribute)attr)) != LiteralType.CHAR) {
            return;
        }
        super.complete_STRING(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_BooleanLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = ConfigUtil.getLiteralType((Attribute)attr);
            if (type != LiteralType.BOOL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Boolean" + mult, null, context));
        acceptor.accept(this.createCompletionProposal("true", "true", null, context));
        acceptor.accept(this.createCompletionProposal("false", "false", null, context));
    }

    @Override
    public void complete_IntLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = ConfigUtil.getLiteralType((Attribute)attr);
            if (type != LiteralType.INT && type != LiteralType.REAL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Integer" + mult, null, context));
        acceptor.accept(this.createCompletionProposal("", "Hexadecimal" + mult, null, context));
    }

    @Override
    public void complete_RealLiteral(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String mult = "";
        Attribute attr = this.getAttribute(model);
        if (attr != null) {
            mult = attr.getSize() > 0 ? "[" + attr.getSize() + "]" : "";
            LiteralType type = ConfigUtil.getLiteralType((Attribute)attr);
            if (type != LiteralType.REAL) {
                return;
            }
        }
        acceptor.accept(this.createCompletionProposal("", "Real" + mult, null, context));
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject model = contentAssistContext.getCurrentModel();
        if (model instanceof AttrConfig && this.hideKeyword((AttrConfig)model, keyword)) {
            return;
        }
        if (model instanceof LiteralArray && this.hideKeyword((LiteralArray)model, keyword)) {
            return;
        }
        if (keyword.getValue().equals("true") || keyword.getValue().equals("false")) {
            return;
        }
        if (model instanceof AttrInstanceConfig && this.hideKeyword((AttrInstanceConfig)model, keyword)) {
            return;
        }
        super.completeKeyword(keyword, contentAssistContext, acceptor);
    }

    private boolean hideKeyword(AttrConfig config, Keyword keyword) {
        LiteralType type = ConfigUtil.getLiteralType((Attribute)config.getAttribute());
        DataType dataType = config.getAttribute().getRefType().getType();
        if ((keyword.getValue().equals("min") || keyword.getValue().equals("max")) && type != LiteralType.INT && type != LiteralType.REAL) {
            return true;
        }
        if (keyword.getValue().equals("Attr") && !(dataType instanceof PrimitiveType) && !(dataType instanceof DataClass)) {
            return true;
        }
        return keyword.getValue().equals("=") && !config.getAttribute().eIsProxy() && !(dataType instanceof PrimitiveType);
    }

    private boolean hideKeyword(AttrInstanceConfig config, Keyword keyword) {
        return keyword.getValue().equals("dynamic configuration") && !(config.eContainer() instanceof ActorInstanceConfig);
    }

    private boolean hideKeyword(LiteralArray array, Keyword keyword) {
        if (keyword.getValue().equals(",") && array.eContainer() instanceof AttrConfig) {
            Attribute attr = ((AttrConfig)array.eContainer()).getAttribute();
            if (attr.getSize() <= array.getLiterals().size()) {
                return true;
            }
            if (((PrimitiveType)attr.getRefType().getType()).getType() == LiteralType.CHAR) {
                return true;
            }
        }
        return false;
    }

    private Attribute getAttribute(EObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Attribute) {
            return (Attribute)o;
        }
        if (o instanceof AttrConfig) {
            return ((AttrConfig)o).getAttribute();
        }
        return this.getAttribute(o.eContainer());
    }
}

