/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.linking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.ui.linking.ImportAwareHyperlinkHelper;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;

public class ConfigHyperlinkHelper
extends ImportAwareHyperlinkHelper {
    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        ILeafNode leaf;
        EObject grammarElement;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null && (grammarElement = (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset)).getParent().getGrammarElement()) instanceof RuleCall) {
            EObject parent;
            RuleCall rc = (RuleCall)grammarElement;
            AbstractRule rule = rc.getRule();
            EObject crossLinkedEObject = null;
            if (rule.getName().equals("RefPath") && (parent = leaf.getSemanticElement().eContainer()) instanceof ActorInstanceConfig) {
                crossLinkedEObject = this.getCrossLinkedEObject((ActorInstanceConfig)parent);
            }
            if (crossLinkedEObject != null) {
                this.createHyperlinksTo(resource, null, crossLinkedEObject, acceptor);
            }
        }
        super.createHyperlinksByOffset(resource, offset, acceptor);
    }

    private EObject getCrossLinkedEObject(ActorInstanceConfig config) {
        SubSystemClass lastAcContainer = config.getRoot();
        ActorRef lastRef = null;
        block0: for (String ref : config.getPath().getRefs()) {
            for (ActorRef r : lastAcContainer.getActorRefs()) {
                if (!r.getName().equals(ref)) continue;
                lastRef = r;
                lastAcContainer = lastRef.getType();
                continue block0;
            }
        }
        return lastRef;
    }
}

