/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.scoping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.PortClassConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class ConfigScopeProvider
extends AbstractDeclarativeScopeProvider {
    public IScope scope_PortInstanceConfig_item(PortInstanceConfig ctx, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        ActorInstanceConfig actorConfig = (ActorInstanceConfig)ctx.eContainer();
        SubSystemClass subsystem = actorConfig.getRoot();
        if (subsystem != null) {
            ActorClass ac = ConfigUtil.resolve((ActorContainerClass)subsystem, actorConfig.getPath());
            for (InterfaceItem item : ConfigUtil.getConfigurableInterfaceItems((ActorContainerClass)ac, true)) {
                scopes.add(EObjectDescription.create((String)item.getName(), (EObject)item));
            }
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    public IScope scope_AttrConfig_attribute(AttrConfig ctx, EReference ref) {
        ArrayList<IEObjectDescription> scopes = new ArrayList<IEObjectDescription>();
        if (ctx.eContainer() instanceof AttrConfig) {
            this.collectAttributes((AttrConfig)ctx.eContainer(), scopes);
        } else if (ctx.eContainer() instanceof ActorClassConfig) {
            this.collectAttributes((ActorClassConfig)ctx.eContainer(), scopes);
        } else if (ctx.eContainer() instanceof ActorInstanceConfig) {
            this.collectAttributes((ActorInstanceConfig)ctx.eContainer(), scopes);
        } else if (ctx.eContainer() instanceof PortClassConfig) {
            this.collectAttributes((PortClassConfig)ctx.eContainer(), scopes);
        } else if (ctx.eContainer() instanceof PortInstanceConfig) {
            this.collectAttributes((PortInstanceConfig)ctx.eContainer(), scopes);
        }
        return new SimpleScope(IScope.NULLSCOPE, scopes);
    }

    private void collectAttributes(AttrConfig config, List<IEObjectDescription> scopes) {
        if (config.getAttribute().getRefType().getType() instanceof DataClass) {
            DataClass dc = (DataClass)config.getAttribute().getRefType().getType();
            for (Attribute att : RoomHelpers.getAllAttributes((DataClass)dc)) {
                scopes.add(EObjectDescription.create((String)att.getName(), (EObject)att));
            }
        }
    }

    private void collectAttributes(ActorClassConfig config, List<IEObjectDescription> scopes) {
        ActorClass actor = config.getActor();
        if (actor != null) {
            for (Attribute att : RoomHelpers.getAllAttributes((ActorClass)actor)) {
                scopes.add(EObjectDescription.create((String)att.getName(), (EObject)att));
            }
        }
    }

    private void collectAttributes(ActorInstanceConfig config, List<IEObjectDescription> scopes) {
        SubSystemClass subsystem = config.getRoot();
        if (subsystem != null) {
            ActorClass actor = ConfigUtil.resolve((ActorContainerClass)subsystem, config.getPath());
            for (Attribute att : RoomHelpers.getAllAttributes((ActorClass)actor)) {
                scopes.add(EObjectDescription.create((String)att.getName(), (EObject)att));
            }
        }
    }

    private void collectAttributes(PortClassConfig config, List<IEObjectDescription> scopes) {
        ProtocolClassConfig protocolConfig = (ProtocolClassConfig)config.eContainer();
        PortClass portClass = null;
        portClass = protocolConfig.getRegular() == config ? protocolConfig.getProtocol().getRegular() : protocolConfig.getProtocol().getConjugate();
        if (portClass != null) {
            for (Attribute att : portClass.getAttributes()) {
                scopes.add(EObjectDescription.create((String)att.getName(), (EObject)att));
            }
        }
    }

    private void collectAttributes(PortInstanceConfig config, List<IEObjectDescription> scopes) {
        PortClass portClass = ConfigUtil.getPortClass(config);
        if (portClass != null) {
            for (Attribute att : portClass.getAttributes()) {
                scopes.add(EObjectDescription.create((String)att.getName(), (EObject)att));
            }
        }
    }
}

