/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.BooleanLiteral;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.ConfigPackage;
import org.eclipse.etrice.core.config.IntLiteral;
import org.eclipse.etrice.core.config.Literal;
import org.eclipse.etrice.core.config.NumberLiteral;
import org.eclipse.etrice.core.config.PortClassConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.RealLiteral;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.StringLiteral;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.converter.ConfigValueConverterService;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LiteralType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.validation.AbstractConfigJavaValidator;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.validation.Check;

public class ConfigJavaValidator
extends AbstractConfigJavaValidator {
    private ConfigValueConverterService converter = new ConfigValueConverterService();

    @Check
    public void checkConfigModel(ConfigModel model) {
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        for (ActorClassConfig classConfig : model.getActorClassConfigs()) {
            if (actorClasses.contains(classConfig.getActor())) {
                this.error("duplicate class config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)classConfig));
                continue;
            }
            actorClasses.add(classConfig.getActor());
        }
        HashSet<String> actorRefs = new HashSet<String>();
        for (ActorInstanceConfig instanceConfig : model.getActorInstanceConfigs()) {
            String ref = String.valueOf(instanceConfig.getRoot().getName()) + this.refPathToString(instanceConfig.getPath());
            if (actorRefs.contains(ref)) {
                this.error("duplicate actor instance config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)instanceConfig));
                continue;
            }
            actorRefs.add(ref);
        }
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        for (ProtocolClassConfig protocolConfig : model.getProtocolClassConfigs()) {
            if (protocolClasses.contains(protocolConfig.getProtocol())) {
                this.error("duplicate protocol class config", model, (EStructuralFeature)ConfigPackage.Literals.CONFIG_MODEL__CONFIG_ELEMENTS, model.getConfigElements().indexOf((Object)protocolConfig));
                continue;
            }
            protocolClasses.add(protocolConfig.getProtocol());
        }
    }

    @Check
    public void checkActorClassConfig(ActorClassConfig config) {
        if (config.getActor().isAbstract()) {
            this.error("abstract actor classes not supported", (EStructuralFeature)ConfigPackage.Literals.ACTOR_CLASS_CONFIG__ACTOR);
        }
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.ACTOR_CLASS_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkActorInstanceConfig(ActorInstanceConfig config) {
        RefPath path;
        SubSystemClass root = config.getRoot();
        if (root != null && !root.eIsProxy() && (path = config.getPath()) != null) {
            String invalidSegment = ConfigUtil.checkPath((ActorContainerClass)root, path);
            if (invalidSegment != null) {
                this.error("no match for segment '" + invalidSegment + "'", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PATH);
            } else {
                ActorRef aRef = ConfigUtil.getLastActorRef((ActorContainerClass)root, path);
                if (aRef != null) {
                    if (aRef.getSize() > 1) {
                        this.error("no arrays of actor references supported", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PATH);
                    }
                } else {
                    this.error("invalid actor reference", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PATH);
                }
            }
        }
        HashSet<InterfaceItem> items = new HashSet<InterfaceItem>();
        for (PortInstanceConfig portConfig : config.getPorts()) {
            InterfaceItem item = portConfig.getItem();
            if (items.contains(item)) {
                this.error("duplicate port instance config", (EStructuralFeature)ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__PORTS, config.getPorts().indexOf((Object)portConfig));
                continue;
            }
            items.add(item);
        }
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.ACTOR_INSTANCE_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkPortClassConfig(PortClassConfig config) {
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.PORT_CLASS_CONFIG__ATTRIBUTES);
    }

    @Check
    public void checkPortInstanceConfig(PortInstanceConfig config) {
        this.checkDuplicateAttributes((List<? extends AttrConfig>)config.getAttributes(), ConfigPackage.Literals.PORT_INSTANCE_CONFIG__ATTRIBUTES);
    }

    private void checkDuplicateAttributes(List<? extends AttrConfig> attrConfigs, EReference ref) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        for (AttrConfig attrConfig : attrConfigs) {
            if (attributes.contains(attrConfig.getAttribute())) {
                this.error("duplicate attribute entry", (EStructuralFeature)ref, attrConfigs.indexOf(attrConfig));
                continue;
            }
            attributes.add(attrConfig.getAttribute());
        }
    }

    @Check
    public void checkAttrConfig(AttrConfig config) {
        Attribute a = config.getAttribute();
        if (a == null) {
            return;
        }
        DataType type = a.getRefType().getType();
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            this.checkAttrConfigValue(primitive, config);
        } else if (type instanceof DataType) {
            if (config.getValue() != null) {
                this.error("not available", (EStructuralFeature)ConfigPackage.Literals.ATTR_CONFIG__VALUE);
            }
            if (a.getSize() > 0) {
                this.error("DataClass arrays not supported", (EStructuralFeature)ConfigPackage.Literals.ATTR_CLASS_CONFIG__ATTRIBUTES);
            }
        }
    }

    @Check
    public void checkAttrClassConfig(AttrClassConfig config) {
        Attribute attr = config.getAttribute();
        if (attr == null) {
            return;
        }
        DataType type = attr.getRefType().getType();
        if (type instanceof PrimitiveType) {
            PrimitiveType primitive = (PrimitiveType)type;
            this.checkAttrConfigMin(primitive, config);
            this.checkAttrConfigMax(primitive, config);
        }
    }

    @Check
    public void checkAttrInstanceConfig(AttrInstanceConfig config) {
        Attribute attr = config.getAttribute();
        if (attr == null) {
            return;
        }
        EAttribute feature = ConfigPackage.eINSTANCE.getAttrInstanceConfig_DynConfig();
        if (config.isDynConfig()) {
            if (!(config.eContainer() instanceof ActorInstanceConfig)) {
                this.error("dynamic configuration only at root attributes", (EStructuralFeature)feature);
            }
            if (config.eContainer() instanceof ActorInstanceConfig) {
                SubSystemClass ssc = ((ActorInstanceConfig)config.eContainer()).getRoot();
                ConfigModel model = this.getConfigModel(config);
                boolean found = false;
                for (SubSystemConfig c : model.getSubSystemConfigs()) {
                    if (!c.getSubSystem().equals(ssc)) continue;
                    if (c.getDynConfig() == null) {
                        this.error("no source for dynamic config in SubSystemConfig", (EStructuralFeature)feature);
                    }
                    found = true;
                }
                if (!found) {
                    this.error("no SubSystemConfig found", (EStructuralFeature)feature);
                }
            }
        }
    }

    private void checkAttrConfigValue(PrimitiveType primitive, AttrConfig config) {
        int attrMult;
        if (config.getValue() == null) {
            return;
        }
        EList<Literal> values = config.getValue().getLiterals();
        EReference valueRef = ConfigPackage.eINSTANCE.getAttrConfig_Value();
        EReference arrayRef = ConfigPackage.eINSTANCE.getLiteralArray_Literals();
        LiteralType type = primitive.getType();
        Attribute attribute = config.getAttribute();
        int n = attrMult = attribute.getSize() > 0 ? attribute.getSize() : 1;
        if (type != LiteralType.CHAR) {
            if (values.size() > attrMult) {
                this.error("too many values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
            }
            if (values.size() > 1 && values.size() < attrMult) {
                this.error("not enough values, multiplicity is " + attrMult, (EStructuralFeature)valueRef);
            }
        }
        block6: for (Literal value : values) {
            switch (type) {
                case BOOL: {
                    if (value instanceof BooleanLiteral) break;
                    this.error("must be boolean value", (EStructuralFeature)valueRef);
                    break;
                }
                case REAL: {
                    if (value instanceof NumberLiteral) break;
                    this.error("must be an integer or real value", (EStructuralFeature)valueRef);
                    break;
                }
                case INT: {
                    if (value instanceof IntLiteral) break;
                    this.error("must be an integer", (EStructuralFeature)valueRef);
                    break;
                }
                case CHAR: {
                    if (!(value instanceof StringLiteral)) {
                        this.error("must be a string", (EStructuralFeature)valueRef);
                        break;
                    }
                    if (values.size() > 1) {
                        this.error("multiplicity must be one", (EStructuralFeature)valueRef);
                    }
                    StringLiteral strValue = (StringLiteral)value;
                    if (attribute.getSize() <= 0 || attrMult >= strValue.getValue().length()) continue block6;
                    this.error("too many characters - maximal length is " + attrMult, (EStructuralFeature)valueRef);
                }
            }
        }
        if (type == LiteralType.INT || type == LiteralType.REAL) {
            ActorClassConfig classConfig = null;
            if (config.eContainer() instanceof ActorInstanceConfig) {
                ActorInstanceConfig actorConfig = (ActorInstanceConfig)config.eContainer();
                ActorClass actorClass = ConfigUtil.resolve((ActorContainerClass)actorConfig.getRoot(), actorConfig.getPath());
                ConfigModel model = this.getConfigModel(actorConfig);
                for (ActorClassConfig cf : model.getActorClassConfigs()) {
                    if (!cf.getActor().equals(actorClass)) continue;
                    classConfig = cf;
                    break;
                }
            } else if (config.eContainer() instanceof ActorClassConfig) {
                classConfig = (ActorClassConfig)config.eContainer();
            }
            AttrClassConfig attrClassConfig = null;
            if (classConfig != null) {
                for (AttrClassConfig acf : classConfig.getAttributes()) {
                    if (!config.getAttribute().equals(acf.getAttribute())) continue;
                    attrClassConfig = acf;
                    break;
                }
            }
            if (attrClassConfig != null) {
                NumberLiteral min = attrClassConfig.getMin();
                NumberLiteral max = attrClassConfig.getMax();
                for (Literal value : values) {
                    long lMax;
                    long lMin;
                    if (!(value instanceof NumberLiteral)) continue;
                    if (value instanceof RealLiteral) {
                        double dbMax;
                        double dbMin;
                        double dbValue = ((RealLiteral)value).getValue();
                        if (min instanceof RealLiteral && (dbMin = ((RealLiteral)min).getValue()) > dbValue) {
                            this.error("value is less than minimum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        }
                        if (!(max instanceof RealLiteral) || !((dbMax = ((RealLiteral)max).getValue()) < dbValue)) continue;
                        this.error("value exceeds maximum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                        continue;
                    }
                    if (!(value instanceof IntLiteral)) continue;
                    long lValue = ((IntLiteral)value).getValue();
                    if (min instanceof IntLiteral && (lMin = ((IntLiteral)min).getValue()) > lValue) {
                        this.error("value is less than minimum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                    }
                    if (!(max instanceof IntLiteral) || (lMax = ((IntLiteral)max).getValue()) >= lValue) continue;
                    this.error("value exceeds maximum", config.getValue(), (EStructuralFeature)arrayRef, values.indexOf(value));
                }
            }
        }
    }

    private void checkAttrConfigMin(PrimitiveType primitive, AttrClassConfig config) {
        NumberLiteral min = config.getMin();
        if (min == null) {
            return;
        }
        EReference minRef = ConfigPackage.eINSTANCE.getAttrClassConfig_Min();
        LiteralType type = primitive.getType();
        if (type == LiteralType.INT || type == LiteralType.REAL) {
            if (primitive.getType() == LiteralType.INT) {
                if (!(min instanceof IntLiteral)) {
                    this.error("incompatible datatype: maximum is not int", (EStructuralFeature)minRef);
                }
            } else if (primitive.getType() == LiteralType.REAL && !(min instanceof RealLiteral)) {
                this.error("incompatible datatype: maximum is not real", (EStructuralFeature)minRef);
            }
            String defaultValue = config.getAttribute().getDefaultValueLiteral();
            if (config.getValue() == null && defaultValue != null) {
                if (type == LiteralType.INT) {
                    if (min instanceof IntLiteral) {
                        try {
                            long lDefaultValue = (Long)this.converter.getLongConverter().toValue(defaultValue, null);
                            long lMax = ((IntLiteral)min).getValue();
                            if (lMax < lDefaultValue) {
                                this.error("default value in ROOM model is less than this maximum", (EStructuralFeature)minRef);
                            }
                        }
                        catch (ValueConverterException e) {
                            this.warning("could not compare with int value in ROOM model (parse error)", (EStructuralFeature)minRef);
                        }
                    } else {
                        this.warning("could not compare with int value in ROOM model (incompatible datatypes)", (EStructuralFeature)minRef);
                    }
                } else if (type == LiteralType.REAL) {
                    if (min instanceof RealLiteral) {
                        try {
                            double dbDefaultValue = (Double)this.converter.getRealConverter().toValue(defaultValue, null);
                            double dbMax = ((RealLiteral)min).getValue();
                            if (dbMax < dbDefaultValue) {
                                this.error("default value in ROOM model is less than this maximum", (EStructuralFeature)minRef);
                            }
                        }
                        catch (ValueConverterException e1) {
                            this.warning("could not compare with real value in ROOM model (parse error)", (EStructuralFeature)minRef);
                        }
                    } else {
                        this.warning("could not compare with real value in ROOM model (incompatible datatypes)", (EStructuralFeature)minRef);
                    }
                }
            }
        }
    }

    private void checkAttrConfigMax(PrimitiveType primitive, AttrClassConfig config) {
        NumberLiteral max = config.getMax();
        if (max == null) {
            return;
        }
        EReference maxRef = ConfigPackage.eINSTANCE.getAttrClassConfig_Max();
        LiteralType type = primitive.getType();
        if (type == LiteralType.INT || type == LiteralType.REAL) {
            if (primitive.getType() == LiteralType.INT) {
                if (!(max instanceof IntLiteral)) {
                    this.error("incompatible datatype: maximum is not int", (EStructuralFeature)maxRef);
                }
            } else if (primitive.getType() == LiteralType.REAL && !(max instanceof RealLiteral)) {
                this.error("incompatible datatype: maximum is not real", (EStructuralFeature)maxRef);
            }
            String defaultValue = config.getAttribute().getDefaultValueLiteral();
            if (config.getValue() == null && defaultValue != null) {
                if (type == LiteralType.INT) {
                    if (max instanceof IntLiteral) {
                        try {
                            long lDefaultValue = (Long)this.converter.getLongConverter().toValue(defaultValue, null);
                            long lMax = ((IntLiteral)max).getValue();
                            if (lMax < lDefaultValue) {
                                this.error("default value in ROOM model exceeds this maximum", (EStructuralFeature)maxRef);
                            }
                        }
                        catch (ValueConverterException e) {
                            this.warning("could not compare with int value in ROOM model (parse error)", (EStructuralFeature)maxRef);
                        }
                    } else {
                        this.warning("could not compare with int value in ROOM model (incompatible datatypes)", (EStructuralFeature)maxRef);
                    }
                } else if (type == LiteralType.REAL) {
                    if (max instanceof RealLiteral) {
                        try {
                            double dbDefaultValue = (Double)this.converter.getRealConverter().toValue(defaultValue, null);
                            double dbMax = ((RealLiteral)max).getValue();
                            if (dbMax < dbDefaultValue) {
                                this.error("default value in ROOM model exceeds this maximum", (EStructuralFeature)maxRef);
                            }
                        }
                        catch (ValueConverterException e1) {
                            this.warning("could not compare with real value in ROOM model (parse error)", (EStructuralFeature)maxRef);
                        }
                    } else {
                        this.warning("could not compare with real value in ROOM model (incompatible datatypes)", (EStructuralFeature)maxRef);
                    }
                }
            }
        }
    }

    private ConfigModel getConfigModel(EObject object) {
        EObject root = object;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        return (ConfigModel)root;
    }

    private String refPathToString(RefPath path) {
        String str = "";
        for (String s : path.getRefs()) {
            str = String.valueOf(str) + "/" + s;
        }
        return str;
    }
}

