/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.BindingInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ConnectionInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenFactory;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortKind;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SAPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SPPInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ServiceImplInstance;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.impl.StructureInstanceImpl;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefSAPoint;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SAPoint;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;

public class GeneratorModelBuilder {
    private static final int OBJ_ID_OFFSET = 100;
    private HashSet<Port> relayPorts = new HashSet();
    private LinkedList<InstanceBase> allObjects = new LinkedList();
    private ILogger logger;
    private IDiagnostician diagnostician;
    private static final String SEP = "#";

    public GeneratorModelBuilder(ILogger logger, IDiagnostician diagnostician) {
        this.logger = logger;
        this.diagnostician = diagnostician;
    }

    public Root createGeneratorModel(List<RoomModel> models, boolean asLibrary) {
        Root root = ETriceGenFactory.eINSTANCE.createRoot();
        root.getModels().addAll(models);
        root.setLibrary(asLibrary);
        if (!root.isLibrary()) {
            this.determineRelayPorts(root);
            for (RoomModel mdl : models) {
                for (SubSystemClass comp : mdl.getSubSystemClasses()) {
                    root.getSubSystemInstances().add((Object)this.createSubSystemInstance(comp));
                }
            }
            this.connectPorts(root);
            this.checkPortMultiplicity(root);
            this.connectServices(root);
            this.setObjectIDs();
        }
        this.createExpandedActorClasses(root);
        return root;
    }

    private void connectServices(Root root) {
        this.createServiceMappings(root);
        this.bindSAPs(root);
    }

    private void createServiceMappings(Root root) {
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.createServiceMappings(comp);
        }
    }

    private void createServiceMappings(StructureInstance si) {
        for (ConnectionInstance ci : si.getConnections()) {
            if (ci.getFromSPP() == null) {
                this.addService(ci.getFromAI(), ci);
                continue;
            }
            if (!ci.getFromSPP().getIncoming().isEmpty()) continue;
            this.addService(si, ci);
        }
        for (ActorInstance child : si.getInstances()) {
            this.createServiceMappings(child);
        }
    }

    private void addService(StructureInstance si, ConnectionInstance ci) {
        assert (si instanceof StructureInstanceImpl) : "unknown implementation " + si.eClass().getName();
        StructureInstanceImpl sii = (StructureInstanceImpl)si;
        ProtocolClass pc = ci.getToSPP().getSpp().getProtocol();
        if (sii.protocol2service.get(pc) != null) {
            Object obj = null;
            obj = si instanceof ActorInstance ? ((ActorInstance)si).getActorClass() : (si instanceof SubSystemInstance ? ((SubSystemInstance)si).getSubSystemClass() : si);
            this.diagnostician.error("A service can only be offered once per actor instance, consider pushing one down to a contained actor!", (EObject)obj, (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs());
        } else if (ci.getFromSPP() != null && ci.getFromSPP().getSpp().getProtocol() != pc) {
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
        } else {
            SPPInstance sppi;
            do {
                if ((sppi = ci.getToSPP()).getOutgoing() != null) continue;
                boolean found = false;
                if (sppi.eContainer() instanceof ActorInstance) {
                    ActorInstance implementor = (ActorInstance)sppi.eContainer();
                    for (ServiceImplInstance svc : implementor.getServices()) {
                        if (svc.getSvcImpl().getSpp() != sppi.getSpp()) continue;
                        found = true;
                        sii.protocol2service.put(pc, svc);
                    }
                } else assert (false);
                if (!found) {
                    ActorContainerClass acr = (ActorContainerClass)sppi.getSpp().eContainer();
                    int idx = acr.getIfSPPs().indexOf((Object)sppi.getSpp());
                    this.diagnostician.error("An SPP mus be connected by a layer connection or implemented by a ServiceImplementation!", (EObject)sppi.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs(), idx);
                }
                return;
            } while ((ci = sppi.getOutgoing()).getToSPP().getSpp().getProtocol() == pc);
            this.diagnostician.error("Layer connection must connect same protocols!", (EObject)ci.getConnection(), (EStructuralFeature)RoomPackage.eINSTANCE.getLayerConnection_From());
            return;
        }
    }

    private void bindSAPs(Root root) {
        for (SubSystemInstance comp : root.getSubSystemInstances()) {
            this.bindSAPs(comp);
        }
    }

    private void bindSAPs(StructureInstance si) {
        for (SAPInstance sap : si.getSaps()) {
            this.bindSAP(si, sap);
        }
        for (ActorInstance child : si.getInstances()) {
            this.bindSAPs(child);
        }
    }

    private void bindSAP(StructureInstance si, SAPInstance sap) {
        assert (si instanceof StructureInstanceImpl);
        StructureInstanceImpl sii = (StructureInstanceImpl)si;
        do {
            ServiceImplInstance svc;
            if ((svc = sii.protocol2service.get(sap.getSap().getProtocol())) == null) continue;
            sap.getPeers().add((Object)svc);
            svc.getPeers().add((Object)sap);
            return;
        } while ((sii = sii.eContainer() instanceof StructureInstanceImpl ? (StructureInstanceImpl)sii.eContainer() : null) != null);
        ActorClass ac = (ActorClass)sap.getSap().eContainer();
        int idx = ac.getStrSAPs().indexOf((Object)sap.getSap());
        this.diagnostician.error("SAP not satisfied!", (EObject)ac, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_StrSAPs(), idx);
    }

    private void determineRelayPorts(Root root) {
        for (RoomModel model : root.getModels()) {
            for (ActorClass ac : model.getActorClasses()) {
                for (Port port : ac.getIfPorts()) {
                    boolean external = false;
                    for (ExternalPort ep : ac.getExtPorts()) {
                        if (ep.getIfport() != port) continue;
                        external = true;
                        break;
                    }
                    if (external) continue;
                    this.relayPorts.add(port);
                    if (!(port.getProtocol() instanceof ProtocolClass) || ((ProtocolClass)port.getProtocol()).getCommType() != CommunicationType.DATA_DRIVEN || !port.isConjugated()) continue;
                    int count = 0;
                    for (Binding b : ac.getBindings()) {
                        if (b.getEndpoint1().getPort() == port) {
                            ++count;
                        }
                        if (b.getEndpoint2().getPort() != port) continue;
                        ++count;
                    }
                    if (count <= true) continue;
                    int idx = ac.getIfPorts().indexOf((Object)port);
                    this.diagnostician.error("data driven conjugate relay port is multiply connected inside its actor class", (EObject)ac, (EStructuralFeature)RoomPackage.eINSTANCE.getActorClass_IfPorts(), idx);
                }
            }
        }
    }

    private void setObjectIDs() {
        int counter = 0;
        for (InstanceBase obj : this.allObjects) {
            if (obj instanceof SubSystemInstance) {
                counter = 100;
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof ActorInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (obj instanceof PortInstance) {
                PortInstance pi = (PortInstance)obj;
                if (pi.getKind() == PortKind.RELAY) continue;
                int multiplicity = pi.getPort().getMultiplicity();
                if (multiplicity == -1) {
                    multiplicity = pi.getPeers().size();
                }
                pi.setObjId(counter);
                counter += multiplicity;
                continue;
            }
            if (obj instanceof SAPInstance) {
                obj.setObjId(counter++);
                continue;
            }
            if (!(obj instanceof ServiceImplInstance)) continue;
            ServiceImplInstance svc = (ServiceImplInstance)obj;
            svc.setObjId(counter);
            counter += svc.getPeers().size();
        }
    }

    private SubSystemInstance createSubSystemInstance(SubSystemClass ssc) {
        this.logger.logInfo("GeneratorModelBuilder: creating subsystem class from " + ssc.getName());
        SubSystemInstance instance = ETriceGenFactory.eINSTANCE.createSubSystemInstance();
        this.allObjects.add(instance);
        instance.setName(ssc.getName());
        instance.setSubSystemClass(ssc);
        for (ActorRef ar : ssc.getActorRefs()) {
            this.addRefInstances(instance, ar);
        }
        this.createBindingInstances(instance, (List<Binding>)ssc.getBindings());
        this.createConnectionInstances(instance, (List<LayerConnection>)ssc.getConnections());
        return instance;
    }

    private ActorInstance recursivelyCreateActorInstances(ActorRef aref) {
        return this.recursivelyCreateActorInstances(aref, -1);
    }

    private ActorInstance recursivelyCreateActorInstances(ActorRef aref, int idx) {
        String name = aref.getName();
        if (idx >= 0) {
            name = String.valueOf(name) + "_" + idx;
        }
        this.logger.logInfo("GeneratorModelBuilder: creating actor instance " + name + " from " + aref.getType().getName());
        ActorInstance ai = ETriceGenFactory.eINSTANCE.createActorInstance();
        this.allObjects.add(ai);
        ai.setName(name);
        ActorClass ac = aref.getType();
        ai.setActorClass(ac);
        if (idx >= 0) {
            ai.setReplIdx(idx);
        }
        LinkedList<ActorClass> classes = new LinkedList<ActorClass>();
        classes.addFirst(ac);
        while (ac.getBase() != null) {
            ac = ac.getBase();
            classes.addFirst(ac);
        }
        for (ActorClass acl : classes) {
            this.createPortInstances(ai, acl);
            this.createServiceRelatedInstances(ai, acl);
            for (ActorRef ar : acl.getActorRefs()) {
                this.addRefInstances(ai, ar);
            }
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ArrayList<LayerConnection> connections = new ArrayList<LayerConnection>();
        for (ActorClass acl : classes) {
            bindings.addAll((Collection<Binding>)acl.getBindings());
            connections.addAll((Collection<LayerConnection>)acl.getConnections());
        }
        this.createBindingInstances(ai, bindings);
        this.createConnectionInstances(ai, connections);
        return ai;
    }

    private void addRefInstances(StructureInstance si, ActorRef ar) {
        if (ar.getSize() > 1) {
            int idx = 0;
            while (idx < ar.getSize()) {
                si.getInstances().add((Object)this.recursivelyCreateActorInstances(ar, idx));
                ++idx;
            }
        } else {
            si.getInstances().add((Object)this.recursivelyCreateActorInstances(ar));
        }
    }

    private void createPortInstances(ActorInstance ai, ActorClass ac) {
        PortInstance pi;
        for (ExternalPort port : ac.getExtPorts()) {
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getIfport().getName());
            pi.setPort(port.getIfport());
            pi.setKind(PortKind.EXTERNAL);
            ai.getPorts().add((Object)pi);
        }
        for (ExternalPort port : ac.getIntPorts()) {
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getName());
            pi.setPort((Port)port);
            pi.setKind(PortKind.INTERNAL);
            ai.getPorts().add((Object)pi);
        }
        for (ExternalPort port : ac.getIfPorts()) {
            if (!this.relayPorts.contains(port)) continue;
            pi = ETriceGenFactory.eINSTANCE.createPortInstance();
            this.allObjects.add(pi);
            pi.setName(port.getName());
            pi.setPort((Port)port);
            pi.setKind(PortKind.RELAY);
            ai.getPorts().add((Object)pi);
        }
    }

    private void createServiceRelatedInstances(ActorInstance ai, ActorClass ac) {
        InstanceBase si;
        for (SAPRef sap : ac.getStrSAPs()) {
            si = ETriceGenFactory.eINSTANCE.createSAPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSap(sap);
            ai.getSaps().add((Object)si);
        }
        for (SAPRef sap : ac.getIfSPPs()) {
            si = ETriceGenFactory.eINSTANCE.createSPPInstance();
            this.allObjects.add(si);
            si.setName(sap.getName());
            si.setSpp((SPPRef)sap);
            ai.getSpps().add((Object)si);
        }
        for (ServiceImplementation svcimpl : ac.getServiceImplementations()) {
            ServiceImplInstance sii = ETriceGenFactory.eINSTANCE.createServiceImplInstance();
            this.allObjects.add(sii);
            sii.setName(svcimpl.getSpp().getName());
            sii.setSvcImpl(svcimpl);
            ai.getServices().add((Object)sii);
        }
    }

    private void createBindingInstances(StructureInstance si, List<Binding> bindings) {
        HashMap<String, ArrayList<PortInstance>> ep2portInstances = this.initPortInstanceMap(si, bindings);
        for (Binding bind : bindings) {
            if (bind.getEndpoint1().getActorRef() == null && bind.getEndpoint2().getActorRef() == null) {
                int idx = bindings.indexOf(bind);
                this.diagnostician.error("binding connects two ports of the same actor", (EObject)bind, (EStructuralFeature)RoomPackage.eINSTANCE.getStructureClass_Bindings(), idx);
                continue;
            }
            ArrayList<PortInstance> ep1Ports = ep2portInstances.get(this.getEndPointKey(bind.getEndpoint1()));
            ArrayList<PortInstance> ep2Ports = ep2portInstances.get(this.getEndPointKey(bind.getEndpoint2()));
            int nBind = ep1Ports.size() > ep2Ports.size() ? ep2Ports.size() : ep1Ports.size();
            int i = 0;
            while (i < nBind) {
                this.createBindingInstance(si, ep1Ports.get(0), ep2Ports.get(0), bind);
                ep1Ports.remove(0);
                ep2Ports.remove(0);
                ++i;
            }
        }
    }

    private void createBindingInstance(StructureInstance si, PortInstance pi1, PortInstance pi2, Binding bind) {
        BindingInstance bi = ETriceGenFactory.eINSTANCE.createBindingInstance();
        bi.getPorts().add((Object)pi1);
        bi.getPorts().add((Object)pi2);
        bi.setBinding(bind);
        si.getBindings().add((Object)bi);
    }

    private HashMap<String, ArrayList<PortInstance>> initPortInstanceMap(StructureInstance si, List<Binding> bindings) {
        HashMap<String, ArrayList<PortInstance>> ep2portInstances = new HashMap<String, ArrayList<PortInstance>>();
        for (PortInstance pi : si.getPorts()) {
            if (pi.getKind() == PortKind.EXTERNAL) continue;
            this.addPortInstance(pi, this.getEndPointKey(null, pi), ep2portInstances);
        }
        for (ActorInstance sub : si.getInstances()) {
            boolean forceMultFixed = sub.getReplIdx() > 1;
            for (PortInstance pi : sub.getPorts()) {
                if (pi.getKind() == PortKind.INTERNAL) continue;
                if (forceMultFixed && pi.getPort().getMultiplicity() < 0) {
                    this.diagnostician.error("port multiplicity of replicated actor has to be fixed", (EObject)pi.getPort(), (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
                }
                this.addPortInstance(pi, this.getEndPointKey(sub, pi), ep2portInstances);
            }
        }
        HashSet<String> multAny = new HashSet<String>();
        for (Binding bind : bindings) {
            this.addNeededInstance(bind.getEndpoint1(), bind.getEndpoint2(), ep2portInstances, multAny);
            this.addNeededInstance(bind.getEndpoint2(), bind.getEndpoint1(), ep2portInstances, multAny);
        }
        return ep2portInstances;
    }

    private void addNeededInstance(BindingEndPoint ep, BindingEndPoint peer_ep, HashMap<String, ArrayList<PortInstance>> ep2portInstances, HashSet<String> multAny) {
        boolean implicitMany;
        String endPointKey = this.getEndPointKey(ep);
        ArrayList<PortInstance> ports = ep2portInstances.get(endPointKey);
        PortInstance pi = ports.get(0);
        boolean bl = implicitMany = pi.getProtocol() == null || pi.getProtocol().getCommType() == CommunicationType.DATA_DRIVEN;
        if (implicitMany || pi.getPort().getMultiplicity() < 0) {
            int size = 1;
            if (peer_ep.getActorRef() instanceof ActorRef) {
                int peerMult = peer_ep.getPort().getMultiplicity();
                if (peerMult <= 0) {
                    peerMult = 1;
                }
                size = ((ActorRef)peer_ep.getActorRef()).getSize() * peerMult;
            }
            int i = 0;
            while (i < size) {
                if (!multAny.contains(endPointKey)) {
                    multAny.add(endPointKey);
                } else {
                    ports.add(pi);
                }
                ++i;
            }
        }
    }

    private String getEndPointKey(ActorInstance ai, PortInstance pi) {
        return String.valueOf(ai != null ? ai.getUnindexedName() : "") + SEP + pi.getPort().getName();
    }

    private String getEndPointKey(BindingEndPoint ep) {
        return this.getEndPointKey(ep.getActorRef(), ep.getPort());
    }

    private String getEndPointKey(ActorContainerRef ref, Port port) {
        return ref == null ? SEP + port.getName() : String.valueOf(ref.getName()) + SEP + port.getName();
    }

    private void addPortInstance(PortInstance pi, String key, HashMap<String, ArrayList<PortInstance>> ep2portInstances) {
        int repl;
        ArrayList<PortInstance> ports = ep2portInstances.get(key);
        if (ports == null) {
            ports = new ArrayList();
            ep2portInstances.put(key, ports);
        }
        if ((repl = pi.getPort().getMultiplicity()) <= 0) {
            repl = 1;
        }
        int i = 0;
        while (i < repl) {
            ports.add(pi);
            ++i;
        }
    }

    private void createConnectionInstances(StructureInstance si, List<LayerConnection> connections) {
        for (LayerConnection lc : connections) {
            SPPoint to = lc.getTo();
            SPPInstance toSPPinst = this.getSPPInstance(si, to.getRef(), to.getService());
            SAPoint from = lc.getFrom();
            if (from instanceof RefSAPoint) {
                if (((RefSAPoint)from).getRef() instanceof ActorRef) {
                    List<ActorInstance> fromInstances = this.getActorInstances(si, (ActorRef)((RefSAPoint)from).getRef());
                    for (ActorInstance fromInst : fromInstances) {
                        ConnectionInstance ci = ETriceGenFactory.eINSTANCE.createConnectionInstance();
                        ci.setConnection(lc);
                        ci.setFromAI(fromInst);
                        ci.setToSPP(toSPPinst);
                        si.getConnections().add((Object)ci);
                    }
                    continue;
                }
                System.err.println("error");
                continue;
            }
            if (from instanceof RelaySAPoint) {
                SPPInstance fromSPPinst = this.getSPPInstance(si, null, ((RelaySAPoint)from).getRelay());
                if (fromSPPinst.getOutgoing() != null) {
                    ActorContainerClass acr = (ActorContainerClass)fromSPPinst.getSpp().eContainer();
                    int idx = acr.getIfSPPs().indexOf((Object)fromSPPinst.getSpp());
                    this.diagnostician.error("SPPRef has several outgoing layer connections!", (EObject)fromSPPinst.getSpp(), (EStructuralFeature)RoomPackage.eINSTANCE.getActorContainerClass_IfSPPs(), idx);
                }
                ConnectionInstance ci = ETriceGenFactory.eINSTANCE.createConnectionInstance();
                ci.setConnection(lc);
                ci.setFromSPP(fromSPPinst);
                ci.setToSPP(toSPPinst);
                si.getConnections().add((Object)ci);
                continue;
            }
            assert (false) : "unknown type of " + from.eClass().getName();
        }
    }

    private SPPInstance getSPPInstance(StructureInstance si, ActorContainerRef ar, SPPRef spp) {
        if (ar == null) {
            for (SPPInstance sppi : si.getSpps()) {
                if (sppi.getSpp() != spp) continue;
                return sppi;
            }
        } else if (ar instanceof ActorRef) {
            List<ActorInstance> subais = this.getActorInstances(si, (ActorRef)ar);
            if (!subais.isEmpty()) {
                return this.getSPPInstance(subais.get(0), null, spp);
            }
        } else {
            boolean cfr_ignored_0 = ar instanceof SubSystemRef;
        }
        return null;
    }

    private List<ActorInstance> getActorInstances(StructureInstance si, ActorRef ar) {
        ArrayList<ActorInstance> result = new ArrayList<ActorInstance>();
        for (ActorInstance subai : si.getInstances()) {
            if (!subai.getUnindexedName().equals(ar.getName())) continue;
            result.add(subai);
        }
        return result;
    }

    private void connectPorts(Root root) {
        EObject obj;
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (!(obj instanceof ActorInstance)) continue;
            for (PortInstance pi : ((ActorInstance)obj).getPorts()) {
                if (pi.getKind() == PortKind.RELAY) continue;
                List<PortInstance> peers = this.getFinalPeers(pi, null, null);
                pi.getPeers().addAll(peers);
            }
        }
        it = root.eAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (!(obj instanceof ActorInstance)) continue;
            for (PortInstance pi : ((ActorInstance)obj).getPorts()) {
                if (pi.getKind() == PortKind.RELAY || pi.getPeers().size() <= 1 || ((InterfaceItemInstance)pi.getPeers().get(0)).getPeers().size() <= 1) continue;
                this.connectPeersOneToOne(pi);
            }
        }
    }

    private List<PortInstance> getFinalPeers(PortInstance pi, BindingInstance from, SubProtocol fromSub) {
        LinkedList<PortInstance> peers = new LinkedList<PortInstance>();
        for (BindingInstance bi : pi.getBindings()) {
            PortInstance end;
            SubProtocol mySub;
            if (bi == from || from != null && from.eContainer() == bi.eContainer() || (mySub = this.getMySubProtocol(pi, bi)) != null && fromSub != null && fromSub != mySub) continue;
            PortInstance portInstance = end = bi.getPorts().get(0) != pi ? (PortInstance)bi.getPorts().get(0) : (PortInstance)bi.getPorts().get(1);
            if (end.getKind() == PortKind.RELAY) {
                SubProtocol peerSub = this.getPeerSubProtocol(pi, bi);
                if (peerSub != null) {
                    fromSub = peerSub;
                }
                peers.addAll(this.getFinalPeers(end, bi, fromSub));
                continue;
            }
            peers.add(end);
        }
        return peers;
    }

    private SubProtocol getMySubProtocol(PortInstance pi, BindingInstance bi) {
        return bi.getPorts().get(0) == pi ? bi.getBinding().getEndpoint1().getSub() : bi.getBinding().getEndpoint2().getSub();
    }

    private SubProtocol getPeerSubProtocol(PortInstance pi, BindingInstance bi) {
        return bi.getPorts().get(0) != pi ? bi.getBinding().getEndpoint1().getSub() : bi.getBinding().getEndpoint2().getSub();
    }

    private void connectPeersOneToOne(PortInstance pi) {
        HashSet<InterfaceItemInstance> thatSide;
        HashSet<InterfaceItemInstance> thisSide = new HashSet<InterfaceItemInstance>((Collection<InterfaceItemInstance>)pi.getPeers());
        if (!Collections.disjoint(thisSide, thatSide = new HashSet<InterfaceItemInstance>((Collection<InterfaceItemInstance>)((InterfaceItemInstance)pi.getPeers().get(0)).getPeers()))) {
            assert (false) : "sets expected to be disjoint";
            return;
        }
        for (InterfaceItemInstance pi1 : thisSide) {
            if (!this.isSameCollection((Collection<InterfaceItemInstance>)thatSide, (Collection<InterfaceItemInstance>)pi1.getPeers())) assert (false) : "expected reciprocal peer lists";
        }
        for (InterfaceItemInstance pi2 : thatSide) {
            if (!this.isSameCollection((Collection<InterfaceItemInstance>)thisSide, (Collection<InterfaceItemInstance>)pi2.getPeers())) assert (false) : "expected reciprocal peer lists";
        }
        boolean thisGreaterThat = this.totalSize(thisSide) > this.totalSize(thatSide);
        Iterator<InterfaceItemInstance> lit = thisGreaterThat ? thisSide.iterator() : thatSide.iterator();
        Iterator<InterfaceItemInstance> sit = thisGreaterThat ? thatSide.iterator() : thisSide.iterator();
        while (sit.hasNext() && lit.hasNext()) {
            InterfaceItemInstance first = lit.next();
            InterfaceItemInstance second = sit.next();
            first.getPeers().clear();
            first.getPeers().add((Object)second);
            second.getPeers().clear();
            second.getPeers().add((Object)first);
        }
        while (lit.hasNext()) {
            InterfaceItemInstance item = lit.next();
            this.reportPortInstanceError(item, "port '" + item.getPath() + "'could not be connected");
        }
    }

    private void reportPortInstanceError(InterfaceItemInstance item, String msg) {
        if (item.eContainer() instanceof ActorInstance) {
            ActorClass ac = ((ActorInstance)item.eContainer()).getActorClass();
            Port port = ((PortInstance)item).getPort();
            EReference feat = ac.getIfPorts().contains((Object)port) ? RoomPackage.Literals.ACTOR_CLASS__INT_PORTS : RoomPackage.Literals.ACTOR_CLASS__IF_PORTS;
            int idx = ac.getIfPorts().indexOf((Object)port);
            if (idx < 0) {
                ac.getIntPorts().indexOf((Object)port);
            }
            this.diagnostician.warning(msg, (EObject)ac, (EStructuralFeature)feat, idx);
        } else assert (false) : "SubSystems can only have relay ports";
    }

    private int totalSize(Collection<InterfaceItemInstance> coll) {
        int size = 0;
        for (InterfaceItemInstance ii : coll) {
            if (ii instanceof PortInstance) {
                int multiplicity = ((PortInstance)ii).getPort().getMultiplicity();
                if (multiplicity != 1) {
                    this.reportPortInstanceError(ii, "port '" + ii.getPath() + "' must have multiplicity 1");
                }
                size += multiplicity;
                continue;
            }
            assert (false) : "should be called with PortInstances onl";
        }
        return size;
    }

    private boolean isSameCollection(Collection<InterfaceItemInstance> coll1, Collection<InterfaceItemInstance> coll2) {
        for (InterfaceItemInstance ii : coll1) {
            if (coll2.contains(ii)) continue;
            return false;
        }
        for (InterfaceItemInstance ii : coll2) {
            if (coll1.contains(ii)) continue;
            return false;
        }
        return true;
    }

    private void checkPortMultiplicity(Root root) {
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            int idx;
            EReference feature;
            EObject obj = (EObject)it.next();
            if (obj instanceof ActorInstance) {
                ActorInstance ai = (ActorInstance)obj;
                ActorClass ac = ai.getActorClass();
                for (PortInstance pi : ai.getPorts()) {
                    if (pi.getKind() == PortKind.RELAY || pi.getProtocol().getCommType() != CommunicationType.EVENT_DRIVEN || pi.getBindings().size() <= pi.getPort().getMultiplicity() || pi.getPort().getMultiplicity() == -1) continue;
                    feature = RoomPackage.eINSTANCE.getActorClass_IfPorts();
                    idx = ac.getIfPorts().indexOf((Object)pi.getPort());
                    if (idx < 0) {
                        feature = RoomPackage.eINSTANCE.getActorClass_IntPorts();
                        idx = ac.getIntPorts().indexOf((Object)pi.getPort());
                    }
                    this.diagnostician.error("number of peers (" + pi.getBindings().size() + ") of port '" + pi.getName() + "' exceeds multiplicity " + pi.getPort().getMultiplicity() + " in instance " + ai.getPath(), (EObject)ac, (EStructuralFeature)feature, idx);
                }
                continue;
            }
            if (!(obj instanceof SubSystemInstance)) continue;
            SubSystemInstance ssi = (SubSystemInstance)obj;
            SubSystemClass ssc = ssi.getSubSystemClass();
            for (PortInstance pi : ssi.getPorts()) {
                feature = RoomPackage.eINSTANCE.getSubSystemClass_RelayPorts();
                idx = ssc.getRelayPorts().indexOf((Object)pi.getPort());
                this.diagnostician.error("number of peers (" + pi.getBindings().size() + ") of port '" + pi.getName() + "' exceeds multiplicity " + pi.getPort().getMultiplicity() + " in instance " + ssi.getPath(), (EObject)ssc, (EStructuralFeature)feature, idx);
            }
        }
    }

    private void createExpandedActorClasses(Root root) {
        for (ActorClass ac : root.getUsedActorClasses()) {
            root.getXpActorClasses().add((Object)this.createExpandedActorClass(ac));
        }
    }

    public ExpandedActorClass createExpandedActorClass(ActorClass ac) {
        this.logger.logInfo("GeneratorModelBuilder: creating expanded actor class from " + ac.getName() + " of " + ((RoomModel)ac.eContainer()).getName());
        ExpandedActorClass xpac = ETriceGenFactory.eINSTANCE.createExpandedActorClass();
        xpac.setActorClass(ac);
        xpac.prepare(this.diagnostician);
        return xpac;
    }
}

