/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel.etricegen.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenFactory;
import org.eclipse.etrice.core.genmodel.etricegen.ETriceGenPackage;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedRefinedState;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.TransitionChain;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.EntryPoint;
import org.eclipse.etrice.core.room.ExitPoint;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ExpandedActorClassImpl
extends EObjectImpl
implements ExpandedActorClass {
    protected ActorClass actorClass;
    protected StateGraph stateMachine;
    private static final String TRIGGER_SEP = "#";
    private IDiagnostician validator;
    private boolean prepared = false;
    private HashSet<StateGraphItem> ownObjects = null;
    private HashMap<InterfaceItem, Integer> ifitem2localId = null;
    private HashMap<StateGraphNode, NodeData> node2data = null;
    private HashMap<State, LinkedList<ActiveTrigger>> state2triggers = null;
    private HashMap<String, MessageFromIf> triggerstring2mif = null;
    private LinkedList<TransitionChain> trchains = null;
    private TransitionToChainBundleMap trans2chainBundle = null;
    private HashMap<EObject, EObject> copy2orig = null;

    protected ExpandedActorClassImpl() {
    }

    protected EClass eStaticClass() {
        return ETriceGenPackage.Literals.EXPANDED_ACTOR_CLASS;
    }

    @Override
    public ActorClass getActorClass() {
        if (this.actorClass != null && this.actorClass.eIsProxy()) {
            InternalEObject oldActorClass = (InternalEObject)this.actorClass;
            this.actorClass = (ActorClass)this.eResolveProxy(oldActorClass);
            if (this.actorClass != oldActorClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldActorClass, (Object)this.actorClass));
            }
        }
        return this.actorClass;
    }

    public ActorClass basicGetActorClass() {
        return this.actorClass;
    }

    @Override
    public void setActorClass(ActorClass newActorClass) {
        ActorClass oldActorClass = this.actorClass;
        this.actorClass = newActorClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldActorClass, (Object)this.actorClass));
        }
    }

    @Override
    public StateGraph getStateMachine() {
        return this.stateMachine;
    }

    public NotificationChain basicSetStateMachine(StateGraph newStateMachine, NotificationChain msgs) {
        StateGraph oldStateMachine = this.stateMachine;
        this.stateMachine = newStateMachine;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldStateMachine, (Object)newStateMachine);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStateMachine(StateGraph newStateMachine) {
        if (newStateMachine != this.stateMachine) {
            NotificationChain msgs = null;
            if (this.stateMachine != null) {
                msgs = ((InternalEObject)this.stateMachine).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newStateMachine != null) {
                msgs = ((InternalEObject)newStateMachine).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetStateMachine(newStateMachine, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newStateMachine, (Object)newStateMachine));
        }
    }

    private void validationError(String msg, EObject obj, EStructuralFeature feature) {
        this.validationError(msg, obj, feature, -1);
    }

    private void validationError(String msg, EObject obj, EStructuralFeature feature, int idx) {
        this.validator.error(msg, this.copy2orig.get(obj), feature, idx);
    }

    private void buildStateGraph() {
        ArrayList<StateGraph> stateMachines = new ArrayList<StateGraph>();
        ActorClass orig = this.getActorClass();
        if (orig.getStateMachine() != null) {
            stateMachines.add(orig.getStateMachine());
        }
        while (orig.getBase() != null) {
            if ((orig = orig.getBase()).getStateMachine() == null) continue;
            stateMachines.add(orig.getStateMachine());
        }
        Collection<StateGraph> copiedStateMachines = this.createCopyOfStateMachines(stateMachines);
        this.collectContentsInNewStateMachine(copiedStateMachines);
        this.introduceExpandedRefinedStates(this.getStateMachine());
    }

    private void collectContentsInNewStateMachine(Collection<StateGraph> copiedStateMachines) {
        StateGraph myStateMachine = RoomFactory.eINSTANCE.createStateGraph();
        this.setStateMachine(myStateMachine);
        HashMap<Transition, DetailCode> trans2refinedAction = new HashMap<Transition, DetailCode>();
        for (StateGraph stateGraph : copiedStateMachines) {
            myStateMachine.getChPoints().addAll((Collection)stateGraph.getChPoints());
            myStateMachine.getStates().addAll((Collection)stateGraph.getStates());
            myStateMachine.getTrPoints().addAll((Collection)stateGraph.getTrPoints());
            myStateMachine.getTransitions().addAll((Collection)stateGraph.getTransitions());
            for (RefinedTransition rt : stateGraph.getRefinedTransitions()) {
                if (rt.getAction() == null || rt.getAction().getCommands().isEmpty()) continue;
                DetailCode code = (DetailCode)trans2refinedAction.get(rt.getTarget());
                if (code == null) {
                    code = RoomFactory.eINSTANCE.createDetailCode();
                    trans2refinedAction.put(rt.getTarget(), code);
                }
                code.getCommands().addAll(0, (Collection)rt.getAction().getCommands());
            }
        }
        for (Map.Entry entry : trans2refinedAction.entrySet()) {
            if (((Transition)entry.getKey()).getAction() == null) {
                ((Transition)entry.getKey()).setAction((DetailCode)entry.getValue());
                continue;
            }
            ((Transition)entry.getKey()).getAction().getCommands().addAll((Collection)((DetailCode)entry.getValue()).getCommands());
        }
    }

    private Collection<StateGraph> createCopyOfStateMachines(List<StateGraph> origStateMachines) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection copiedStateMachines = copier.copyAll(origStateMachines);
        copier.copyReferences();
        for (EObject o : copier.keySet()) {
            EObject c = (EObject)copier.get((Object)o);
            this.copy2orig.put(c, o);
        }
        if (this.getActorClass().getStateMachine() != null) {
            StateGraph self = (StateGraph)copiedStateMachines.iterator().next();
            TreeIterator it = self.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof StateGraphItem)) continue;
                this.addOwnObject((StateGraphItem)obj);
            }
        }
        return copiedStateMachines;
    }

    private void introduceExpandedRefinedStates(StateGraph sg) {
        ArrayList states = new ArrayList(sg.getStates());
        for (State s : states) {
            if (!(s instanceof RefinedState)) continue;
            RefinedState rs = (RefinedState)s;
            ExpandedRefinedState state = ETriceGenFactory.eINSTANCE.createExpandedRefinedState();
            state.init(rs);
            this.copy2orig.put((EObject)state, this.getOrig((EObject)rs));
            if (!this.isOwnObject((StateGraphItem)rs)) continue;
            this.addOwnObject((StateGraphItem)state);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.introduceExpandedRefinedStates(s.getSubgraph());
        }
    }

    private void addOutgoingTransition(StateGraphNode node, Transition t) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            data = new NodeData();
            this.node2data.put(node, data);
        }
        data.getOutTrans().add(t);
    }

    private void addIncomingTransition(StateGraphNode node, Transition t) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            data = new NodeData();
            this.node2data.put(node, data);
        }
        data.getInTrans().add(t);
    }

    private void findOutgoingTransitions(StateGraph sg) {
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.findOutgoingTransitions(s.getSubgraph());
        }
        for (Transition t : sg.getTransitions()) {
            this.addIncomingTransition(this.getAdjustedTargetNode(t), t);
            if (!(t instanceof NonInitialTransition)) continue;
            this.addOutgoingTransition(this.getNode(((NonInitialTransition)t).getFrom()), t);
        }
    }

    private void checkTransitionChains(StateGraph sg) {
        for (Transition t : sg.getTransitions()) {
            TransitionChain chain = this.getChain(t);
            if (chain != null || this.getActorClass().isAbstract()) continue;
            int idx = sg.getTransitions().indexOf((Object)t);
            this.validationError("transition is not part of a transition chain (only allowed for abstract actor classes)", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), idx);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.checkTransitionChains(s.getSubgraph());
        }
    }

    private void doChecks(StateGraph sg) {
        int idx;
        NodeData data;
        if (sg.getTransitions().isEmpty() && sg.getStates().isEmpty() && sg.getChPoints().isEmpty() && sg.getTrPoints().isEmpty()) {
            return;
        }
        int initCount = 0;
        for (Transition t : sg.getTransitions()) {
            if (!(t instanceof InitialTransition)) continue;
            ++initCount;
        }
        if (initCount == 0) {
            if (sg.eContainer() instanceof State) {
                NodeData data2;
                if (!this.getActorClass().isAbstract() && (data2 = this.node2data.get((State)sg.eContainer())) != null && data2.getLoopTransitions().size() != data2.getInTrans().size()) {
                    this.validationError(String.valueOf(this.getActorClass().getName()) + ": Having no initial transition in a nested state is valid only if there is no transition to history except of self transitions!", sg.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getState_Subgraph());
                }
            } else {
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": The TOP level has to have an initial transition!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions());
            }
        } else if (initCount > 1) {
            this.validationError(String.valueOf(this.getActorClass().getName()) + ": There has to be exactly one initial transition!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions());
        }
        for (ChoicePoint cp : sg.getChPoints()) {
            data = this.node2data.get(cp);
            idx = sg.getChPoints().indexOf((Object)cp);
            if (data == null) {
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": ChoicePoint is not connected!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
                continue;
            }
            if (data.getOutTrans().size() < 2) {
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": ChoicePoint should have 2 or more branches but has " + data.getOutTrans().size(), (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
            }
            if (this.getDefaultBranch(data.getOutTrans()) == null) {
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": ChoicePoint has no default branch!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
            }
            if (data.getLoopTransitions().isEmpty()) continue;
            this.validationError(String.valueOf(this.getActorClass().getName()) + ": ChoicePoint is connected to itself!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_ChPoints(), idx);
        }
        for (TrPoint tp : sg.getTrPoints()) {
            data = this.node2data.get(tp);
            idx = sg.getChPoints().indexOf((Object)tp);
            if (data == null) {
                if (this.getActorClass((EObject)tp).isAbstract()) continue;
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint is not connected", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                continue;
            }
            if (tp instanceof EntryPoint || tp instanceof ExitPoint) {
                if (!this.getActorClass().isAbstract() && data.getInTrans().isEmpty()) {
                    this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint has no incoming transition!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                }
                if (this.getActorClass((EObject)tp).isAbstract()) {
                    if (data.getOutTrans().size() > 1) {
                        this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint must have at most one outgoing transition!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                    }
                } else if (data.getOutTrans().size() != 1) {
                    this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint must have exactly one outgoing transition!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                }
                if (data.getLoopTransitions().isEmpty()) continue;
                this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint must have no self transitions!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
                continue;
            }
            if (!(tp instanceof TransitionPoint) || data.getOutTrans().size() >= data.getLoopTransitions().size()) continue;
            this.validationError(String.valueOf(this.getActorClass().getName()) + ": TrPoint must have no incoming transitions!", (EObject)sg, (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_TrPoints(), idx);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.doChecks(s.getSubgraph());
        }
    }

    private void findTriggersOfState(State s) {
        LinkedList<ActiveTrigger> triggers = new LinkedList<ActiveTrigger>();
        HashMap<String, ActiveTrigger> caughtTriggers = new HashMap<String, ActiveTrigger>();
        this.collectTriggersAndTransitions(s, caughtTriggers, triggers);
        this.state2triggers.put(s, triggers);
    }

    private String getTriggerString(MessageFromIf mifp) {
        return String.valueOf(mifp.getFrom().getName()) + TRIGGER_SEP + mifp.getMessage().getName();
    }

    private void collectOutgoingTransitions(EList<Transition> sameLevelTransitions, HashMap<String, ActiveTrigger> caughtTriggers, LinkedList<ActiveTrigger> triggers) {
        for (Transition t : sameLevelTransitions) {
            if (!(t instanceof TriggeredTransition)) continue;
            TriggeredTransition tt = (TriggeredTransition)t;
            for (Trigger trig : ((TriggeredTransition)t).getTriggers()) {
                for (MessageFromIf mifp : trig.getMsgFromIfPairs()) {
                    String tr = this.getTriggerString(mifp);
                    ActiveTrigger at = caughtTriggers.get(tr);
                    if (at == null) {
                        at = ETriceGenFactory.eINSTANCE.createActiveTrigger();
                        at.setMsg(mifp.getMessage());
                        at.setIfitem(mifp.getFrom());
                        at.setTrigger(tr);
                        at.getTransitions().add((Object)tt);
                        caughtTriggers.put(tr, at);
                        triggers.add(at);
                        continue;
                    }
                    TriggeredTransition unguarded = null;
                    boolean accepted = true;
                    for (TriggeredTransition t2 : at.getTransitions()) {
                        for (Trigger trig2 : t2.getTriggers()) {
                            if (!this.isMatching(trig2, tr) || RoomHelpers.isGuarded((Trigger)trig2)) continue;
                            unguarded = t2;
                            if (sameLevelTransitions.contains((Object)t2)) continue;
                            accepted = false;
                        }
                    }
                    if (!accepted) continue;
                    if (unguarded != null) {
                        if (!RoomHelpers.isGuarded((Trigger)trig)) {
                            this.validationError("Transitions with same trigger on same level have to be guarded!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
                            continue;
                        }
                        int idx = at.getTransitions().indexOf(unguarded);
                        at.getTransitions().add(idx, (Object)tt);
                        continue;
                    }
                    at.getTransitions().add((Object)tt);
                }
            }
        }
    }

    private void collectTriggersAndTransitions(State s, HashMap<String, ActiveTrigger> caughtTriggers, LinkedList<ActiveTrigger> triggers) {
        this.collectOutgoingTransitions(this.getOutgoingTransitions((StateGraphNode)s), caughtTriggers, triggers);
        if (s.eContainer() instanceof StateGraph) {
            StateGraph sg = (StateGraph)s.eContainer();
            BasicEList trpTransitions = new BasicEList();
            for (TrPoint tp : sg.getTrPoints()) {
                trpTransitions.addAll(this.getOutgoingTransitions((StateGraphNode)tp));
            }
            this.collectOutgoingTransitions((EList<Transition>)trpTransitions, caughtTriggers, triggers);
            if (sg.eContainer() instanceof State) {
                this.collectTriggersAndTransitions((State)sg.eContainer(), caughtTriggers, triggers);
            }
        } else assert (false) : "A State must always reside in a StateGraph!";
    }

    private void findLeafStateTriggers(StateGraph sg) {
        for (State s : sg.getStates()) {
            if (s.getSubgraph() != null) {
                this.findLeafStateTriggers(s.getSubgraph());
                continue;
            }
            this.findTriggersOfState(s);
        }
    }

    private void fillTriggerStringMap() {
        HashMap<String, InterfaceItem> name2ifitem = new HashMap<String, InterfaceItem>();
        HashMap<String, EList<Message>> name2msgs = new HashMap<String, EList<Message>>();
        ActorClass ac = this.getActorClass();
        while (ac != null) {
            for (Port ip : ac.getIntPorts()) {
                this.mapPort(ip, name2ifitem, name2msgs);
            }
            for (ExternalPort ep : ac.getExtPorts()) {
                this.mapPort(ep.getIfport(), name2ifitem, name2msgs);
            }
            for (SAPRef sap : ac.getStrSAPs()) {
                this.mapSAP(sap, name2ifitem, name2msgs);
            }
            for (ServiceImplementation spp : ac.getServiceImplementations()) {
                this.mapSPP(spp.getSpp(), name2ifitem, name2msgs);
            }
            ac = ac.getBase();
        }
        HashSet<String> triggers = new HashSet<String>();
        for (LinkedList<ActiveTrigger> ttlist : this.state2triggers.values()) {
            for (ActiveTrigger tt : ttlist) {
                triggers.add(tt.getTrigger());
            }
        }
        for (String trig : triggers) {
            String[] parts = trig.split(TRIGGER_SEP);
            assert (parts.length == 2) : "By our convention triggers are composed of two parts separated by #. Here we have '" + trig + "' which doesn't consist of two parts!";
            InterfaceItem ii = name2ifitem.get(parts[0]);
            assert (ii != null) : "The name '" + parts[0] + "' did not match an interface item (in name2ifitem)!";
            EList<Message> msgs = name2msgs.get(parts[0]);
            assert (msgs != null) : "The name '" + parts[0] + "' did not match an interface item (in name2msgs)!";
            Message msg = null;
            for (Message m : msgs) {
                if (!m.getName().equals(parts[1])) continue;
                msg = m;
            }
            assert (msg != null) : "The message '" + parts[1] + "' did not match a message!";
            MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
            mif.setFrom(ii);
            mif.setMessage(msg);
            this.triggerstring2mif.put(trig, mif);
        }
    }

    private void mapPort(Port p, HashMap<String, InterfaceItem> name2ifitem, HashMap<String, EList<Message>> name2msgs) {
        name2ifitem.put(p.getName(), (InterfaceItem)p);
        if (!(p.getProtocol() instanceof ProtocolClass)) {
            return;
        }
        if (p.isConjugated()) {
            name2msgs.put(p.getName(), (EList<Message>)((ProtocolClass)p.getProtocol()).getOutgoingMessages());
        } else {
            name2msgs.put(p.getName(), (EList<Message>)((ProtocolClass)p.getProtocol()).getIncomingMessages());
        }
    }

    private void mapSAP(SAPRef sap, HashMap<String, InterfaceItem> name2ifitem, HashMap<String, EList<Message>> name2msgs) {
        name2ifitem.put(sap.getName(), (InterfaceItem)sap);
        name2msgs.put(sap.getName(), (EList<Message>)sap.getProtocol().getOutgoingMessages());
    }

    private void mapSPP(SPPRef spp, HashMap<String, InterfaceItem> name2ifitem, HashMap<String, EList<Message>> name2msgs) {
        name2ifitem.put(spp.getName(), (InterfaceItem)spp);
        name2msgs.put(spp.getName(), (EList<Message>)spp.getProtocol().getIncomingMessages());
    }

    private void addTransitionChain(Transition t) {
        TransitionChain tc = ETriceGenFactory.eINSTANCE.createTransitionChain();
        tc.setTransition(t);
        if (t instanceof TriggeredTransition) {
            VarDecl data = null;
            boolean first = true;
            for (Trigger tr : ((TriggeredTransition)t).getTriggers()) {
                for (MessageFromIf mif : tr.getMsgFromIfPairs()) {
                    if (first) {
                        first = false;
                        data = mif.getMessage().getData();
                        continue;
                    }
                    if (data != null) {
                        if (mif.getMessage().getData() == null) {
                            this.validationError("If one MessageFromIf has data all have to have data for a given transition!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
                            continue;
                        }
                        VarDecl a = mif.getMessage().getData();
                        if (data.getRefType().getType() != a.getRefType().getType()) {
                            this.validationError("The data types of all MessageFromIf have to be the same!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
                        }
                        if (data.getRefType().isRef() == a.getRefType().isRef()) continue;
                        this.validationError("The data types of all MessageFromIf have to be the same ref type!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
                        continue;
                    }
                    if (mif.getMessage().getData() == null) continue;
                    this.validationError("If one MessageFromIf has no data all have to have no data for a given transition!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
                }
            }
            if (first) {
                this.validationError("Triggered transition has to have a message from interface!", (EObject)t, (EStructuralFeature)RoomPackage.eINSTANCE.getTriggeredTransition_Triggers());
            }
            tc.setData(data);
        }
        this.collectChainTransitions(tc, t);
        this.trchains.add(tc);
    }

    private void collectChainTransitions(TransitionChain tc, Transition t) {
        this.trans2chainBundle.put(t, tc);
        StateGraphNode node = this.getNode(t.getTo());
        if (node instanceof State) {
            return;
        }
        if (tc.getTransition() instanceof NonInitialTransition && node == this.getNode(((NonInitialTransition)tc.getTransition()).getFrom())) {
            if (node instanceof TransitionPoint) {
                tc.setSkipEntry(true);
            }
            return;
        }
        for (Transition next : this.getOutgoingTransitions(node)) {
            if (next instanceof TriggeredTransition) {
                int idx = ((StateGraph)next.eContainer()).getTransitions().indexOf((Object)next);
                this.validationError("Segments following the triggering transition can have no triggers!\n", next.eContainer(), (EStructuralFeature)RoomPackage.eINSTANCE.getStateGraph_Transitions(), idx);
            }
            this.collectChainTransitions(tc, next);
        }
    }

    private void findTransitionChains(StateGraph sg, Class<?> cls) {
        for (Transition t : sg.getTransitions()) {
            if (!cls.isInstance(t) && !(t instanceof InitialTransition)) continue;
            this.addTransitionChain(t);
        }
        for (State s : sg.getStates()) {
            if (s.getSubgraph() == null) continue;
            this.findTransitionChains(s.getSubgraph(), cls);
        }
    }

    @Override
    public void prepare(IDiagnostician validator) {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.validator = validator;
        this.ifitem2localId = new HashMap();
        this.ownObjects = new HashSet();
        this.node2data = new HashMap();
        this.state2triggers = new HashMap();
        this.triggerstring2mif = new HashMap();
        this.trchains = new LinkedList();
        this.trans2chainBundle = new TransitionToChainBundleMap();
        this.copy2orig = new HashMap();
        this.buildStateGraph();
        this.computeInterfaceItemLocalIds(this.getActorClass(), 0);
        this.findOutgoingTransitions(this.getStateMachine());
        this.doChecks(this.getStateMachine());
        if (validator.isFailed()) {
            return;
        }
        if (this.getActorClass().getCommType() == ActorCommunicationType.DATA_DRIVEN) {
            this.findTransitionChains(this.getStateMachine(), GuardedTransition.class);
        } else {
            this.findLeafStateTriggers(this.getStateMachine());
            this.fillTriggerStringMap();
            this.findTransitionChains(this.getStateMachine(), TriggeredTransition.class);
            this.computeCommonChainData();
            this.checkTransitionChains(this.getStateMachine());
        }
    }

    private void computeCommonChainData() {
        for (TransitionChainBundle tcb : this.trans2chainBundle.values()) {
            if (tcb.chains.size() == 1) {
                tcb.commonData = ((TransitionChain)tcb.chains.get(0)).getData();
                continue;
            }
            ArrayList<RefableType> types = new ArrayList<RefableType>();
            for (TransitionChain chain : tcb.chains) {
                if (chain.getData() != null) {
                    types.add(chain.getData().getRefType());
                    continue;
                }
                types.add(null);
            }
            RefableType rt = RoomHelpers.getLastCommonSuperType(types);
            if (rt == null) continue;
            VarDecl vd = RoomFactory.eINSTANCE.createVarDecl();
            vd.setName("data");
            vd.setRefType(rt);
            tcb.commonData = vd;
        }
    }

    @Override
    public void release() {
        if (!this.prepared) {
            return;
        }
        this.prepared = false;
        this.ifitem2localId = null;
        this.ownObjects = null;
        this.node2data = null;
        this.state2triggers = null;
        this.triggerstring2mif = null;
        this.trchains = null;
        this.trans2chainBundle = null;
        this.copy2orig = null;
    }

    @Override
    public void addOwnObject(StateGraphItem obj) {
        this.ownObjects.add(obj);
    }

    @Override
    public boolean isOwnObject(StateGraphItem obj) {
        return this.ownObjects.contains(obj);
    }

    private int computeInterfaceItemLocalIds(ActorClass ac, int offset) {
        if (ac.getBase() != null) {
            offset = this.computeInterfaceItemLocalIds(ac.getBase(), offset);
        }
        for (ExternalPort ep : ac.getExtPorts()) {
            this.ifitem2localId.put((InterfaceItem)ep.getIfport(), offset);
            ++offset;
        }
        for (Port ip : ac.getIntPorts()) {
            this.ifitem2localId.put((InterfaceItem)ip, offset);
            ++offset;
        }
        for (SAPRef sap : ac.getStrSAPs()) {
            this.ifitem2localId.put((InterfaceItem)sap, offset);
            ++offset;
        }
        for (ServiceImplementation svc : ac.getServiceImplementations()) {
            this.ifitem2localId.put((InterfaceItem)svc.getSpp(), offset);
            ++offset;
        }
        return offset;
    }

    @Override
    public int getInterfaceItemLocalId(InterfaceItem ifitem) {
        Integer localId = this.ifitem2localId.get(ifitem);
        if (localId != null) {
            return localId;
        }
        return -1;
    }

    @Override
    public boolean hasStateMachine() {
        ActorClass ac = this.getActorClass();
        while (ac != null) {
            if (ac.getStateMachine() != null) {
                return true;
            }
            ac = ac.getBase();
        }
        return false;
    }

    @Override
    public String getTriggerCodeName(MessageFromIf mif) {
        return "TRIG_" + mif.getFrom().getName() + "__" + mif.getMessage().getName();
    }

    @Override
    public String getTriggerCodeName(String trigger) {
        String[] parts = trigger.split(TRIGGER_SEP);
        return "TRIG_" + parts[0] + "__" + parts[1];
    }

    @Override
    public EList<Transition> getOutgoingTransitions(StateGraphNode node) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            return new BasicEList();
        }
        return new BasicEList(data.getOutTrans());
    }

    @Override
    public EList<Transition> getIncomingTransitions(StateGraphNode node) {
        NodeData data = this.node2data.get(node);
        if (data == null) {
            return new BasicEList();
        }
        return new BasicEList(data.getInTrans());
    }

    @Override
    public EList<ActiveTrigger> getActiveTriggers(State state) {
        LinkedList<ActiveTrigger> triggers = this.state2triggers.get(state);
        if (triggers == null) {
            return new BasicEList();
        }
        return new BasicEList(triggers);
    }

    @Override
    public EList<MessageFromIf> getTriggers() {
        return new BasicEList(this.triggerstring2mif.values());
    }

    @Override
    public EList<MessageFromIf> getOwnTriggers() {
        BasicEList result = new BasicEList();
        HashSet<Object> ownIfItems = new HashSet<Object>();
        ownIfItems.addAll((Collection<Object>)this.getActorClass().getIntPorts());
        for (ExternalPort ep : this.getActorClass().getExtPorts()) {
            ownIfItems.add(ep.getIfport());
        }
        ownIfItems.addAll((Collection<Object>)this.getActorClass().getStrSAPs());
        for (ServiceImplementation svc : this.getActorClass().getServiceImplementations()) {
            ownIfItems.add(svc.getSpp());
        }
        for (MessageFromIf mif : this.triggerstring2mif.values()) {
            if (!ownIfItems.contains(mif.getFrom())) continue;
            result.add((Object)mif);
        }
        Collections.sort(result, new Comparator<MessageFromIf>(){

            @Override
            public int compare(MessageFromIf o1, MessageFromIf o2) {
                return ExpandedActorClassImpl.this.getTriggerCodeName(o1).compareTo(ExpandedActorClassImpl.this.getTriggerCodeName(o2));
            }
        });
        return result;
    }

    @Override
    public String getMessageID(MessageFromIf mif) {
        if (mif.getFrom() instanceof Port) {
            Port p = (Port)mif.getFrom();
            return String.valueOf(p.getProtocol().getName()) + (p.isConjugated() ? ".OUT_" : ".IN_") + mif.getMessage().getName();
        }
        if (mif.getFrom() instanceof SAPRef) {
            SAPRef sap = (SAPRef)mif.getFrom();
            return String.valueOf(sap.getProtocol().getName()) + ".OUT_" + mif.getMessage().getName();
        }
        if (mif.getFrom() instanceof SPPRef) {
            SPPRef spp = (SPPRef)mif.getFrom();
            return String.valueOf(spp.getProtocol().getName()) + ".IN_" + mif.getMessage().getName();
        }
        return "unknown interface item";
    }

    @Override
    public TransitionChain getChain(Transition trans) {
        if (trans == null) {
            return null;
        }
        TransitionChainBundle tcb = (TransitionChainBundle)this.trans2chainBundle.get(trans);
        if (tcb == null || tcb.chains.isEmpty()) {
            return null;
        }
        return (TransitionChain)tcb.chains.get(0);
    }

    @Override
    public VarDecl getData(Transition trans) {
        if (trans == null) {
            return null;
        }
        TransitionChainBundle tcb = (TransitionChainBundle)this.trans2chainBundle.get(trans);
        if (tcb == null || tcb.chains.isEmpty()) {
            return null;
        }
        if (tcb.chains.size() == 1) {
            return ((TransitionChain)tcb.chains.get(0)).getData();
        }
        return tcb.commonData;
    }

    @Override
    public EList<TransitionChain> getTransitionChains() {
        return new BasicEList(this.trchains);
    }

    @Override
    public EList<TransitionChain> getOwnTransitionChains() {
        BasicEList result = new BasicEList();
        for (TransitionChain tc : this.trchains) {
            if (!this.isOwnObject((StateGraphItem)tc.getTransition())) continue;
            result.add((Object)tc);
        }
        Collections.sort(result, new Comparator<TransitionChain>(){

            @Override
            public int compare(TransitionChain o1, TransitionChain o2) {
                return RoomNameProvider.getFullPath((StateGraphItem)o1.getTransition()).compareTo(RoomNameProvider.getFullPath((StateGraphItem)o2.getTransition()));
            }
        });
        return result;
    }

    @Override
    public StateGraphNode getNode(TransitionTerminal tt) {
        if (tt instanceof StateTerminal) {
            return ((StateTerminal)tt).getState();
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return ((SubStateTrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp();
        }
        return null;
    }

    private StateGraphNode getAdjustedTargetNode(Transition t) {
        NodeData data;
        StateGraphNode node = this.getNode(t.getTo());
        if (node instanceof EntryPoint && ((data = this.node2data.get(node)) == null || data.getOutTrans().isEmpty()) && this.getActorClass((EObject)node).isAbstract() && node.eContainer().eContainer() instanceof State) {
            State newTarget = (State)node.eContainer().eContainer();
            StateTerminal st = RoomFactory.eINSTANCE.createStateTerminal();
            st.setState(newTarget);
            t.setTo((TransitionTerminal)st);
            node = newTarget;
        }
        return node;
    }

    private ActorClass getActorClass(EObject node) {
        node = this.copy2orig.get(node);
        while (node != null) {
            if (node instanceof ActorClass) {
                return (ActorClass)node;
            }
            node = node.eContainer();
        }
        return null;
    }

    @Override
    public boolean isMatching(Trigger trig, String trigstr) {
        for (MessageFromIf mifp2 : trig.getMsgFromIfPairs()) {
            String tr2 = this.getTriggerString(mifp2);
            if (!tr2.equals(trigstr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContinuationTransition getDefaultBranch(EList<Transition> out) {
        return this.getDefaultBranch((List<Transition>)out);
    }

    @Override
    public EObject getOrig(EObject copy) {
        return this.copy2orig.get(copy);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetStateMachine(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    private ContinuationTransition getDefaultBranch(List<Transition> out) {
        for (Transition t : out) {
            if (!(t instanceof ContinuationTransition)) continue;
            return (ContinuationTransition)t;
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getActorClass();
                }
                return this.basicGetActorClass();
            }
            case 1: {
                return this.getStateMachine();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setActorClass((ActorClass)newValue);
                return;
            }
            case 1: {
                this.setStateMachine((StateGraph)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setActorClass(null);
                return;
            }
            case 1: {
                this.setStateMachine(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.actorClass != null;
            }
            case 1: {
                return this.stateMachine != null;
            }
        }
        return super.eIsSet(featureID);
    }

    private static class NodeData {
        private LinkedList<Transition> inTrans = new LinkedList();
        private LinkedList<Transition> outTrans = new LinkedList();
        private LinkedList<Transition> loopTrans = null;

        private NodeData() {
        }

        LinkedList<Transition> getInTrans() {
            return this.inTrans;
        }

        LinkedList<Transition> getOutTrans() {
            return this.outTrans;
        }

        LinkedList<Transition> getLoopTransitions() {
            if (this.loopTrans == null) {
                this.loopTrans = new LinkedList();
                for (Transition t : this.getOutTrans()) {
                    NonInitialTransition tr = (NonInitialTransition)t;
                    if (tr.getFrom() instanceof StateTerminal) {
                        if (!(tr.getTo() instanceof StateTerminal) || ((StateTerminal)tr.getFrom()).getState() != ((StateTerminal)tr.getTo()).getState()) continue;
                        this.loopTrans.add((Transition)tr);
                        continue;
                    }
                    if (!(tr.getFrom() instanceof TrPointTerminal) || !(tr.getTo() instanceof TrPointTerminal) || ((TrPointTerminal)tr.getFrom()).getTrPoint() != ((TrPointTerminal)tr.getTo()).getTrPoint()) continue;
                    this.loopTrans.add((Transition)tr);
                }
            }
            return this.loopTrans;
        }
    }

    private static class TransitionChainBundle {
        private ArrayList<TransitionChain> chains = new ArrayList();
        private VarDecl commonData = null;

        private TransitionChainBundle() {
        }
    }

    private static class TransitionToChainBundleMap
    extends HashMap<Transition, TransitionChainBundle> {
        private static final long serialVersionUID = 1L;

        private TransitionToChainBundleMap() {
        }

        @Override
        void put(Transition t, TransitionChain tc) {
            TransitionChainBundle tcb = (TransitionChainBundle)this.get(t);
            if (tcb == null) {
                tcb = new TransitionChainBundle();
                this.put(t, tcb);
            }
            tcb.chains.add(tc);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            for (Map.Entry entry : this.entrySet()) {
                result.append("transition " + RoomNameProvider.getFullPath((StateGraphItem)((StateGraphItem)entry.getKey())) + ":\n");
                TransitionChainBundle bundle = (TransitionChainBundle)entry.getValue();
                for (TransitionChain tc : bundle.chains) {
                    String data = tc.getData() != null ? " with data " + tc.getData().getRefType().getType().getName() : "";
                    result.append("  chain starting at " + RoomNameProvider.getFullPath((StateGraphItem)tc.getTransition()) + data + "\n");
                }
                String data = bundle.commonData != null ? bundle.commonData.getRefType().getType().getName() : "-";
                result.append("  bundle data " + data + "\n");
            }
            return result.toString();
        }
    }
}

